// This code conforms with the UFC specification version 1.4
// and was automatically generated by FFC version 0.9.2+.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   epsilon:                        1e-14
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False

#ifndef __HYPERELASTICITY_H
#define __HYPERELASTICITY_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class hyperelasticity_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  hyperelasticity_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Discontinuous Lagrange', Cell('tetrahedron', 1, Space(3)), 0)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 1;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute sub determinants
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Compute constants
    
    // Get coordinates and map to the reference (FIAT) element
    
    
    // Reset values.
    *values = 0.000000000000000;
    
    // Array of basisvalues.
    double basisvalues[1] = {0.000000000000000};
    
    // Declare helper variables.
    
    // Compute basisvalues.
    basisvalues[0] = 1.000000000000000;
    
    // Table(s) of coefficients.
    static const double coefficients0[1] = \
    {1.000000000000000};
    
    // Compute value(s).
    for (unsigned int r = 0; r < 1; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    }// end loop over 'r'
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Element is constant, calling evaluate_basis.
    evaluate_basis(0, values, coordinates, c);
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    
    // Get coordinates and map to the reference (FIAT) element
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    
    // Array of basisvalues.
    double basisvalues[1] = {0.000000000000000};
    
    // Declare helper variables.
    
    // Compute basisvalues.
    basisvalues[0] = 1.000000000000000;
    
    // Table(s) of coefficients.
    static const double coefficients0[1] = \
    {1.000000000000000};
    
    // Tables of derivatives of the polynomial base (transpose).
    static const double dmats0[1][1] = \
    {{0.000000000000000}};
    
    static const double dmats1[1][1] = \
    {{0.000000000000000}};
    
    static const double dmats2[1][1] = \
    {{0.000000000000000}};
    
    // Compute reference derivatives.
    // Declare pointer to array of derivatives on FIAT element.
    double *derivatives = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      derivatives[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Declare derivative matrix (of polynomial basis).
    double dmats[1][1] = \
    {{1.000000000000000}};
    
    // Declare (auxiliary) derivative matrix (of polynomial basis).
    double dmats_old[1][1] = \
    {{1.000000000000000}};
    
    // Loop possible derivatives.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      // Resetting dmats values to compute next derivative.
      for (unsigned int t = 0; t < 1; t++)
      {
        for (unsigned int u = 0; u < 1; u++)
        {
          dmats[t][u] = 0.000000000000000;
          if (t == u)
          {
          dmats[t][u] = 1.000000000000000;
          }
          
        }// end loop over 'u'
      }// end loop over 't'
      
      // Looping derivative order to generate dmats.
      for (unsigned int s = 0; s < n; s++)
      {
        // Updating dmats_old with new values and resetting dmats.
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            dmats_old[t][u] = dmats[t][u];
            dmats[t][u] = 0.000000000000000;
          }// end loop over 'u'
        }// end loop over 't'
        
        // Update dmats using an inner product.
        if (combinations[r][s] == 0)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 1)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 2)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
      }// end loop over 's'
      for (unsigned int s = 0; s < 1; s++)
      {
        for (unsigned int t = 0; t < 1; t++)
        {
          derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Transform derivatives back to physical element
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r] += transform[r][s]*derivatives[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer to array of derivatives on FIAT element
    delete [] derivatives;
    
    // Delete pointer to array of combinations of derivatives and transform
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] combinations[r];
    }// end loop over 'r'
    delete [] combinations;
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] transform[r];
    }// end loop over 'r'
    delete [] transform;
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Element is constant, calling evaluate_basis_derivatives.
    evaluate_basis_derivatives(0, n, values, coordinates, c);
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = 0.250000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.250000000000000*x[2][0] + 0.250000000000000*x[3][0];
      y[1] = 0.250000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.250000000000000*x[2][1] + 0.250000000000000*x[3][1];
      y[2] = 0.250000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.250000000000000*x[2][2] + 0.250000000000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.000000000000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = 0.250000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.250000000000000*x[2][0] + 0.250000000000000*x[3][0];
    y[1] = 0.250000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.250000000000000*x[2][1] + 0.250000000000000*x[3][1];
    y[2] = 0.250000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.250000000000000*x[2][2] + 0.250000000000000*x[3][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[0];
    vertex_values[2] = dof_values[0];
    vertex_values[3] = dof_values[0];
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a finite element.

class hyperelasticity_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  hyperelasticity_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 4;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    *values = 0.000000000000000;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.000000000000000, 0.223606797749979};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.000000000000000;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 4; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.000000000000000, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 4; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.000000000000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a finite element.

class hyperelasticity_finite_element_2: public ufc::finite_element
{
public:

  /// Constructor
  hyperelasticity_finite_element_2() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_finite_element_2()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 12;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    values[0] = 0.000000000000000;
    values[1] = 0.000000000000000;
    values[2] = 0.000000000000000;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.000000000000000, 0.223606797749979};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.000000000000000, 0.223606797749979};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.000000000000000, 0.223606797749979};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[3] = {0.000000000000000, 0.000000000000000, 0.000000000000000};
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 12; r++)
    {
      evaluate_basis(r, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 3; s++)
      {
        values[r*3 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.000000000000000, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.000000000000000, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.500000000000000*(2.000000000000000 + Y + Z + 2.000000000000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.000000000000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.000000000000000 + Y) + (2.000000000000000 + Z + 3.000000000000000*Y)/2.000000000000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.000000000000000 + r + s + Z*(2.000000000000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.500000000000000 + r)*(1.000000000000000 + r + s)*(1.500000000000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.288675134594813, 0.000000000000000, 0.000000000000000, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {6.324555320336760, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats1[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.477225575051662, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      static const double dmats2[4][4] = \
      {{0.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {3.162277660168380, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {1.825741858350554, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {5.163977794943223, 0.000000000000000, 0.000000000000000, 0.000000000000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.000000000000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.000000000000000, 0.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 1.000000000000000, 0.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 1.000000000000000, 0.000000000000000},
      {0.000000000000000, 0.000000000000000, 0.000000000000000, 1.000000000000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.000000000000000;
            if (t == u)
            {
            dmats[t][u] = 1.000000000000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.000000000000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[3*num_derivatives];
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      dof_values[r] = 0.000000000000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 12; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[3];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 6:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 7:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 8:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 9:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 10:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 11:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    }
    
    return 0.000000000000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[3];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[4] = vals[1];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[5] = vals[1];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[6] = vals[1];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[7] = vals[1];
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[8] = vals[2];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[9] = vals[2];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[10] = vals[2];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[11] = vals[2];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[3] = dof_values[1];
    vertex_values[6] = dof_values[2];
    vertex_values[9] = dof_values[3];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[4];
    vertex_values[4] = dof_values[5];
    vertex_values[7] = dof_values[6];
    vertex_values[10] = dof_values[7];
    // Evaluate function and change variables
    vertex_values[2] = dof_values[8];
    vertex_values[5] = dof_values[9];
    vertex_values[8] = dof_values[10];
    vertex_values[11] = dof_values[11];
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 3;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    }
    
    return 0;
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class hyperelasticity_dof_map_0: public ufc::dof_map
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  hyperelasticity_dof_map_0() : ufc::dof_map()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~hyperelasticity_dof_map_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dof map
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Discontinuous Lagrange', Cell('tetrahedron', 1, Space(3)), 0)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dof map for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[3];
    return false;
  }

  /// Initialize dof map for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dof map for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 1;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 1;
  }

  // Return the geometric dimension of the coordinates this dof map provides
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 0;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[3][0];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = 0.250000000000000*x[0][0] + 0.250000000000000*x[1][0] + 0.250000000000000*x[2][0] + 0.250000000000000*x[3][0];
    coordinates[0][1] = 0.250000000000000*x[0][1] + 0.250000000000000*x[1][1] + 0.250000000000000*x[2][1] + 0.250000000000000*x[3][1];
    coordinates[0][2] = 0.250000000000000*x[0][2] + 0.250000000000000*x[1][2] + 0.250000000000000*x[2][2] + 0.250000000000000*x[3][2];
  }

  /// Return the number of sub dof maps (for a mixed element)
  virtual unsigned int num_sub_dof_maps() const
  {
    return 0;
  }

  /// Create a new dof_map for sub dof map i (for a mixed element)
  virtual ufc::dof_map* create_sub_dof_map(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class hyperelasticity_dof_map_1: public ufc::dof_map
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  hyperelasticity_dof_map_1() : ufc::dof_map()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~hyperelasticity_dof_map_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dof map
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dof map for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0];
    return false;
  }

  /// Initialize dof map for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dof map for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 4;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 4;
  }

  // Return the geometric dimension of the coordinates this dof map provides
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[0][0];
    dofs[1] = c.entity_indices[0][1];
    dofs[2] = c.entity_indices[0][2];
    dofs[3] = c.entity_indices[0][3];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[0][2] = x[0][2];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[1][2] = x[1][2];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[2][2] = x[2][2];
    coordinates[3][0] = x[3][0];
    coordinates[3][1] = x[3][1];
    coordinates[3][2] = x[3][2];
  }

  /// Return the number of sub dof maps (for a mixed element)
  virtual unsigned int num_sub_dof_maps() const
  {
    return 0;
  }

  /// Create a new dof_map for sub dof map i (for a mixed element)
  virtual ufc::dof_map* create_sub_dof_map(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class hyperelasticity_dof_map_2: public ufc::dof_map
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  hyperelasticity_dof_map_2() : ufc::dof_map()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~hyperelasticity_dof_map_2()
  {
    // Do nothing
  }

  /// Return a string identifying the dof map
  virtual const char* signature() const
  {
    return "FFC dofmap for VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dof map for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = 3.000000000000000*m.num_entities[0];
    return false;
  }

  /// Initialize dof map for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dof map for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 12;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 12;
  }

  // Return the geometric dimension of the coordinates this dof map provides
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 9;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 3;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    dofs[3] = offset + c.entity_indices[0][3];
    offset += m.num_entities[0];
    dofs[4] = offset + c.entity_indices[0][0];
    dofs[5] = offset + c.entity_indices[0][1];
    dofs[6] = offset + c.entity_indices[0][2];
    dofs[7] = offset + c.entity_indices[0][3];
    offset += m.num_entities[0];
    dofs[8] = offset + c.entity_indices[0][0];
    dofs[9] = offset + c.entity_indices[0][1];
    dofs[10] = offset + c.entity_indices[0][2];
    dofs[11] = offset + c.entity_indices[0][3];
    offset += m.num_entities[0];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 6;
      dofs[5] = 7;
      dofs[6] = 9;
      dofs[7] = 10;
      dofs[8] = 11;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 6;
      dofs[5] = 7;
      dofs[6] = 8;
      dofs[7] = 10;
      dofs[8] = 11;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 7;
      dofs[6] = 8;
      dofs[7] = 9;
      dofs[8] = 11;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 8;
      dofs[7] = 9;
      dofs[8] = 10;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 4;
        dofs[2] = 8;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 5;
        dofs[2] = 9;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 6;
        dofs[2] = 10;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
        dofs[1] = 7;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[0][2] = x[0][2];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[1][2] = x[1][2];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[2][2] = x[2][2];
    coordinates[3][0] = x[3][0];
    coordinates[3][1] = x[3][1];
    coordinates[3][2] = x[3][2];
    coordinates[4][0] = x[0][0];
    coordinates[4][1] = x[0][1];
    coordinates[4][2] = x[0][2];
    coordinates[5][0] = x[1][0];
    coordinates[5][1] = x[1][1];
    coordinates[5][2] = x[1][2];
    coordinates[6][0] = x[2][0];
    coordinates[6][1] = x[2][1];
    coordinates[6][2] = x[2][2];
    coordinates[7][0] = x[3][0];
    coordinates[7][1] = x[3][1];
    coordinates[7][2] = x[3][2];
    coordinates[8][0] = x[0][0];
    coordinates[8][1] = x[0][1];
    coordinates[8][2] = x[0][2];
    coordinates[9][0] = x[1][0];
    coordinates[9][1] = x[1][1];
    coordinates[9][2] = x[1][2];
    coordinates[10][0] = x[2][0];
    coordinates[10][1] = x[2][1];
    coordinates[10][2] = x[2][2];
    coordinates[11][0] = x[3][0];
    coordinates[11][1] = x[3][1];
    coordinates[11][2] = x[3][2];
  }

  /// Return the number of sub dof maps (for a mixed element)
  virtual unsigned int num_sub_dof_maps() const
  {
    return 3;
  }

  /// Create a new dof_map for sub dof map i (for a mixed element)
  virtual ufc::dof_map* create_sub_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dof_map_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dof_map_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dof_map_1();
        break;
      }
    }
    
    return 0;
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class hyperelasticity_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  hyperelasticity_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Array of quadrature weights.
    static const double W1 = 0.166666666666666;
    // Quadrature points on the UFC reference element: (0.250000000000000, 0.250000000000000, 0.250000000000000)
    
    // Value of basis functions at quadrature points.
    static const double FE1_C0_D001[1][2] = \
    {{-1.000000000000000, 1.000000000000000}};
    
    // Array of non-zero columns
    static const unsigned int nzc1[2] = {0, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc3[2] = {0, 1};
    
    // Array of non-zero columns
    static const unsigned int nzc9[2] = {8, 11};
    
    // Array of non-zero columns
    static const unsigned int nzc2[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc6[2] = {4, 6};
    
    // Array of non-zero columns
    static const unsigned int nzc7[2] = {4, 5};
    
    // Array of non-zero columns
    static const unsigned int nzc11[2] = {8, 9};
    
    // Array of non-zero columns
    static const unsigned int nzc10[2] = {8, 10};
    
    // Array of non-zero columns
    static const unsigned int nzc5[2] = {4, 7};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 144; r++)
    {
      A[r] = 0.000000000000000;
    }// end loop over 'r'
    // Number of operations to compute geometry constants: 6133.
    double G[192];
    G[0] = W1*det*(2.000000000000000*w[1][0]*(K_00*(K_00*(K_01*K_11 + K_02*K_12) + K_10*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_11 + K_02*(K_01*(K_01*K_12 + K_02*K_11) + K_02*K_02*K_12)) + w[2][0]*(K_00*(K_00*(K_01*K_11 + K_02*K_12) + K_10*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_11 + K_02*(K_01*(K_01*K_12 + K_02*K_11) + K_02*K_02*K_12)));
    G[1] = K_01*W1*det*(3.000000000000000*w[2][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + 6.000000000000000*w[1][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[2] = W1*det*(0.500000000000000*w[2][0]*(K_00*K_00*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_01*K_01*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_02*K_02*(K_10*K_10 + K_11*K_11 + K_12*K_12)) + w[1][0]*(K_00*K_10*(2.000000000000000*K_02*K_12 + K_00*K_10) + K_01*K_11*(2.000000000000000*(K_00*K_10 + K_02*K_12) + K_01*K_11) + K_02*K_02*K_12*K_12));
    G[3] = W1*det*(K_01*(K_00*K_10*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0]) + K_01*K_11*(3.000000000000000*w[2][0] + 6.000000000000000*w[1][0]) + K_02*K_12*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0])) + K_11*(2.000000000000000*w[1][0]*(K_00*K_00 + K_02*K_02) + w[2][0]*(K_00*K_00 + K_02*K_02)));
    G[4] = W1*det*(w[1][0]*(4.000000000000000*K_00*K_02*K_10*K_12 + K_10*K_10*(3.000000000000000*K_00*K_00 + K_01*K_01 + K_02*K_02) + K_11*(4.000000000000000*K_01*(K_00*K_10 + K_02*K_12) + K_11*(3.000000000000000*K_01*K_01 + K_00*K_00 + K_02*K_02)) + K_12*K_12*(3.000000000000000*K_02*K_02 + K_00*K_00 + K_01*K_01)) + w[2][0]*(0.500000000000000*(K_00*K_00*K_11*K_11 + K_01*K_01*K_10*K_10 + K_02*K_02*(K_10*K_10 + K_11*K_11) + K_12*K_12*(K_00*K_00 + K_01*K_01)) + 1.500000000000000*K_01*K_01*K_11*K_11 + K_00*K_10*(1.500000000000000*K_00*K_10 + 2.000000000000000*K_01*K_11) + K_02*K_12*(1.500000000000000*K_02*K_12 + 2.000000000000000*(K_00*K_10 + K_01*K_11))));
    G[5] = W1*det*(2.000000000000000*w[1][0]*(K_00*(K_10*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_10 + K_01*K_11 + K_02*K_12)) + K_01*(K_02*K_11*K_22 + K_21*(K_01*K_11 + K_02*K_12)) + K_02*K_02*K_12*K_22) + w[2][0]*(K_10*K_20*(K_00*K_00 + K_01*K_01 + K_02*K_02) + K_11*K_21*(K_00*K_00 + K_01*K_01 + K_02*K_02) + K_12*K_22*(K_00*K_00 + K_01*K_01 + K_02*K_02)));
    G[6] = W1*det*(0.500000000000000*w[2][0]*(K_00*K_00*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_01*K_01*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_02*K_02*(K_20*K_20 + K_21*K_21 + K_22*K_22)) + w[1][0]*(K_00*K_20*(2.000000000000000*K_01*K_21 + K_00*K_20) + K_01*K_01*K_21*K_21 + K_02*K_22*(2.000000000000000*(K_00*K_20 + K_01*K_21) + K_02*K_22)));
    G[7] = W1*det*(w[1][0]*(4.000000000000000*K_01*K_02*K_21*K_22 + K_20*(4.000000000000000*K_00*(K_01*K_21 + K_02*K_22) + K_20*(3.000000000000000*K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_21*K_21*(3.000000000000000*K_01*K_01 + K_00*K_00 + K_02*K_02) + K_22*K_22*(3.000000000000000*K_02*K_02 + K_00*K_00 + K_01*K_01)) + w[2][0]*(0.500000000000000*(K_00*K_00*(K_21*K_21 + K_22*K_22) + K_01*K_01*K_22*K_22 + K_02*K_02*K_21*K_21 + K_20*K_20*(K_01*K_01 + K_02*K_02)) + 1.500000000000000*K_00*K_00*K_20*K_20 + K_01*K_21*(1.500000000000000*K_01*K_21 + 2.000000000000000*K_00*K_20) + K_02*K_22*(1.500000000000000*K_02*K_22 + 2.000000000000000*(K_00*K_20 + K_01*K_21))));
    G[8] = W1*det*(3.000000000000000*w[2][0]*(K_00*(K_00*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_21 + K_02*(K_01*(K_01*K_22 + K_02*K_21) + K_02*K_02*K_22)) + 6.000000000000000*w[1][0]*(K_00*(K_00*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_21 + K_02*(K_01*(K_01*K_22 + K_02*K_21) + K_02*K_02*K_22)));
    G[9] = K_00*W1*det*(2.000000000000000*w[1][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + w[2][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[10] = W1*det*(2.000000000000000*K_00*w[1][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22) + K_20*w[2][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[11] = W1*det*(K_00*K_00*(K_00*K_00*(1.500000000000000*w[2][0] + 3.000000000000000*w[1][0]) + K_01*K_01*(3.000000000000000*w[2][0] + 6.000000000000000*w[1][0]) + K_02*K_02*(3.000000000000000*w[2][0] + 6.000000000000000*w[1][0])) + K_01*K_01*K_01*K_01*(1.500000000000000*w[2][0] + 3.000000000000000*w[1][0]) + K_02*K_02*(K_01*K_01*(3.000000000000000*w[2][0] + 6.000000000000000*w[1][0]) + K_02*K_02*(1.500000000000000*w[2][0] + 3.000000000000000*w[1][0])));
    G[12] = W1*det*(w[1][0]*(K_00*(4.000000000000000*K_02*(K_10*K_22 + K_12*K_20) + K_00*(2.000000000000000*(K_11*K_21 + K_12*K_22) + 6.000000000000000*K_10*K_20)) + K_01*(4.000000000000000*(K_11*(K_00*K_20 + K_02*K_22) + K_21*(K_00*K_10 + K_02*K_12)) + K_01*(2.000000000000000*(K_10*K_20 + K_12*K_22) + 6.000000000000000*K_11*K_21)) + K_02*K_02*(2.000000000000000*(K_10*K_20 + K_11*K_21) + 6.000000000000000*K_12*K_22)) + w[2][0]*(K_00*(2.000000000000000*K_02*(K_10*K_22 + K_12*K_20) + K_00*(3.000000000000000*K_10*K_20 + K_11*K_21 + K_12*K_22)) + K_01*(2.000000000000000*(K_11*(K_00*K_20 + K_02*K_22) + K_21*(K_00*K_10 + K_02*K_12)) + K_01*(3.000000000000000*K_11*K_21 + K_10*K_20 + K_12*K_22)) + K_02*K_02*(3.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21)));
    G[13] = W1*det*(2.000000000000000*w[1][0]*(K_00*(K_00*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_21 + K_02*(K_01*(K_01*K_22 + K_02*K_21) + K_02*K_02*K_22)) + w[2][0]*(K_00*(K_00*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_21 + K_02*(K_01*(K_01*K_22 + K_02*K_21) + K_02*K_02*K_22)));
    G[14] = W1*det*(2.000000000000000*K_02*w[1][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22) + K_22*w[2][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[15] = W1*det*(K_00*K_00*(K_00*K_00*(w[1][0] + 0.500000000000000*w[2][0]) + K_01*K_01*(w[2][0] + 2.000000000000000*w[1][0]) + K_02*K_02*(w[2][0] + 2.000000000000000*w[1][0])) + K_01*K_01*K_01*K_01*(w[1][0] + 0.500000000000000*w[2][0]) + K_02*K_02*(K_01*K_01*(w[2][0] + 2.000000000000000*w[1][0]) + K_02*K_02*(w[1][0] + 0.500000000000000*w[2][0])));
    G[16] = K_02*W1*det*(2.000000000000000*w[1][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + w[2][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[17] = W1*det*(K_01*(K_00*K_20*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0]) + K_01*K_21*(3.000000000000000*w[2][0] + 6.000000000000000*w[1][0]) + K_02*K_22*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0])) + K_21*(2.000000000000000*w[1][0]*(K_00*K_00 + K_02*K_02) + w[2][0]*(K_00*K_00 + K_02*K_02)));
    G[18] = W1*det*(2.000000000000000*K_00*w[1][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12) + K_10*w[2][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[19] = W1*det*(K_01*K_01*w[2][0] + w[1][0]*(2.000000000000000*K_01*K_01 + K_00*K_00 + K_02*K_02));
    G[20] = W1*det*(3.000000000000000*w[2][0]*(K_00*(K_00*(K_01*K_11 + K_02*K_12) + K_10*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_11 + K_02*(K_01*(K_01*K_12 + K_02*K_11) + K_02*K_02*K_12)) + 6.000000000000000*w[1][0]*(K_00*(K_00*(K_01*K_11 + K_02*K_12) + K_10*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_11 + K_02*(K_01*(K_01*K_12 + K_02*K_11) + K_02*K_02*K_12)));
    G[21] = W1*det*(2.000000000000000*K_02*w[1][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12) + K_12*w[2][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[22] = W1*det*(w[1][0]*(K_10*(K_10*(2.000000000000000*K_00*K_20 + K_01*K_21 + K_02*K_22) + K_11*(K_00*K_21 + K_01*K_20) + K_12*(K_00*K_22 + K_02*K_20)) + K_11*(K_11*(2.000000000000000*K_01*K_21 + K_00*K_20 + K_02*K_22) + K_12*(K_01*K_22 + K_02*K_21)) + K_12*K_12*(2.000000000000000*K_02*K_22 + K_00*K_20 + K_01*K_21)) + w[2][0]*(K_02*K_12*K_12*K_22 + K_10*(K_00*K_10*K_20 + K_12*(K_00*K_22 + K_02*K_20)) + K_11*(K_01*(K_10*K_20 + K_12*K_22) + K_21*(K_00*K_10 + K_01*K_11 + K_02*K_12))));
    G[23] = W1*det*(2.000000000000000*w[1][0]*(K_02*K_12*K_12*K_22 + K_10*(K_00*K_10*K_20 + K_12*(K_00*K_22 + K_02*K_20)) + K_11*(K_01*(K_10*K_20 + K_12*K_22) + K_21*(K_00*K_10 + K_01*K_11 + K_02*K_12))) + w[2][0]*(K_00*K_20*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_01*K_21*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_02*K_22*(K_10*K_10 + K_11*K_11 + K_12*K_12)));
    G[24] = W1*det*(2.000000000000000*w[1][0]*(K_02*K_12*K_12*K_12 + K_10*(K_00*K_10*K_10 + K_12*(K_00*K_12 + K_02*K_10)) + K_11*(K_01*(K_10*K_10 + K_12*K_12) + K_11*(K_00*K_10 + K_01*K_11 + K_02*K_12))) + w[2][0]*(K_02*K_12*K_12*K_12 + K_10*(K_00*K_10*K_10 + K_12*(K_00*K_12 + K_02*K_10)) + K_11*(K_01*(K_10*K_10 + K_12*K_12) + K_11*(K_00*K_10 + K_01*K_11 + K_02*K_12))));
    G[25] = W1*det*(K_00*(w[1][0]*(2.000000000000000*K_00*K_10 + K_01*K_11 + K_02*K_12) + w[2][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12)) + K_10*w[1][0]*(K_01*K_01 + K_02*K_02));
    G[26] = W1*det*(w[1][0]*(2.000000000000000*(K_00*K_10*(K_00*K_10 + K_01*K_11) + K_01*K_01*K_11*K_11 + K_02*K_12*(K_00*K_10 + K_01*K_11 + K_02*K_12)) + K_00*K_00*K_11*K_11 + K_01*K_01*K_10*K_10 + K_02*K_02*(K_10*K_10 + K_11*K_11) + K_12*K_12*(K_00*K_00 + K_01*K_01)) + w[2][0]*(K_00*K_10*(2.000000000000000*K_02*K_12 + K_00*K_10) + K_01*K_11*(2.000000000000000*(K_00*K_10 + K_02*K_12) + K_01*K_11) + K_02*K_02*K_12*K_12));
    G[27] = W1*det*(w[1][0]*(K_20*(K_20*(2.000000000000000*K_00*K_10 + K_01*K_11 + K_02*K_12) + K_21*(K_00*K_11 + K_01*K_10)) + K_21*K_21*(2.000000000000000*K_01*K_11 + K_00*K_10 + K_02*K_12) + K_22*(K_00*(K_10*K_22 + K_12*K_20) + K_01*(K_11*K_22 + K_12*K_21) + K_02*(2.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21))) + w[2][0]*(K_01*K_11*K_21*K_21 + K_20*(K_00*K_10*K_20 + K_21*(K_00*K_11 + K_01*K_10)) + K_22*(K_02*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_12*(K_00*K_20 + K_01*K_21))));
    G[28] = W1*det*(K_00*K_12*w[2][0] + K_02*K_10*w[1][0]);
    G[29] = W1*det*(w[1][0]*(K_00*(K_00*(2.000000000000000*K_10*K_20 + K_11*K_21 + K_12*K_22) + K_02*(K_10*K_22 + K_12*K_20)) + K_01*(K_01*(K_10*K_20 + K_12*K_22) + K_11*(K_00*K_20 + K_02*K_22) + K_21*(2.000000000000000*K_01*K_11 + K_00*K_10 + K_02*K_12)) + K_02*K_02*(2.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21)) + w[2][0]*(K_00*(K_10*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_10 + K_01*K_11 + K_02*K_12)) + K_01*(K_02*K_11*K_22 + K_21*(K_01*K_11 + K_02*K_12)) + K_02*K_02*K_12*K_22));
    G[30] = W1*det*(K_12*w[2][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22) + w[1][0]*(K_02*(2.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21) + K_22*(K_00*K_10 + K_01*K_11)));
    G[31] = W1*det*(K_00*w[2][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22) + w[1][0]*(K_10*(K_01*K_21 + K_02*K_22) + K_20*(2.000000000000000*K_00*K_10 + K_01*K_11 + K_02*K_12)));
    G[32] = W1*det*(K_02*w[1][0]*(K_10*K_10 + K_11*K_11) + K_12*(w[1][0]*(2.000000000000000*K_02*K_12 + K_00*K_10 + K_01*K_11) + w[2][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12)));
    G[33] = W1*det*(w[1][0]*(2.000000000000000*K_02*K_02*K_12*K_12 + K_00*K_10*(2.000000000000000*K_00*K_10 + 4.000000000000000*K_02*K_12) + K_01*K_11*(2.000000000000000*K_01*K_11 + 4.000000000000000*(K_00*K_10 + K_02*K_12))) + w[2][0]*(K_00*K_00*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_01*K_01*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_02*K_02*(K_10*K_10 + K_11*K_11 + K_12*K_12)));
    G[34] = W1*det*(2.000000000000000*K_10*w[1][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12) + K_00*w[2][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[35] = W1*det*(K_00*K_00*(K_00*K_00*(w[2][0] + 2.000000000000000*w[1][0]) + K_01*K_01*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0]) + K_02*K_02*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0])) + K_01*K_01*K_01*K_01*(w[2][0] + 2.000000000000000*w[1][0]) + K_02*K_02*(K_01*K_01*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0]) + K_02*K_02*(w[2][0] + 2.000000000000000*w[1][0])));
    G[36] = W1*det*(w[1][0]*(2.000000000000000*(K_00*K_20*(K_00*K_20 + K_01*K_21) + K_01*K_01*K_21*K_21 + K_02*K_22*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_00*K_00*(K_21*K_21 + K_22*K_22) + K_01*K_01*K_22*K_22 + K_02*K_02*K_21*K_21 + K_20*K_20*(K_01*K_01 + K_02*K_02)) + w[2][0]*(K_00*K_20*(2.000000000000000*K_01*K_21 + K_00*K_20) + K_01*K_01*K_21*K_21 + K_02*K_22*(2.000000000000000*(K_00*K_20 + K_01*K_21) + K_02*K_22)));
    G[37] = W1*det*(K_00*(w[1][0]*(2.000000000000000*K_00*K_20 + K_01*K_21 + K_02*K_22) + w[2][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_20*w[1][0]*(K_01*K_01 + K_02*K_02));
    G[38] = W1*det*(K_01*(w[1][0]*(2.000000000000000*K_01*K_21 + K_00*K_20 + K_02*K_22) + w[2][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_21*w[1][0]*(K_00*K_00 + K_02*K_02));
    G[39] = K_01*W1*det*(2.000000000000000*w[1][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + w[2][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[40] = K_00*K_01*W1*det*(w[1][0] + w[2][0]);
    G[41] = W1*det*(K_01*(w[1][0]*(2.000000000000000*K_01*K_11 + K_00*K_10 + K_02*K_12) + w[2][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12)) + K_11*w[1][0]*(K_00*K_00 + K_02*K_02));
    G[42] = W1*det*(K_12*(w[1][0]*(2.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21) + w[2][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22)) + K_22*w[1][0]*(K_10*K_10 + K_11*K_11));
    G[43] = W1*det*(K_11*w[1][0]*(K_20*K_20 + K_22*K_22) + K_21*(w[1][0]*(2.000000000000000*K_11*K_21 + K_10*K_20 + K_12*K_22) + w[2][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22)));
    G[44] = W1*det*(2.000000000000000*w[1][0]*(K_10*K_10*K_10*K_20 + K_11*(K_11*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_21*(K_10*K_10 + K_12*K_12)) + K_12*(K_10*K_10*K_22 + K_12*(K_10*K_20 + K_12*K_22))) + w[2][0]*(K_10*K_10*K_10*K_20 + K_11*(K_11*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_21*(K_10*K_10 + K_12*K_12)) + K_12*(K_10*K_10*K_22 + K_12*(K_10*K_20 + K_12*K_22))));
    G[45] = W1*det*(K_21*w[2][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12) + w[1][0]*(K_01*(K_10*K_20 + K_12*K_22) + K_11*(2.000000000000000*K_01*K_21 + K_00*K_20 + K_02*K_22)));
    G[46] = W1*det*(w[1][0]*(2.000000000000000*K_12*K_12*K_22*K_22 + K_10*K_20*(2.000000000000000*K_10*K_20 + 4.000000000000000*(K_11*K_21 + K_12*K_22)) + K_11*K_21*(2.000000000000000*K_11*K_21 + 4.000000000000000*K_12*K_22)) + w[2][0]*(K_10*K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_11*K_11*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_12*K_12*(K_20*K_20 + K_21*K_21 + K_22*K_22)));
    G[47] = W1*det*(K_11*K_22*w[1][0] + K_12*K_21*w[2][0]);
    G[48] = W1*det*(2.000000000000000*K_22*w[1][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_12*w[2][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[49] = W1*det*(w[1][0]*(2.000000000000000*(K_10*K_20*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_11*K_11*K_21*K_21 + K_12*K_22*(K_11*K_21 + K_12*K_22)) + K_20*K_20*(K_11*K_11 + K_12*K_12) + K_21*K_21*(K_10*K_10 + K_12*K_12) + K_22*K_22*(K_10*K_10 + K_11*K_11)) + w[2][0]*(K_10*K_20*(2.000000000000000*K_11*K_21 + K_10*K_20) + K_11*K_11*K_21*K_21 + K_12*K_22*(2.000000000000000*(K_10*K_20 + K_11*K_21) + K_12*K_22)));
    G[50] = W1*det*(2.000000000000000*w[1][0]*(K_01*K_11*K_21*K_21 + K_20*(K_00*K_10*K_20 + K_21*(K_00*K_11 + K_01*K_10)) + K_22*(K_02*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_12*(K_00*K_20 + K_01*K_21))) + w[2][0]*(K_00*K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_01*K_11*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_02*K_12*(K_20*K_20 + K_21*K_21 + K_22*K_22)));
    G[51] = W1*det*(2.000000000000000*w[1][0]*(K_12*K_22*K_22*K_22 + K_20*(K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_20*(K_11*K_21 + K_12*K_22)) + K_21*(K_11*K_22*K_22 + K_21*(K_11*K_21 + K_12*K_22))) + w[2][0]*(K_12*K_22*K_22*K_22 + K_20*(K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_20*(K_11*K_21 + K_12*K_22)) + K_21*(K_11*K_22*K_22 + K_21*(K_11*K_21 + K_12*K_22))));
    G[52] = W1*det*(2.000000000000000*K_11*w[1][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_21*w[2][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[53] = W1*det*(2.000000000000000*K_01*w[1][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12) + K_11*w[2][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[54] = K_00*W1*det*(3.000000000000000*w[2][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + 6.000000000000000*w[1][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[55] = W1*det*(K_00*(K_01*K_21*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0]) + K_02*K_22*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0])) + K_20*(K_00*K_00*(3.000000000000000*w[2][0] + 6.000000000000000*w[1][0]) + K_01*K_01*(w[2][0] + 2.000000000000000*w[1][0]) + K_02*K_02*(w[2][0] + 2.000000000000000*w[1][0])));
    G[56] = W1*det*(K_00*(K_00*K_10*(3.000000000000000*w[2][0] + 6.000000000000000*w[1][0]) + K_01*K_11*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0]) + K_02*K_12*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0])) + K_10*(2.000000000000000*w[1][0]*(K_01*K_01 + K_02*K_02) + w[2][0]*(K_01*K_01 + K_02*K_02)));
    G[57] = W1*det*(2.000000000000000*K_01*w[1][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22) + K_21*w[2][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[58] = W1*det*(K_00*K_00*w[2][0] + w[1][0]*(2.000000000000000*K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[59] = W1*det*(0.500000000000000*w[2][0]*(K_00*K_20*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_01*K_21*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_02*K_22*(K_10*K_10 + K_11*K_11 + K_12*K_12)) + w[1][0]*(K_02*K_12*K_12*K_22 + K_10*(K_00*K_10*K_20 + K_12*(K_00*K_22 + K_02*K_20)) + K_11*(K_01*(K_10*K_20 + K_12*K_22) + K_21*(K_00*K_10 + K_01*K_11 + K_02*K_12))));
    G[60] = W1*det*(1.500000000000000*w[2][0]*(K_00*(K_00*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_21 + K_02*(K_01*(K_01*K_22 + K_02*K_21) + K_02*K_02*K_22)) + 3.000000000000000*w[1][0]*(K_00*(K_00*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_21 + K_02*(K_01*(K_01*K_22 + K_02*K_21) + K_02*K_02*K_22)));
    G[61] = W1*det*(w[1][0]*(2.000000000000000*(K_10*(K_00*K_21 + K_01*K_20) + K_11*(K_00*K_20 + K_02*K_22) + K_12*(K_01*K_22 + K_02*K_21)) + 6.000000000000000*K_01*K_11*K_21) + w[2][0]*(K_01*(3.000000000000000*K_11*K_21 + K_10*K_20 + K_12*K_22) + K_11*(K_00*K_20 + K_02*K_22) + K_21*(K_00*K_10 + K_02*K_12)));
    G[62] = W1*det*(w[1][0]*(K_10*(2.000000000000000*(K_11*(K_00*K_21 + K_01*K_20) + K_12*(K_00*K_22 + K_02*K_20)) + K_10*(3.000000000000000*K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_11*(2.000000000000000*K_12*(K_01*K_22 + K_02*K_21) + K_11*(3.000000000000000*K_01*K_21 + K_00*K_20 + K_02*K_22)) + K_12*K_12*(3.000000000000000*K_02*K_22 + K_00*K_20 + K_01*K_21)) + w[2][0]*(K_10*(K_10*(0.500000000000000*(K_01*K_21 + K_02*K_22) + 1.500000000000000*K_00*K_20) + K_11*(K_00*K_21 + K_01*K_20) + K_12*(K_00*K_22 + K_02*K_20)) + K_11*(K_11*(0.500000000000000*(K_00*K_20 + K_02*K_22) + 1.500000000000000*K_01*K_21) + K_12*(K_01*K_22 + K_02*K_21)) + K_12*K_12*(0.500000000000000*(K_00*K_20 + K_01*K_21) + 1.500000000000000*K_02*K_22)));
    G[63] = W1*det*(0.500000000000000*w[2][0]*(K_02*K_22*K_22*K_22 + K_20*(K_00*(K_21*K_21 + K_22*K_22) + K_20*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_21*(K_01*(K_21*K_21 + K_22*K_22) + K_02*K_21*K_22)) + w[1][0]*(K_02*K_22*K_22*K_22 + K_20*(K_00*(K_21*K_21 + K_22*K_22) + K_20*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_21*(K_01*(K_21*K_21 + K_22*K_22) + K_02*K_21*K_22)));
    G[64] = W1*det*(w[1][0]*(2.000000000000000*(K_00*K_00*(K_21*K_21 + K_22*K_22) + K_01*K_01*K_22*K_22 + K_02*K_02*K_21*K_21 + K_20*K_20*(K_01*K_01 + K_02*K_02)) + 6.000000000000000*K_00*K_00*K_20*K_20 + K_01*K_21*(6.000000000000000*K_01*K_21 + 8.000000000000000*K_00*K_20) + K_02*K_22*(6.000000000000000*K_02*K_22 + 8.000000000000000*(K_00*K_20 + K_01*K_21))) + w[2][0]*(4.000000000000000*K_01*K_02*K_21*K_22 + K_20*(4.000000000000000*K_00*(K_01*K_21 + K_02*K_22) + K_20*(3.000000000000000*K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_21*K_21*(3.000000000000000*K_01*K_01 + K_00*K_00 + K_02*K_02) + K_22*K_22*(3.000000000000000*K_02*K_02 + K_00*K_00 + K_01*K_01)));
    G[65] = W1*det*(K_00*w[1][0]*(K_21*K_21 + K_22*K_22) + K_20*(w[1][0]*(2.000000000000000*K_00*K_20 + K_01*K_21 + K_02*K_22) + w[2][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22)));
    G[66] = W1*det*(K_10*w[2][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22) + w[1][0]*(K_00*(K_11*K_21 + K_12*K_22) + K_20*(2.000000000000000*K_00*K_10 + K_01*K_11 + K_02*K_12)));
    G[67] = W1*det*(w[1][0]*(K_20*(4.000000000000000*K_21*(K_00*K_11 + K_01*K_10) + K_20*(2.000000000000000*(K_01*K_11 + K_02*K_12) + 6.000000000000000*K_00*K_10)) + K_21*K_21*(2.000000000000000*(K_00*K_10 + K_02*K_12) + 6.000000000000000*K_01*K_11) + K_22*(4.000000000000000*(K_20*(K_00*K_12 + K_02*K_10) + K_21*(K_01*K_12 + K_02*K_11)) + K_22*(2.000000000000000*(K_00*K_10 + K_01*K_11) + 6.000000000000000*K_02*K_12))) + w[2][0]*(K_20*(2.000000000000000*K_21*(K_00*K_11 + K_01*K_10) + K_20*(3.000000000000000*K_00*K_10 + K_01*K_11 + K_02*K_12)) + K_21*K_21*(3.000000000000000*K_01*K_11 + K_00*K_10 + K_02*K_12) + K_22*(2.000000000000000*(K_20*(K_00*K_12 + K_02*K_10) + K_21*(K_01*K_12 + K_02*K_11)) + K_22*(3.000000000000000*K_02*K_12 + K_00*K_10 + K_01*K_11))));
    G[68] = W1*det*(K_02*w[1][0]*(K_20*K_20 + K_21*K_21) + K_22*(w[1][0]*(2.000000000000000*K_02*K_22 + K_00*K_20 + K_01*K_21) + w[2][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22)));
    G[69] = W1*det*(0.500000000000000*w[2][0]*(K_00*(K_00*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_21 + K_02*(K_01*(K_01*K_22 + K_02*K_21) + K_02*K_02*K_22)) + w[1][0]*(K_00*(K_00*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_21 + K_02*(K_01*(K_01*K_22 + K_02*K_21) + K_02*K_02*K_22)));
    G[70] = W1*det*(K_02*(w[1][0]*(2.000000000000000*K_02*K_22 + K_00*K_20 + K_01*K_21) + w[2][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_22*w[1][0]*(K_00*K_00 + K_01*K_01));
    G[71] = W1*det*(K_01*(K_20*K_20*(w[2][0] + 2.000000000000000*w[1][0]) + K_21*K_21*(3.000000000000000*w[2][0] + 6.000000000000000*w[1][0]) + K_22*K_22*(w[2][0] + 2.000000000000000*w[1][0])) + K_21*(2.000000000000000*w[2][0]*(K_00*K_20 + K_02*K_22) + 4.000000000000000*w[1][0]*(K_00*K_20 + K_02*K_22)));
    G[72] = W1*det*(1.500000000000000*w[2][0]*(K_02*K_22*K_22*K_22 + K_20*(K_00*(K_21*K_21 + K_22*K_22) + K_20*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_21*(K_01*(K_21*K_21 + K_22*K_22) + K_02*K_21*K_22)) + 3.000000000000000*w[1][0]*(K_02*K_22*K_22*K_22 + K_20*(K_00*(K_21*K_21 + K_22*K_22) + K_20*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_21*(K_01*(K_21*K_21 + K_22*K_22) + K_02*K_21*K_22)));
    G[73] = W1*det*(K_01*K_21*(w[2][0] + 2.000000000000000*w[1][0]) + w[1][0]*(K_00*K_20 + K_02*K_22));
    G[74] = W1*det*(K_10*K_10*K_10*K_10*(w[2][0] + 2.000000000000000*w[1][0]) + K_11*K_11*(K_10*K_10*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0]) + K_11*K_11*(w[2][0] + 2.000000000000000*w[1][0])) + K_12*K_12*(2.000000000000000*w[2][0]*(K_10*K_10 + K_11*K_11) + 4.000000000000000*w[1][0]*(K_10*K_10 + K_11*K_11) + K_12*K_12*(w[2][0] + 2.000000000000000*w[1][0])));
    G[75] = W1*det*(K_00*w[1][0]*(K_11*K_11 + K_12*K_12) + K_10*(w[1][0]*(2.000000000000000*K_00*K_10 + K_01*K_11 + K_02*K_12) + w[2][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12)));
    G[76] = K_10*K_12*W1*det*(w[1][0] + w[2][0]);
    G[77] = W1*det*(K_10*(w[1][0]*(2.000000000000000*K_10*K_20 + K_11*K_21 + K_12*K_22) + w[2][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22)) + K_20*w[1][0]*(K_11*K_11 + K_12*K_12));
    G[78] = K_12*W1*det*(2.000000000000000*w[1][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + w[2][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[79] = K_10*W1*det*(2.000000000000000*w[1][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + w[2][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[80] = W1*det*(K_11*w[2][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22) + w[1][0]*(K_01*(K_10*K_20 + K_12*K_22) + K_21*(2.000000000000000*K_01*K_11 + K_00*K_10 + K_02*K_12)));
    G[81] = W1*det*(K_00*K_11*w[2][0] + K_01*K_10*w[1][0]);
    G[82] = W1*det*(K_01*w[1][0]*(K_10*K_10 + K_12*K_12) + K_11*(w[1][0]*(2.000000000000000*K_01*K_11 + K_00*K_10 + K_02*K_12) + w[2][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12)));
    G[83] = W1*det*(K_10*K_22*w[2][0] + K_12*K_20*w[1][0]);
    G[84] = W1*det*(K_22*w[2][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12) + w[1][0]*(K_02*(2.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21) + K_12*(K_00*K_20 + K_01*K_21)));
    G[85] = W1*det*(K_12*w[1][0]*(K_20*K_20 + K_21*K_21) + K_22*(w[1][0]*(2.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21) + w[2][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22)));
    G[86] = W1*det*(2.000000000000000*K_20*w[1][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_10*w[2][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[87] = W1*det*(2.000000000000000*K_12*w[1][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_22*w[2][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[88] = W1*det*(K_01*w[2][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22) + w[1][0]*(K_11*(K_00*K_20 + K_02*K_22) + K_21*(2.000000000000000*K_01*K_11 + K_00*K_10 + K_02*K_12)));
    G[89] = W1*det*(0.500000000000000*w[2][0]*(K_10*K_10*K_10*K_20 + K_11*(K_11*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_21*(K_10*K_10 + K_12*K_12)) + K_12*(K_10*K_10*K_22 + K_12*(K_10*K_20 + K_12*K_22))) + w[1][0]*(K_10*K_10*K_10*K_20 + K_11*(K_11*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_21*(K_10*K_10 + K_12*K_12)) + K_12*(K_10*K_10*K_22 + K_12*(K_10*K_20 + K_12*K_22))));
    G[90] = W1*det*(0.500000000000000*w[2][0]*(K_10*K_20*(K_00*K_00 + K_01*K_01 + K_02*K_02) + K_11*K_21*(K_00*K_00 + K_01*K_01 + K_02*K_02) + K_12*K_22*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + w[1][0]*(K_00*(K_10*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_10 + K_01*K_11 + K_02*K_12)) + K_01*(K_02*K_11*K_22 + K_21*(K_01*K_11 + K_02*K_12)) + K_02*K_02*K_12*K_22));
    G[91] = W1*det*(w[1][0]*(K_10*(4.000000000000000*(K_11*(K_00*K_21 + K_01*K_20) + K_12*(K_00*K_22 + K_02*K_20)) + K_10*(2.000000000000000*(K_01*K_21 + K_02*K_22) + 6.000000000000000*K_00*K_20)) + K_11*(4.000000000000000*K_12*(K_01*K_22 + K_02*K_21) + K_11*(2.000000000000000*(K_00*K_20 + K_02*K_22) + 6.000000000000000*K_01*K_21)) + K_12*K_12*(2.000000000000000*(K_00*K_20 + K_01*K_21) + 6.000000000000000*K_02*K_22)) + w[2][0]*(K_10*(2.000000000000000*(K_11*(K_00*K_21 + K_01*K_20) + K_12*(K_00*K_22 + K_02*K_20)) + K_10*(3.000000000000000*K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_11*(2.000000000000000*K_12*(K_01*K_22 + K_02*K_21) + K_11*(3.000000000000000*K_01*K_21 + K_00*K_20 + K_02*K_22)) + K_12*K_12*(3.000000000000000*K_02*K_22 + K_00*K_20 + K_01*K_21)));
    G[92] = W1*det*(K_11*(w[1][0]*(2.000000000000000*K_11*K_21 + K_10*K_20 + K_12*K_22) + w[2][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22)) + K_21*w[1][0]*(K_10*K_10 + K_12*K_12));
    G[93] = W1*det*(0.500000000000000*w[2][0]*(K_12*K_22*K_22*K_22 + K_20*(K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_20*(K_11*K_21 + K_12*K_22)) + K_21*(K_11*K_22*K_22 + K_21*(K_11*K_21 + K_12*K_22))) + w[1][0]*(K_12*K_22*K_22*K_22 + K_20*(K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_20*(K_11*K_21 + K_12*K_22)) + K_21*(K_11*K_22*K_22 + K_21*(K_11*K_21 + K_12*K_22))));
    G[94] = W1*det*(K_10*w[1][0]*(K_21*K_21 + K_22*K_22) + K_20*(w[1][0]*(2.000000000000000*K_10*K_20 + K_11*K_21 + K_12*K_22) + w[2][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22)));
    G[95] = W1*det*(1.500000000000000*w[2][0]*(K_10*K_10*K_10*K_20 + K_11*(K_11*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_21*(K_10*K_10 + K_12*K_12)) + K_12*(K_10*K_10*K_22 + K_12*(K_10*K_20 + K_12*K_22))) + 3.000000000000000*w[1][0]*(K_10*K_10*K_10*K_20 + K_11*(K_11*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_21*(K_10*K_10 + K_12*K_12)) + K_12*(K_10*K_10*K_22 + K_12*(K_10*K_20 + K_12*K_22))));
    G[96] = W1*det*(K_12*(K_20*K_20*(w[2][0] + 2.000000000000000*w[1][0]) + K_21*K_21*(w[2][0] + 2.000000000000000*w[1][0]) + K_22*K_22*(3.000000000000000*w[2][0] + 6.000000000000000*w[1][0])) + K_22*(2.000000000000000*w[2][0]*(K_10*K_20 + K_11*K_21) + 4.000000000000000*w[1][0]*(K_10*K_20 + K_11*K_21)));
    G[97] = W1*det*(w[1][0]*(K_00*(2.000000000000000*K_02*(K_10*K_22 + K_12*K_20) + K_00*(3.000000000000000*K_10*K_20 + K_11*K_21 + K_12*K_22)) + K_01*(2.000000000000000*(K_11*(K_00*K_20 + K_02*K_22) + K_21*(K_00*K_10 + K_02*K_12)) + K_01*(3.000000000000000*K_11*K_21 + K_10*K_20 + K_12*K_22)) + K_02*K_02*(3.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21)) + w[2][0]*(K_00*(K_00*(0.500000000000000*(K_11*K_21 + K_12*K_22) + 1.500000000000000*K_10*K_20) + K_02*(K_10*K_22 + K_12*K_20)) + K_01*(K_01*(0.500000000000000*(K_10*K_20 + K_12*K_22) + 1.500000000000000*K_11*K_21) + K_11*(K_00*K_20 + K_02*K_22) + K_21*(K_00*K_10 + K_02*K_12)) + K_02*K_02*(0.500000000000000*(K_10*K_20 + K_11*K_21) + 1.500000000000000*K_12*K_22)));
    G[98] = W1*det*(1.500000000000000*w[2][0]*(K_12*K_22*K_22*K_22 + K_20*(K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_20*(K_11*K_21 + K_12*K_22)) + K_21*(K_11*K_22*K_22 + K_21*(K_11*K_21 + K_12*K_22))) + 3.000000000000000*w[1][0]*(K_12*K_22*K_22*K_22 + K_20*(K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_20*(K_11*K_21 + K_12*K_22)) + K_21*(K_11*K_22*K_22 + K_21*(K_11*K_21 + K_12*K_22))));
    G[99] = W1*det*(w[1][0]*(2.000000000000000*(K_10*(K_00*K_22 + K_02*K_20) + K_11*(K_01*K_22 + K_02*K_21) + K_12*(K_00*K_20 + K_01*K_21)) + 6.000000000000000*K_02*K_12*K_22) + w[2][0]*(K_00*(K_10*K_22 + K_12*K_20) + K_01*(K_11*K_22 + K_12*K_21) + K_02*(3.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21)));
    G[100] = W1*det*(K_12*K_22*w[2][0] + w[1][0]*(2.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21));
    G[101] = W1*det*(w[1][0]*(2.000000000000000*(K_20*K_20*(K_11*K_11 + K_12*K_12) + K_21*K_21*(K_10*K_10 + K_12*K_12) + K_22*K_22*(K_10*K_10 + K_11*K_11)) + 6.000000000000000*K_12*K_12*K_22*K_22 + K_10*K_20*(6.000000000000000*K_10*K_20 + 8.000000000000000*(K_11*K_21 + K_12*K_22)) + K_11*K_21*(6.000000000000000*K_11*K_21 + 8.000000000000000*K_12*K_22)) + w[2][0]*(4.000000000000000*K_10*K_12*K_20*K_22 + K_10*K_10*(3.000000000000000*K_20*K_20 + K_21*K_21 + K_22*K_22) + K_11*(K_11*(K_20*K_20 + K_22*K_22) + K_21*(3.000000000000000*K_11*K_21 + 4.000000000000000*(K_10*K_20 + K_12*K_22))) + K_12*K_12*(3.000000000000000*K_22*K_22 + K_20*K_20 + K_21*K_21)));
    G[102] = W1*det*(K_12*(w[1][0]*(4.000000000000000*(K_10*K_20 + K_11*K_21) + 6.000000000000000*K_12*K_22) + w[2][0]*(2.000000000000000*(K_10*K_20 + K_11*K_21) + 3.000000000000000*K_12*K_22)) + K_22*(2.000000000000000*w[1][0]*(K_10*K_10 + K_11*K_11) + w[2][0]*(K_10*K_10 + K_11*K_11)));
    G[103] = W1*det*(2.000000000000000*w[1][0]*(K_02*K_22*K_22*K_22 + K_20*(K_00*(K_21*K_21 + K_22*K_22) + K_20*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_21*(K_01*(K_21*K_21 + K_22*K_22) + K_02*K_21*K_22)) + w[2][0]*(K_02*K_22*K_22*K_22 + K_20*(K_00*(K_21*K_21 + K_22*K_22) + K_20*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_21*(K_01*(K_21*K_21 + K_22*K_22) + K_02*K_21*K_22)));
    G[104] = W1*det*(K_20*K_20*(K_20*K_20*(w[2][0] + 2.000000000000000*w[1][0]) + K_21*K_21*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0])) + K_21*K_21*K_21*K_21*(w[2][0] + 2.000000000000000*w[1][0]) + K_22*K_22*(K_20*K_20*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0]) + K_21*K_21*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0]) + K_22*K_22*(w[2][0] + 2.000000000000000*w[1][0])));
    G[105] = K_20*K_22*W1*det*(w[1][0] + w[2][0]);
    G[106] = K_22*W1*det*(2.000000000000000*w[1][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + w[2][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[107] = K_20*W1*det*(2.000000000000000*w[1][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + w[2][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[108] = W1*det*(2.000000000000000*K_21*w[1][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22) + K_01*w[2][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[109] = W1*det*(0.500000000000000*w[2][0]*(K_10*K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_11*K_11*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_12*K_12*(K_20*K_20 + K_21*K_21 + K_22*K_22)) + w[1][0]*(K_10*K_20*(2.000000000000000*K_11*K_21 + K_10*K_20) + K_11*K_11*K_21*K_21 + K_12*K_22*(2.000000000000000*(K_10*K_20 + K_11*K_21) + K_12*K_22)));
    G[110] = W1*det*(2.000000000000000*K_21*w[1][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_11*w[2][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[111] = W1*det*(K_20*K_20*(K_20*K_20*(w[1][0] + 0.500000000000000*w[2][0]) + K_21*K_21*(w[2][0] + 2.000000000000000*w[1][0])) + K_21*K_21*K_21*K_21*(w[1][0] + 0.500000000000000*w[2][0]) + K_22*K_22*(K_20*K_20*(w[2][0] + 2.000000000000000*w[1][0]) + K_21*K_21*(w[2][0] + 2.000000000000000*w[1][0]) + K_22*K_22*(w[1][0] + 0.500000000000000*w[2][0])));
    G[112] = W1*det*(2.000000000000000*K_20*w[1][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22) + K_00*w[2][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[113] = W1*det*(3.000000000000000*w[2][0]*(K_02*K_22*K_22*K_22 + K_20*(K_00*(K_21*K_21 + K_22*K_22) + K_20*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_21*(K_01*(K_21*K_21 + K_22*K_22) + K_02*K_21*K_22)) + 6.000000000000000*w[1][0]*(K_02*K_22*K_22*K_22 + K_20*(K_00*(K_21*K_21 + K_22*K_22) + K_20*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_21*(K_01*(K_21*K_21 + K_22*K_22) + K_02*K_21*K_22)));
    G[114] = W1*det*(w[1][0]*(4.000000000000000*K_10*K_12*K_20*K_22 + K_10*K_10*(3.000000000000000*K_20*K_20 + K_21*K_21 + K_22*K_22) + K_11*(K_11*(K_20*K_20 + K_22*K_22) + K_21*(3.000000000000000*K_11*K_21 + 4.000000000000000*(K_10*K_20 + K_12*K_22))) + K_12*K_12*(3.000000000000000*K_22*K_22 + K_20*K_20 + K_21*K_21)) + w[2][0]*(0.500000000000000*(K_20*K_20*(K_11*K_11 + K_12*K_12) + K_21*K_21*(K_10*K_10 + K_12*K_12) + K_22*K_22*(K_10*K_10 + K_11*K_11)) + 1.500000000000000*K_12*K_12*K_22*K_22 + K_10*K_20*(1.500000000000000*K_10*K_20 + 2.000000000000000*(K_11*K_21 + K_12*K_22)) + K_11*K_21*(1.500000000000000*K_11*K_21 + 2.000000000000000*K_12*K_22)));
    G[115] = K_22*W1*det*(3.000000000000000*w[2][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + 6.000000000000000*w[1][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[116] = W1*det*(K_20*K_20*(K_20*K_20*(1.500000000000000*w[2][0] + 3.000000000000000*w[1][0]) + K_21*K_21*(3.000000000000000*w[2][0] + 6.000000000000000*w[1][0])) + K_21*K_21*K_21*K_21*(1.500000000000000*w[2][0] + 3.000000000000000*w[1][0]) + K_22*K_22*(K_20*K_20*(3.000000000000000*w[2][0] + 6.000000000000000*w[1][0]) + K_21*K_21*(3.000000000000000*w[2][0] + 6.000000000000000*w[1][0]) + K_22*K_22*(1.500000000000000*w[2][0] + 3.000000000000000*w[1][0])));
    G[117] = W1*det*(K_02*(2.000000000000000*w[1][0]*(K_20*K_20 + K_21*K_21) + w[2][0]*(K_20*K_20 + K_21*K_21)) + K_22*(K_00*K_20*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0]) + K_01*K_21*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0]) + K_02*K_22*(3.000000000000000*w[2][0] + 6.000000000000000*w[1][0])));
    G[118] = K_21*W1*det*(2.000000000000000*w[1][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + w[2][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[119] = W1*det*(K_22*K_22*w[2][0] + w[1][0]*(2.000000000000000*K_22*K_22 + K_20*K_20 + K_21*K_21));
    G[120] = W1*det*(3.000000000000000*w[2][0]*(K_12*K_22*K_22*K_22 + K_20*(K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_20*(K_11*K_21 + K_12*K_22)) + K_21*(K_11*K_22*K_22 + K_21*(K_11*K_21 + K_12*K_22))) + 6.000000000000000*w[1][0]*(K_12*K_22*K_22*K_22 + K_20*(K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_20*(K_11*K_21 + K_12*K_22)) + K_21*(K_11*K_22*K_22 + K_21*(K_11*K_21 + K_12*K_22))));
    G[121] = K_10*K_11*W1*det*(w[1][0] + w[2][0]);
    G[122] = K_11*W1*det*(2.000000000000000*w[1][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + w[2][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[123] = W1*det*(K_20*w[2][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12) + w[1][0]*(K_00*(K_11*K_21 + K_12*K_22) + K_10*(2.000000000000000*K_00*K_20 + K_01*K_21 + K_02*K_22)));
    G[124] = W1*det*(K_10*K_22*w[1][0] + K_12*K_20*w[2][0]);
    G[125] = W1*det*(2.000000000000000*K_10*w[1][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_20*w[2][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[126] = W1*det*(K_02*(K_00*K_20*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0]) + K_01*K_21*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0])) + K_22*(2.000000000000000*w[1][0]*(K_00*K_00 + K_01*K_01) + K_02*K_02*(3.000000000000000*w[2][0] + 6.000000000000000*w[1][0]) + w[2][0]*(K_00*K_00 + K_01*K_01)));
    G[127] = W1*det*(K_01*w[1][0]*(K_20*K_20 + K_22*K_22) + K_21*(w[1][0]*(2.000000000000000*K_01*K_21 + K_00*K_20 + K_02*K_22) + w[2][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22)));
    G[128] = W1*det*(K_02*K_22*w[2][0] + w[1][0]*(2.000000000000000*K_02*K_22 + K_00*K_20 + K_01*K_21));
    G[129] = W1*det*(0.500000000000000*w[2][0]*(K_02*K_12*K_12*K_12 + K_10*(K_00*K_10*K_10 + K_12*(K_00*K_12 + K_02*K_10)) + K_11*(K_01*(K_10*K_10 + K_12*K_12) + K_11*(K_00*K_10 + K_01*K_11 + K_02*K_12))) + w[1][0]*(K_02*K_12*K_12*K_12 + K_10*(K_00*K_10*K_10 + K_12*(K_00*K_12 + K_02*K_10)) + K_11*(K_01*(K_10*K_10 + K_12*K_12) + K_11*(K_00*K_10 + K_01*K_11 + K_02*K_12))));
    G[130] = W1*det*(K_01*(w[1][0]*(2.000000000000000*(K_10*K_10 + K_12*K_12) + 6.000000000000000*K_11*K_11) + w[2][0]*(3.000000000000000*K_11*K_11 + K_10*K_10 + K_12*K_12)) + K_11*(K_00*K_10*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0]) + K_02*K_12*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0])));
    G[131] = W1*det*(1.500000000000000*w[2][0]*(K_02*K_12*K_12*K_12 + K_10*(K_00*K_10*K_10 + K_12*(K_00*K_12 + K_02*K_10)) + K_11*(K_01*(K_10*K_10 + K_12*K_12) + K_11*(K_00*K_10 + K_01*K_11 + K_02*K_12))) + 3.000000000000000*w[1][0]*(K_02*K_12*K_12*K_12 + K_10*(K_00*K_10*K_10 + K_12*(K_00*K_12 + K_02*K_10)) + K_11*(K_01*(K_10*K_10 + K_12*K_12) + K_11*(K_00*K_10 + K_01*K_11 + K_02*K_12))));
    G[132] = W1*det*(0.500000000000000*w[2][0]*(K_00*K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_01*K_11*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_02*K_12*(K_20*K_20 + K_21*K_21 + K_22*K_22)) + w[1][0]*(K_01*K_11*K_21*K_21 + K_20*(K_00*K_10*K_20 + K_21*(K_00*K_11 + K_01*K_10)) + K_22*(K_02*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_12*(K_00*K_20 + K_01*K_21))));
    G[133] = W1*det*(w[1][0]*(K_20*(2.000000000000000*K_21*(K_00*K_11 + K_01*K_10) + K_20*(3.000000000000000*K_00*K_10 + K_01*K_11 + K_02*K_12)) + K_21*K_21*(3.000000000000000*K_01*K_11 + K_00*K_10 + K_02*K_12) + K_22*(2.000000000000000*(K_20*(K_00*K_12 + K_02*K_10) + K_21*(K_01*K_12 + K_02*K_11)) + K_22*(3.000000000000000*K_02*K_12 + K_00*K_10 + K_01*K_11))) + w[2][0]*(K_20*(0.500000000000000*K_20*(K_01*K_11 + K_02*K_12) + K_00*(K_11*K_21 + K_12*K_22) + K_10*(1.500000000000000*K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_21*K_21*(0.500000000000000*(K_00*K_10 + K_02*K_12) + 1.500000000000000*K_01*K_11) + K_22*(K_21*(K_01*K_12 + K_02*K_11) + K_22*(0.500000000000000*(K_00*K_10 + K_01*K_11) + 1.500000000000000*K_02*K_12))));
    G[134] = W1*det*(0.500000000000000*w[2][0]*(K_00*(K_00*(K_01*K_11 + K_02*K_12) + K_10*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_11 + K_02*(K_01*(K_01*K_12 + K_02*K_11) + K_02*K_02*K_12)) + w[1][0]*(K_00*(K_00*(K_01*K_11 + K_02*K_12) + K_10*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_11 + K_02*(K_01*(K_01*K_12 + K_02*K_11) + K_02*K_02*K_12)));
    G[135] = W1*det*(K_02*(w[1][0]*(2.000000000000000*K_02*K_12 + K_00*K_10 + K_01*K_11) + w[2][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12)) + K_12*w[1][0]*(K_00*K_00 + K_01*K_01));
    G[136] = W1*det*(1.500000000000000*w[2][0]*(K_00*(K_00*(K_01*K_11 + K_02*K_12) + K_10*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_11 + K_02*(K_01*(K_01*K_12 + K_02*K_11) + K_02*K_02*K_12)) + 3.000000000000000*w[1][0]*(K_00*(K_00*(K_01*K_11 + K_02*K_12) + K_10*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_11 + K_02*(K_01*(K_01*K_12 + K_02*K_11) + K_02*K_02*K_12)));
    G[137] = W1*det*(K_01*K_11*(w[2][0] + 2.000000000000000*w[1][0]) + w[1][0]*(K_00*K_10 + K_02*K_12));
    G[138] = W1*det*(w[1][0]*(2.000000000000000*(K_00*K_00*K_11*K_11 + K_01*K_01*K_10*K_10 + K_02*K_02*(K_10*K_10 + K_11*K_11) + K_12*K_12*(K_00*K_00 + K_01*K_01)) + 6.000000000000000*K_02*K_02*K_12*K_12 + K_00*K_10*(6.000000000000000*K_00*K_10 + 8.000000000000000*K_02*K_12) + K_01*K_11*(6.000000000000000*K_01*K_11 + 8.000000000000000*(K_00*K_10 + K_02*K_12))) + w[2][0]*(4.000000000000000*K_00*K_02*K_10*K_12 + K_10*K_10*(3.000000000000000*K_00*K_00 + K_01*K_01 + K_02*K_02) + K_11*(4.000000000000000*K_01*(K_00*K_10 + K_02*K_12) + K_11*(3.000000000000000*K_01*K_01 + K_00*K_00 + K_02*K_02)) + K_12*K_12*(3.000000000000000*K_02*K_02 + K_00*K_00 + K_01*K_01)));
    G[139] = W1*det*(K_02*w[2][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22) + w[1][0]*(K_12*(2.000000000000000*K_02*K_22 + K_00*K_20 + K_01*K_21) + K_22*(K_00*K_10 + K_01*K_11)));
    G[140] = W1*det*(K_01*K_22*w[1][0] + K_02*K_21*w[2][0]);
    G[141] = W1*det*(2.000000000000000*K_22*w[1][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22) + K_02*w[2][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[142] = W1*det*(w[1][0]*(2.000000000000000*K_00*K_00*K_20*K_20 + K_01*K_21*(2.000000000000000*K_01*K_21 + 4.000000000000000*K_00*K_20) + K_02*K_22*(2.000000000000000*K_02*K_22 + 4.000000000000000*(K_00*K_20 + K_01*K_21))) + w[2][0]*(K_00*K_00*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_01*K_01*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_02*K_02*(K_20*K_20 + K_21*K_21 + K_22*K_22)));
    G[143] = K_02*W1*det*(3.000000000000000*w[2][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + 6.000000000000000*w[1][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[144] = W1*det*(K_02*K_02*w[2][0] + w[1][0]*(2.000000000000000*K_02*K_02 + K_00*K_00 + K_01*K_01));
    G[145] = W1*det*(K_02*(2.000000000000000*w[2][0]*(K_00*K_10 + K_01*K_11) + 4.000000000000000*w[1][0]*(K_00*K_10 + K_01*K_11)) + K_12*(2.000000000000000*w[1][0]*(K_00*K_00 + K_01*K_01) + K_02*K_02*(3.000000000000000*w[2][0] + 6.000000000000000*w[1][0]) + w[2][0]*(K_00*K_00 + K_01*K_01)));
    G[146] = W1*det*(K_11*(2.000000000000000*w[2][0]*(K_10*K_20 + K_12*K_22) + 4.000000000000000*w[1][0]*(K_10*K_20 + K_12*K_22)) + K_21*(w[1][0]*(2.000000000000000*(K_10*K_10 + K_12*K_12) + 6.000000000000000*K_11*K_11) + w[2][0]*(3.000000000000000*K_11*K_11 + K_10*K_10 + K_12*K_12)));
    G[147] = W1*det*(K_11*(2.000000000000000*w[1][0]*(K_20*K_20 + K_22*K_22) + w[2][0]*(K_20*K_20 + K_22*K_22)) + K_21*(w[1][0]*(4.000000000000000*(K_10*K_20 + K_12*K_22) + 6.000000000000000*K_11*K_21) + w[2][0]*(2.000000000000000*(K_10*K_20 + K_12*K_22) + 3.000000000000000*K_11*K_21)));
    G[148] = W1*det*(K_11*K_21*w[2][0] + w[1][0]*(2.000000000000000*K_11*K_21 + K_10*K_20 + K_12*K_22));
    G[149] = W1*det*(K_00*K_21*w[1][0] + K_01*K_20*w[2][0]);
    G[150] = W1*det*(K_11*K_22*w[2][0] + K_12*K_21*w[1][0]);
    G[151] = W1*det*(w[1][0]*(2.000000000000000*(K_00*K_12*K_22 + K_01*K_10*K_21 + K_02*(K_10*K_22 + K_12*K_20) + K_11*(K_00*K_21 + K_01*K_20)) + 6.000000000000000*K_00*K_10*K_20) + w[2][0]*(K_10*(3.000000000000000*K_00*K_20 + K_01*K_21 + K_02*K_22) + K_11*(K_00*K_21 + K_01*K_20) + K_12*(K_00*K_22 + K_02*K_20)));
    G[152] = W1*det*(K_10*(2.000000000000000*w[1][0]*(K_21*K_21 + K_22*K_22) + w[2][0]*(K_21*K_21 + K_22*K_22)) + K_20*(w[1][0]*(4.000000000000000*(K_11*K_21 + K_12*K_22) + 6.000000000000000*K_10*K_20) + w[2][0]*(2.000000000000000*(K_11*K_21 + K_12*K_22) + 3.000000000000000*K_10*K_20)));
    G[153] = W1*det*(K_10*(K_11*K_21*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0]) + K_12*K_22*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0])) + K_20*(K_10*K_10*(3.000000000000000*w[2][0] + 6.000000000000000*w[1][0]) + K_11*K_11*(w[2][0] + 2.000000000000000*w[1][0]) + K_12*K_12*(w[2][0] + 2.000000000000000*w[1][0])));
    G[154] = W1*det*(K_10*K_20*w[2][0] + w[1][0]*(2.000000000000000*K_10*K_20 + K_11*K_21 + K_12*K_22));
    G[155] = W1*det*(K_00*K_22*w[1][0] + K_02*K_20*w[2][0]);
    G[156] = W1*det*(K_01*K_22*w[2][0] + K_02*K_21*w[1][0]);
    G[157] = W1*det*(2.000000000000000*K_12*w[1][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12) + K_02*w[2][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[158] = W1*det*(K_01*K_12*w[1][0] + K_02*K_11*w[2][0]);
    G[159] = W1*det*(K_02*K_12*(w[2][0] + 2.000000000000000*w[1][0]) + w[1][0]*(K_00*K_10 + K_01*K_11));
    G[160] = W1*det*(K_02*(2.000000000000000*w[1][0]*(K_10*K_10 + K_11*K_11) + w[2][0]*(K_10*K_10 + K_11*K_11)) + K_12*(K_00*K_10*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0]) + K_01*K_11*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0]) + K_02*K_12*(3.000000000000000*w[2][0] + 6.000000000000000*w[1][0])));
    G[161] = W1*det*(K_00*(K_10*K_10*(3.000000000000000*w[2][0] + 6.000000000000000*w[1][0]) + K_11*K_11*(w[2][0] + 2.000000000000000*w[1][0]) + K_12*K_12*(w[2][0] + 2.000000000000000*w[1][0])) + K_10*(K_01*K_11*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0]) + K_02*K_12*(2.000000000000000*w[2][0] + 4.000000000000000*w[1][0])));
    G[162] = W1*det*(K_00*K_10*(w[2][0] + 2.000000000000000*w[1][0]) + w[1][0]*(K_01*K_11 + K_02*K_12));
    G[163] = W1*det*(K_00*K_22*w[2][0] + K_02*K_20*w[1][0]);
    G[164] = W1*det*(K_10*K_21*w[2][0] + K_11*K_20*w[1][0]);
    G[165] = W1*det*(K_00*K_12*w[1][0] + K_02*K_10*w[2][0]);
    G[166] = K_20*K_21*W1*det*(w[1][0] + w[2][0]);
    G[167] = W1*det*(K_00*K_11*w[1][0] + K_01*K_10*w[2][0]);
    G[168] = W1*det*(2.000000000000000*K_11*w[1][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12) + K_01*w[2][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[169] = W1*det*(K_01*K_12*w[2][0] + K_02*K_11*w[1][0]);
    G[170] = W1*det*(K_00*(2.000000000000000*w[1][0]*(K_21*K_21 + K_22*K_22) + w[2][0]*(K_21*K_21 + K_22*K_22)) + K_20*(w[1][0]*(4.000000000000000*(K_01*K_21 + K_02*K_22) + 6.000000000000000*K_00*K_20) + w[2][0]*(2.000000000000000*(K_01*K_21 + K_02*K_22) + 3.000000000000000*K_00*K_20)));
    G[171] = W1*det*(K_00*K_20*w[2][0] + w[1][0]*(2.000000000000000*K_00*K_20 + K_01*K_21 + K_02*K_22));
    G[172] = K_21*K_22*W1*det*(w[1][0] + w[2][0]);
    G[173] = W1*det*(K_00*K_21*w[2][0] + K_01*K_20*w[1][0]);
    G[174] = K_21*W1*det*(3.000000000000000*w[2][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + 6.000000000000000*w[1][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[175] = W1*det*(K_21*K_21*w[2][0] + w[1][0]*(2.000000000000000*K_21*K_21 + K_20*K_20 + K_22*K_22));
    G[176] = K_01*K_02*W1*det*(w[1][0] + w[2][0]);
    G[177] = K_11*K_12*W1*det*(w[1][0] + w[2][0]);
    G[178] = K_20*W1*det*(3.000000000000000*w[2][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + 6.000000000000000*w[1][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[179] = W1*det*(K_20*K_20*w[2][0] + w[1][0]*(2.000000000000000*K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[180] = W1*det*(3.000000000000000*w[2][0]*(K_02*K_12*K_12*K_12 + K_10*(K_00*K_10*K_10 + K_12*(K_00*K_12 + K_02*K_10)) + K_11*(K_01*(K_10*K_10 + K_12*K_12) + K_11*(K_00*K_10 + K_01*K_11 + K_02*K_12))) + 6.000000000000000*w[1][0]*(K_02*K_12*K_12*K_12 + K_10*(K_00*K_10*K_10 + K_12*(K_00*K_12 + K_02*K_10)) + K_11*(K_01*(K_10*K_10 + K_12*K_12) + K_11*(K_00*K_10 + K_01*K_11 + K_02*K_12))));
    G[181] = K_10*W1*det*(3.000000000000000*w[2][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + 6.000000000000000*w[1][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[182] = W1*det*(K_10*K_10*K_10*K_10*(1.500000000000000*w[2][0] + 3.000000000000000*w[1][0]) + K_11*K_11*(K_10*K_10*(3.000000000000000*w[2][0] + 6.000000000000000*w[1][0]) + K_11*K_11*(1.500000000000000*w[2][0] + 3.000000000000000*w[1][0])) + K_12*K_12*(3.000000000000000*w[2][0]*(K_10*K_10 + K_11*K_11) + 6.000000000000000*w[1][0]*(K_10*K_10 + K_11*K_11) + K_12*K_12*(1.500000000000000*w[2][0] + 3.000000000000000*w[1][0])));
    G[183] = W1*det*(K_10*K_10*K_10*K_10*(w[1][0] + 0.500000000000000*w[2][0]) + K_11*K_11*(K_10*K_10*(w[2][0] + 2.000000000000000*w[1][0]) + K_11*K_11*(w[1][0] + 0.500000000000000*w[2][0])) + K_12*K_12*(2.000000000000000*w[1][0]*(K_10*K_10 + K_11*K_11) + K_12*K_12*(w[1][0] + 0.500000000000000*w[2][0]) + w[2][0]*(K_10*K_10 + K_11*K_11)));
    G[184] = W1*det*(3.000000000000000*w[2][0]*(K_10*K_10*K_10*K_20 + K_11*(K_11*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_21*(K_10*K_10 + K_12*K_12)) + K_12*(K_10*K_10*K_22 + K_12*(K_10*K_20 + K_12*K_22))) + 6.000000000000000*w[1][0]*(K_10*K_10*K_10*K_20 + K_11*(K_11*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_21*(K_10*K_10 + K_12*K_12)) + K_12*(K_10*K_10*K_22 + K_12*(K_10*K_20 + K_12*K_22))));
    G[185] = W1*det*(K_10*K_10*w[2][0] + w[1][0]*(2.000000000000000*K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[186] = W1*det*(K_12*K_12*(w[2][0] + 2.000000000000000*w[1][0]) + w[1][0]*(K_10*K_10 + K_11*K_11));
    G[187] = K_12*W1*det*(3.000000000000000*w[2][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + 6.000000000000000*w[1][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[188] = W1*det*(K_10*K_21*w[1][0] + K_11*K_20*w[2][0]);
    G[189] = K_11*W1*det*(3.000000000000000*w[2][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + 6.000000000000000*w[1][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[190] = W1*det*(K_11*K_11*w[2][0] + w[1][0]*(2.000000000000000*K_11*K_11 + K_10*K_10 + K_12*K_12));
    G[191] = K_00*K_02*W1*det*(w[1][0] + w[2][0]);
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 2792
    // Only 1 integration point, omitting IP loop.
    
    // Coefficient declarations.
    double F0 = 0.000000000000000;
    double F1 = 0.000000000000000;
    double F2 = 0.000000000000000;
    double F3 = 0.000000000000000;
    double F4 = 0.000000000000000;
    double F5 = 0.000000000000000;
    double F6 = 0.000000000000000;
    double F7 = 0.000000000000000;
    double F8 = 0.000000000000000;
    
    // Total number of operations to compute function values = 36
    for (unsigned int r = 0; r < 2; r++)
    {
      F0 += FE1_C0_D001[0][r]*w[0][nzc3[r]];
      F1 += FE1_C0_D001[0][r]*w[0][nzc2[r]];
      F2 += FE1_C0_D001[0][r]*w[0][nzc1[r]];
      F3 += FE1_C0_D001[0][r]*w[0][nzc7[r]];
      F4 += FE1_C0_D001[0][r]*w[0][nzc6[r]];
      F5 += FE1_C0_D001[0][r]*w[0][nzc5[r]];
      F6 += FE1_C0_D001[0][r]*w[0][nzc11[r]];
      F7 += FE1_C0_D001[0][r]*w[0][nzc10[r]];
      F8 += FE1_C0_D001[0][r]*w[0][nzc9[r]];
    }// end loop over 'r'
    
    // Number of operations to compute ip constants: 1784
    double I[45];
    // Number of operations: 54
    I[0] = (G[19] + F0*(G[9] + F0*G[15]) + F1*(G[18] + F0*G[0] + F1*G[2] + F2*G[5]) + F2*(G[10] + F0*G[13] + F2*G[6]) + F3*(G[1] + F3*G[11] + F4*G[20]) + F4*(G[3] + F4*G[4]) + F5*(G[17] + F3*G[8] + F4*G[12] + F5*G[7]) + F6*(G[16] + F6*G[15] + F7*G[0]) + F7*(G[21] + F7*G[2]) + F8*(G[14] + F6*G[13] + F7*G[5] + F8*G[6]));
    
    // Number of operations: 30
    I[1] = (G[28] + F0*G[21] + F1*G[32] + F2*G[30] + F6*(G[25] + F0*G[0] + F1*G[26] + F2*G[29]) + F7*(G[34] + F0*G[33] + F1*G[24] + F2*G[23]) + F8*(G[31] + F0*G[5] + F1*G[22] + F2*G[27]));
    
    // Number of operations: 30
    I[2] = (G[40] + F0*G[39] + F1*G[41] + F2*G[38] + F3*(G[9] + F0*G[35] + F1*G[0] + F2*G[13]) + F4*(G[25] + F0*G[0] + F1*G[26] + F2*G[29]) + F5*(G[37] + F0*G[13] + F1*G[29] + F2*G[36]));
    
    // Number of operations: 30
    I[3] = (G[47] + F3*(G[30] + F6*G[29] + F7*G[23] + F8*G[27]) + F4*(G[42] + F6*G[22] + F7*G[44] + F8*G[49]) + F5*(G[48] + F6*G[50] + F7*G[46] + F8*G[51]) + F6*G[45] + F7*G[52] + F8*G[43]);
    
    // Number of operations: 54
    I[4] = (G[58] + F0*(G[54] + F0*G[11] + F1*G[20] + F2*G[8]) + F1*(G[56] + F1*G[4] + F2*G[12]) + F2*(G[55] + F2*G[7]) + F3*(G[39] + F3*G[15] + F4*G[0]) + F4*(G[53] + F4*G[2]) + F5*(G[57] + F3*G[13] + F4*G[5] + F5*G[6]) + F6*(G[16] + F6*G[15] + F7*G[0]) + F7*(G[21] + F7*G[2]) + F8*(G[14] + F6*G[13] + F7*G[5] + F8*G[6]));
    
    // Number of operations: 54
    I[5] = (G[73] + F0*(G[37] + F0*G[69] + F1*G[29] + F2*G[36]) + F1*(G[66] + F1*G[59] + F2*G[27]) + F2*(G[65] + F2*G[63]) + F3*(G[17] + F3*G[60] + F4*G[12]) + F4*(G[61] + F4*G[62]) + F5*(G[71] + F3*G[64] + F4*G[67] + F5*G[72]) + F6*(G[70] + F6*G[69] + F7*G[29]) + F7*(G[30] + F7*G[59]) + F8*(G[68] + F6*G[36] + F7*G[27] + F8*G[63]));
    
    // Number of operations: 30
    I[6] = (G[76] + F0*G[32] + F1*G[78] + F2*G[42] + F6*(G[75] + F0*G[26] + F1*G[24] + F2*G[22]) + F7*(G[79] + F0*G[24] + F1*G[74] + F2*G[44]) + F8*(G[77] + F0*G[22] + F1*G[44] + F2*G[49]));
    
    // Number of operations: 30
    I[7] = (G[81] + F0*G[53] + F1*G[82] + F2*G[80] + F3*(G[25] + F0*G[0] + F1*G[26] + F2*G[29]) + F4*(G[34] + F0*G[33] + F1*G[24] + F2*G[23]) + F5*(G[31] + F0*G[5] + F1*G[22] + F2*G[27]));
    
    // Number of operations: 30
    I[8] = (G[83] + F0*G[84] + F1*G[87] + F2*G[85] + F6*(G[66] + F0*G[29] + F1*G[23] + F2*G[27]) + F7*(G[77] + F0*G[22] + F1*G[44] + F2*G[49]) + F8*(G[86] + F0*G[50] + F1*G[46] + F2*G[51]));
    
    // Number of operations: 54
    I[9] = (G[100] + F0*(G[31] + F0*G[90] + F1*G[22] + F2*G[27]) + F1*(G[77] + F1*G[89] + F2*G[49]) + F2*(G[94] + F2*G[93]) + F3*(G[88] + F3*G[90] + F4*G[22]) + F4*(G[92] + F4*G[89]) + F5*(G[43] + F3*G[27] + F4*G[49] + F5*G[93]) + F6*(G[99] + F6*G[97] + F7*G[91]) + F7*(G[102] + F7*G[95]) + F8*(G[96] + F6*G[67] + F7*G[101] + F8*G[98]));
    
    // Number of operations: 30
    I[10] = (G[105] + F0*G[68] + F1*G[85] + F2*G[106] + F6*(G[65] + F0*G[36] + F1*G[27] + F2*G[103]) + F7*(G[94] + F0*G[27] + F1*G[49] + F2*G[51]) + F8*(G[107] + F0*G[103] + F1*G[51] + F2*G[104]));
    
    // Number of operations: 54
    I[11] = (G[119] + F0*(G[112] + F0*G[6] + F1*G[50] + F2*G[103]) + F1*(G[86] + F1*G[109] + F2*G[51]) + F2*(G[107] + F2*G[111]) + F3*(G[108] + F3*G[6] + F4*G[50]) + F4*(G[110] + F4*G[109]) + F5*(G[118] + F3*G[103] + F4*G[51] + F5*G[111]) + F6*(G[117] + F6*G[7] + F7*G[67]) + F7*(G[96] + F7*G[114]) + F8*(G[115] + F6*G[113] + F7*G[120] + F8*G[116]));
    
    // Number of operations: 30
    I[12] = (G[121] + F0*G[82] + F1*G[122] + F2*G[92] + F3*(G[75] + F0*G[26] + F1*G[24] + F2*G[22]) + F4*(G[79] + F0*G[24] + F1*G[74] + F2*G[44]) + F5*(G[77] + F0*G[22] + F1*G[44] + F2*G[49]));
    
    // Number of operations: 30
    I[13] = (G[124] + F0*G[30] + F1*G[42] + F2*G[48] + F6*(G[123] + F0*G[29] + F1*G[22] + F2*G[50]) + F7*(G[125] + F0*G[23] + F1*G[44] + F2*G[46]) + F8*(G[94] + F0*G[27] + F1*G[49] + F2*G[51]));
    
    // Number of operations: 54
    I[14] = (G[128] + F0*(G[37] + F0*G[69] + F1*G[29] + F2*G[36]) + F1*(G[66] + F1*G[59] + F2*G[27]) + F2*(G[65] + F2*G[63]) + F3*(G[38] + F3*G[69] + F4*G[29]) + F4*(G[80] + F4*G[59]) + F5*(G[127] + F3*G[36] + F4*G[27] + F5*G[63]) + F6*(G[126] + F6*G[60] + F7*G[12]) + F7*(G[99] + F7*G[62]) + F8*(G[117] + F6*G[64] + F7*G[67] + F8*G[72]));
    
    // Number of operations: 54
    I[15] = (G[137] + F0*(G[25] + F0*G[134]) + F1*(G[75] + F0*G[26] + F1*G[129]) + F2*(G[123] + F0*G[29] + F1*G[22] + F2*G[132]) + F3*(G[3] + F3*G[136] + F4*G[138]) + F4*(G[130] + F4*G[131]) + F5*(G[61] + F3*G[12] + F4*G[91] + F5*G[133]) + F6*(G[135] + F6*G[134] + F7*G[26]) + F7*(G[32] + F7*G[129]) + F8*(G[84] + F6*G[29] + F7*G[22] + F8*G[132]));
    
    // Number of operations: 30
    I[16] = (G[140] + F3*(G[70] + F6*G[13] + F7*G[29] + F8*G[36]) + F4*(G[139] + F6*G[5] + F7*G[22] + F8*G[27]) + F5*(G[141] + F6*G[142] + F7*G[50] + F8*G[103]) + F6*G[57] + F7*G[45] + F8*G[127]);
    
    // Number of operations: 54
    I[17] = (G[144] + F0*(G[9] + F0*G[15]) + F1*(G[18] + F0*G[0] + F1*G[2]) + F2*(G[10] + F0*G[13] + F1*G[5] + F2*G[6]) + F3*(G[39] + F3*G[15] + F4*G[0]) + F4*(G[53] + F4*G[2]) + F5*(G[57] + F3*G[13] + F4*G[5] + F5*G[6]) + F6*(G[143] + F6*G[11] + F7*G[20]) + F7*(G[145] + F7*G[4]) + F8*(G[126] + F6*G[8] + F7*G[12] + F8*G[7]));
    
    // Number of operations: 54
    I[18] = (G[148] + F0*(G[31] + F0*G[90]) + F1*(G[77] + F0*G[22] + F1*G[89]) + F2*(G[94] + F0*G[27] + F1*G[49] + F2*G[93]) + F3*(G[61] + F3*G[97]) + F4*(G[146] + F3*G[91] + F4*G[95]) + F5*(G[147] + F3*G[67] + F4*G[101] + F5*G[98]) + F6*(G[139] + F6*G[90] + F7*G[22]) + F7*(G[42] + F7*G[89]) + F8*(G[85] + F6*G[27] + F7*G[49] + F8*G[93]));
    
    // Number of operations: 30
    I[19] = (G[149] + F0*G[38] + F1*G[88] + F2*G[108] + F3*(G[10] + F0*G[13] + F1*G[5] + F2*G[142]) + F4*(G[123] + F0*G[29] + F1*G[22] + F2*G[50]) + F5*(G[65] + F0*G[36] + F1*G[27] + F2*G[103]));
    
    // Number of operations: 30
    I[20] = (G[150] + F3*(G[84] + F6*G[29] + F7*G[22] + F8*G[50]) + F4*(G[87] + F6*G[23] + F7*G[44] + F8*G[46]) + F5*(G[85] + F6*G[27] + F7*G[49] + F8*G[51]) + F6*G[80] + F7*G[92] + F8*G[110]);
    
    // Number of operations: 54
    I[21] = (G[154] + F0*(G[151] + F0*G[97] + F1*G[91] + F2*G[67]) + F1*(G[153] + F1*G[95] + F2*G[101]) + F2*(G[152] + F2*G[98]) + F3*(G[88] + F3*G[90]) + F4*(G[92] + F3*G[22] + F4*G[89]) + F5*(G[43] + F3*G[27] + F4*G[49] + F5*G[93]) + F6*(G[139] + F6*G[90] + F7*G[22]) + F7*(G[42] + F7*G[89]) + F8*(G[85] + F6*G[27] + F7*G[49] + F8*G[93]));
    
    // Number of operations: 30
    I[22] = (G[155] + F0*G[70] + F1*G[139] + F2*G[141] + F6*(G[10] + F0*G[13] + F1*G[5] + F2*G[142]) + F7*(G[123] + F0*G[29] + F1*G[22] + F2*G[50]) + F8*(G[65] + F0*G[36] + F1*G[27] + F2*G[103]));
    
    // Number of operations: 30
    I[23] = (G[156] + F3*(G[14] + F6*G[13] + F7*G[5] + F8*G[142]) + F4*(G[84] + F6*G[29] + F7*G[22] + F8*G[50]) + F5*(G[68] + F6*G[36] + F7*G[27] + F8*G[103]) + F6*G[38] + F7*G[88] + F8*G[108]);
    
    // Number of operations: 30
    I[24] = (G[158] + F3*(G[135] + F6*G[0] + F7*G[26] + F8*G[29]) + F4*(G[157] + F6*G[33] + F7*G[24] + F8*G[23]) + F5*(G[139] + F6*G[5] + F7*G[22] + F8*G[27]) + F6*G[53] + F7*G[82] + F8*G[80]);
    
    // Number of operations: 54
    I[25] = (G[159] + F0*(G[25] + F0*G[134] + F1*G[26] + F2*G[29]) + F1*(G[75] + F1*G[129] + F2*G[22]) + F2*(G[123] + F2*G[132]) + F3*(G[41] + F3*G[134] + F4*G[26]) + F4*(G[82] + F4*G[129]) + F5*(G[45] + F3*G[29] + F4*G[22] + F5*G[132]) + F6*(G[145] + F6*G[136] + F7*G[138]) + F7*(G[160] + F7*G[131]) + F8*(G[99] + F6*G[12] + F7*G[91] + F8*G[133]));
    
    // Number of operations: 55
    I[26] = (G[162] + F0*(G[56] + F0*G[136] + F1*G[138] + F2*G[12]) + F1*(G[161] + F1*G[131] + F2*G[91]) + F2*(G[151] + F2*G[133]) + F3*(G[41] + F3*G[134] + F4*G[26]) + F4*G[82] + F5*(G[45] + F3*G[29] + F4*G[22] + F5*G[132]) + F6*(G[135] + F6*G[134] + F7*G[26]) + F7*G[32] + F8*(G[84] + F6*G[29] + F7*G[22] + F8*G[132]) + G[129]*(F4*F4 + F7*F7));
    
    // Number of operations: 30
    I[27] = (G[163] + F0*G[14] + F1*G[84] + F2*G[68] + F6*(G[37] + F0*G[13] + F1*G[29] + F2*G[36]) + F7*(G[31] + F0*G[5] + F1*G[22] + F2*G[27]) + F8*(G[112] + F0*G[142] + F1*G[50] + F2*G[103]));
    
    // Number of operations: 30
    I[28] = (G[164] + F0*G[45] + F1*G[52] + F2*G[43] + F3*(G[66] + F0*G[29] + F1*G[23] + F2*G[27]) + F4*(G[77] + F0*G[22] + F1*G[44] + F2*G[49]) + F5*(G[86] + F0*G[50] + F1*G[46] + F2*G[51]));
    
    // Number of operations: 30
    I[29] = (G[165] + F0*G[135] + F1*G[157] + F2*G[139] + F6*(G[18] + F0*G[0] + F1*G[33] + F2*G[5]) + F7*(G[75] + F0*G[26] + F1*G[24] + F2*G[22]) + F8*(G[66] + F0*G[29] + F1*G[23] + F2*G[27]));
    
    // Number of operations: 30
    I[30] = (G[166] + F0*G[127] + F1*G[43] + F2*G[118] + F3*(G[65] + F0*G[36] + F1*G[27] + F2*G[103]) + F4*(G[94] + F0*G[27] + F1*G[49] + F2*G[51]) + F5*(G[107] + F0*G[103] + F1*G[51] + F2*G[104]));
    
    // Number of operations: 30
    I[31] = (G[167] + F0*G[41] + F1*G[168] + F2*G[88] + F3*(G[18] + F0*G[0] + F1*G[33] + F2*G[5]) + F4*(G[75] + F0*G[26] + F1*G[24] + F2*G[22]) + F5*(G[66] + F0*G[29] + F1*G[23] + F2*G[27]));
    
    // Number of operations: 30
    I[32] = (G[169] + F3*(G[21] + F6*G[0] + F7*G[33] + F8*G[5]) + F4*(G[32] + F6*G[26] + F7*G[24] + F8*G[22]) + F5*(G[30] + F6*G[29] + F7*G[23] + F8*G[27]) + F6*G[41] + F7*G[168] + F8*G[88]);
    
    // Number of operations: 54
    I[33] = (G[171] + F0*(G[55] + F0*G[60] + F1*G[12] + F2*G[64]) + F1*(G[151] + F1*G[62] + F2*G[67]) + F2*(G[170] + F2*G[72]) + F3*(G[38] + F3*G[69] + F4*G[29]) + F4*(G[80] + F4*G[59]) + F5*(G[127] + F3*G[36] + F4*G[27] + F5*G[63]) + F6*(G[70] + F6*G[69] + F7*G[29]) + F7*(G[30] + F7*G[59]) + F8*(G[68] + F6*G[36] + F7*G[27] + F8*G[63]));
    
    // Number of operations: 30
    I[34] = (G[172] + F3*(G[68] + F6*G[36] + F7*G[27] + F8*G[103]) + F4*(G[85] + F6*G[27] + F7*G[49] + F8*G[51]) + F5*(G[106] + F6*G[103] + F7*G[51] + F8*G[104]) + F6*G[127] + F7*G[43] + F8*G[118]);
    
    // Number of operations: 30
    I[35] = (G[173] + F0*G[57] + F1*G[45] + F2*G[127] + F3*(G[37] + F0*G[13] + F1*G[29] + F2*G[36]) + F4*(G[31] + F0*G[5] + F1*G[22] + F2*G[27]) + F5*(G[112] + F0*G[142] + F1*G[50] + F2*G[103]));
    
    // Number of operations: 54
    I[36] = (G[175] + F0*(G[112] + F0*G[6] + F1*G[50] + F2*G[103]) + F1*(G[86] + F1*G[109] + F2*G[51]) + F2*(G[107] + F2*G[111]) + F3*(G[71] + F3*G[7] + F4*G[67]) + F4*(G[147] + F4*G[114]) + F5*(G[174] + F3*G[113] + F4*G[120] + F5*G[116]) + F6*(G[141] + F6*G[6] + F7*G[50]) + F7*(G[48] + F7*G[109]) + F8*(G[106] + F6*G[103] + F7*G[51] + F8*G[111]));
    
    // Number of operations: 30
    I[37] = (G[176] + F3*(G[16] + F6*G[35] + F7*G[0] + F8*G[13]) + F4*(G[135] + F6*G[0] + F7*G[26] + F8*G[29]) + F5*(G[70] + F6*G[13] + F7*G[29] + F8*G[36]) + F6*G[39] + F7*G[41] + F8*G[38]);
    
    // Number of operations: 30
    I[38] = (G[177] + F3*(G[32] + F6*G[26] + F7*G[24] + F8*G[22]) + F4*(G[78] + F6*G[24] + F7*G[74] + F8*G[44]) + F5*(G[42] + F6*G[22] + F7*G[44] + F8*G[49]) + F6*G[82] + F7*G[122] + F8*G[92]);
    
    // Number of operations: 54
    I[39] = (G[179] + F0*(G[170] + F0*G[7] + F1*G[67] + F2*G[113]) + F1*(G[152] + F1*G[114] + F2*G[120]) + F2*(G[178] + F2*G[116]) + F3*(G[108] + F3*G[6] + F4*G[50]) + F4*(G[110] + F4*G[109]) + F5*(G[118] + F3*G[103] + F4*G[51] + F5*G[111]) + F6*(G[141] + F6*G[6] + F7*G[50]) + F7*(G[48] + F7*G[109]) + F8*(G[106] + F6*G[103] + F7*G[51] + F8*G[111]));
    
    // Number of operations: 55
    I[40] = (G[185] + F0*(G[161] + F0*G[4]) + F1*(G[181] + F0*G[180] + F1*G[182]) + F2*(G[153] + F0*G[91] + F1*G[184] + F2*G[114]) + F3*(G[168] + F3*G[2] + F4*G[24]) + F4*G[122] + F5*(G[52] + F3*G[23] + F4*G[44] + F5*G[109]) + F6*(G[157] + F6*G[2] + F7*G[24]) + F7*G[78] + F8*(G[87] + F6*G[23] + F7*G[44] + F8*G[109]) + G[183]*(F4*F4 + F7*F7));
    
    // Number of operations: 54
    I[41] = (G[186] + F0*(G[34] + F0*G[2]) + F1*(G[79] + F0*G[24] + F1*G[183] + F2*G[44]) + F2*(G[125] + F0*G[23] + F2*G[109]) + F3*(G[168] + F3*G[2] + F4*G[24]) + F4*(G[122] + F4*G[183]) + F5*(G[52] + F3*G[23] + F4*G[44] + F5*G[109]) + F6*(G[160] + F6*G[4] + F7*G[180]) + F7*(G[187] + F7*G[182]) + F8*(G[102] + F6*G[91] + F7*G[184] + F8*G[114]));
    
    // Number of operations: 30
    I[42] = (G[188] + F0*G[80] + F1*G[92] + F2*G[110] + F3*(G[123] + F0*G[29] + F1*G[22] + F2*G[50]) + F4*(G[125] + F0*G[23] + F1*G[44] + F2*G[46]) + F5*(G[94] + F0*G[27] + F1*G[49] + F2*G[51]));
    
    // Number of operations: 54
    I[43] = (G[190] + F0*(G[34] + F0*G[2]) + F1*(G[79] + F0*G[24] + F1*G[183] + F2*G[44]) + F2*(G[125] + F0*G[23] + F2*G[109]) + F3*(G[130] + F3*G[4] + F4*G[180]) + F4*(G[189] + F4*G[182]) + F5*(G[146] + F3*G[91] + F4*G[184] + F5*G[114]) + F6*(G[157] + F6*G[2] + F8*G[23]) + F7*(G[78] + F6*G[24] + F7*G[183] + F8*G[44]) + F8*(G[87] + F8*G[109]));
    
    // Number of operations: 30
    I[44] = (G[191] + F0*G[16] + F1*G[135] + F2*G[70] + F6*(G[9] + F0*G[35] + F1*G[0] + F2*G[13]) + F7*(G[25] + F0*G[0] + F1*G[26] + F2*G[29]) + F8*(G[37] + F0*G[13] + F1*G[29] + F2*G[36]));
    
    
    // Number of operations for primary indices: 972
    for (unsigned int j = 0; j < 2; j++)
    {
      for (unsigned int k = 0; k < 2; k++)
      {
        // Number of operations to compute entry: 3
        A[nzc7[j]*12 + nzc7[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[0];
        // Number of operations to compute entry: 3
        A[nzc10[j]*12 + nzc3[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[1];
        // Number of operations to compute entry: 3
        A[nzc7[j]*12 + nzc3[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[2];
        // Number of operations to compute entry: 3
        A[nzc10[j]*12 + nzc5[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[3];
        // Number of operations to compute entry: 3
        A[nzc3[j]*12 + nzc3[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[4];
        // Number of operations to compute entry: 3
        A[nzc7[j]*12 + nzc5[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[5];
        // Number of operations to compute entry: 3
        A[nzc2[j]*12 + nzc10[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[6];
        // Number of operations to compute entry: 3
        A[nzc6[j]*12 + nzc3[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[7];
        // Number of operations to compute entry: 3
        A[nzc2[j]*12 + nzc9[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[8];
        // Number of operations to compute entry: 3
        A[nzc9[j]*12 + nzc10[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[9];
        // Number of operations to compute entry: 3
        A[nzc1[j]*12 + nzc9[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[10];
        // Number of operations to compute entry: 3
        A[nzc9[j]*12 + nzc9[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[11];
        // Number of operations to compute entry: 3
        A[nzc6[j]*12 + nzc2[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[12];
        // Number of operations to compute entry: 3
        A[nzc1[j]*12 + nzc10[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[13];
        // Number of operations to compute entry: 3
        A[nzc11[j]*12 + nzc9[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[14];
        // Number of operations to compute entry: 3
        A[nzc7[j]*12 + nzc6[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[15];
        // Number of operations to compute entry: 3
        A[nzc5[j]*12 + nzc11[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[16];
        // Number of operations to compute entry: 3
        A[nzc2[j]*12 + nzc6[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[12];
        // Number of operations to compute entry: 3
        A[nzc3[j]*12 + nzc6[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[7];
        // Number of operations to compute entry: 3
        A[nzc11[j]*12 + nzc11[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[17];
        // Number of operations to compute entry: 3
        A[nzc5[j]*12 + nzc6[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[18];
        // Number of operations to compute entry: 3
        A[nzc1[j]*12 + nzc7[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[19];
        // Number of operations to compute entry: 3
        A[nzc6[j]*12 + nzc9[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[20];
        // Number of operations to compute entry: 3
        A[nzc2[j]*12 + nzc1[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[21];
        // Number of operations to compute entry: 3
        A[nzc11[j]*12 + nzc1[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[22];
        // Number of operations to compute entry: 3
        A[nzc9[j]*12 + nzc7[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[23];
        // Number of operations to compute entry: 3
        A[nzc6[j]*12 + nzc11[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[24];
        // Number of operations to compute entry: 3
        A[nzc10[j]*12 + nzc2[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[6];
        // Number of operations to compute entry: 3
        A[nzc10[j]*12 + nzc11[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[25];
        // Number of operations to compute entry: 3
        A[nzc3[j]*12 + nzc2[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[26];
        // Number of operations to compute entry: 3
        A[nzc3[j]*12 + nzc9[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[27];
        // Number of operations to compute entry: 3
        A[nzc5[j]*12 + nzc2[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[28];
        // Number of operations to compute entry: 3
        A[nzc10[j]*12 + nzc9[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[9];
        // Number of operations to compute entry: 3
        A[nzc9[j]*12 + nzc11[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[14];
        // Number of operations to compute entry: 3
        A[nzc11[j]*12 + nzc2[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[29];
        // Number of operations to compute entry: 3
        A[nzc1[j]*12 + nzc5[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[30];
        // Number of operations to compute entry: 3
        A[nzc2[j]*12 + nzc7[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[31];
        // Number of operations to compute entry: 3
        A[nzc10[j]*12 + nzc7[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[32];
        // Number of operations to compute entry: 3
        A[nzc1[j]*12 + nzc11[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[22];
        // Number of operations to compute entry: 3
        A[nzc2[j]*12 + nzc3[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[26];
        // Number of operations to compute entry: 3
        A[nzc1[j]*12 + nzc3[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[33];
        // Number of operations to compute entry: 3
        A[nzc9[j]*12 + nzc5[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[34];
        // Number of operations to compute entry: 3
        A[nzc2[j]*12 + nzc5[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[28];
        // Number of operations to compute entry: 3
        A[nzc7[j]*12 + nzc10[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[32];
        // Number of operations to compute entry: 3
        A[nzc7[j]*12 + nzc2[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[31];
        // Number of operations to compute entry: 3
        A[nzc9[j]*12 + nzc3[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[27];
        // Number of operations to compute entry: 3
        A[nzc5[j]*12 + nzc3[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[35];
        // Number of operations to compute entry: 3
        A[nzc9[j]*12 + nzc1[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[10];
        // Number of operations to compute entry: 3
        A[nzc5[j]*12 + nzc5[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[36];
        // Number of operations to compute entry: 3
        A[nzc11[j]*12 + nzc7[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[37];
        // Number of operations to compute entry: 3
        A[nzc11[j]*12 + nzc5[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[16];
        // Number of operations to compute entry: 3
        A[nzc6[j]*12 + nzc10[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[38];
        // Number of operations to compute entry: 3
        A[nzc9[j]*12 + nzc2[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[8];
        // Number of operations to compute entry: 3
        A[nzc10[j]*12 + nzc6[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[38];
        // Number of operations to compute entry: 3
        A[nzc3[j]*12 + nzc10[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[1];
        // Number of operations to compute entry: 3
        A[nzc11[j]*12 + nzc6[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[24];
        // Number of operations to compute entry: 3
        A[nzc1[j]*12 + nzc1[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[39];
        // Number of operations to compute entry: 3
        A[nzc1[j]*12 + nzc2[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[21];
        // Number of operations to compute entry: 3
        A[nzc2[j]*12 + nzc2[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[40];
        // Number of operations to compute entry: 3
        A[nzc2[j]*12 + nzc11[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[29];
        // Number of operations to compute entry: 3
        A[nzc10[j]*12 + nzc10[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[41];
        // Number of operations to compute entry: 3
        A[nzc1[j]*12 + nzc6[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[42];
        // Number of operations to compute entry: 3
        A[nzc7[j]*12 + nzc11[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[37];
        // Number of operations to compute entry: 3
        A[nzc5[j]*12 + nzc1[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[30];
        // Number of operations to compute entry: 3
        A[nzc10[j]*12 + nzc1[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[13];
        // Number of operations to compute entry: 3
        A[nzc6[j]*12 + nzc6[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[43];
        // Number of operations to compute entry: 3
        A[nzc3[j]*12 + nzc7[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[2];
        // Number of operations to compute entry: 3
        A[nzc9[j]*12 + nzc6[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[20];
        // Number of operations to compute entry: 3
        A[nzc7[j]*12 + nzc1[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[19];
        // Number of operations to compute entry: 3
        A[nzc11[j]*12 + nzc10[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[25];
        // Number of operations to compute entry: 3
        A[nzc6[j]*12 + nzc7[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[15];
        // Number of operations to compute entry: 3
        A[nzc3[j]*12 + nzc1[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[33];
        // Number of operations to compute entry: 3
        A[nzc5[j]*12 + nzc10[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[3];
        // Number of operations to compute entry: 3
        A[nzc7[j]*12 + nzc9[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[23];
        // Number of operations to compute entry: 3
        A[nzc3[j]*12 + nzc5[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[35];
        // Number of operations to compute entry: 3
        A[nzc6[j]*12 + nzc1[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[42];
        // Number of operations to compute entry: 3
        A[nzc11[j]*12 + nzc3[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[44];
        // Number of operations to compute entry: 3
        A[nzc5[j]*12 + nzc9[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[34];
        // Number of operations to compute entry: 3
        A[nzc3[j]*12 + nzc11[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[44];
        // Number of operations to compute entry: 3
        A[nzc6[j]*12 + nzc5[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[18];
        // Number of operations to compute entry: 3
        A[nzc5[j]*12 + nzc7[k]] += FE1_C0_D001[0][j]*FE1_C0_D001[0][k]*I[5];
      }// end loop over 'k'
    }// end loop over 'j'
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class hyperelasticity_cell_integral_1_0: public ufc::cell_integral
{
public:

  /// Constructor
  hyperelasticity_cell_integral_1_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_cell_integral_1_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Array of quadrature weights.
    static const double W8[8] = {0.036979856358853, 0.016027040598477, 0.021157006454524, 0.009169429921480, 0.036979856358853, 0.016027040598477, 0.021157006454524, 0.009169429921480};
    // Quadrature points on the UFC reference element: (0.156682637336818, 0.136054976802846, 0.122514822655441), (0.081395667014670, 0.070679724159397, 0.544151844011225), (0.065838687060044, 0.565933165072801, 0.122514822655441), (0.034202793236766, 0.293998800631623, 0.544151844011225), (0.584747563204894, 0.136054976802846, 0.122514822655441), (0.303772764814708, 0.070679724159397, 0.544151844011225), (0.245713325211713, 0.565933165072801, 0.122514822655441), (0.127646562120385, 0.293998800631623, 0.544151844011225)
    
    // Value of basis functions at quadrature points.
    static const double FE1_C0[8][4] = \
    {{0.584747563204894, 0.156682637336818, 0.136054976802846, 0.122514822655441},
    {0.303772764814707, 0.081395667014670, 0.070679724159397, 0.544151844011225},
    {0.245713325211713, 0.065838687060044, 0.565933165072801, 0.122514822655441},
    {0.127646562120385, 0.034202793236766, 0.293998800631623, 0.544151844011225},
    {0.156682637336818, 0.584747563204894, 0.136054976802846, 0.122514822655441},
    {0.081395667014670, 0.303772764814708, 0.070679724159397, 0.544151844011225},
    {0.065838687060044, 0.245713325211713, 0.565933165072801, 0.122514822655441},
    {0.034202793236766, 0.127646562120385, 0.293998800631623, 0.544151844011225}};
    
    // Array of non-zero columns
    static const unsigned int nzc0[4] = {0, 1, 2, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc4[4] = {4, 5, 6, 7};
    
    // Array of non-zero columns
    static const unsigned int nzc8[4] = {8, 9, 10, 11};
    
    static const double FE1_C0_D001[8][2] = \
    {{-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000},
    {-1.000000000000000, 1.000000000000000}};
    
    // Array of non-zero columns
    static const unsigned int nzc1[2] = {0, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc3[2] = {0, 1};
    
    // Array of non-zero columns
    static const unsigned int nzc9[2] = {8, 11};
    
    // Array of non-zero columns
    static const unsigned int nzc2[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc6[2] = {4, 6};
    
    // Array of non-zero columns
    static const unsigned int nzc7[2] = {4, 5};
    
    // Array of non-zero columns
    static const unsigned int nzc11[2] = {8, 9};
    
    // Array of non-zero columns
    static const unsigned int nzc10[2] = {8, 10};
    
    // Array of non-zero columns
    static const unsigned int nzc5[2] = {4, 7};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 12; r++)
    {
      A[r] = 0.000000000000000;
    }// end loop over 'r'
    // Number of operations to compute geometry constants: 5914.
    double G[219];
    G[0] = det*(0.500000000000000*w[4][0]*(K_10*K_10*K_10*K_20 + K_11*(K_11*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_21*(K_10*K_10 + K_12*K_12)) + K_12*(K_10*K_10*K_22 + K_12*(K_10*K_20 + K_12*K_22))) + w[3][0]*(K_10*K_10*K_10*K_20 + K_11*(K_11*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_21*(K_10*K_10 + K_12*K_12)) + K_12*(K_10*K_10*K_22 + K_12*(K_10*K_20 + K_12*K_22))));
    G[1] = det*(0.500000000000000*w[4][0]*(K_12*K_22*K_22*K_22 + K_20*(K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_20*(K_11*K_21 + K_12*K_22)) + K_21*(K_11*K_22*K_22 + K_21*(K_11*K_21 + K_12*K_22))) + w[3][0]*(K_12*K_22*K_22*K_22 + K_20*(K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_20*(K_11*K_21 + K_12*K_22)) + K_21*(K_11*K_22*K_22 + K_21*(K_11*K_21 + K_12*K_22))));
    G[2] = det*(2.000000000000000*w[3][0]*(K_02*K_22*K_22*K_22 + K_20*(K_00*(K_21*K_21 + K_22*K_22) + K_20*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_21*(K_01*(K_21*K_21 + K_22*K_22) + K_02*K_21*K_22)) + w[4][0]*(K_02*K_22*K_22*K_22 + K_20*(K_00*(K_21*K_21 + K_22*K_22) + K_20*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_21*(K_01*(K_21*K_21 + K_22*K_22) + K_02*K_21*K_22)));
    G[3] = det*(0.500000000000000*w[4][0]*(K_00*(K_00*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_21 + K_02*(K_01*(K_01*K_22 + K_02*K_21) + K_02*K_02*K_22)) + w[3][0]*(K_00*(K_00*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_21 + K_02*(K_01*(K_01*K_22 + K_02*K_21) + K_02*K_02*K_22)));
    G[4] = det*(0.500000000000000*K_20*w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_10*w[3][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22));
    G[5] = det*(w[3][0]*(4.000000000000000*K_01*K_02*K_21*K_22 + K_20*(4.000000000000000*K_00*(K_01*K_21 + K_02*K_22) + K_20*(3.000000000000000*K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_21*K_21*(3.000000000000000*K_01*K_01 + K_00*K_00 + K_02*K_02) + K_22*K_22*(3.000000000000000*K_02*K_02 + K_00*K_00 + K_01*K_01)) + w[4][0]*(0.500000000000000*(K_00*K_00*(K_21*K_21 + K_22*K_22) + K_01*K_01*K_22*K_22 + K_02*K_02*K_21*K_21 + K_20*K_20*(K_01*K_01 + K_02*K_02)) + 1.500000000000000*K_00*K_00*K_20*K_20 + K_01*K_21*(1.500000000000000*K_01*K_21 + 2.000000000000000*K_00*K_20) + K_02*K_22*(1.500000000000000*K_02*K_22 + 2.000000000000000*(K_00*K_20 + K_01*K_21))));
    G[6] = det*(K_00*K_22*w[3][0] + K_02*K_20*w[4][0]);
    G[7] = det*(w[3][0]*(2.000000000000000*(K_10*K_20*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_11*K_11*K_21*K_21 + K_12*K_22*(K_11*K_21 + K_12*K_22)) + K_20*K_20*(K_11*K_11 + K_12*K_12) + K_21*K_21*(K_10*K_10 + K_12*K_12) + K_22*K_22*(K_10*K_10 + K_11*K_11)) + w[4][0]*(K_10*K_20*(2.000000000000000*K_11*K_21 + K_10*K_20) + K_11*K_11*K_21*K_21 + K_12*K_22*(2.000000000000000*(K_10*K_20 + K_11*K_21) + K_12*K_22)));
    G[8] = det*(K_10*(2.000000000000000*w[3][0]*(K_21*K_21 + K_22*K_22) + w[4][0]*(K_21*K_21 + K_22*K_22)) + K_20*(K_10*K_20*(3.000000000000000*w[4][0] + 6.000000000000000*w[3][0]) + K_11*K_21*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0]) + K_12*K_22*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0])));
    G[9] = det*(K_11*(w[3][0]*(2.000000000000000*K_11*K_21 + K_10*K_20 + K_12*K_22) + w[4][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22)) + K_21*w[3][0]*(K_10*K_10 + K_12*K_12));
    G[10] = det*(K_00*w[3][0]*(K_21*K_21 + K_22*K_22) + K_20*(w[3][0]*(2.000000000000000*K_00*K_20 + K_01*K_21 + K_02*K_22) + w[4][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22)));
    G[11] = det*(0.500000000000000*K_20*w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + K_00*w[3][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22));
    G[12] = det*(w[3][0]*(K_10*(K_10*(2.000000000000000*K_00*K_20 + K_01*K_21 + K_02*K_22) + K_11*(K_00*K_21 + K_01*K_20) + K_12*(K_00*K_22 + K_02*K_20)) + K_11*(K_11*(2.000000000000000*K_01*K_21 + K_00*K_20 + K_02*K_22) + K_12*(K_01*K_22 + K_02*K_21)) + K_12*K_12*(2.000000000000000*K_02*K_22 + K_00*K_20 + K_01*K_21)) + w[4][0]*(K_02*K_12*K_12*K_22 + K_10*(K_00*K_10*K_20 + K_12*(K_00*K_22 + K_02*K_20)) + K_11*(K_01*(K_10*K_20 + K_12*K_22) + K_21*(K_00*K_10 + K_01*K_11 + K_02*K_12))));
    G[13] = K_20*det*(0.500000000000000*w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + w[3][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[14] = det*(w[3][0]*(K_00*(2.000000000000000*K_02*(K_10*K_22 + K_12*K_20) + K_00*(3.000000000000000*K_10*K_20 + K_11*K_21 + K_12*K_22)) + K_01*(2.000000000000000*(K_11*(K_00*K_20 + K_02*K_22) + K_21*(K_00*K_10 + K_02*K_12)) + K_01*(3.000000000000000*K_11*K_21 + K_10*K_20 + K_12*K_22)) + K_02*K_02*(3.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21)) + w[4][0]*(K_00*(K_00*(0.500000000000000*(K_11*K_21 + K_12*K_22) + 1.500000000000000*K_10*K_20) + K_02*(K_10*K_22 + K_12*K_20)) + K_01*(K_01*(0.500000000000000*(K_10*K_20 + K_12*K_22) + 1.500000000000000*K_11*K_21) + K_11*(K_00*K_20 + K_02*K_22) + K_21*(K_00*K_10 + K_02*K_12)) + K_02*K_02*(0.500000000000000*(K_10*K_20 + K_11*K_21) + 1.500000000000000*K_12*K_22)));
    G[15] = det*(0.500000000000000*w[4][0]*(K_10*K_20*(K_00*K_00 + K_01*K_01 + K_02*K_02) + K_11*K_21*(K_00*K_00 + K_01*K_01 + K_02*K_02) + K_12*K_22*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + w[3][0]*(K_00*(K_10*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_10 + K_01*K_11 + K_02*K_12)) + K_01*(K_02*K_11*K_22 + K_21*(K_01*K_11 + K_02*K_12)) + K_02*K_02*K_12*K_22));
    G[16] = det*(2.000000000000000*K_22*w[3][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22) + K_02*w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[17] = det*(K_02*w[4][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22) + w[3][0]*(K_12*(2.000000000000000*K_02*K_22 + K_00*K_20 + K_01*K_21) + K_22*(K_00*K_10 + K_01*K_11)));
    G[18] = det*(K_20*w[4][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12) + w[3][0]*(K_00*(K_11*K_21 + K_12*K_22) + K_10*(2.000000000000000*K_00*K_20 + K_01*K_21 + K_02*K_22)));
    G[19] = det*(w[3][0]*(K_20*(K_20*(2.000000000000000*K_00*K_10 + K_01*K_11 + K_02*K_12) + K_21*(K_00*K_11 + K_01*K_10)) + K_21*K_21*(2.000000000000000*K_01*K_11 + K_00*K_10 + K_02*K_12) + K_22*(K_00*(K_10*K_22 + K_12*K_20) + K_01*(K_11*K_22 + K_12*K_21) + K_02*(2.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21))) + w[4][0]*(K_01*K_11*K_21*K_21 + K_20*(K_00*K_10*K_20 + K_21*(K_00*K_11 + K_01*K_10)) + K_22*(K_02*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_12*(K_00*K_20 + K_01*K_21))));
    G[20] = det*(2.000000000000000*K_21*w[3][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22) + K_01*w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[21] = det*(K_10*w[3][0]*(K_21*K_21 + K_22*K_22) + K_20*(w[3][0]*(2.000000000000000*K_10*K_20 + K_11*K_21 + K_12*K_22) + w[4][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22)));
    G[22] = det*(K_00*(2.000000000000000*w[3][0]*(K_21*K_21 + K_22*K_22) + w[4][0]*(K_21*K_21 + K_22*K_22)) + K_20*(K_00*K_20*(3.000000000000000*w[4][0] + 6.000000000000000*w[3][0]) + K_01*K_21*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0]) + K_02*K_22*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0])));
    G[23] = det*(2.000000000000000*K_21*w[3][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_11*w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[24] = det*(2.000000000000000*K_22*w[3][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_12*w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[25] = det*(w[3][0]*(2.000000000000000*(K_00*K_20*(K_00*K_20 + K_01*K_21) + K_01*K_01*K_21*K_21 + K_02*K_22*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_00*K_00*(K_21*K_21 + K_22*K_22) + K_01*K_01*K_22*K_22 + K_02*K_02*K_21*K_21 + K_20*K_20*(K_01*K_01 + K_02*K_02)) + w[4][0]*(K_00*K_20*(2.000000000000000*K_01*K_21 + K_00*K_20) + K_01*K_01*K_21*K_21 + K_02*K_22*(2.000000000000000*(K_00*K_20 + K_01*K_21) + K_02*K_22)));
    G[26] = det*(2.000000000000000*w[3][0]*(K_12*K_22*K_22*K_22 + K_20*(K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_20*(K_11*K_21 + K_12*K_22)) + K_21*(K_11*K_22*K_22 + K_21*(K_11*K_21 + K_12*K_22))) + w[4][0]*(K_12*K_22*K_22*K_22 + K_20*(K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_20*(K_11*K_21 + K_12*K_22)) + K_21*(K_11*K_22*K_22 + K_21*(K_11*K_21 + K_12*K_22))));
    G[27] = det*(w[3][0]*(K_20*(4.000000000000000*K_21*(K_00*K_11 + K_01*K_10) + K_20*(2.000000000000000*(K_01*K_11 + K_02*K_12) + 6.000000000000000*K_00*K_10)) + K_21*K_21*(2.000000000000000*(K_00*K_10 + K_02*K_12) + 6.000000000000000*K_01*K_11) + K_22*(4.000000000000000*(K_20*(K_00*K_12 + K_02*K_10) + K_21*(K_01*K_12 + K_02*K_11)) + K_22*(2.000000000000000*(K_00*K_10 + K_01*K_11) + 6.000000000000000*K_02*K_12))) + w[4][0]*(K_20*(2.000000000000000*K_21*(K_00*K_11 + K_01*K_10) + K_20*(3.000000000000000*K_00*K_10 + K_01*K_11 + K_02*K_12)) + K_21*K_21*(3.000000000000000*K_01*K_11 + K_00*K_10 + K_02*K_12) + K_22*(2.000000000000000*(K_20*(K_00*K_12 + K_02*K_10) + K_21*(K_01*K_12 + K_02*K_11)) + K_22*(3.000000000000000*K_02*K_12 + K_00*K_10 + K_01*K_11))));
    G[28] = det*(K_11*w[4][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22) + w[3][0]*(K_01*(K_10*K_20 + K_12*K_22) + K_21*(2.000000000000000*K_01*K_11 + K_00*K_10 + K_02*K_12)));
    G[29] = det*(K_10*K_20*w[4][0] + w[3][0]*(2.000000000000000*K_10*K_20 + K_11*K_21 + K_12*K_22));
    G[30] = det*(2.000000000000000*w[3][0]*(K_01*K_11*K_21*K_21 + K_20*(K_00*K_10*K_20 + K_21*(K_00*K_11 + K_01*K_10)) + K_22*(K_02*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_12*(K_00*K_20 + K_01*K_21))) + w[4][0]*(K_00*K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_01*K_11*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_02*K_12*(K_20*K_20 + K_21*K_21 + K_22*K_22)));
    G[31] = (0.500000000000000*det*w[4][0]*(K_10*K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_11*K_11*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_12*K_12*(K_20*K_20 + K_21*K_21 + K_22*K_22)) + det*w[3][0]*(K_10*K_20*(2.000000000000000*K_11*K_21 + K_10*K_20) + K_11*K_11*K_21*K_21 + K_12*K_22*(2.000000000000000*(K_10*K_20 + K_11*K_21) + K_12*K_22)));
    G[32] = det*(K_11*w[3][0]*(K_20*K_20 + K_22*K_22) + K_21*(w[3][0]*(2.000000000000000*K_11*K_21 + K_10*K_20 + K_12*K_22) + w[4][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22)));
    G[33] = det*(0.500000000000000*w[4][0]*(K_00*K_20*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_01*K_21*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_02*K_22*(K_10*K_10 + K_11*K_11 + K_12*K_12)) + w[3][0]*(K_02*K_12*K_12*K_22 + K_10*(K_00*K_10*K_20 + K_12*(K_00*K_22 + K_02*K_20)) + K_11*(K_01*(K_10*K_20 + K_12*K_22) + K_21*(K_00*K_10 + K_01*K_11 + K_02*K_12))));
    G[34] = det*(K_20*K_20*(K_20*K_20*(w[3][0] + 0.500000000000000*w[4][0]) + K_21*K_21*(w[4][0] + 2.000000000000000*w[3][0])) + K_21*K_21*K_21*K_21*(w[3][0] + 0.500000000000000*w[4][0]) + K_22*K_22*(K_20*K_20*(w[4][0] + 2.000000000000000*w[3][0]) + K_21*K_21*(w[4][0] + 2.000000000000000*w[3][0]) + K_22*K_22*(w[3][0] + 0.500000000000000*w[4][0])));
    G[35] = det*(w[3][0]*(K_10*(2.000000000000000*(K_11*(K_00*K_21 + K_01*K_20) + K_12*(K_00*K_22 + K_02*K_20)) + K_10*(3.000000000000000*K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_11*(2.000000000000000*K_12*(K_01*K_22 + K_02*K_21) + K_11*(3.000000000000000*K_01*K_21 + K_00*K_20 + K_02*K_22)) + K_12*K_12*(3.000000000000000*K_02*K_22 + K_00*K_20 + K_01*K_21)) + w[4][0]*(K_10*(K_10*(0.500000000000000*(K_01*K_21 + K_02*K_22) + 1.500000000000000*K_00*K_20) + K_11*(K_00*K_21 + K_01*K_20) + K_12*(K_00*K_22 + K_02*K_20)) + K_11*(K_11*(0.500000000000000*(K_00*K_20 + K_02*K_22) + 1.500000000000000*K_01*K_21) + K_12*(K_01*K_22 + K_02*K_21)) + K_12*K_12*(0.500000000000000*(K_00*K_20 + K_01*K_21) + 1.500000000000000*K_02*K_22)));
    G[36] = det*(w[3][0]*(K_00*(K_00*(2.000000000000000*K_10*K_20 + K_11*K_21 + K_12*K_22) + K_02*(K_10*K_22 + K_12*K_20)) + K_01*(K_01*(K_10*K_20 + K_12*K_22) + K_11*(K_00*K_20 + K_02*K_22) + K_21*(2.000000000000000*K_01*K_11 + K_00*K_10 + K_02*K_12)) + K_02*K_02*(2.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21)) + w[4][0]*(K_00*(K_10*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_10 + K_01*K_11 + K_02*K_12)) + K_01*(K_02*K_11*K_22 + K_21*(K_01*K_11 + K_02*K_12)) + K_02*K_02*K_12*K_22));
    G[37] = K_22*det*(2.000000000000000*w[3][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[38] = K_20*det*(1.500000000000000*w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + 3.000000000000000*w[3][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[39] = det*(K_02*w[3][0]*(K_20*K_20 + K_21*K_21) + K_22*(w[3][0]*(2.000000000000000*K_02*K_22 + K_00*K_20 + K_01*K_21) + w[4][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22)));
    G[40] = det*(K_12*w[4][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22) + w[3][0]*(K_02*(2.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21) + K_22*(K_00*K_10 + K_01*K_11)));
    G[41] = det*(K_20*K_20*w[4][0] + w[3][0]*(2.000000000000000*K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[42] = det*(1.500000000000000*w[4][0]*(K_02*K_22*K_22*K_22 + K_20*(K_00*(K_21*K_21 + K_22*K_22) + K_20*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_21*(K_01*(K_21*K_21 + K_22*K_22) + K_02*K_21*K_22)) + 3.000000000000000*w[3][0]*(K_02*K_22*K_22*K_22 + K_20*(K_00*(K_21*K_21 + K_22*K_22) + K_20*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_21*(K_01*(K_21*K_21 + K_22*K_22) + K_02*K_21*K_22)));
    G[43] = det*(0.500000000000000*w[4][0]*(K_02*K_22*K_22*K_22 + K_20*(K_00*(K_21*K_21 + K_22*K_22) + K_20*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_21*(K_01*(K_21*K_21 + K_22*K_22) + K_02*K_21*K_22)) + w[3][0]*(K_02*K_22*K_22*K_22 + K_20*(K_00*(K_21*K_21 + K_22*K_22) + K_20*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_21*(K_01*(K_21*K_21 + K_22*K_22) + K_02*K_21*K_22)));
    G[44] = det*(w[3][0]*(4.000000000000000*K_10*K_12*K_20*K_22 + K_10*K_10*(3.000000000000000*K_20*K_20 + K_21*K_21 + K_22*K_22) + K_11*(K_11*(K_20*K_20 + K_22*K_22) + K_21*(3.000000000000000*K_11*K_21 + 4.000000000000000*(K_10*K_20 + K_12*K_22))) + K_12*K_12*(3.000000000000000*K_22*K_22 + K_20*K_20 + K_21*K_21)) + w[4][0]*(0.500000000000000*(K_20*K_20*(K_11*K_11 + K_12*K_12) + K_21*K_21*(K_10*K_10 + K_12*K_12) + K_22*K_22*(K_10*K_10 + K_11*K_11)) + 1.500000000000000*K_12*K_12*K_22*K_22 + K_10*K_20*(1.500000000000000*K_10*K_20 + 2.000000000000000*(K_11*K_21 + K_12*K_22)) + K_11*K_21*(1.500000000000000*K_11*K_21 + 2.000000000000000*K_12*K_22)));
    G[45] = det*(K_00*K_21*w[3][0] + K_01*K_20*w[4][0]);
    G[46] = det*(w[3][0]*(2.000000000000000*(K_00*K_12*K_22 + K_01*K_10*K_21 + K_02*(K_10*K_22 + K_12*K_20) + K_11*(K_00*K_21 + K_01*K_20)) + 6.000000000000000*K_00*K_10*K_20) + w[4][0]*(K_10*(3.000000000000000*K_00*K_20 + K_01*K_21 + K_02*K_22) + K_11*(K_00*K_21 + K_01*K_20) + K_12*(K_00*K_22 + K_02*K_20)));
    G[47] = det*(K_12*w[3][0]*(K_20*K_20 + K_21*K_21) + K_22*(w[3][0]*(2.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21) + w[4][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22)));
    G[48] = det*(K_02*(w[3][0]*(2.000000000000000*K_02*K_22 + K_00*K_20 + K_01*K_21) + w[4][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_22*w[3][0]*(K_00*K_00 + K_01*K_01));
    G[49] = det*(K_00*(K_01*K_21*(w[4][0] + 2.000000000000000*w[3][0]) + K_02*K_22*(w[4][0] + 2.000000000000000*w[3][0])) + K_20*(K_00*K_00*(1.500000000000000*w[4][0] + 3.000000000000000*w[3][0]) + K_01*K_01*(w[3][0] + 0.500000000000000*w[4][0]) + K_02*K_02*(w[3][0] + 0.500000000000000*w[4][0])));
    G[50] = det*(K_01*w[4][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22) + w[3][0]*(K_11*(K_00*K_20 + K_02*K_22) + K_21*(2.000000000000000*K_01*K_11 + K_00*K_10 + K_02*K_12)));
    G[51] = det*(K_12*(w[3][0]*(2.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21) + w[4][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22)) + K_22*w[3][0]*(K_10*K_10 + K_11*K_11));
    G[52] = (0.500000000000000*det*w[4][0]*(K_00*K_00*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_01*K_01*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_02*K_02*(K_20*K_20 + K_21*K_21 + K_22*K_22)) + det*w[3][0]*(K_00*K_20*(2.000000000000000*K_01*K_21 + K_00*K_20) + K_01*K_01*K_21*K_21 + K_02*K_22*(2.000000000000000*(K_00*K_20 + K_01*K_21) + K_02*K_22)));
    G[53] = det*(K_01*w[3][0]*(K_20*K_20 + K_22*K_22) + K_21*(w[3][0]*(2.000000000000000*K_01*K_21 + K_00*K_20 + K_02*K_22) + w[4][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22)));
    G[54] = K_20*K_21*det*(w[3][0] + w[4][0]);
    G[55] = det*(K_00*K_20*w[4][0] + w[3][0]*(2.000000000000000*K_00*K_20 + K_01*K_21 + K_02*K_22));
    G[56] = det*(K_01*(w[3][0]*(2.000000000000000*K_01*K_21 + K_00*K_20 + K_02*K_22) + w[4][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_21*w[3][0]*(K_00*K_00 + K_02*K_02));
    G[57] = K_21*det*(2.000000000000000*w[3][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[58] = det*(K_10*K_21*w[3][0] + K_11*K_20*w[4][0]);
    G[59] = det*(K_10*K_22*w[3][0] + K_12*K_20*w[4][0]);
    G[60] = det*(K_10*(w[3][0]*(2.000000000000000*(K_11*K_21 + K_12*K_22) + 3.000000000000000*K_10*K_20) + w[4][0]*(1.500000000000000*K_10*K_20 + K_11*K_21 + K_12*K_22)) + K_20*(K_11*K_11*(w[3][0] + 0.500000000000000*w[4][0]) + K_12*K_12*(w[3][0] + 0.500000000000000*w[4][0])));
    G[61] = det*(1.500000000000000*w[4][0]*(K_12*K_22*K_22*K_22 + K_20*(K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_20*(K_11*K_21 + K_12*K_22)) + K_21*(K_11*K_22*K_22 + K_21*(K_11*K_21 + K_12*K_22))) + 3.000000000000000*w[3][0]*(K_12*K_22*K_22*K_22 + K_20*(K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_20*(K_11*K_21 + K_12*K_22)) + K_21*(K_11*K_22*K_22 + K_21*(K_11*K_21 + K_12*K_22))));
    G[62] = K_20*K_22*det*(w[3][0] + w[4][0]);
    G[63] = det*(w[3][0]*(2.000000000000000*(K_00*K_10*(K_00*K_10 + K_01*K_11) + K_01*K_01*K_11*K_11 + K_02*K_12*(K_00*K_10 + K_01*K_11 + K_02*K_12)) + K_00*K_00*K_11*K_11 + K_01*K_01*K_10*K_10 + K_02*K_02*(K_10*K_10 + K_11*K_11) + K_12*K_12*(K_00*K_00 + K_01*K_01)) + w[4][0]*(K_00*K_10*(2.000000000000000*K_02*K_12 + K_00*K_10) + K_01*K_11*(2.000000000000000*(K_00*K_10 + K_02*K_12) + K_01*K_11) + K_02*K_02*K_12*K_12));
    G[64] = det*(K_22*w[4][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12) + w[3][0]*(K_02*(2.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21) + K_12*(K_00*K_20 + K_01*K_21)));
    G[65] = det*(0.500000000000000*w[4][0]*(K_02*K_12*K_12*K_12 + K_10*(K_00*K_10*K_10 + K_12*(K_00*K_12 + K_02*K_10)) + K_11*(K_01*(K_10*K_10 + K_12*K_12) + K_11*(K_00*K_10 + K_01*K_11 + K_02*K_12))) + w[3][0]*(K_02*K_12*K_12*K_12 + K_10*(K_00*K_10*K_10 + K_12*(K_00*K_12 + K_02*K_10)) + K_11*(K_01*(K_10*K_10 + K_12*K_12) + K_11*(K_00*K_10 + K_01*K_11 + K_02*K_12))));
    G[66] = det*(K_01*(K_10*K_10*(w[3][0] + 0.500000000000000*w[4][0]) + K_11*K_11*(1.500000000000000*w[4][0] + 3.000000000000000*w[3][0]) + K_12*K_12*(w[3][0] + 0.500000000000000*w[4][0])) + K_11*(K_00*K_10*(w[4][0] + 2.000000000000000*w[3][0]) + K_02*K_12*(w[4][0] + 2.000000000000000*w[3][0])));
    G[67] = K_01*K_02*det*(w[3][0] + w[4][0]);
    G[68] = (0.500000000000000*det*w[4][0]*(K_00*K_00*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_01*K_01*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_02*K_02*(K_10*K_10 + K_11*K_11 + K_12*K_12)) + det*w[3][0]*(K_00*K_10*(2.000000000000000*K_02*K_12 + K_00*K_10) + K_01*K_11*(2.000000000000000*(K_00*K_10 + K_02*K_12) + K_01*K_11) + K_02*K_02*K_12*K_12));
    G[69] = det*(K_00*w[3][0]*(K_11*K_11 + K_12*K_12) + K_10*(K_00*K_10*(w[4][0] + 2.000000000000000*w[3][0]) + K_01*K_11*(w[3][0] + w[4][0]) + K_02*K_12*(w[3][0] + w[4][0])));
    G[70] = K_01*det*(0.500000000000000*w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + w[3][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[71] = det*(K_00*K_00*(K_00*K_00*(w[3][0] + 0.500000000000000*w[4][0]) + K_01*K_01*(w[4][0] + 2.000000000000000*w[3][0]) + K_02*K_02*(w[4][0] + 2.000000000000000*w[3][0])) + K_01*K_01*K_01*K_01*(w[3][0] + 0.500000000000000*w[4][0]) + K_02*K_02*(K_01*K_01*(w[4][0] + 2.000000000000000*w[3][0]) + K_02*K_02*(w[3][0] + 0.500000000000000*w[4][0])));
    G[72] = det*(K_00*K_11*w[3][0] + K_01*K_10*w[4][0]);
    G[73] = det*(K_01*(K_20*K_20*(w[3][0] + 0.500000000000000*w[4][0]) + K_21*K_21*(1.500000000000000*w[4][0] + 3.000000000000000*w[3][0]) + K_22*K_22*(w[3][0] + 0.500000000000000*w[4][0])) + K_21*(2.000000000000000*w[3][0]*(K_00*K_20 + K_02*K_22) + w[4][0]*(K_00*K_20 + K_02*K_22)));
    G[74] = det*(2.000000000000000*K_02*w[3][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22) + K_22*w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[75] = det*(K_01*(K_00*K_10*(w[3][0] + w[4][0]) + K_01*K_11*(w[4][0] + 2.000000000000000*w[3][0]) + K_02*K_12*(w[3][0] + w[4][0])) + K_11*w[3][0]*(K_00*K_00 + K_02*K_02));
    G[76] = det*(2.000000000000000*K_00*w[3][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22) + K_20*w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[77] = det*(w[3][0]*(2.000000000000000*(K_10*(K_00*K_21 + K_01*K_20) + K_11*(K_00*K_20 + K_02*K_22) + K_12*(K_01*K_22 + K_02*K_21)) + 6.000000000000000*K_01*K_11*K_21) + w[4][0]*(K_01*(3.000000000000000*K_11*K_21 + K_10*K_20 + K_12*K_22) + K_11*(K_00*K_20 + K_02*K_22) + K_21*(K_00*K_10 + K_02*K_12)));
    G[78] = K_02*det*(2.000000000000000*w[3][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[79] = det*(K_02*w[3][0]*(K_10*K_10 + K_11*K_11) + K_12*(K_00*K_10*(w[3][0] + w[4][0]) + K_01*K_11*(w[3][0] + w[4][0]) + K_02*K_12*(w[4][0] + 2.000000000000000*w[3][0])));
    G[80] = det*(K_00*(K_00*K_10*(w[4][0] + 2.000000000000000*w[3][0]) + K_01*K_11*(w[3][0] + w[4][0]) + K_02*K_12*(w[3][0] + w[4][0])) + K_10*w[3][0]*(K_01*K_01 + K_02*K_02));
    G[81] = det*(2.000000000000000*w[3][0]*(K_00*(K_00*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_21 + K_02*(K_01*(K_01*K_22 + K_02*K_21) + K_02*K_02*K_22)) + w[4][0]*(K_00*(K_00*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_21 + K_02*(K_01*(K_01*K_22 + K_02*K_21) + K_02*K_02*K_22)));
    G[82] = det*(K_10*w[4][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22) + w[3][0]*(K_00*(K_11*K_21 + K_12*K_22) + K_20*(2.000000000000000*K_00*K_10 + K_01*K_11 + K_02*K_12)));
    G[83] = det*(2.000000000000000*w[3][0]*(K_00*(K_10*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_10 + K_01*K_11 + K_02*K_12)) + K_01*(K_02*K_11*K_22 + K_21*(K_01*K_11 + K_02*K_12)) + K_02*K_02*K_12*K_22) + w[4][0]*(K_10*K_20*(K_00*K_00 + K_01*K_01 + K_02*K_02) + K_11*K_21*(K_00*K_00 + K_01*K_01 + K_02*K_02) + K_12*K_22*(K_00*K_00 + K_01*K_01 + K_02*K_02)));
    G[84] = det*(K_01*K_01*w[4][0] + w[3][0]*(2.000000000000000*K_01*K_01 + K_00*K_00 + K_02*K_02));
    G[85] = det*(0.500000000000000*K_01*w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_21*w[3][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22));
    G[86] = det*(w[3][0]*(4.000000000000000*K_00*K_02*K_10*K_12 + K_10*K_10*(3.000000000000000*K_00*K_00 + K_01*K_01 + K_02*K_02) + K_11*(4.000000000000000*K_01*(K_00*K_10 + K_02*K_12) + K_11*(3.000000000000000*K_01*K_01 + K_00*K_00 + K_02*K_02)) + K_12*K_12*(3.000000000000000*K_02*K_02 + K_00*K_00 + K_01*K_01)) + w[4][0]*(0.500000000000000*(K_00*K_00*K_11*K_11 + K_01*K_01*K_10*K_10 + K_02*K_02*(K_10*K_10 + K_11*K_11) + K_12*K_12*(K_00*K_00 + K_01*K_01)) + 1.500000000000000*K_01*K_01*K_11*K_11 + K_00*K_10*(1.500000000000000*K_00*K_10 + 2.000000000000000*K_01*K_11) + K_02*K_12*(1.500000000000000*K_02*K_12 + 2.000000000000000*(K_00*K_10 + K_01*K_11))));
    G[87] = det*(0.500000000000000*K_01*w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_11*w[3][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12));
    G[88] = det*(0.500000000000000*w[4][0]*(K_00*K_10*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_01*K_11*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_02*K_12*(K_20*K_20 + K_21*K_21 + K_22*K_22)) + w[3][0]*(K_01*K_11*K_21*K_21 + K_20*(K_00*K_10*K_20 + K_21*(K_00*K_11 + K_01*K_10)) + K_22*(K_02*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_12*(K_00*K_20 + K_01*K_21))));
    G[89] = det*(2.000000000000000*w[3][0]*(K_00*(K_00*(K_01*K_11 + K_02*K_12) + K_10*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_11 + K_02*(K_01*(K_01*K_12 + K_02*K_11) + K_02*K_02*K_12)) + w[4][0]*(K_00*(K_00*(K_01*K_11 + K_02*K_12) + K_10*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_11 + K_02*(K_01*(K_01*K_12 + K_02*K_11) + K_02*K_02*K_12)));
    G[90] = det*(2.000000000000000*K_02*w[3][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12) + K_12*w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[91] = det*(1.500000000000000*w[4][0]*(K_00*(K_00*(K_01*K_11 + K_02*K_12) + K_10*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_11 + K_02*(K_01*(K_01*K_12 + K_02*K_11) + K_02*K_02*K_12)) + 3.000000000000000*w[3][0]*(K_00*(K_00*(K_01*K_11 + K_02*K_12) + K_10*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_11 + K_02*(K_01*(K_01*K_12 + K_02*K_11) + K_02*K_02*K_12)));
    G[92] = K_01*det*(1.500000000000000*w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + 3.000000000000000*w[3][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[93] = det*(0.500000000000000*w[4][0]*(K_00*(K_00*(K_01*K_11 + K_02*K_12) + K_10*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_11 + K_02*(K_01*(K_01*K_12 + K_02*K_11) + K_02*K_02*K_12)) + w[3][0]*(K_00*(K_00*(K_01*K_11 + K_02*K_12) + K_10*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_11 + K_02*(K_01*(K_01*K_12 + K_02*K_11) + K_02*K_02*K_12)));
    G[94] = det*(K_01*(2.000000000000000*w[4][0]*(K_00*K_10 + K_02*K_12) + 4.000000000000000*w[3][0]*(K_00*K_10 + K_02*K_12)) + K_11*(K_00*K_00*(w[4][0] + 2.000000000000000*w[3][0]) + K_01*K_01*(3.000000000000000*w[4][0] + 6.000000000000000*w[3][0]) + K_02*K_02*(w[4][0] + 2.000000000000000*w[3][0])));
    G[95] = det*(K_00*(w[3][0]*(2.000000000000000*K_00*K_20 + K_01*K_21 + K_02*K_22) + w[4][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_20*w[3][0]*(K_01*K_01 + K_02*K_02));
    G[96] = det*(w[3][0]*(K_00*(4.000000000000000*K_02*(K_10*K_22 + K_12*K_20) + K_00*(2.000000000000000*(K_11*K_21 + K_12*K_22) + 6.000000000000000*K_10*K_20)) + K_01*(4.000000000000000*(K_11*(K_00*K_20 + K_02*K_22) + K_21*(K_00*K_10 + K_02*K_12)) + K_01*(2.000000000000000*(K_10*K_20 + K_12*K_22) + 6.000000000000000*K_11*K_21)) + K_02*K_02*(2.000000000000000*(K_10*K_20 + K_11*K_21) + 6.000000000000000*K_12*K_22)) + w[4][0]*(K_00*(2.000000000000000*K_02*(K_10*K_22 + K_12*K_20) + K_00*(3.000000000000000*K_10*K_20 + K_11*K_21 + K_12*K_22)) + K_01*(2.000000000000000*(K_11*(K_00*K_20 + K_02*K_22) + K_21*(K_00*K_10 + K_02*K_12)) + K_01*(3.000000000000000*K_11*K_21 + K_10*K_20 + K_12*K_22)) + K_02*K_02*(3.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21)));
    G[97] = det*(K_01*K_21*w[4][0] + w[3][0]*(2.000000000000000*K_01*K_21 + K_00*K_20 + K_02*K_22));
    G[98] = det*(1.500000000000000*w[4][0]*(K_00*(K_00*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_21 + K_02*(K_01*(K_01*K_22 + K_02*K_21) + K_02*K_02*K_22)) + 3.000000000000000*w[3][0]*(K_00*(K_00*(K_01*K_21 + K_02*K_22) + K_20*(K_00*K_00 + K_01*K_01 + K_02*K_02)) + K_01*K_01*K_01*K_21 + K_02*(K_01*(K_01*K_22 + K_02*K_21) + K_02*K_02*K_22)));
    G[99] = K_00*K_01*det*(w[3][0] + w[4][0]);
    G[100] = K_00*det*(2.000000000000000*w[3][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[101] = det*(w[3][0]*(K_20*(2.000000000000000*K_21*(K_00*K_11 + K_01*K_10) + K_20*(3.000000000000000*K_00*K_10 + K_01*K_11 + K_02*K_12)) + K_21*K_21*(3.000000000000000*K_01*K_11 + K_00*K_10 + K_02*K_12) + K_22*(2.000000000000000*(K_20*(K_00*K_12 + K_02*K_10) + K_21*(K_01*K_12 + K_02*K_11)) + K_22*(3.000000000000000*K_02*K_12 + K_00*K_10 + K_01*K_11))) + w[4][0]*(K_20*(0.500000000000000*K_20*(K_01*K_11 + K_02*K_12) + K_00*(K_11*K_21 + K_12*K_22) + K_10*(1.500000000000000*K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_21*K_21*(0.500000000000000*(K_00*K_10 + K_02*K_12) + 1.500000000000000*K_01*K_11) + K_22*(K_21*(K_01*K_12 + K_02*K_11) + K_22*(0.500000000000000*(K_00*K_10 + K_01*K_11) + 1.500000000000000*K_02*K_12))));
    G[102] = det*(K_01*K_11*w[4][0] + w[3][0]*(2.000000000000000*K_01*K_11 + K_00*K_10 + K_02*K_12));
    G[103] = det*(K_01*K_12*w[4][0] + K_02*K_11*w[3][0]);
    G[104] = det*(K_02*(K_00*K_10*(w[3][0] + w[4][0]) + K_01*K_11*(w[3][0] + w[4][0]) + K_02*K_12*(w[4][0] + 2.000000000000000*w[3][0])) + K_12*w[3][0]*(K_00*K_00 + K_01*K_01));
    G[105] = det*(2.000000000000000*K_00*w[3][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12) + K_10*w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[106] = det*(K_01*K_22*w[4][0] + K_02*K_21*w[3][0]);
    G[107] = det*(K_01*(K_00*K_20*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0]) + K_01*K_21*(3.000000000000000*w[4][0] + 6.000000000000000*w[3][0]) + K_02*K_22*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0])) + K_21*(K_00*K_00*(w[4][0] + 2.000000000000000*w[3][0]) + K_02*K_02*(w[4][0] + 2.000000000000000*w[3][0])));
    G[108] = det*(K_10*K_10*K_10*K_10*(w[3][0] + 0.500000000000000*w[4][0]) + K_11*K_11*(K_10*K_10*(w[4][0] + 2.000000000000000*w[3][0]) + K_11*K_11*(w[3][0] + 0.500000000000000*w[4][0])) + K_12*K_12*(K_10*K_10*(w[4][0] + 2.000000000000000*w[3][0]) + K_11*K_11*(w[4][0] + 2.000000000000000*w[3][0]) + K_12*K_12*(w[3][0] + 0.500000000000000*w[4][0])));
    G[109] = K_10*det*(0.500000000000000*w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + w[3][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[110] = det*(K_00*K_12*w[3][0] + K_02*K_10*w[4][0]);
    G[111] = det*(2.000000000000000*w[3][0]*(K_10*K_10*K_10*K_20 + K_11*(K_11*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_21*(K_10*K_10 + K_12*K_12)) + K_12*(K_10*K_10*K_22 + K_12*(K_10*K_20 + K_12*K_22))) + w[4][0]*(K_10*K_10*K_10*K_20 + K_11*(K_11*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_21*(K_10*K_10 + K_12*K_12)) + K_12*(K_10*K_10*K_22 + K_12*(K_10*K_20 + K_12*K_22))));
    G[112] = det*(K_10*(K_10*K_20*(3.000000000000000*w[4][0] + 6.000000000000000*w[3][0]) + K_11*K_21*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0]) + K_12*K_22*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0])) + K_20*(2.000000000000000*w[3][0]*(K_11*K_11 + K_12*K_12) + w[4][0]*(K_11*K_11 + K_12*K_12)));
    G[113] = K_11*det*(2.000000000000000*w[3][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[114] = det*(0.500000000000000*K_10*w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + K_00*w[3][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12));
    G[115] = det*(2.000000000000000*w[3][0]*(K_02*K_12*K_12*K_12 + K_10*(K_00*K_10*K_10 + K_12*(K_00*K_12 + K_02*K_10)) + K_11*(K_01*(K_10*K_10 + K_12*K_12) + K_11*(K_00*K_10 + K_01*K_11 + K_02*K_12))) + w[4][0]*(K_02*K_12*K_12*K_12 + K_10*(K_00*K_10*K_10 + K_12*(K_00*K_12 + K_02*K_10)) + K_11*(K_01*(K_10*K_10 + K_12*K_12) + K_11*(K_00*K_10 + K_01*K_11 + K_02*K_12))));
    G[116] = det*(0.500000000000000*K_10*w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_20*w[3][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22));
    G[117] = det*(2.000000000000000*K_12*w[3][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12) + K_02*w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[118] = det*(2.000000000000000*w[3][0]*(K_02*K_12*K_12*K_22 + K_10*(K_00*K_10*K_20 + K_12*(K_00*K_22 + K_02*K_20)) + K_11*(K_01*(K_10*K_20 + K_12*K_22) + K_21*(K_00*K_10 + K_01*K_11 + K_02*K_12))) + w[4][0]*(K_00*K_20*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_01*K_21*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_02*K_22*(K_10*K_10 + K_11*K_11 + K_12*K_12)));
    G[119] = det*(K_10*(w[3][0]*(2.000000000000000*K_10*K_20 + K_11*K_21 + K_12*K_22) + w[4][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22)) + K_20*w[3][0]*(K_11*K_11 + K_12*K_12));
    G[120] = det*(w[3][0]*(K_10*(4.000000000000000*(K_11*(K_00*K_21 + K_01*K_20) + K_12*(K_00*K_22 + K_02*K_20)) + K_10*(2.000000000000000*(K_01*K_21 + K_02*K_22) + 6.000000000000000*K_00*K_20)) + K_11*(4.000000000000000*K_12*(K_01*K_22 + K_02*K_21) + K_11*(2.000000000000000*(K_00*K_20 + K_02*K_22) + 6.000000000000000*K_01*K_21)) + K_12*K_12*(2.000000000000000*(K_00*K_20 + K_01*K_21) + 6.000000000000000*K_02*K_22)) + w[4][0]*(K_10*(2.000000000000000*(K_11*(K_00*K_21 + K_01*K_20) + K_12*(K_00*K_22 + K_02*K_20)) + K_10*(3.000000000000000*K_00*K_20 + K_01*K_21 + K_02*K_22)) + K_11*(2.000000000000000*K_12*(K_01*K_22 + K_02*K_21) + K_11*(3.000000000000000*K_01*K_21 + K_00*K_20 + K_02*K_22)) + K_12*K_12*(3.000000000000000*K_02*K_22 + K_00*K_20 + K_01*K_21)));
    G[121] = det*(K_01*w[3][0]*(K_10*K_10 + K_12*K_12) + K_11*(K_00*K_10*(w[3][0] + w[4][0]) + K_01*K_11*(w[4][0] + 2.000000000000000*w[3][0]) + K_02*K_12*(w[3][0] + w[4][0])));
    G[122] = det*(K_10*K_10*w[4][0] + w[3][0]*(2.000000000000000*K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[123] = det*(2.000000000000000*K_11*w[3][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_21*w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[124] = det*(1.500000000000000*w[4][0]*(K_02*K_12*K_12*K_12 + K_10*(K_00*K_10*K_10 + K_12*(K_00*K_12 + K_02*K_10)) + K_11*(K_01*(K_10*K_10 + K_12*K_12) + K_11*(K_00*K_10 + K_01*K_11 + K_02*K_12))) + 3.000000000000000*w[3][0]*(K_02*K_12*K_12*K_12 + K_10*(K_00*K_10*K_10 + K_12*(K_00*K_12 + K_02*K_10)) + K_11*(K_01*(K_10*K_10 + K_12*K_12) + K_11*(K_00*K_10 + K_01*K_11 + K_02*K_12))));
    G[125] = det*(K_10*(K_21*K_21*(w[3][0] + 0.500000000000000*w[4][0]) + K_22*K_22*(w[3][0] + 0.500000000000000*w[4][0])) + K_20*(w[3][0]*(2.000000000000000*(K_11*K_21 + K_12*K_22) + 3.000000000000000*K_10*K_20) + w[4][0]*(1.500000000000000*K_10*K_20 + K_11*K_21 + K_12*K_22)));
    G[126] = det*(1.500000000000000*w[4][0]*(K_10*K_10*K_10*K_20 + K_11*(K_11*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_21*(K_10*K_10 + K_12*K_12)) + K_12*(K_10*K_10*K_22 + K_12*(K_10*K_20 + K_12*K_22))) + 3.000000000000000*w[3][0]*(K_10*K_10*K_10*K_20 + K_11*(K_11*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_21*(K_10*K_10 + K_12*K_12)) + K_12*(K_10*K_10*K_22 + K_12*(K_10*K_20 + K_12*K_22))));
    G[127] = det*(K_00*(K_10*K_10*(3.000000000000000*w[4][0] + 6.000000000000000*w[3][0]) + K_11*K_11*(w[4][0] + 2.000000000000000*w[3][0]) + K_12*K_12*(w[4][0] + 2.000000000000000*w[3][0])) + K_10*(K_01*K_11*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0]) + K_02*K_12*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0])));
    G[128] = det*(2.000000000000000*K_12*w[3][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_22*w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[129] = det*(K_00*(K_00*K_10*(1.500000000000000*w[4][0] + 3.000000000000000*w[3][0]) + K_01*K_11*(w[4][0] + 2.000000000000000*w[3][0]) + K_02*K_12*(w[4][0] + 2.000000000000000*w[3][0])) + K_10*(K_01*K_01*(w[3][0] + 0.500000000000000*w[4][0]) + K_02*K_02*(w[3][0] + 0.500000000000000*w[4][0])));
    G[130] = det*(2.000000000000000*K_11*w[3][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12) + K_01*w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[131] = K_12*det*(2.000000000000000*w[3][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[132] = det*(K_21*w[4][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12) + w[3][0]*(K_01*(K_10*K_20 + K_12*K_22) + K_11*(2.000000000000000*K_01*K_21 + K_00*K_20 + K_02*K_22)));
    G[133] = det*(K_10*K_21*w[4][0] + K_11*K_20*w[3][0]);
    G[134] = det*(K_00*K_10*(w[4][0] + 2.000000000000000*w[3][0]) + w[3][0]*(K_01*K_11 + K_02*K_12));
    G[135] = K_10*K_11*det*(w[3][0] + w[4][0]);
    G[136] = K_10*K_12*det*(w[3][0] + w[4][0]);
    G[137] = K_10*det*(1.500000000000000*w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + 3.000000000000000*w[3][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[138] = det*(K_10*K_22*w[4][0] + K_12*K_20*w[3][0]);
    G[139] = det*(0.500000000000000*K_02*w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_12*w[3][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12));
    G[140] = det*(K_02*K_02*w[4][0] + w[3][0]*(2.000000000000000*K_02*K_02 + K_00*K_00 + K_01*K_01));
    G[141] = det*(K_02*(2.000000000000000*w[4][0]*(K_00*K_20 + K_01*K_21) + 4.000000000000000*w[3][0]*(K_00*K_20 + K_01*K_21)) + K_22*(K_00*K_00*(w[4][0] + 2.000000000000000*w[3][0]) + K_01*K_01*(w[4][0] + 2.000000000000000*w[3][0]) + K_02*K_02*(3.000000000000000*w[4][0] + 6.000000000000000*w[3][0])));
    G[142] = K_02*det*(1.500000000000000*w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + 3.000000000000000*w[3][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[143] = det*(0.500000000000000*K_02*w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_22*w[3][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22));
    G[144] = det*(K_02*(K_00*K_10*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0]) + K_01*K_11*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0])) + K_12*(K_00*K_00*(w[4][0] + 2.000000000000000*w[3][0]) + K_01*K_01*(w[4][0] + 2.000000000000000*w[3][0]) + K_02*K_02*(3.000000000000000*w[4][0] + 6.000000000000000*w[3][0])));
    G[145] = det*(2.000000000000000*K_01*w[3][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22) + K_21*w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[146] = det*(K_02*(K_10*K_10*(w[3][0] + 0.500000000000000*w[4][0]) + K_11*K_11*(w[3][0] + 0.500000000000000*w[4][0])) + K_12*(K_00*K_10*(w[4][0] + 2.000000000000000*w[3][0]) + K_01*K_11*(w[4][0] + 2.000000000000000*w[3][0]) + K_02*K_12*(1.500000000000000*w[4][0] + 3.000000000000000*w[3][0])));
    G[147] = det*(K_02*(K_20*K_20*(w[3][0] + 0.500000000000000*w[4][0]) + K_21*K_21*(w[3][0] + 0.500000000000000*w[4][0])) + K_22*(K_00*K_20*(w[4][0] + 2.000000000000000*w[3][0]) + K_01*K_21*(w[4][0] + 2.000000000000000*w[3][0]) + K_02*K_22*(1.500000000000000*w[4][0] + 3.000000000000000*w[3][0])));
    G[148] = K_02*det*(0.500000000000000*w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + w[3][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[149] = det*(K_01*K_22*w[3][0] + K_02*K_21*w[4][0]);
    G[150] = det*(w[3][0]*(2.000000000000000*(K_10*(K_00*K_22 + K_02*K_20) + K_11*(K_01*K_22 + K_02*K_21) + K_12*(K_00*K_20 + K_01*K_21)) + 6.000000000000000*K_02*K_12*K_22) + w[4][0]*(K_00*(K_10*K_22 + K_12*K_20) + K_01*(K_11*K_22 + K_12*K_21) + K_02*(3.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21)));
    G[151] = K_00*K_02*det*(w[3][0] + w[4][0]);
    G[152] = det*(K_01*K_12*w[3][0] + K_02*K_11*w[4][0]);
    G[153] = K_01*det*(2.000000000000000*w[3][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[154] = det*(K_02*K_12*w[4][0] + w[3][0]*(2.000000000000000*K_02*K_12 + K_00*K_10 + K_01*K_11));
    G[155] = det*(2.000000000000000*K_01*w[3][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12) + K_11*w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[156] = det*(K_02*K_22*w[4][0] + w[3][0]*(2.000000000000000*K_02*K_22 + K_00*K_20 + K_01*K_21));
    G[157] = K_11*det*(1.500000000000000*w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + 3.000000000000000*w[3][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[158] = K_10*det*(2.000000000000000*w[3][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[159] = det*(0.500000000000000*K_11*w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + K_01*w[3][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12));
    G[160] = det*(K_11*(K_20*K_20*(w[3][0] + 0.500000000000000*w[4][0]) + K_22*K_22*(w[3][0] + 0.500000000000000*w[4][0])) + K_21*(K_10*K_20*(w[4][0] + 2.000000000000000*w[3][0]) + K_11*K_21*(1.500000000000000*w[4][0] + 3.000000000000000*w[3][0]) + K_12*K_22*(w[4][0] + 2.000000000000000*w[3][0])));
    G[161] = det*(K_11*(2.000000000000000*w[4][0]*(K_10*K_20 + K_12*K_22) + 4.000000000000000*w[3][0]*(K_10*K_20 + K_12*K_22)) + K_21*(K_10*K_10*(w[4][0] + 2.000000000000000*w[3][0]) + K_11*K_11*(3.000000000000000*w[4][0] + 6.000000000000000*w[3][0]) + K_12*K_12*(w[4][0] + 2.000000000000000*w[3][0])));
    G[162] = det*(2.000000000000000*K_10*w[3][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_20*w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[163] = det*(2.000000000000000*K_10*w[3][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12) + K_00*w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[164] = det*(0.500000000000000*K_11*w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_21*w[3][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22));
    G[165] = K_11*det*(0.500000000000000*w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + w[3][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[166] = det*(K_01*(K_10*K_10*(w[4][0] + 2.000000000000000*w[3][0]) + K_11*K_11*(3.000000000000000*w[4][0] + 6.000000000000000*w[3][0]) + K_12*K_12*(w[4][0] + 2.000000000000000*w[3][0])) + K_11*(2.000000000000000*w[4][0]*(K_00*K_10 + K_02*K_12) + 4.000000000000000*w[3][0]*(K_00*K_10 + K_02*K_12)));
    G[167] = det*(K_00*w[4][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22) + w[3][0]*(K_10*(K_01*K_21 + K_02*K_22) + K_20*(2.000000000000000*K_00*K_10 + K_01*K_11 + K_02*K_12)));
    G[168] = det*(K_11*K_21*w[4][0] + w[3][0]*(2.000000000000000*K_11*K_21 + K_10*K_20 + K_12*K_22));
    G[169] = det*(K_01*(K_00*K_10*(w[4][0] + 2.000000000000000*w[3][0]) + K_01*K_11*(1.500000000000000*w[4][0] + 3.000000000000000*w[3][0]) + K_02*K_12*(w[4][0] + 2.000000000000000*w[3][0])) + K_11*(0.500000000000000*w[4][0]*(K_00*K_00 + K_02*K_02) + w[3][0]*(K_00*K_00 + K_02*K_02)));
    G[170] = det*(K_00*K_11*w[4][0] + K_01*K_10*w[3][0]);
    G[171] = det*(K_11*K_11*w[4][0] + w[3][0]*(2.000000000000000*K_11*K_11 + K_10*K_10 + K_12*K_12));
    G[172] = K_11*K_12*det*(w[3][0] + w[4][0]);
    G[173] = det*(K_11*K_22*w[4][0] + K_12*K_21*w[3][0]);
    G[174] = det*(K_11*(2.000000000000000*w[3][0]*(K_10*K_20 + K_12*K_22) + w[4][0]*(K_10*K_20 + K_12*K_22)) + K_21*(K_10*K_10*(w[3][0] + 0.500000000000000*w[4][0]) + K_11*K_11*(1.500000000000000*w[4][0] + 3.000000000000000*w[3][0]) + K_12*K_12*(w[3][0] + 0.500000000000000*w[4][0])));
    G[175] = K_20*det*(2.000000000000000*w[3][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[176] = det*(0.500000000000000*K_21*w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + K_01*w[3][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22));
    G[177] = K_21*det*(1.500000000000000*w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + 3.000000000000000*w[3][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[178] = det*(K_11*(K_20*K_20*(w[4][0] + 2.000000000000000*w[3][0]) + K_22*K_22*(w[4][0] + 2.000000000000000*w[3][0])) + K_21*(K_10*K_20*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0]) + K_11*K_21*(3.000000000000000*w[4][0] + 6.000000000000000*w[3][0]) + K_12*K_22*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0])));
    G[179] = det*(2.000000000000000*K_20*w[3][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22) + K_10*w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[180] = K_21*det*(0.500000000000000*w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + w[3][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[181] = det*(0.500000000000000*K_21*w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_11*w[3][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22));
    G[182] = det*(2.000000000000000*K_20*w[3][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22) + K_00*w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[183] = det*(K_21*K_21*w[4][0] + w[3][0]*(2.000000000000000*K_21*K_21 + K_20*K_20 + K_22*K_22));
    G[184] = det*(K_01*(K_00*K_20*(w[4][0] + 2.000000000000000*w[3][0]) + K_01*K_21*(1.500000000000000*w[4][0] + 3.000000000000000*w[3][0]) + K_02*K_22*(w[4][0] + 2.000000000000000*w[3][0])) + K_21*(0.500000000000000*w[4][0]*(K_00*K_00 + K_02*K_02) + w[3][0]*(K_00*K_00 + K_02*K_02)));
    G[185] = det*(K_00*K_21*w[4][0] + K_01*K_20*w[3][0]);
    G[186] = det*(K_11*K_22*w[3][0] + K_12*K_21*w[4][0]);
    G[187] = K_21*K_22*det*(w[3][0] + w[4][0]);
    G[188] = det*(K_01*(K_20*K_20*(w[4][0] + 2.000000000000000*w[3][0]) + K_22*K_22*(w[4][0] + 2.000000000000000*w[3][0])) + K_21*(K_00*K_20*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0]) + K_01*K_21*(3.000000000000000*w[4][0] + 6.000000000000000*w[3][0]) + K_02*K_22*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0])));
    G[189] = det*(0.500000000000000*K_22*w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_12*w[3][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22));
    G[190] = det*(K_02*(2.000000000000000*w[3][0]*(K_20*K_20 + K_21*K_21) + w[4][0]*(K_20*K_20 + K_21*K_21)) + K_22*(K_00*K_20*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0]) + K_01*K_21*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0]) + K_02*K_22*(3.000000000000000*w[4][0] + 6.000000000000000*w[3][0])));
    G[191] = det*(K_02*(K_00*K_20*(w[4][0] + 2.000000000000000*w[3][0]) + K_01*K_21*(w[4][0] + 2.000000000000000*w[3][0])) + K_22*(K_00*K_00*(w[3][0] + 0.500000000000000*w[4][0]) + K_01*K_01*(w[3][0] + 0.500000000000000*w[4][0]) + K_02*K_02*(1.500000000000000*w[4][0] + 3.000000000000000*w[3][0])));
    G[192] = K_22*det*(0.500000000000000*w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + w[3][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[193] = det*(K_12*(K_10*K_20*(w[4][0] + 2.000000000000000*w[3][0]) + K_11*K_21*(w[4][0] + 2.000000000000000*w[3][0]) + K_12*K_22*(1.500000000000000*w[4][0] + 3.000000000000000*w[3][0])) + K_22*(K_10*K_10*(w[3][0] + 0.500000000000000*w[4][0]) + K_11*K_11*(w[3][0] + 0.500000000000000*w[4][0])));
    G[194] = K_22*det*(1.500000000000000*w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + 3.000000000000000*w[3][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22));
    G[195] = det*(0.500000000000000*K_22*w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + K_02*w[3][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22));
    G[196] = det*(K_12*(K_20*K_20*(w[4][0] + 2.000000000000000*w[3][0]) + K_21*K_21*(w[4][0] + 2.000000000000000*w[3][0]) + K_22*K_22*(3.000000000000000*w[4][0] + 6.000000000000000*w[3][0])) + K_22*(2.000000000000000*w[4][0]*(K_10*K_20 + K_11*K_21) + 4.000000000000000*w[3][0]*(K_10*K_20 + K_11*K_21)));
    G[197] = det*(K_00*K_22*w[4][0] + K_02*K_20*w[3][0]);
    G[198] = det*(K_12*K_22*w[4][0] + w[3][0]*(2.000000000000000*K_12*K_22 + K_10*K_20 + K_11*K_21));
    G[199] = det*(K_22*K_22*w[4][0] + w[3][0]*(2.000000000000000*K_22*K_22 + K_20*K_20 + K_21*K_21));
    G[200] = K_12*det*(0.500000000000000*w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + w[3][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[201] = det*(K_02*(K_00*K_10*(w[4][0] + 2.000000000000000*w[3][0]) + K_01*K_11*(w[4][0] + 2.000000000000000*w[3][0]) + K_02*K_12*(1.500000000000000*w[4][0] + 3.000000000000000*w[3][0])) + K_12*(K_00*K_00*(w[3][0] + 0.500000000000000*w[4][0]) + K_01*K_01*(w[3][0] + 0.500000000000000*w[4][0])));
    G[202] = det*(0.500000000000000*K_12*w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_22*w[3][0]*(K_10*K_20 + K_11*K_21 + K_12*K_22));
    G[203] = det*(K_02*(2.000000000000000*w[3][0]*(K_10*K_10 + K_11*K_11) + w[4][0]*(K_10*K_10 + K_11*K_11)) + K_12*(K_00*K_10*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0]) + K_01*K_11*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0]) + K_02*K_12*(3.000000000000000*w[4][0] + 6.000000000000000*w[3][0])));
    G[204] = K_12*det*(1.500000000000000*w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + 3.000000000000000*w[3][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12));
    G[205] = det*(K_12*(K_20*K_20*(w[3][0] + 0.500000000000000*w[4][0]) + K_21*K_21*(w[3][0] + 0.500000000000000*w[4][0]) + K_22*K_22*(1.500000000000000*w[4][0] + 3.000000000000000*w[3][0])) + K_22*(2.000000000000000*w[3][0]*(K_10*K_20 + K_11*K_21) + w[4][0]*(K_10*K_20 + K_11*K_21)));
    G[206] = det*(0.500000000000000*K_12*w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + K_02*w[3][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12));
    G[207] = det*(K_12*(w[3][0]*(4.000000000000000*(K_10*K_20 + K_11*K_21) + 6.000000000000000*K_12*K_22) + w[4][0]*(2.000000000000000*(K_10*K_20 + K_11*K_21) + 3.000000000000000*K_12*K_22)) + K_22*(2.000000000000000*w[3][0]*(K_10*K_10 + K_11*K_11) + w[4][0]*(K_10*K_10 + K_11*K_11)));
    G[208] = det*(K_00*K_12*w[4][0] + K_02*K_10*w[3][0]);
    G[209] = det*(K_12*K_12*w[4][0] + w[3][0]*(2.000000000000000*K_12*K_12 + K_10*K_10 + K_11*K_11));
    G[210] = det*(0.500000000000000*K_00*w[4][0]*(K_10*K_10 + K_11*K_11 + K_12*K_12) + K_10*w[3][0]*(K_00*K_10 + K_01*K_11 + K_02*K_12));
    G[211] = K_00*det*(0.500000000000000*w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + w[3][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[212] = det*(0.500000000000000*K_00*w[4][0]*(K_20*K_20 + K_21*K_21 + K_22*K_22) + K_20*w[3][0]*(K_00*K_20 + K_01*K_21 + K_02*K_22));
    G[213] = det*(K_00*(2.000000000000000*w[4][0]*(K_01*K_21 + K_02*K_22) + 4.000000000000000*w[3][0]*(K_01*K_21 + K_02*K_22)) + K_20*(K_00*K_00*(3.000000000000000*w[4][0] + 6.000000000000000*w[3][0]) + K_01*K_01*(w[4][0] + 2.000000000000000*w[3][0]) + K_02*K_02*(w[4][0] + 2.000000000000000*w[3][0])));
    G[214] = det*(K_00*(K_21*K_21*(w[3][0] + 0.500000000000000*w[4][0]) + K_22*K_22*(w[3][0] + 0.500000000000000*w[4][0])) + K_20*(K_00*K_20*(1.500000000000000*w[4][0] + 3.000000000000000*w[3][0]) + K_01*K_21*(w[4][0] + 2.000000000000000*w[3][0]) + K_02*K_22*(w[4][0] + 2.000000000000000*w[3][0])));
    G[215] = det*(K_00*(K_00*K_10*(3.000000000000000*w[4][0] + 6.000000000000000*w[3][0]) + K_01*K_11*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0]) + K_02*K_12*(2.000000000000000*w[4][0] + 4.000000000000000*w[3][0])) + K_10*(2.000000000000000*w[3][0]*(K_01*K_01 + K_02*K_02) + w[4][0]*(K_01*K_01 + K_02*K_02)));
    G[216] = K_00*det*(1.500000000000000*w[4][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02) + 3.000000000000000*w[3][0]*(K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[217] = det*(K_00*K_00*w[4][0] + w[3][0]*(2.000000000000000*K_00*K_00 + K_01*K_01 + K_02*K_02));
    G[218] = det*(K_00*(K_10*K_10*(1.500000000000000*w[4][0] + 3.000000000000000*w[3][0]) + K_11*K_11*(w[3][0] + 0.500000000000000*w[4][0]) + K_12*K_12*(w[3][0] + 0.500000000000000*w[4][0])) + K_10*(K_01*K_11*(w[4][0] + 2.000000000000000*w[3][0]) + K_02*K_12*(w[4][0] + 2.000000000000000*w[3][0])));
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 14264
    for (unsigned int ip = 0; ip < 8; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.000000000000000;
      double F1 = 0.000000000000000;
      double F2 = 0.000000000000000;
      double F3 = 0.000000000000000;
      double F4 = 0.000000000000000;
      double F5 = 0.000000000000000;
      double F6 = 0.000000000000000;
      double F7 = 0.000000000000000;
      double F8 = 0.000000000000000;
      double F9 = 0.000000000000000;
      double F10 = 0.000000000000000;
      double F11 = 0.000000000000000;
      
      // Total number of operations to compute function values = 36
      for (unsigned int r = 0; r < 2; r++)
      {
        F3 += FE1_C0_D001[ip][r]*w[0][nzc3[r]];
        F4 += FE1_C0_D001[ip][r]*w[0][nzc2[r]];
        F5 += FE1_C0_D001[ip][r]*w[0][nzc1[r]];
        F6 += FE1_C0_D001[ip][r]*w[0][nzc7[r]];
        F7 += FE1_C0_D001[ip][r]*w[0][nzc6[r]];
        F8 += FE1_C0_D001[ip][r]*w[0][nzc5[r]];
        F9 += FE1_C0_D001[ip][r]*w[0][nzc11[r]];
        F10 += FE1_C0_D001[ip][r]*w[0][nzc10[r]];
        F11 += FE1_C0_D001[ip][r]*w[0][nzc9[r]];
      }// end loop over 'r'
      
      // Total number of operations to compute function values = 24
      for (unsigned int r = 0; r < 4; r++)
      {
        F0 += FE1_C0[ip][r]*w[1][nzc0[r]];
        F1 += FE1_C0[ip][r]*w[1][nzc4[r]];
        F2 += FE1_C0[ip][r]*w[1][nzc8[r]];
      }// end loop over 'r'
      
      // Number of operations to compute ip constants: 1663
      double I[12];
      // Number of operations: 183
      I[0] = W8[ip]*(F10*(G[59] + F10*G[4] + F9*G[18]) + F11*(G[62] + F10*G[21] + F11*G[13] + F9*G[10]) + F3*(G[55] + F10*(G[40] + F10*G[33] + F9*G[36]) + F11*(G[39] + F10*G[19] + F11*G[43] + F9*G[25]) + F3*(G[49] + F3*G[3]) + F5*(G[22] + F3*G[5] + F5*G[42]) + F6*(G[56] + F6*G[3] + F7*G[36]) + F7*(G[28] + F7*G[33]) + F8*(G[53] + F6*G[25] + F7*G[19] + F8*G[43]) + F9*(G[48] + F9*G[3])) + F4*(G[29] + F10*G[51] + F11*(G[47] + F10*G[7] + F11*G[1] + F9*G[19]) + F3*(G[46] + F3*G[14] + F4*G[35]) + F4*G[60] + F5*(G[8] + F3*G[27] + F4*G[44] + F5*G[61]) + F6*(G[50] + F6*G[15] + F7*G[12]) + F7*G[9] + F8*(G[32] + F6*G[19] + F7*G[7] + F8*G[1]) + F9*(G[17] + F10*G[12] + F9*G[15]) + G[0]*(F10*F10 + F4*F4 + F7*F7)) + F5*(G[41] + F10*(G[24] + F10*G[31] + F9*G[30]) + F11*(G[37] + F10*G[26] + F11*G[34] + F9*G[2]) + F5*(G[38] + F5*G[34]) + F6*(G[20] + F6*G[52] + F7*G[30]) + F7*(G[23] + F7*G[31]) + F8*(G[57] + F6*G[2] + F7*G[26] + F8*G[34]) + F9*(G[16] + F9*G[52])) + F6*(G[45] + F6*G[11] + F7*G[18]) + F7*(G[58] + F7*G[4]) + F8*(G[54] + F6*G[10] + F7*G[21] + F8*G[13]) + F9*(G[6] + F9*G[11]));
      
      // Number of operations: 184
      I[1] = W8[ip]*(F10*(G[103] + F10*G[87] + F9*G[75]) + F11*(G[106] + F10*G[50] + F11*G[85] + F9*G[56]) + F3*(G[99] + F3*G[70] + F4*G[75]) + F4*(G[72] + F4*G[87]) + F5*(G[45] + F3*G[56] + F4*G[50] + F5*G[85]) + F6*(G[84] + F10*(G[90] + F10*G[68] + F9*G[89]) + F11*(G[74] + F10*G[83] + F11*G[52] + F9*G[81]) + F3*(G[100] + F3*G[71] + F4*G[89]) + F4*(G[105] + F4*G[68]) + F5*(G[76] + F3*G[81] + F4*G[83] + F5*G[52]) + F6*G[92] + F9*G[78] + G[71]*(F6*F6 + F9*F9)) + F7*(G[102] + F10*G[79] + F11*(G[64] + F10*G[12] + F11*G[88] + F9*G[36]) + F3*(G[80] + F3*G[93] + F4*G[63]) + F4*G[69] + F5*(G[18] + F3*G[36] + F4*G[12] + F5*G[88]) + F6*(G[94] + F6*G[91] + F7*G[86]) + F7*G[66] + F8*(G[77] + F6*G[96] + F7*G[35] + F8*G[101]) + F9*(G[104] + F10*G[63] + F9*G[93]) + G[65]*(F10*F10 + F4*F4 + F7*F7)) + F8*(G[97] + F10*(G[40] + F10*G[33] + F9*G[36]) + F11*(G[39] + F10*G[19] + F11*G[43] + F9*G[25]) + F3*(G[95] + F3*G[3] + F4*G[36]) + F4*(G[82] + F4*G[33]) + F5*(G[10] + F3*G[25] + F4*G[19] + F5*G[43]) + F6*(G[107] + F6*G[98] + F8*G[5]) + F8*(G[73] + F8*G[43]) + F9*(G[48] + F9*G[3])) + F9*(G[67] + F9*G[70]));
      
      // Number of operations: 184
      I[2] = W8[ip]*(F10*(G[136] + F10*G[109]) + F11*(G[138] + F10*G[119] + F11*G[116] + F9*G[82]) + F3*(G[134] + F10*(G[79] + F10*G[65] + F9*G[63]) + F11*(G[64] + F10*G[12] + F11*G[88] + F9*G[36]) + F3*G[129] + F5*(G[46] + F3*G[14] + F5*G[101]) + F6*G[75] + F7*(G[121] + F6*G[63] + F7*G[65]) + F8*(G[132] + F6*G[36] + F7*G[12] + F8*G[88]) + F9*G[104] + G[93]*(F3*F3 + F6*F6 + F9*F9)) + F4*(G[122] + F10*G[131] + F11*(G[128] + F10*G[111] + F11*G[31] + F9*G[118]) + F3*(G[127] + F3*G[86] + F4*G[124]) + F4*G[137] + F5*(G[112] + F3*G[120] + F4*G[126] + F5*G[44]) + F6*(G[130] + F6*G[68] + F7*G[115] + F8*G[118]) + F7*G[113] + F8*(G[123] + F7*G[111] + F8*G[31]) + F9*(G[117] + F10*G[115] + F9*G[68]) + G[108]*(F10*F10 + F4*F4 + F7*F7)) + F5*(G[29] + F10*(G[51] + F10*G[0] + F9*G[12]) + F11*(G[47] + F10*G[7] + F11*G[1] + F9*G[19]) + F5*(G[125] + F5*G[1]) + F6*(G[50] + F6*G[15] + F7*G[12]) + F7*(G[9] + F7*G[0]) + F8*(G[32] + F6*G[19] + F7*G[7] + F8*G[1]) + F9*(G[17] + F9*G[15])) + F6*(G[72] + F6*G[114] + F7*G[69]) + F7*(G[135] + F7*G[109]) + F8*(G[133] + F6*G[82] + F7*G[119] + F8*G[116]) + F9*(G[110] + F10*G[69] + F9*G[114]));
      
      // Number of operations: 184
      I[3] = W8[ip]*(F10*(G[154] + F10*G[146] + F11*(G[150] + F10*G[35] + F11*G[101] + F9*G[96]) + F3*(G[80] + F3*G[93] + F4*G[63]) + F4*G[69] + F5*(G[18] + F3*G[36] + F4*G[12] + F5*G[88]) + F6*(G[75] + F6*G[93] + F7*G[63]) + F7*G[121] + F8*(G[132] + F6*G[36] + F7*G[12] + F8*G[88]) + F9*(G[144] + F10*G[86] + F9*G[91]) + G[65]*(F10*F10 + F4*F4 + F7*F7)) + F11*(G[156] + F11*(G[147] + F11*G[43] + F9*G[5]) + F3*(G[95] + F3*G[3] + F4*G[36]) + F4*(G[82] + F4*G[33]) + F5*(G[10] + F3*G[25] + F4*G[19] + F5*G[43]) + F6*(G[56] + F6*G[3] + F7*G[36]) + F7*(G[28] + F7*G[33]) + F8*(G[53] + F6*G[25] + F7*G[19] + F8*G[43]) + F9*(G[141] + F9*G[98])) + F3*(G[151] + F3*G[148] + F4*G[104]) + F4*G[110] + F5*(G[6] + F3*G[48] + F4*G[17] + F5*G[143]) + F6*(G[67] + F6*G[148] + F7*G[104]) + F7*G[152] + F8*(G[149] + F6*G[48] + F7*G[17] + F8*G[143]) + F9*(G[140] + F3*(G[100] + F3*G[71] + F4*G[89]) + F4*(G[105] + F4*G[68]) + F5*(G[76] + F3*G[81] + F4*G[83] + F5*G[52]) + F6*(G[153] + F6*G[71] + F7*G[89] + F8*G[81]) + F7*(G[155] + F7*G[68] + F8*G[83]) + F8*(G[145] + F8*G[52]) + F9*(G[142] + F9*G[71])) + G[139]*(F4*F4 + F7*F7));
      
      // Number of operations: 184
      I[4] = W8[ip]*(F10*(G[172] + F10*G[165] + F9*G[121]) + F11*(G[173] + F10*G[9] + F11*G[164] + F9*G[28]) + F3*(G[170] + F3*G[159] + F4*G[121]) + F4*(G[135] + F4*G[165]) + F5*(G[58] + F3*G[28] + F4*G[9] + F5*G[164]) + F6*(G[102] + F10*(G[79] + F10*G[65] + F9*G[63]) + F11*(G[64] + F10*G[12] + F11*G[88] + F9*G[36]) + F3*G[80] + F4*(G[69] + F3*G[63] + F4*G[65]) + F5*(G[18] + F3*G[36] + F4*G[12] + F5*G[88]) + F6*G[169] + F9*G[104] + G[93]*(F3*F3 + F6*F6 + F9*F9)) + F7*(G[171] + F10*G[131] + F11*(G[128] + F10*G[111] + F11*G[31] + F9*G[118]) + F3*(G[163] + F3*G[68] + F4*G[115]) + F4*G[158] + F5*(G[162] + F3*G[118] + F4*G[111] + F5*G[31]) + F6*(G[166] + F6*G[86] + F7*G[124] + F8*G[120]) + F7*G[157] + F8*(G[161] + F7*G[126] + F8*G[44]) + F9*(G[117] + F10*G[115] + F9*G[68]) + G[108]*(F10*F10 + F4*F4 + F7*F7)) + F8*(G[168] + F10*(G[51] + F10*G[0] + F9*G[12]) + F11*(G[47] + F10*G[7] + F11*G[1] + F9*G[19]) + F3*(G[167] + F3*G[15] + F4*G[12]) + F4*(G[119] + F4*G[0]) + F5*(G[21] + F3*G[19] + F4*G[7] + F5*G[1]) + F6*(G[77] + F6*G[14] + F8*G[101]) + F8*(G[160] + F8*G[1]) + F9*(G[17] + F9*G[15])) + F9*(G[152] + F9*G[159]));
      
      // Number of operations: 185
      I[5] = W8[ip]*(F10*(G[186] + F10*G[181]) + F11*(G[187] + F10*G[32] + F11*G[180] + F9*G[53]) + F3*(G[185] + F3*G[176] + F4*G[132]) + F4*(G[133] + F4*G[181]) + F5*(G[54] + F3*G[53] + F4*G[32] + F5*G[180]) + F6*(G[97] + F10*(G[40] + F10*G[33] + F9*G[36]) + F11*(G[39] + F10*G[19] + F11*G[43] + F9*G[25]) + F3*G[95] + F4*(G[82] + F3*G[36] + F4*G[33]) + F5*(G[10] + F3*G[25] + F4*G[19] + F5*G[43]) + F6*G[184] + F9*G[48] + G[3]*(F3*F3 + F6*F6 + F9*F9)) + F7*(G[168] + F10*G[51] + F11*(G[47] + F10*G[7] + F11*G[1] + F9*G[19]) + F3*(G[167] + F3*G[15] + F4*G[12]) + F4*G[119] + F5*(G[21] + F3*G[19] + F4*G[7] + F5*G[1]) + F6*(G[77] + F6*G[14] + F7*G[35]) + F7*G[174] + F8*(G[178] + F6*G[27] + F7*G[44] + F8*G[61]) + F9*(G[17] + F10*G[12] + F9*G[15]) + G[0]*(F10*F10 + F4*F4 + F7*F7)) + F8*(G[183] + F10*(G[24] + F10*G[31] + F9*G[30]) + F11*(G[37] + F10*G[26] + F11*G[34] + F9*G[2]) + F3*G[182] + F4*(G[179] + F3*G[30] + F4*G[31]) + F5*(G[175] + F3*G[2] + F4*G[26] + F5*G[34]) + F6*(G[188] + F6*G[5] + F8*G[42]) + F8*(G[177] + F8*G[34]) + F9*G[16] + G[52]*(F3*F3 + F9*F9)) + F9*(G[149] + F10*G[132] + F9*G[176]));
      
      // Number of operations: 185
      I[6] = W8[ip]*(F10*(G[198] + F10*G[193] + F11*(G[196] + F10*G[44] + F11*G[61] + F9*G[27]) + F3*(G[167] + F3*G[15] + F4*G[12]) + F4*G[119] + F5*(G[21] + F3*G[19] + F4*G[7] + F5*G[1]) + F6*(G[50] + F6*G[15] + F7*G[12]) + F7*G[9] + F8*(G[32] + F6*G[19] + F7*G[7] + F8*G[1]) + F9*(G[150] + F10*G[35] + F9*G[14]) + G[0]*(F10*F10 + F4*F4 + F7*F7)) + F11*(G[199] + F11*(G[194] + F11*G[34] + F9*G[42]) + F3*(G[182] + F3*G[52] + F4*G[30]) + F4*G[179] + F5*(G[175] + F3*G[2] + F4*G[26] + F5*G[34]) + F6*(G[20] + F6*G[52] + F7*G[30]) + F7*G[23] + F8*(G[57] + F6*G[2] + F7*G[26] + F8*G[34]) + F9*(G[190] + F9*G[5]) + G[31]*(F4*F4 + F7*F7)) + F3*(G[197] + F3*G[195] + F5*G[39]) + F4*(G[138] + F3*G[64] + F4*G[189] + F5*G[47]) + F5*(G[62] + F5*G[192]) + F6*(G[106] + F6*G[195] + F7*G[64]) + F7*(G[173] + F7*G[189]) + F8*(G[187] + F6*G[39] + F7*G[47] + F8*G[192]) + F9*(G[156] + F3*G[95] + F4*(G[82] + F3*G[36] + F4*G[33]) + F5*(G[10] + F3*G[25] + F4*G[19] + F5*G[43]) + F6*G[56] + F7*(G[28] + F6*G[36] + F7*G[33]) + F8*(G[53] + F6*G[25] + F7*G[19] + F8*G[43]) + F9*G[191] + G[3]*(F3*F3 + F6*F6 + F9*F9)));
      
      // Number of operations: 185
      I[7] = W8[ip]*(F10*(G[209] + F10*G[204] + F11*(G[207] + F10*G[126] + F11*G[44] + F9*G[120]) + F3*(G[163] + F3*G[68] + F4*G[115]) + F4*G[158] + F5*(G[162] + F3*G[118] + F4*G[111] + F5*G[31]) + F6*(G[130] + F6*G[68] + F7*G[115] + F8*G[118]) + F7*G[113] + F8*(G[123] + F7*G[111] + F8*G[31]) + F9*(G[203] + F10*G[124] + F9*G[86]) + G[108]*(F10*F10 + F4*F4 + F7*F7)) + F11*(G[198] + F11*(G[205] + F11*G[1] + F9*G[101]) + F3*(G[167] + F3*G[15] + F4*G[12]) + F4*G[119] + F5*(G[21] + F3*G[19] + F4*G[7] + F5*G[1]) + F6*(G[50] + F6*G[15] + F7*G[12]) + F7*G[9] + F8*(G[32] + F6*G[19] + F7*G[7] + F8*G[1]) + F9*(G[150] + F9*G[14]) + G[0]*(F4*F4 + F7*F7)) + F3*(G[208] + F3*G[206] + F5*G[40]) + F4*(G[136] + F3*G[79] + F4*G[200] + F5*G[51]) + F5*(G[59] + F5*G[202]) + F6*(G[103] + F6*G[206] + F7*G[79]) + F7*(G[172] + F7*G[200]) + F8*(G[186] + F6*G[40] + F7*G[51] + F8*G[202]) + F9*(G[154] + F3*G[80] + F4*(G[69] + F3*G[63] + F4*G[65]) + F5*(G[18] + F3*G[36] + F4*G[12] + F5*G[88]) + F6*G[75] + F7*(G[121] + F6*G[63] + F7*G[65]) + F8*(G[132] + F6*G[36] + F7*G[12] + F8*G[88]) + F9*G[201] + G[93]*(F3*F3 + F6*F6 + F9*F9)));
      
      // Number of operations: 183
      I[8] = W8[ip]*(F10*(G[208] + F10*G[210] + F9*G[80]) + F11*(G[197] + F10*G[167] + F11*G[212] + F9*G[95]) + F3*(G[217] + F10*(G[90] + F10*G[68] + F9*G[89]) + F11*(G[74] + F10*G[83] + F11*G[52] + F9*G[81]) + F3*(G[216] + F3*G[71] + F5*G[98]) + F5*(G[213] + F5*G[5]) + F6*(G[153] + F6*G[71] + F7*G[89]) + F7*(G[155] + F7*G[68]) + F8*(G[145] + F6*G[81] + F7*G[83] + F8*G[52]) + F9*(G[78] + F9*G[71])) + F4*(G[134] + F10*G[79] + F11*(G[64] + F10*G[12] + F11*G[88] + F9*G[36]) + F3*(G[215] + F3*G[91] + F4*G[86]) + F4*G[218] + F5*(G[46] + F3*G[96] + F4*G[35] + F5*G[101]) + F6*(G[75] + F6*G[93] + F7*G[63]) + F7*G[121] + F8*(G[132] + F6*G[36] + F7*G[12] + F8*G[88]) + F9*(G[104] + F10*G[63] + F9*G[93]) + G[65]*(F10*F10 + F4*F4 + F7*F7)) + F5*(G[55] + F10*(G[40] + F10*G[33] + F9*G[36]) + F11*(G[39] + F10*G[19] + F11*G[43] + F9*G[25]) + F5*(G[214] + F5*G[43]) + F6*(G[56] + F6*G[3] + F7*G[36]) + F7*(G[28] + F7*G[33]) + F8*(G[53] + F6*G[25] + F7*G[19] + F8*G[43]) + F9*(G[48] + F9*G[3])) + F6*(G[99] + F6*G[211] + F7*G[80]) + F7*(G[170] + F7*G[210]) + F8*(G[185] + F6*G[95] + F7*G[167] + F8*G[212]) + F9*(G[151] + F9*G[211]));
      
      // Number of operations: 2
      I[9] =  - F0*W8[ip]*det;
      
      // Number of operations: 2
      I[10] =  - F2*W8[ip]*det;
      
      // Number of operations: 2
      I[11] =  - F1*W8[ip]*det;
      
      
      // Number of operations for primary indices: 36
      for (unsigned int j = 0; j < 2; j++)
      {
        // Number of operations to compute entry: 2
        A[nzc1[j]] += FE1_C0_D001[ip][j]*I[0];
        // Number of operations to compute entry: 2
        A[nzc7[j]] += FE1_C0_D001[ip][j]*I[1];
        // Number of operations to compute entry: 2
        A[nzc2[j]] += FE1_C0_D001[ip][j]*I[2];
        // Number of operations to compute entry: 2
        A[nzc11[j]] += FE1_C0_D001[ip][j]*I[3];
        // Number of operations to compute entry: 2
        A[nzc6[j]] += FE1_C0_D001[ip][j]*I[4];
        // Number of operations to compute entry: 2
        A[nzc5[j]] += FE1_C0_D001[ip][j]*I[5];
        // Number of operations to compute entry: 2
        A[nzc9[j]] += FE1_C0_D001[ip][j]*I[6];
        // Number of operations to compute entry: 2
        A[nzc10[j]] += FE1_C0_D001[ip][j]*I[7];
        // Number of operations to compute entry: 2
        A[nzc3[j]] += FE1_C0_D001[ip][j]*I[8];
      }// end loop over 'j'
      
      // Number of operations for primary indices: 24
      for (unsigned int j = 0; j < 4; j++)
      {
        // Number of operations to compute entry: 2
        A[nzc0[j]] += FE1_C0[ip][j]*I[9];
        // Number of operations to compute entry: 2
        A[nzc8[j]] += FE1_C0[ip][j]*I[10];
        // Number of operations to compute entry: 2
        A[nzc4[j]] += FE1_C0[ip][j]*I[11];
      }// end loop over 'j'
    }// end loop over 'ip'
  }

};

/// This class defines the interface for the tabulation of the
/// exterior facet tensor corresponding to the local contribution to
/// a form from the integral over an exterior facet.

class hyperelasticity_exterior_facet_integral_1_0: public ufc::exterior_facet_integral
{
public:

  /// Constructor
  hyperelasticity_exterior_facet_integral_1_0() : ufc::exterior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_exterior_facet_integral_1_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int facet) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      27
    // Number of operations (multiply-add pairs) for geometry tensor:    12
    // Number of operations (multiply-add pairs) for tensor contraction: 90
    // Total number of operations (multiply-add pairs):                  129
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute sub determinants
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Get vertices on face
    static unsigned int face_vertices[4][3] = {{1, 2, 3}, {0, 2, 3}, {0, 1, 3}, {0, 1, 2}};
    const unsigned int v0 = face_vertices[facet][0];
    const unsigned int v1 = face_vertices[facet][1];
    const unsigned int v2 = face_vertices[facet][2];
    
    // Compute scale factor (area of face scaled by area of reference triangle)
    const double a0 = (x[v0][1]*x[v1][2]
                     + x[v0][2]*x[v2][1]
                     + x[v1][1]*x[v2][2])
                    - (x[v2][1]*x[v1][2]
                     + x[v2][2]*x[v0][1]
                     + x[v1][1]*x[v0][2]);
    
    const double a1 = (x[v0][2]*x[v1][0]
                     + x[v0][0]*x[v2][2]
                     + x[v1][2]*x[v2][0])
                    - (x[v2][2]*x[v1][0]
                     + x[v2][0]*x[v0][2]
                    + x[v1][2]*x[v0][0]);
    
    const double a2 = (x[v0][0]*x[v1][1]
                     + x[v0][1]*x[v2][0]
                     + x[v1][0]*x[v2][1])
                    - (x[v2][0]*x[v1][1]
                     + x[v2][1]*x[v0][0]
                     + x[v1][0]*x[v0][1]);
    
    const double det = std::sqrt(a0*a0 + a1*a1 + a2*a2);
    
    // Compute geometry tensor
    const double G0_0 = det*w[2][0]*(1.0);
    const double G0_1 = det*w[2][1]*(1.0);
    const double G0_2 = det*w[2][2]*(1.0);
    const double G0_3 = det*w[2][3]*(1.0);
    const double G0_4 = det*w[2][4]*(1.0);
    const double G0_5 = det*w[2][5]*(1.0);
    const double G0_6 = det*w[2][6]*(1.0);
    const double G0_7 = det*w[2][7]*(1.0);
    const double G0_8 = det*w[2][8]*(1.0);
    const double G0_9 = det*w[2][9]*(1.0);
    const double G0_10 = det*w[2][10]*(1.0);
    const double G0_11 = det*w[2][11]*(1.0);
    
    // Compute element tensor
    switch (facet)
    {
    case 0:
      {
        A[0] = 0.000000000000000;
      A[1] = -0.083333333333333*G0_1 - 0.041666666666667*G0_2 - 0.041666666666667*G0_3;
      A[2] = -0.041666666666667*G0_1 - 0.083333333333333*G0_2 - 0.041666666666667*G0_3;
      A[3] = -0.041666666666667*G0_1 - 0.041666666666667*G0_2 - 0.083333333333333*G0_3;
      A[4] = 0.000000000000000;
      A[5] = -0.083333333333333*G0_5 - 0.041666666666667*G0_6 - 0.041666666666667*G0_7;
      A[6] = -0.041666666666667*G0_5 - 0.083333333333333*G0_6 - 0.041666666666667*G0_7;
      A[7] = -0.041666666666667*G0_5 - 0.041666666666667*G0_6 - 0.083333333333333*G0_7;
      A[8] = 0.000000000000000;
      A[9] = -0.083333333333333*G0_9 - 0.041666666666667*G0_10 - 0.041666666666667*G0_11;
      A[10] = -0.041666666666667*G0_9 - 0.083333333333333*G0_10 - 0.041666666666667*G0_11;
      A[11] = -0.041666666666667*G0_9 - 0.041666666666667*G0_10 - 0.083333333333333*G0_11;
        break;
      }
    case 1:
      {
        A[0] = -0.083333333333333*G0_0 - 0.041666666666667*G0_2 - 0.041666666666667*G0_3;
      A[1] = 0.000000000000000;
      A[2] = -0.041666666666667*G0_0 - 0.083333333333333*G0_2 - 0.041666666666667*G0_3;
      A[3] = -0.041666666666667*G0_0 - 0.041666666666667*G0_2 - 0.083333333333333*G0_3;
      A[4] = -0.083333333333333*G0_4 - 0.041666666666667*G0_6 - 0.041666666666667*G0_7;
      A[5] = 0.000000000000000;
      A[6] = -0.041666666666667*G0_4 - 0.083333333333333*G0_6 - 0.041666666666667*G0_7;
      A[7] = -0.041666666666667*G0_4 - 0.041666666666667*G0_6 - 0.083333333333333*G0_7;
      A[8] = -0.083333333333333*G0_8 - 0.041666666666667*G0_10 - 0.041666666666667*G0_11;
      A[9] = 0.000000000000000;
      A[10] = -0.041666666666667*G0_8 - 0.083333333333333*G0_10 - 0.041666666666667*G0_11;
      A[11] = -0.041666666666667*G0_8 - 0.041666666666667*G0_10 - 0.083333333333333*G0_11;
        break;
      }
    case 2:
      {
        A[0] = -0.083333333333333*G0_0 - 0.041666666666667*G0_1 - 0.041666666666667*G0_3;
      A[1] = -0.041666666666667*G0_0 - 0.083333333333333*G0_1 - 0.041666666666667*G0_3;
      A[2] = 0.000000000000000;
      A[3] = -0.041666666666667*G0_0 - 0.041666666666667*G0_1 - 0.083333333333333*G0_3;
      A[4] = -0.083333333333333*G0_4 - 0.041666666666667*G0_5 - 0.041666666666667*G0_7;
      A[5] = -0.041666666666667*G0_4 - 0.083333333333333*G0_5 - 0.041666666666667*G0_7;
      A[6] = 0.000000000000000;
      A[7] = -0.041666666666667*G0_4 - 0.041666666666667*G0_5 - 0.083333333333333*G0_7;
      A[8] = -0.083333333333333*G0_8 - 0.041666666666667*G0_9 - 0.041666666666667*G0_11;
      A[9] = -0.041666666666667*G0_8 - 0.083333333333333*G0_9 - 0.041666666666667*G0_11;
      A[10] = 0.000000000000000;
      A[11] = -0.041666666666667*G0_8 - 0.041666666666667*G0_9 - 0.083333333333333*G0_11;
        break;
      }
    case 3:
      {
        A[0] = -0.083333333333333*G0_0 - 0.041666666666667*G0_1 - 0.041666666666667*G0_2;
      A[1] = -0.041666666666667*G0_0 - 0.083333333333333*G0_1 - 0.041666666666667*G0_2;
      A[2] = -0.041666666666667*G0_0 - 0.041666666666667*G0_1 - 0.083333333333333*G0_2;
      A[3] = 0.000000000000000;
      A[4] = -0.083333333333333*G0_4 - 0.041666666666667*G0_5 - 0.041666666666667*G0_6;
      A[5] = -0.041666666666667*G0_4 - 0.083333333333333*G0_5 - 0.041666666666667*G0_6;
      A[6] = -0.041666666666667*G0_4 - 0.041666666666667*G0_5 - 0.083333333333333*G0_6;
      A[7] = 0.000000000000000;
      A[8] = -0.083333333333333*G0_8 - 0.041666666666667*G0_9 - 0.041666666666667*G0_10;
      A[9] = -0.041666666666667*G0_8 - 0.083333333333333*G0_9 - 0.041666666666667*G0_10;
      A[10] = -0.041666666666667*G0_8 - 0.041666666666667*G0_9 - 0.083333333333333*G0_10;
      A[11] = 0.000000000000000;
        break;
      }
    }
    
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class hyperelasticity_form_0: public ufc::form
{
public:

  /// Constructor
  hyperelasticity_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Sum(Product(Constant(Cell('tetrahedron', 1, Space(3)), 1), IndexSum(Indexed(ComponentTensor(IndexSum(Sum(Sum(Product(Indexed(ComponentTensor(Division(Indexed(ComponentTensor(IndexSum(Sum(Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(0),), {Index(0): 3})), MultiIndex((Index(1),), {Index(1): 3})), MultiIndex((Index(1), Index(0)), {Index(0): 3, Index(1): 3})), MultiIndex((Index(2), Index(3)), {Index(2): 3, Index(3): 3})), MultiIndex((Index(3), Index(2)), {Index(2): 3, Index(3): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(6),), {Index(6): 3})), MultiIndex((Index(7),), {Index(7): 3})), MultiIndex((Index(7), Index(6)), {Index(7): 3, Index(6): 3})), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3}))), Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(0),), {Index(0): 3})), MultiIndex((Index(1),), {Index(1): 3})), MultiIndex((Index(1), Index(0)), {Index(0): 3, Index(1): 3})), MultiIndex((Index(2), Index(3)), {Index(2): 3, Index(3): 3})), MultiIndex((Index(3), Index(2)), {Index(2): 3, Index(3): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(6),), {Index(6): 3})), MultiIndex((Index(7),), {Index(7): 3})), MultiIndex((Index(7), Index(6)), {Index(7): 3, Index(6): 3})), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3})))), MultiIndex((Index(5),), {Index(5): 3})), MultiIndex((Index(4), Index(8)), {Index(4): 3, Index(8): 3})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), IntValue(2, (), (), {})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), MultiIndex((Index(11), Index(12)), {Index(11): 3, Index(12): 3})), Indexed(ComponentTensor(Division(Indexed(Sum(ComponentTensor(IndexSum(Product(Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(13),), {Index(13): 3})), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(14), Index(13)), {Index(14): 3, Index(13): 3})), Identity(3)), MultiIndex((Index(15), Index(16)), {Index(16): 3, Index(15): 3})), MultiIndex((Index(16), Index(15)), {Index(16): 3, Index(15): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(17),), {Index(17): 3})), MultiIndex((Index(18),), {Index(18): 3})), MultiIndex((Index(18), Index(17)), {Index(17): 3, Index(18): 3})), Identity(3)), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3}))), MultiIndex((Index(5),), {Index(5): 3})), MultiIndex((Index(4), Index(8)), {Index(4): 3, Index(8): 3})), ComponentTensor(Product(IntValue(-1, (), (), {}), Indexed(Identity(3), MultiIndex((Index(19), Index(20)), {Index(19): 3, Index(20): 3}))), MultiIndex((Index(19), Index(20)), {Index(19): 3, Index(20): 3}))), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), IntValue(2, (), (), {})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), MultiIndex((Index(12), Index(21)), {Index(21): 3, Index(12): 3}))), Product(Indexed(ComponentTensor(Division(Indexed(ComponentTensor(IndexSum(Sum(Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(0),), {Index(0): 3})), MultiIndex((Index(1),), {Index(1): 3})), MultiIndex((Index(1), Index(0)), {Index(0): 3, Index(1): 3})), MultiIndex((Index(2), Index(3)), {Index(2): 3, Index(3): 3})), MultiIndex((Index(3), Index(2)), {Index(2): 3, Index(3): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(6),), {Index(6): 3})), MultiIndex((Index(7),), {Index(7): 3})), MultiIndex((Index(7), Index(6)), {Index(7): 3, Index(6): 3})), Identity(3)), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3}))), Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(6),), {Index(6): 3})), MultiIndex((Index(7),), {Index(7): 3})), MultiIndex((Index(7), Index(6)), {Index(7): 3, Index(6): 3})), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3})), Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(0),), {Index(0): 3})), MultiIndex((Index(1),), {Index(1): 3})), MultiIndex((Index(1), Index(0)), {Index(0): 3, Index(1): 3})), Identity(3)), MultiIndex((Index(2), Index(3)), {Index(2): 3, Index(3): 3})), MultiIndex((Index(3), Index(2)), {Index(2): 3, Index(3): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})))), MultiIndex((Index(5),), {Index(5): 3})), MultiIndex((Index(4), Index(8)), {Index(4): 3, Index(8): 3})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), IntValue(2, (), (), {})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), MultiIndex((Index(11), Index(12)), {Index(11): 3, Index(12): 3})), Indexed(ComponentTensor(Division(Indexed(ComponentTensor(IndexSum(Sum(Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(13),), {Index(13): 3})), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(14), Index(13)), {Index(14): 3, Index(13): 3})), MultiIndex((Index(15), Index(16)), {Index(16): 3, Index(15): 3})), MultiIndex((Index(16), Index(15)), {Index(16): 3, Index(15): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(17),), {Index(17): 3})), MultiIndex((Index(18),), {Index(18): 3})), MultiIndex((Index(18), Index(17)), {Index(17): 3, Index(18): 3})), Identity(3)), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3}))), Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(17),), {Index(17): 3})), MultiIndex((Index(18),), {Index(18): 3})), MultiIndex((Index(18), Index(17)), {Index(17): 3, Index(18): 3})), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3})), Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(13),), {Index(13): 3})), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(14), Index(13)), {Index(14): 3, Index(13): 3})), Identity(3)), MultiIndex((Index(15), Index(16)), {Index(16): 3, Index(15): 3})), MultiIndex((Index(16), Index(15)), {Index(16): 3, Index(15): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})))), MultiIndex((Index(5),), {Index(5): 3})), MultiIndex((Index(4), Index(8)), {Index(4): 3, Index(8): 3})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), IntValue(2, (), (), {})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), MultiIndex((Index(12), Index(21)), {Index(21): 3, Index(12): 3})))), Sum(Product(Indexed(ComponentTensor(Division(Indexed(ComponentTensor(IndexSum(Sum(Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(13),), {Index(13): 3})), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(14), Index(13)), {Index(14): 3, Index(13): 3})), MultiIndex((Index(15), Index(16)), {Index(16): 3, Index(15): 3})), MultiIndex((Index(16), Index(15)), {Index(16): 3, Index(15): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(17),), {Index(17): 3})), MultiIndex((Index(18),), {Index(18): 3})), MultiIndex((Index(18), Index(17)), {Index(17): 3, Index(18): 3})), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3}))), Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(13),), {Index(13): 3})), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(14), Index(13)), {Index(14): 3, Index(13): 3})), MultiIndex((Index(15), Index(16)), {Index(16): 3, Index(15): 3})), MultiIndex((Index(16), Index(15)), {Index(16): 3, Index(15): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(17),), {Index(17): 3})), MultiIndex((Index(18),), {Index(18): 3})), MultiIndex((Index(18), Index(17)), {Index(17): 3, Index(18): 3})), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3})))), MultiIndex((Index(5),), {Index(5): 3})), MultiIndex((Index(4), Index(8)), {Index(4): 3, Index(8): 3})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), IntValue(2, (), (), {})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), MultiIndex((Index(12), Index(21)), {Index(21): 3, Index(12): 3})), Indexed(ComponentTensor(Division(Indexed(Sum(ComponentTensor(IndexSum(Product(Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(0),), {Index(0): 3})), MultiIndex((Index(1),), {Index(1): 3})), MultiIndex((Index(1), Index(0)), {Index(0): 3, Index(1): 3})), Identity(3)), MultiIndex((Index(2), Index(3)), {Index(2): 3, Index(3): 3})), MultiIndex((Index(3), Index(2)), {Index(2): 3, Index(3): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(6),), {Index(6): 3})), MultiIndex((Index(7),), {Index(7): 3})), MultiIndex((Index(7), Index(6)), {Index(7): 3, Index(6): 3})), Identity(3)), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3}))), MultiIndex((Index(5),), {Index(5): 3})), MultiIndex((Index(4), Index(8)), {Index(4): 3, Index(8): 3})), ComponentTensor(Product(IntValue(-1, (), (), {}), Indexed(Identity(3), MultiIndex((Index(19), Index(20)), {Index(19): 3, Index(20): 3}))), MultiIndex((Index(19), Index(20)), {Index(19): 3, Index(20): 3}))), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), IntValue(2, (), (), {})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), MultiIndex((Index(11), Index(12)), {Index(11): 3, Index(12): 3}))), Product(Indexed(ComponentTensor(Division(Indexed(ComponentTensor(IndexSum(Sum(Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(13),), {Index(13): 3})), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(14), Index(13)), {Index(14): 3, Index(13): 3})), MultiIndex((Index(15), Index(16)), {Index(16): 3, Index(15): 3})), MultiIndex((Index(16), Index(15)), {Index(16): 3, Index(15): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(17),), {Index(17): 3})), MultiIndex((Index(18),), {Index(18): 3})), MultiIndex((Index(18), Index(17)), {Index(17): 3, Index(18): 3})), Identity(3)), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3}))), Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(17),), {Index(17): 3})), MultiIndex((Index(18),), {Index(18): 3})), MultiIndex((Index(18), Index(17)), {Index(17): 3, Index(18): 3})), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3})), Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(13),), {Index(13): 3})), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(14), Index(13)), {Index(14): 3, Index(13): 3})), Identity(3)), MultiIndex((Index(15), Index(16)), {Index(16): 3, Index(15): 3})), MultiIndex((Index(16), Index(15)), {Index(16): 3, Index(15): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})))), MultiIndex((Index(5),), {Index(5): 3})), MultiIndex((Index(4), Index(8)), {Index(4): 3, Index(8): 3})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), IntValue(2, (), (), {})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), MultiIndex((Index(12), Index(21)), {Index(21): 3, Index(12): 3})), Indexed(ComponentTensor(Division(Indexed(ComponentTensor(IndexSum(Sum(Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(0),), {Index(0): 3})), MultiIndex((Index(1),), {Index(1): 3})), MultiIndex((Index(1), Index(0)), {Index(0): 3, Index(1): 3})), MultiIndex((Index(2), Index(3)), {Index(2): 3, Index(3): 3})), MultiIndex((Index(3), Index(2)), {Index(2): 3, Index(3): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(6),), {Index(6): 3})), MultiIndex((Index(7),), {Index(7): 3})), MultiIndex((Index(7), Index(6)), {Index(7): 3, Index(6): 3})), Identity(3)), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3}))), Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(6),), {Index(6): 3})), MultiIndex((Index(7),), {Index(7): 3})), MultiIndex((Index(7), Index(6)), {Index(7): 3, Index(6): 3})), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3})), Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(0),), {Index(0): 3})), MultiIndex((Index(1),), {Index(1): 3})), MultiIndex((Index(1), Index(0)), {Index(0): 3, Index(1): 3})), Identity(3)), MultiIndex((Index(2), Index(3)), {Index(2): 3, Index(3): 3})), MultiIndex((Index(3), Index(2)), {Index(2): 3, Index(3): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})))), MultiIndex((Index(5),), {Index(5): 3})), MultiIndex((Index(4), Index(8)), {Index(4): 3, Index(8): 3})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), IntValue(2, (), (), {})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), MultiIndex((Index(11), Index(12)), {Index(11): 3, Index(12): 3}))))), MultiIndex((Index(12),), {Index(12): 3})), MultiIndex((Index(11), Index(21)), {Index(21): 3, Index(11): 3})), MultiIndex((Index(22), Index(22)), {Index(22): 3})), MultiIndex((Index(22),), {Index(22): 3}))), Product(Division(Constant(Cell('tetrahedron', 1, Space(3)), 2), IntValue(2, (), (), {})), Sum(Product(IndexSum(Indexed(ComponentTensor(Division(Indexed(ComponentTensor(IndexSum(Sum(Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(23),), {Index(23): 3})), MultiIndex((Index(24),), {Index(24): 3})), MultiIndex((Index(24), Index(23)), {Index(24): 3, Index(23): 3})), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), MultiIndex((Index(26), Index(25)), {Index(26): 3, Index(25): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(27),), {Index(27): 3})), MultiIndex((Index(28),), {Index(28): 3})), MultiIndex((Index(28), Index(27)), {Index(28): 3, Index(27): 3})), Identity(3)), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3}))), Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(27),), {Index(27): 3})), MultiIndex((Index(28),), {Index(28): 3})), MultiIndex((Index(28), Index(27)), {Index(28): 3, Index(27): 3})), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3})), Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(23),), {Index(23): 3})), MultiIndex((Index(24),), {Index(24): 3})), MultiIndex((Index(24), Index(23)), {Index(24): 3, Index(23): 3})), Identity(3)), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), MultiIndex((Index(26), Index(25)), {Index(26): 3, Index(25): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})))), MultiIndex((Index(5),), {Index(5): 3})), MultiIndex((Index(4), Index(8)), {Index(4): 3, Index(8): 3})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), IntValue(2, (), (), {})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), MultiIndex((Index(29), Index(29)), {Index(29): 3})), MultiIndex((Index(29),), {Index(29): 3})), Product(IntValue(2, (), (), {}), IndexSum(Indexed(ComponentTensor(Division(Indexed(ComponentTensor(IndexSum(Sum(Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(23),), {Index(23): 3})), MultiIndex((Index(24),), {Index(24): 3})), MultiIndex((Index(24), Index(23)), {Index(24): 3, Index(23): 3})), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), MultiIndex((Index(26), Index(25)), {Index(26): 3, Index(25): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(27),), {Index(27): 3})), MultiIndex((Index(28),), {Index(28): 3})), MultiIndex((Index(28), Index(27)), {Index(28): 3, Index(27): 3})), Identity(3)), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3}))), Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(27),), {Index(27): 3})), MultiIndex((Index(28),), {Index(28): 3})), MultiIndex((Index(28), Index(27)), {Index(28): 3, Index(27): 3})), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3})), Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(23),), {Index(23): 3})), MultiIndex((Index(24),), {Index(24): 3})), MultiIndex((Index(24), Index(23)), {Index(24): 3, Index(23): 3})), Identity(3)), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), MultiIndex((Index(26), Index(25)), {Index(26): 3, Index(25): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})))), MultiIndex((Index(5),), {Index(5): 3})), MultiIndex((Index(4), Index(8)), {Index(4): 3, Index(8): 3})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), IntValue(2, (), (), {})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), MultiIndex((Index(29), Index(29)), {Index(29): 3})), MultiIndex((Index(29),), {Index(29): 3})))), Product(IndexSum(Indexed(ComponentTensor(Division(Indexed(Sum(ComponentTensor(IndexSum(Product(Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(23),), {Index(23): 3})), MultiIndex((Index(24),), {Index(24): 3})), MultiIndex((Index(24), Index(23)), {Index(24): 3, Index(23): 3})), Identity(3)), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), MultiIndex((Index(26), Index(25)), {Index(26): 3, Index(25): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(27),), {Index(27): 3})), MultiIndex((Index(28),), {Index(28): 3})), MultiIndex((Index(28), Index(27)), {Index(28): 3, Index(27): 3})), Identity(3)), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3}))), MultiIndex((Index(5),), {Index(5): 3})), MultiIndex((Index(4), Index(8)), {Index(4): 3, Index(8): 3})), ComponentTensor(Product(IntValue(-1, (), (), {}), Indexed(Identity(3), MultiIndex((Index(19), Index(20)), {Index(19): 3, Index(20): 3}))), MultiIndex((Index(19), Index(20)), {Index(19): 3, Index(20): 3}))), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), IntValue(2, (), (), {})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), MultiIndex((Index(29), Index(29)), {Index(29): 3})), MultiIndex((Index(29),), {Index(29): 3})), Product(IntValue(2, (), (), {}), IndexSum(Indexed(ComponentTensor(Division(Indexed(ComponentTensor(IndexSum(Sum(Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(23),), {Index(23): 3})), MultiIndex((Index(24),), {Index(24): 3})), MultiIndex((Index(24), Index(23)), {Index(24): 3, Index(23): 3})), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), MultiIndex((Index(26), Index(25)), {Index(26): 3, Index(25): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(27),), {Index(27): 3})), MultiIndex((Index(28),), {Index(28): 3})), MultiIndex((Index(28), Index(27)), {Index(28): 3, Index(27): 3})), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3}))), Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(23),), {Index(23): 3})), MultiIndex((Index(24),), {Index(24): 3})), MultiIndex((Index(24), Index(23)), {Index(24): 3, Index(23): 3})), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), MultiIndex((Index(26), Index(25)), {Index(26): 3, Index(25): 3})), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(27),), {Index(27): 3})), MultiIndex((Index(28),), {Index(28): 3})), MultiIndex((Index(28), Index(27)), {Index(28): 3, Index(27): 3})), MultiIndex((Index(5), Index(8)), {Index(5): 3, Index(8): 3})))), MultiIndex((Index(5),), {Index(5): 3})), MultiIndex((Index(4), Index(8)), {Index(4): 3, Index(8): 3})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), IntValue(2, (), (), {})), MultiIndex((Index(9), Index(10)), {Index(10): 3, Index(9): 3})), MultiIndex((Index(29), Index(29)), {Index(29): 3})), MultiIndex((Index(29),), {Index(29): 3}))))))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 3;
  }

  /// Return the number of cell integrals
  virtual unsigned int num_cell_integrals() const
  {
    return 1;
  }

  /// Return the number of exterior facet integrals
  virtual unsigned int num_exterior_facet_integrals() const
  {
    return 0;
  }

  /// Return the number of interior facet integrals
  virtual unsigned int num_interior_facet_integrals() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 3:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    case 4:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dof map for argument function i
  virtual ufc::dof_map* create_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dof_map_2();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dof_map_2();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dof_map_2();
        break;
      }
    case 3:
      {
        return new hyperelasticity_dof_map_0();
        break;
      }
    case 4:
      {
        return new hyperelasticity_dof_map_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class hyperelasticity_form_1: public ufc::form
{
public:

  /// Constructor
  hyperelasticity_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Sum(Product(IntValue(-1, (), (), {}), IndexSum(Product(Indexed(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(0),), {Index(0): 3})), Indexed(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(0),), {Index(0): 3}))), MultiIndex((Index(0),), {Index(0): 3}))), Sum(Product(Constant(Cell('tetrahedron', 1, Space(3)), 3), IndexSum(Indexed(ComponentTensor(IndexSum(Sum(Product(Indexed(ComponentTensor(Division(Indexed(ComponentTensor(IndexSum(Sum(Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(1),), {Index(1): 3})), MultiIndex((Index(2),), {Index(2): 3})), MultiIndex((Index(2), Index(1)), {Index(2): 3, Index(1): 3})), MultiIndex((Index(3), Index(4)), {Index(4): 3, Index(3): 3})), MultiIndex((Index(4), Index(3)), {Index(4): 3, Index(3): 3})), MultiIndex((Index(5), Index(6)), {Index(5): 3, Index(6): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(7),), {Index(7): 3})), MultiIndex((Index(8),), {Index(8): 3})), MultiIndex((Index(8), Index(7)), {Index(7): 3, Index(8): 3})), Identity(3)), MultiIndex((Index(6), Index(9)), {Index(9): 3, Index(6): 3}))), Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(7),), {Index(7): 3})), MultiIndex((Index(8),), {Index(8): 3})), MultiIndex((Index(8), Index(7)), {Index(7): 3, Index(8): 3})), MultiIndex((Index(6), Index(9)), {Index(9): 3, Index(6): 3})), Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(1),), {Index(1): 3})), MultiIndex((Index(2),), {Index(2): 3})), MultiIndex((Index(2), Index(1)), {Index(2): 3, Index(1): 3})), Identity(3)), MultiIndex((Index(3), Index(4)), {Index(4): 3, Index(3): 3})), MultiIndex((Index(4), Index(3)), {Index(4): 3, Index(3): 3})), MultiIndex((Index(5), Index(6)), {Index(5): 3, Index(6): 3})))), MultiIndex((Index(6),), {Index(6): 3})), MultiIndex((Index(5), Index(9)), {Index(5): 3, Index(9): 3})), MultiIndex((Index(10), Index(11)), {Index(11): 3, Index(10): 3})), IntValue(2, (), (), {})), MultiIndex((Index(10), Index(11)), {Index(11): 3, Index(10): 3})), MultiIndex((Index(12), Index(13)), {Index(13): 3, Index(12): 3})), Indexed(ComponentTensor(Division(Indexed(Sum(ComponentTensor(IndexSum(Product(Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(15),), {Index(15): 3})), MultiIndex((Index(15), Index(14)), {Index(14): 3, Index(15): 3})), Identity(3)), MultiIndex((Index(16), Index(17)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(17), Index(16)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(5), Index(6)), {Index(5): 3, Index(6): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(18),), {Index(18): 3})), MultiIndex((Index(19),), {Index(19): 3})), MultiIndex((Index(19), Index(18)), {Index(19): 3, Index(18): 3})), Identity(3)), MultiIndex((Index(6), Index(9)), {Index(9): 3, Index(6): 3}))), MultiIndex((Index(6),), {Index(6): 3})), MultiIndex((Index(5), Index(9)), {Index(5): 3, Index(9): 3})), ComponentTensor(Product(IntValue(-1, (), (), {}), Indexed(Identity(3), MultiIndex((Index(20), Index(21)), {Index(21): 3, Index(20): 3}))), MultiIndex((Index(20), Index(21)), {Index(21): 3, Index(20): 3}))), MultiIndex((Index(10), Index(11)), {Index(11): 3, Index(10): 3})), IntValue(2, (), (), {})), MultiIndex((Index(10), Index(11)), {Index(11): 3, Index(10): 3})), MultiIndex((Index(13), Index(22)), {Index(22): 3, Index(13): 3}))), Product(Indexed(ComponentTensor(Division(Indexed(ComponentTensor(IndexSum(Sum(Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(15),), {Index(15): 3})), MultiIndex((Index(15), Index(14)), {Index(14): 3, Index(15): 3})), MultiIndex((Index(16), Index(17)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(17), Index(16)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(5), Index(6)), {Index(5): 3, Index(6): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(18),), {Index(18): 3})), MultiIndex((Index(19),), {Index(19): 3})), MultiIndex((Index(19), Index(18)), {Index(19): 3, Index(18): 3})), Identity(3)), MultiIndex((Index(6), Index(9)), {Index(9): 3, Index(6): 3}))), Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(18),), {Index(18): 3})), MultiIndex((Index(19),), {Index(19): 3})), MultiIndex((Index(19), Index(18)), {Index(19): 3, Index(18): 3})), MultiIndex((Index(6), Index(9)), {Index(9): 3, Index(6): 3})), Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(15),), {Index(15): 3})), MultiIndex((Index(15), Index(14)), {Index(14): 3, Index(15): 3})), Identity(3)), MultiIndex((Index(16), Index(17)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(17), Index(16)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(5), Index(6)), {Index(5): 3, Index(6): 3})))), MultiIndex((Index(6),), {Index(6): 3})), MultiIndex((Index(5), Index(9)), {Index(5): 3, Index(9): 3})), MultiIndex((Index(10), Index(11)), {Index(11): 3, Index(10): 3})), IntValue(2, (), (), {})), MultiIndex((Index(10), Index(11)), {Index(11): 3, Index(10): 3})), MultiIndex((Index(13), Index(22)), {Index(22): 3, Index(13): 3})), Indexed(ComponentTensor(Division(Indexed(Sum(ComponentTensor(IndexSum(Product(Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(1),), {Index(1): 3})), MultiIndex((Index(2),), {Index(2): 3})), MultiIndex((Index(2), Index(1)), {Index(2): 3, Index(1): 3})), Identity(3)), MultiIndex((Index(3), Index(4)), {Index(4): 3, Index(3): 3})), MultiIndex((Index(4), Index(3)), {Index(4): 3, Index(3): 3})), MultiIndex((Index(5), Index(6)), {Index(5): 3, Index(6): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(7),), {Index(7): 3})), MultiIndex((Index(8),), {Index(8): 3})), MultiIndex((Index(8), Index(7)), {Index(7): 3, Index(8): 3})), Identity(3)), MultiIndex((Index(6), Index(9)), {Index(9): 3, Index(6): 3}))), MultiIndex((Index(6),), {Index(6): 3})), MultiIndex((Index(5), Index(9)), {Index(5): 3, Index(9): 3})), ComponentTensor(Product(IntValue(-1, (), (), {}), Indexed(Identity(3), MultiIndex((Index(20), Index(21)), {Index(21): 3, Index(20): 3}))), MultiIndex((Index(20), Index(21)), {Index(21): 3, Index(20): 3}))), MultiIndex((Index(10), Index(11)), {Index(11): 3, Index(10): 3})), IntValue(2, (), (), {})), MultiIndex((Index(10), Index(11)), {Index(11): 3, Index(10): 3})), MultiIndex((Index(12), Index(13)), {Index(13): 3, Index(12): 3})))), MultiIndex((Index(13),), {Index(13): 3})), MultiIndex((Index(12), Index(22)), {Index(22): 3, Index(12): 3})), MultiIndex((Index(23), Index(23)), {Index(23): 3})), MultiIndex((Index(23),), {Index(23): 3}))), Product(Division(Constant(Cell('tetrahedron', 1, Space(3)), 4), IntValue(2, (), (), {})), Product(IndexSum(Indexed(ComponentTensor(Division(Indexed(Sum(ComponentTensor(IndexSum(Product(Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(24),), {Index(24): 3})), MultiIndex((Index(25),), {Index(25): 3})), MultiIndex((Index(25), Index(24)), {Index(24): 3, Index(25): 3})), Identity(3)), MultiIndex((Index(26), Index(27)), {Index(26): 3, Index(27): 3})), MultiIndex((Index(27), Index(26)), {Index(26): 3, Index(27): 3})), MultiIndex((Index(5), Index(6)), {Index(5): 3, Index(6): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(28),), {Index(28): 3})), MultiIndex((Index(29),), {Index(29): 3})), MultiIndex((Index(29), Index(28)), {Index(29): 3, Index(28): 3})), Identity(3)), MultiIndex((Index(6), Index(9)), {Index(9): 3, Index(6): 3}))), MultiIndex((Index(6),), {Index(6): 3})), MultiIndex((Index(5), Index(9)), {Index(5): 3, Index(9): 3})), ComponentTensor(Product(IntValue(-1, (), (), {}), Indexed(Identity(3), MultiIndex((Index(20), Index(21)), {Index(21): 3, Index(20): 3}))), MultiIndex((Index(20), Index(21)), {Index(21): 3, Index(20): 3}))), MultiIndex((Index(10), Index(11)), {Index(11): 3, Index(10): 3})), IntValue(2, (), (), {})), MultiIndex((Index(10), Index(11)), {Index(11): 3, Index(10): 3})), MultiIndex((Index(30), Index(30)), {Index(30): 3})), MultiIndex((Index(30),), {Index(30): 3})), Product(IntValue(2, (), (), {}), IndexSum(Indexed(ComponentTensor(Division(Indexed(ComponentTensor(IndexSum(Sum(Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(24),), {Index(24): 3})), MultiIndex((Index(25),), {Index(25): 3})), MultiIndex((Index(25), Index(24)), {Index(24): 3, Index(25): 3})), MultiIndex((Index(26), Index(27)), {Index(26): 3, Index(27): 3})), MultiIndex((Index(27), Index(26)), {Index(26): 3, Index(27): 3})), MultiIndex((Index(5), Index(6)), {Index(5): 3, Index(6): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(28),), {Index(28): 3})), MultiIndex((Index(29),), {Index(29): 3})), MultiIndex((Index(29), Index(28)), {Index(29): 3, Index(28): 3})), Identity(3)), MultiIndex((Index(6), Index(9)), {Index(9): 3, Index(6): 3}))), Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(28),), {Index(28): 3})), MultiIndex((Index(29),), {Index(29): 3})), MultiIndex((Index(29), Index(28)), {Index(29): 3, Index(28): 3})), MultiIndex((Index(6), Index(9)), {Index(9): 3, Index(6): 3})), Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(24),), {Index(24): 3})), MultiIndex((Index(25),), {Index(25): 3})), MultiIndex((Index(25), Index(24)), {Index(24): 3, Index(25): 3})), Identity(3)), MultiIndex((Index(26), Index(27)), {Index(26): 3, Index(27): 3})), MultiIndex((Index(27), Index(26)), {Index(26): 3, Index(27): 3})), MultiIndex((Index(5), Index(6)), {Index(5): 3, Index(6): 3})))), MultiIndex((Index(6),), {Index(6): 3})), MultiIndex((Index(5), Index(9)), {Index(5): 3, Index(9): 3})), MultiIndex((Index(10), Index(11)), {Index(11): 3, Index(10): 3})), IntValue(2, (), (), {})), MultiIndex((Index(10), Index(11)), {Index(11): 3, Index(10): 3})), MultiIndex((Index(30), Index(30)), {Index(30): 3})), MultiIndex((Index(30),), {Index(30): 3}))))))), Measure('cell', 0, None)), Integral(Product(IntValue(-1, (), (), {}), IndexSum(Product(Indexed(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(31),), {Index(31): 3})), Indexed(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 2), MultiIndex((Index(31),), {Index(31): 3}))), MultiIndex((Index(31),), {Index(31): 3}))), Measure('exterior_facet', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 5;
  }

  /// Return the number of cell integrals
  virtual unsigned int num_cell_integrals() const
  {
    return 1;
  }

  /// Return the number of exterior facet integrals
  virtual unsigned int num_exterior_facet_integrals() const
  {
    return 1;
  }

  /// Return the number of interior facet integrals
  virtual unsigned int num_interior_facet_integrals() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 3:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 4:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    case 5:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dof map for argument function i
  virtual ufc::dof_map* create_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dof_map_2();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dof_map_2();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dof_map_2();
        break;
      }
    case 3:
      {
        return new hyperelasticity_dof_map_2();
        break;
      }
    case 4:
      {
        return new hyperelasticity_dof_map_0();
        break;
      }
    case 5:
      {
        return new hyperelasticity_dof_map_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_cell_integral_1_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_exterior_facet_integral_1_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>

namespace HyperElasticity
{

class CoefficientSpace_B: public dolfin::FunctionSpace
{
public:

  CoefficientSpace_B(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_B(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_B(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace_B(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace_B()
  {
  }

};

class CoefficientSpace_T: public dolfin::FunctionSpace
{
public:

  CoefficientSpace_T(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_T(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_T(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace_T(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace_T()
  {
  }

};

class CoefficientSpace_lmbda: public dolfin::FunctionSpace
{
public:

  CoefficientSpace_lmbda(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_lmbda(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_lmbda(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace_lmbda(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace_lmbda()
  {
  }

};

class CoefficientSpace_mu: public dolfin::FunctionSpace
{
public:

  CoefficientSpace_mu(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_mu(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_0()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_mu(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace_mu(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_0()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace_mu()
  {
  }

};

class CoefficientSpace_u: public dolfin::FunctionSpace
{
public:

  CoefficientSpace_u(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_u(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), mesh)))
  {
    // Do nothing
  }

  CoefficientSpace_u(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), *mesh)))
  {
      // Do nothing
  }

  CoefficientSpace_u(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), *mesh)))
  {
      // Do nothing
  }

  ~CoefficientSpace_u()
  {
  }

};

class Form_0_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_0()
  {
  }

};

class Form_0_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_1()
  {
  }

};

typedef CoefficientSpace_u Form_0_FunctionSpace_2;

typedef CoefficientSpace_mu Form_0_FunctionSpace_3;

typedef CoefficientSpace_lmbda Form_0_FunctionSpace_4;

class Form_0: public dolfin::Form
{
public:

  // Constructor
  Form_0(const dolfin::FunctionSpace& V0, const dolfin::FunctionSpace& V1):
    dolfin::Form(2, 3), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = boost::shared_ptr<const ufc::form>(new hyperelasticity_form_0());
  }

  // Constructor
  Form_0(const dolfin::FunctionSpace& V0, const dolfin::FunctionSpace& V1, const dolfin::GenericFunction& u, const dolfin::GenericFunction& mu, const dolfin::GenericFunction& lmbda):
    dolfin::Form(2, 3), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    this->u = u;
    this->mu = mu;
    this->lmbda = lmbda;

    _ufc_form = boost::shared_ptr<const ufc::form>(new hyperelasticity_form_0());
  }

  // Constructor
  Form_0(const dolfin::FunctionSpace& V0, const dolfin::FunctionSpace& V1, boost::shared_ptr<const dolfin::GenericFunction> u, boost::shared_ptr<const dolfin::GenericFunction> mu, boost::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::Form(2, 3), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    this->u = *u;
    this->mu = *mu;
    this->lmbda = *lmbda;

    _ufc_form = boost::shared_ptr<const ufc::form>(new hyperelasticity_form_0());
  }

  // Constructor
  Form_0(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::FunctionSpace> V1):
    dolfin::Form(2, 3), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = boost::shared_ptr<const ufc::form>(new hyperelasticity_form_0());
  }

  // Constructor
  Form_0(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::FunctionSpace> V1, const dolfin::GenericFunction& u, const dolfin::GenericFunction& mu, const dolfin::GenericFunction& lmbda):
    dolfin::Form(2, 3), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    this->u = u;
    this->mu = mu;
    this->lmbda = lmbda;

    _ufc_form = boost::shared_ptr<const ufc::form>(new hyperelasticity_form_0());
  }

  // Constructor
  Form_0(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::GenericFunction> u, boost::shared_ptr<const dolfin::GenericFunction> mu, boost::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::Form(2, 3), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    this->u = *u;
    this->mu = *mu;
    this->lmbda = *lmbda;

    _ufc_form = boost::shared_ptr<const ufc::form>(new hyperelasticity_form_0());
  }

  // Destructor
  ~Form_0()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "mu")
      return 1;
    else if (name == "lmbda")
      return 2;

    dolfin::error("Invalid coefficient.");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "mu";
    case 2:
      return "lmbda";
    }

    dolfin::error("Invalid coefficient.");
    return "unnamed";
  }

  // Typedefs
  typedef Form_0_FunctionSpace_0 TestSpace;
  typedef Form_0_FunctionSpace_1 TrialSpace;
  typedef Form_0_FunctionSpace_2 CoefficientSpace_u;
  typedef Form_0_FunctionSpace_3 CoefficientSpace_mu;
  typedef Form_0_FunctionSpace_4 CoefficientSpace_lmbda;

  // Coefficients
  dolfin::CoefficientAssigner u;
  dolfin::CoefficientAssigner mu;
  dolfin::CoefficientAssigner lmbda;
};

class Form_1_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_1_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), *mesh)))
  {
      // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dof_map>(new hyperelasticity_dof_map_2()), *mesh)))
  {
      // Do nothing
  }

  ~Form_1_FunctionSpace_0()
  {
  }

};

typedef CoefficientSpace_u Form_1_FunctionSpace_1;

typedef CoefficientSpace_B Form_1_FunctionSpace_2;

typedef CoefficientSpace_T Form_1_FunctionSpace_3;

typedef CoefficientSpace_mu Form_1_FunctionSpace_4;

typedef CoefficientSpace_lmbda Form_1_FunctionSpace_5;

class Form_1: public dolfin::Form
{
public:

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0):
    dolfin::Form(1, 5), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    _ufc_form = boost::shared_ptr<const ufc::form>(new hyperelasticity_form_1());
  }

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0, const dolfin::GenericFunction& u, const dolfin::GenericFunction& B, const dolfin::GenericFunction& T, const dolfin::GenericFunction& mu, const dolfin::GenericFunction& lmbda):
    dolfin::Form(1, 5), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->u = u;
    this->B = B;
    this->T = T;
    this->mu = mu;
    this->lmbda = lmbda;

    _ufc_form = boost::shared_ptr<const ufc::form>(new hyperelasticity_form_1());
  }

  // Constructor
  Form_1(const dolfin::FunctionSpace& V0, boost::shared_ptr<const dolfin::GenericFunction> u, boost::shared_ptr<const dolfin::GenericFunction> B, boost::shared_ptr<const dolfin::GenericFunction> T, boost::shared_ptr<const dolfin::GenericFunction> mu, boost::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::Form(1, 5), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->u = *u;
    this->B = *B;
    this->T = *T;
    this->mu = *mu;
    this->lmbda = *lmbda;

    _ufc_form = boost::shared_ptr<const ufc::form>(new hyperelasticity_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 5), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    _function_spaces[0] = V0;

    _ufc_form = boost::shared_ptr<const ufc::form>(new hyperelasticity_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0, const dolfin::GenericFunction& u, const dolfin::GenericFunction& B, const dolfin::GenericFunction& T, const dolfin::GenericFunction& mu, const dolfin::GenericFunction& lmbda):
    dolfin::Form(1, 5), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    _function_spaces[0] = V0;

    this->u = u;
    this->B = B;
    this->T = T;
    this->mu = mu;
    this->lmbda = lmbda;

    _ufc_form = boost::shared_ptr<const ufc::form>(new hyperelasticity_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::GenericFunction> u, boost::shared_ptr<const dolfin::GenericFunction> B, boost::shared_ptr<const dolfin::GenericFunction> T, boost::shared_ptr<const dolfin::GenericFunction> mu, boost::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::Form(1, 5), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    _function_spaces[0] = V0;

    this->u = *u;
    this->B = *B;
    this->T = *T;
    this->mu = *mu;
    this->lmbda = *lmbda;

    _ufc_form = boost::shared_ptr<const ufc::form>(new hyperelasticity_form_1());
  }

  // Destructor
  ~Form_1()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "B")
      return 1;
    else if (name == "T")
      return 2;
    else if (name == "mu")
      return 3;
    else if (name == "lmbda")
      return 4;

    dolfin::error("Invalid coefficient.");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "B";
    case 2:
      return "T";
    case 3:
      return "mu";
    case 4:
      return "lmbda";
    }

    dolfin::error("Invalid coefficient.");
    return "unnamed";
  }

  // Typedefs
  typedef Form_1_FunctionSpace_0 TestSpace;
  typedef Form_1_FunctionSpace_1 CoefficientSpace_u;
  typedef Form_1_FunctionSpace_2 CoefficientSpace_B;
  typedef Form_1_FunctionSpace_3 CoefficientSpace_T;
  typedef Form_1_FunctionSpace_4 CoefficientSpace_mu;
  typedef Form_1_FunctionSpace_5 CoefficientSpace_lmbda;

  // Coefficients
  dolfin::CoefficientAssigner u;
  dolfin::CoefficientAssigner B;
  dolfin::CoefficientAssigner T;
  dolfin::CoefficientAssigner mu;
  dolfin::CoefficientAssigner lmbda;
};

// Class typedefs
typedef Form_0 BilinearForm;
typedef Form_1 LinearForm;
typedef Form_0::TestSpace FunctionSpace;

}

#endif
