# -*- Perl -*-
#
# transclude.pl -- Transclude XLinks in HTML documents
#
# $Id: transclude.pl,v 1.2 2000/11/03 13:22:31 ndw Exp $
#
# Copyright (C) 2000 Norman Walsh
#
# This script searches for XLinks:
#
#  <a xml:link="simple" show="embed" actuate="auto" href="..."/>
#
# and replaces them with the content of the file pointed to by href.
#
# These occur if you want to use the following technique to
# incorporate external text files into your slides:
#
# <inlinegraphic format="linespecific" fileref="..."/>
#
# This script destructively modifies all files that have
# extensions of .htm, .html, or .fo in the current directory or
# the directory passed as a command-line argument.
#

my $verbose = 0;

my $file = shift @ARGV || ".";

if (-d $file) {
    my $dir = $file;
    opendir (DIR, $dir);
    while ($name = readdir(DIR)) {
	$file = "$dir/$name";
	next if ! -f $file;
	next if $file !~ /\.html?$/ && $file !~ /\.fo$/;

	&process_file($file);
    }
} else {
    &process_file($file);
}

sub process_file {
    my $file = shift;

    print "Performing transclusions in $file.\n" if $verbose;

    open (F, $file);
    binmode F;
    read (F, $_, -s $file);
    close (F);

    # match either <a ... /> or <a ... ></a>
    $match = "<a\\s.*?(\\/>\|><\\/a>)";

    my $content = "";
    while (/$match/) {
	$content .= $`;
	$tag = $&;
	$_ = $';

	if ($tag =~ /xlink:type=[\'\"]simple[\'\"]/
	    && $tag =~ /xlink:show=[\'\"]embed[\'\"]/
	    && $tag =~ /xlink:actuate=[\'\"]onLoad[\'\"]/
	    && $tag =~ /href=[\'\"](.*?)[\'\"]/) {
	    my $href = $1;
	    if (open (F, $href)) {
		local $_;
		read (F, $_, -s $href);
		close (F);

		s/&/&amp;/sg;
		s/</&lt;/sg;
		$content .= $_;
		print "\t$href\n" if $verbose;
	    } else {
		warn "Performing transclusions in $file:\n" if !$verbose;
		warn "\tFailed: $href\n";
	    }
	} else {
	    $content .= $tag;
	}
    }
    $_ = $content . $_;

    open (F, ">$file");
    binmode F;
    print F $_;
    close (F);
}
