#!/usr/bin/perl -- # -*- Perl -*-
#
# makeslides.pl -- Run XT and transclude automatically on a slides
#
# $Id: makeslides.pl,v 1.2 2000/11/03 13:22:31 ndw Exp $
#
# Copyright (C) 2000 Norman Walsh
#
# This should be tweaked by a Makefile, but it isn't. You have to hack it.
# Change $PROCESSOR appropriate for your local system.

use strict;
use Getopt::Std;
use vars qw($opt_s $opt_i $opt_p $opt_m $opt_n);

my $thisfile = $0;
my $thisdir = $thisfile;

$thisdir = $1 if ($thisdir =~ /^(.*)[\\\/][^\\\/]+$/);

my $usage = "Usage: $0 [-s stylesheet] [-m media] [-n] [-i] [-p xslt-processor ] slides.xml\n";

die $usage if ! getopts('s:ip:m:n');

my $STYLESHEET = $opt_s;
my $PROCESSOR  = $opt_p || "xt";
my $IE5        = $opt_i;
my $NOCHUNK    = $opt_n;
my $OUTFILE    = "";
my $OPTIONS    = "";

$OPTIONS .= "ie5=1 " if $IE5;
$OPTIONS .= "chunk=0 " if $NOCHUNK;

my $file = shift @ARGV || "slides.xml";

die $usage if ! -f $file;

if ($NOCHUNK) {
    $OUTFILE = $file;
    $OUTFILE =~ s/\.xml$//;
    $OUTFILE .= ".html";
}

if ($opt_m eq 'print' || $opt_m eq 'fo') {
    $OUTFILE = $file;
    $OUTFILE =~ s/\.xml$//;
    $OUTFILE .= ".fo";
}

if (!$STYLESHEET) {
    open (F, $file);
    binmode F;
    read (F, $_, 4096);
    close (F);
    my @pis = m/<\?xml-stylesheet.*?\?>/g;
    foreach my $pi (@pis) {
	my $href = $1 if $pi =~ /href=[\'\"](.*?)[\'\"]/s;
	my $media = $1 if $pi =~ /media=[\'\"](.*?)[\'\"]/s;
	if ($href && ($media eq $opt_m || !$opt_m)) {
	    $STYLESHEET = $href;
	    last;
	}
    }
}

die "$usage\nNo stylesheet\n" if !$STYLESHEET;

$STYLESHEET =~ s/\\/\//sg;
if ($STYLESHEET =~ /^[a-z]:/i) {
    $STYLESHEET = $';
}

my $COMSPEC = "";

if ($ENV{'COMSPEC'}) {
    $COMSPEC = $ENV{'COMSPEC'} . " /c";
} else {
    $COMSPEC = "";
}

#print("$COMSPEC$PROCESSOR $file $STYLESHEET $OPTIONS $OUTFILE\n");
system("$PROCESSOR $file $STYLESHEET $OUTFILE $OPTIONS");

#print("$COMSPEC$^X $thisdir/transclude.pl $OUTFILE\n");
system("$^X $thisdir/transclude.pl $OUTFILE");

__END__
:endofperl


