/* ****************************************************************************
 *
 * Copyright (c) Microsoft Corporation. 
 *
 * This source code is subject to terms and conditions of the Microsoft Public License. A 
 * copy of the license can be found in the License.html file at the root of this distribution. If 
 * you cannot locate the  Microsoft Public License, please send an email to 
 * dlr@microsoft.com. By using this source code in any fashion, you are agreeing to be bound 
 * by the terms of the Microsoft Public License.
 *
 * You must not remove this notice, or any other, from this software.
 *
 *
 * ***************************************************************************/

using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq.Expressions;
using System.Reflection;
using System.Runtime.CompilerServices;
using System.Dynamic;
using System.Text;
using System.Threading;

using Microsoft.Scripting;
using Microsoft.Scripting.Actions;
using Microsoft.Scripting.Actions.Calls;
using Microsoft.Scripting.Generation;
using Microsoft.Scripting.Runtime;
using Microsoft.Scripting.Utils;

using IronPython.Runtime.Binding;
using IronPython.Runtime.Operations;

using Ast = System.Linq.Expressions.Expression;
using AstUtils = Microsoft.Scripting.Ast.Utils;

namespace IronPython.Runtime.Types {

    public partial class BuiltinFunction : PythonTypeSlot {
        private Type GetCallerType(int argCount) {
            switch (argCount) {
                
                #region Generated Python Builtin Function Optimizable Switch

                // *** BEGIN GENERATED CODE ***
                // generated by function: builtin_function_callers_switch from: generate_calls.py

                case 0:
                    if (IsUnbound) {
                        return typeof(BuiltinFunctionCaller<>);
                    }
                    return typeof(BuiltinMethodCaller<>);
                case 1:
                    if (IsUnbound) {
                        return typeof(BuiltinFunctionCaller<,>);
                    }
                    return typeof(BuiltinMethodCaller<,>);
                case 2:
                    if (IsUnbound) {
                        return typeof(BuiltinFunctionCaller<,,>);
                    }
                    return typeof(BuiltinMethodCaller<,,>);
                case 3:
                    if (IsUnbound) {
                        return typeof(BuiltinFunctionCaller<,,,>);
                    }
                    return typeof(BuiltinMethodCaller<,,,>);
                case 4:
                    if (IsUnbound) {
                        return typeof(BuiltinFunctionCaller<,,,,>);
                    }
                    return typeof(BuiltinMethodCaller<,,,,>);
                case 5:
                    if (IsUnbound) {
                        return typeof(BuiltinFunctionCaller<,,,,,>);
                    }
                    return typeof(BuiltinMethodCaller<,,,,,>);
                case 6:
                    if (IsUnbound) {
                        return typeof(BuiltinFunctionCaller<,,,,,,>);
                    }
                    return typeof(BuiltinMethodCaller<,,,,,,>);
                case 7:
                    if (IsUnbound) {
                        return typeof(BuiltinFunctionCaller<,,,,,,,>);
                    }
                    return typeof(BuiltinMethodCaller<,,,,,,,>);
                case 8:
                    if (IsUnbound) {
                        return typeof(BuiltinFunctionCaller<,,,,,,,,>);
                    }
                    return typeof(BuiltinMethodCaller<,,,,,,,,>);
                case 9:
                    if (IsUnbound) {
                        return typeof(BuiltinFunctionCaller<,,,,,,,,,>);
                    }
                    return typeof(BuiltinMethodCaller<,,,,,,,,,>);
                case 10:
                    if (IsUnbound) {
                        return typeof(BuiltinFunctionCaller<,,,,,,,,,,>);
                    }
                    return typeof(BuiltinMethodCaller<,,,,,,,,,,>);
                case 11:
                    if (IsUnbound) {
                        return typeof(BuiltinFunctionCaller<,,,,,,,,,,,>);
                    }
                    return typeof(BuiltinMethodCaller<,,,,,,,,,,,>);
                case 12:
                    if (IsUnbound) {
                        return typeof(BuiltinFunctionCaller<,,,,,,,,,,,,>);
                    }
                    return typeof(BuiltinMethodCaller<,,,,,,,,,,,,>);
                case 13:
                    if (IsUnbound) {
                        return typeof(BuiltinFunctionCaller<,,,,,,,,,,,,,>);
                    }
                    return typeof(BuiltinMethodCaller<,,,,,,,,,,,,,>);

                // *** END GENERATED CODE ***

                #endregion
            }

            return null;
        }
        
        internal class OptimizingInfo {
            public readonly OptimizingCallDelegate Caller;
            public readonly Type[] TypeTest;
            public readonly CallSignature Signature;
            public bool ShouldOptimize;

            public OptimizingInfo(OptimizingCallDelegate caller, Type[] types, CallSignature signature) {
                Caller = caller;
                Signature = signature;
                TypeTest = types;
            }
        }

        class BuiltinFunctionCaller<TFuncType> where TFuncType : class {
            protected readonly BuiltinFunction _func;
            protected readonly OptimizingInfo _info;
            protected readonly CallSite<Func<CallSite, CodeContext, TFuncType, object>> _site;
            public readonly Func<CallSite, CodeContext, TFuncType, object> MyDelegate;

            public BuiltinFunctionCaller(CallSite<Func<CallSite, CodeContext, TFuncType, object>> site, OptimizingInfo info, BuiltinFunction func) {
                _func = func;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, object>(Call0);
            }

            public object Call0(CallSite site, CodeContext context, TFuncType func) {
                if (((BuiltinFunction)(object)func) == _func && !_info.ShouldOptimize) {
                    return _info.Caller.Invoke(new object[] { context }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, object>>)site).Update(site, context, func);
            }
        }

        class BuiltinMethodCaller<TFuncType> where TFuncType : class {
            protected readonly BuiltinFunctionData _data;
            protected readonly Type _selfType;

            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, object> MyDelegate;

            public BuiltinMethodCaller(CallSite<Func<CallSite, CodeContext, TFuncType, object>> site, OptimizingInfo info, BuiltinFunction func, Type selfType) {
                _data = func._data;
                _site = site;
                _info = info;
                _selfType = selfType;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, object>(Call0);
            }

            public object Call0(CallSite site, CodeContext context, TFuncType func) {
                BuiltinFunction bf = func as BuiltinFunction;
                if (bf != null && !bf.IsUnbound && bf._data == _data &&
                    !_info.ShouldOptimize &&
                    (_selfType == null || CompilerHelpers.GetType(bf.__self__) == _selfType)) {
                    return _info.Caller(new object[] { context, bf.__self__ }, out _info.ShouldOptimize);
                }
                
                return ((CallSite<Func<CallSite, CodeContext, TFuncType, object>>)site).Update(site, context, func);
            }
        }

        #region Generated Python Builtin Function Optimizable Callers

        // *** BEGIN GENERATED CODE ***
        // generated by function: builtin_function_callers from: generate_calls.py

        class BuiltinFunctionCaller<TFuncType, T0> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, object> MyDelegate;
            private readonly BuiltinFunction _func;
            private readonly Type _type0;

            public BuiltinFunctionCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, object>> site, OptimizingInfo info, BuiltinFunction func, Type type0) {
                _func = func;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, object>(Call1);
                _type0 = type0;
            }

            public object Call1(CallSite site, CodeContext context, TFuncType func, T0 arg0) {
                if (((BuiltinFunction)(object)func) == _func &&
                    !_info.ShouldOptimize && 
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0)
                   ) {
                    return _info.Caller(new object[] { context, arg0 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, object>>)site).Update(site, context, func, arg0);
            }
        }

        class BuiltinMethodCaller<TFuncType, T0> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, object> MyDelegate;
            private readonly Type _selfType;
            private readonly BuiltinFunctionData _data;
            private readonly Type _type0;

            public BuiltinMethodCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, object>> site, OptimizingInfo info, BuiltinFunction func, Type selfType, Type type0) {
                _selfType = selfType;
                _data = func._data;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, object>(Call1);
                _type0 = type0;
            }

            public object Call1(CallSite site, CodeContext context, TFuncType func, T0 arg0) {
                BuiltinFunction bf = func as BuiltinFunction;
                if (bf != null && !bf.IsUnbound && bf._data == _data &&
                    !_info.ShouldOptimize &&
                    (_selfType == null || CompilerHelpers.GetType(bf.__self__) == _selfType) &&
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0)
                    ) {
                    return _info.Caller(new object[] { context, bf.__self__, arg0 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, object>>)site).Update(site, context, func, arg0);
            }
        }

        class BuiltinFunctionCaller<TFuncType, T0, T1> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, object> MyDelegate;
            private readonly BuiltinFunction _func;
            private readonly Type _type0, _type1;

            public BuiltinFunctionCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, object>> site, OptimizingInfo info, BuiltinFunction func, Type type0, Type type1) {
                _func = func;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, object>(Call2);
                _type0 = type0;
                _type1 = type1;
            }

            public object Call2(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1) {
                if (((BuiltinFunction)(object)func) == _func &&
                    !_info.ShouldOptimize && 
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1)
                   ) {
                    return _info.Caller(new object[] { context, arg0, arg1 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, object>>)site).Update(site, context, func, arg0, arg1);
            }
        }

        class BuiltinMethodCaller<TFuncType, T0, T1> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, object> MyDelegate;
            private readonly Type _selfType;
            private readonly BuiltinFunctionData _data;
            private readonly Type _type0, _type1;

            public BuiltinMethodCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, object>> site, OptimizingInfo info, BuiltinFunction func, Type selfType, Type type0, Type type1) {
                _selfType = selfType;
                _data = func._data;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, object>(Call2);
                _type0 = type0;
                _type1 = type1;
            }

            public object Call2(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1) {
                BuiltinFunction bf = func as BuiltinFunction;
                if (bf != null && !bf.IsUnbound && bf._data == _data &&
                    !_info.ShouldOptimize &&
                    (_selfType == null || CompilerHelpers.GetType(bf.__self__) == _selfType) &&
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1)
                    ) {
                    return _info.Caller(new object[] { context, bf.__self__, arg0, arg1 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, object>>)site).Update(site, context, func, arg0, arg1);
            }
        }

        class BuiltinFunctionCaller<TFuncType, T0, T1, T2> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, object> MyDelegate;
            private readonly BuiltinFunction _func;
            private readonly Type _type0, _type1, _type2;

            public BuiltinFunctionCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, object>> site, OptimizingInfo info, BuiltinFunction func, Type type0, Type type1, Type type2) {
                _func = func;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, object>(Call3);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
            }

            public object Call3(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2) {
                if (((BuiltinFunction)(object)func) == _func &&
                    !_info.ShouldOptimize && 
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2)
                   ) {
                    return _info.Caller(new object[] { context, arg0, arg1, arg2 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, object>>)site).Update(site, context, func, arg0, arg1, arg2);
            }
        }

        class BuiltinMethodCaller<TFuncType, T0, T1, T2> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, object> MyDelegate;
            private readonly Type _selfType;
            private readonly BuiltinFunctionData _data;
            private readonly Type _type0, _type1, _type2;

            public BuiltinMethodCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, object>> site, OptimizingInfo info, BuiltinFunction func, Type selfType, Type type0, Type type1, Type type2) {
                _selfType = selfType;
                _data = func._data;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, object>(Call3);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
            }

            public object Call3(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2) {
                BuiltinFunction bf = func as BuiltinFunction;
                if (bf != null && !bf.IsUnbound && bf._data == _data &&
                    !_info.ShouldOptimize &&
                    (_selfType == null || CompilerHelpers.GetType(bf.__self__) == _selfType) &&
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2)
                    ) {
                    return _info.Caller(new object[] { context, bf.__self__, arg0, arg1, arg2 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, object>>)site).Update(site, context, func, arg0, arg1, arg2);
            }
        }

        class BuiltinFunctionCaller<TFuncType, T0, T1, T2, T3> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, object> MyDelegate;
            private readonly BuiltinFunction _func;
            private readonly Type _type0, _type1, _type2, _type3;

            public BuiltinFunctionCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, object>> site, OptimizingInfo info, BuiltinFunction func, Type type0, Type type1, Type type2, Type type3) {
                _func = func;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, object>(Call4);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
            }

            public object Call4(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3) {
                if (((BuiltinFunction)(object)func) == _func &&
                    !_info.ShouldOptimize && 
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3)
                   ) {
                    return _info.Caller(new object[] { context, arg0, arg1, arg2, arg3 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3);
            }
        }

        class BuiltinMethodCaller<TFuncType, T0, T1, T2, T3> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, object> MyDelegate;
            private readonly Type _selfType;
            private readonly BuiltinFunctionData _data;
            private readonly Type _type0, _type1, _type2, _type3;

            public BuiltinMethodCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, object>> site, OptimizingInfo info, BuiltinFunction func, Type selfType, Type type0, Type type1, Type type2, Type type3) {
                _selfType = selfType;
                _data = func._data;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, object>(Call4);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
            }

            public object Call4(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3) {
                BuiltinFunction bf = func as BuiltinFunction;
                if (bf != null && !bf.IsUnbound && bf._data == _data &&
                    !_info.ShouldOptimize &&
                    (_selfType == null || CompilerHelpers.GetType(bf.__self__) == _selfType) &&
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3)
                    ) {
                    return _info.Caller(new object[] { context, bf.__self__, arg0, arg1, arg2, arg3 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3);
            }
        }

        class BuiltinFunctionCaller<TFuncType, T0, T1, T2, T3, T4> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, object> MyDelegate;
            private readonly BuiltinFunction _func;
            private readonly Type _type0, _type1, _type2, _type3, _type4;

            public BuiltinFunctionCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, object>> site, OptimizingInfo info, BuiltinFunction func, Type type0, Type type1, Type type2, Type type3, Type type4) {
                _func = func;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, object>(Call5);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
                _type4 = type4;
            }

            public object Call5(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
                if (((BuiltinFunction)(object)func) == _func &&
                    !_info.ShouldOptimize && 
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3) &&
                    (_type4 == null || CompilerHelpers.GetType(arg4) == _type4)
                   ) {
                    return _info.Caller(new object[] { context, arg0, arg1, arg2, arg3, arg4 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3, arg4);
            }
        }

        class BuiltinMethodCaller<TFuncType, T0, T1, T2, T3, T4> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, object> MyDelegate;
            private readonly Type _selfType;
            private readonly BuiltinFunctionData _data;
            private readonly Type _type0, _type1, _type2, _type3, _type4;

            public BuiltinMethodCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, object>> site, OptimizingInfo info, BuiltinFunction func, Type selfType, Type type0, Type type1, Type type2, Type type3, Type type4) {
                _selfType = selfType;
                _data = func._data;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, object>(Call5);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
                _type4 = type4;
            }

            public object Call5(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
                BuiltinFunction bf = func as BuiltinFunction;
                if (bf != null && !bf.IsUnbound && bf._data == _data &&
                    !_info.ShouldOptimize &&
                    (_selfType == null || CompilerHelpers.GetType(bf.__self__) == _selfType) &&
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3) &&
                    (_type4 == null || CompilerHelpers.GetType(arg4) == _type4)
                    ) {
                    return _info.Caller(new object[] { context, bf.__self__, arg0, arg1, arg2, arg3, arg4 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3, arg4);
            }
        }

        class BuiltinFunctionCaller<TFuncType, T0, T1, T2, T3, T4, T5> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, object> MyDelegate;
            private readonly BuiltinFunction _func;
            private readonly Type _type0, _type1, _type2, _type3, _type4, _type5;

            public BuiltinFunctionCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, object>> site, OptimizingInfo info, BuiltinFunction func, Type type0, Type type1, Type type2, Type type3, Type type4, Type type5) {
                _func = func;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, object>(Call6);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
                _type4 = type4;
                _type5 = type5;
            }

            public object Call6(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5) {
                if (((BuiltinFunction)(object)func) == _func &&
                    !_info.ShouldOptimize && 
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3) &&
                    (_type4 == null || CompilerHelpers.GetType(arg4) == _type4) &&
                    (_type5 == null || CompilerHelpers.GetType(arg5) == _type5)
                   ) {
                    return _info.Caller(new object[] { context, arg0, arg1, arg2, arg3, arg4, arg5 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3, arg4, arg5);
            }
        }

        class BuiltinMethodCaller<TFuncType, T0, T1, T2, T3, T4, T5> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, object> MyDelegate;
            private readonly Type _selfType;
            private readonly BuiltinFunctionData _data;
            private readonly Type _type0, _type1, _type2, _type3, _type4, _type5;

            public BuiltinMethodCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, object>> site, OptimizingInfo info, BuiltinFunction func, Type selfType, Type type0, Type type1, Type type2, Type type3, Type type4, Type type5) {
                _selfType = selfType;
                _data = func._data;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, object>(Call6);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
                _type4 = type4;
                _type5 = type5;
            }

            public object Call6(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5) {
                BuiltinFunction bf = func as BuiltinFunction;
                if (bf != null && !bf.IsUnbound && bf._data == _data &&
                    !_info.ShouldOptimize &&
                    (_selfType == null || CompilerHelpers.GetType(bf.__self__) == _selfType) &&
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3) &&
                    (_type4 == null || CompilerHelpers.GetType(arg4) == _type4) &&
                    (_type5 == null || CompilerHelpers.GetType(arg5) == _type5)
                    ) {
                    return _info.Caller(new object[] { context, bf.__self__, arg0, arg1, arg2, arg3, arg4, arg5 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3, arg4, arg5);
            }
        }

        class BuiltinFunctionCaller<TFuncType, T0, T1, T2, T3, T4, T5, T6> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, object> MyDelegate;
            private readonly BuiltinFunction _func;
            private readonly Type _type0, _type1, _type2, _type3, _type4, _type5, _type6;

            public BuiltinFunctionCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, object>> site, OptimizingInfo info, BuiltinFunction func, Type type0, Type type1, Type type2, Type type3, Type type4, Type type5, Type type6) {
                _func = func;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, object>(Call7);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
                _type4 = type4;
                _type5 = type5;
                _type6 = type6;
            }

            public object Call7(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6) {
                if (((BuiltinFunction)(object)func) == _func &&
                    !_info.ShouldOptimize && 
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3) &&
                    (_type4 == null || CompilerHelpers.GetType(arg4) == _type4) &&
                    (_type5 == null || CompilerHelpers.GetType(arg5) == _type5) &&
                    (_type6 == null || CompilerHelpers.GetType(arg6) == _type6)
                   ) {
                    return _info.Caller(new object[] { context, arg0, arg1, arg2, arg3, arg4, arg5, arg6 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
            }
        }

        class BuiltinMethodCaller<TFuncType, T0, T1, T2, T3, T4, T5, T6> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, object> MyDelegate;
            private readonly Type _selfType;
            private readonly BuiltinFunctionData _data;
            private readonly Type _type0, _type1, _type2, _type3, _type4, _type5, _type6;

            public BuiltinMethodCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, object>> site, OptimizingInfo info, BuiltinFunction func, Type selfType, Type type0, Type type1, Type type2, Type type3, Type type4, Type type5, Type type6) {
                _selfType = selfType;
                _data = func._data;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, object>(Call7);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
                _type4 = type4;
                _type5 = type5;
                _type6 = type6;
            }

            public object Call7(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6) {
                BuiltinFunction bf = func as BuiltinFunction;
                if (bf != null && !bf.IsUnbound && bf._data == _data &&
                    !_info.ShouldOptimize &&
                    (_selfType == null || CompilerHelpers.GetType(bf.__self__) == _selfType) &&
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3) &&
                    (_type4 == null || CompilerHelpers.GetType(arg4) == _type4) &&
                    (_type5 == null || CompilerHelpers.GetType(arg5) == _type5) &&
                    (_type6 == null || CompilerHelpers.GetType(arg6) == _type6)
                    ) {
                    return _info.Caller(new object[] { context, bf.__self__, arg0, arg1, arg2, arg3, arg4, arg5, arg6 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
            }
        }

        class BuiltinFunctionCaller<TFuncType, T0, T1, T2, T3, T4, T5, T6, T7> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, object> MyDelegate;
            private readonly BuiltinFunction _func;
            private readonly Type _type0, _type1, _type2, _type3, _type4, _type5, _type6, _type7;

            public BuiltinFunctionCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, object>> site, OptimizingInfo info, BuiltinFunction func, Type type0, Type type1, Type type2, Type type3, Type type4, Type type5, Type type6, Type type7) {
                _func = func;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, object>(Call8);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
                _type4 = type4;
                _type5 = type5;
                _type6 = type6;
                _type7 = type7;
            }

            public object Call8(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7) {
                if (((BuiltinFunction)(object)func) == _func &&
                    !_info.ShouldOptimize && 
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3) &&
                    (_type4 == null || CompilerHelpers.GetType(arg4) == _type4) &&
                    (_type5 == null || CompilerHelpers.GetType(arg5) == _type5) &&
                    (_type6 == null || CompilerHelpers.GetType(arg6) == _type6) &&
                    (_type7 == null || CompilerHelpers.GetType(arg7) == _type7)
                   ) {
                    return _info.Caller(new object[] { context, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
            }
        }

        class BuiltinMethodCaller<TFuncType, T0, T1, T2, T3, T4, T5, T6, T7> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, object> MyDelegate;
            private readonly Type _selfType;
            private readonly BuiltinFunctionData _data;
            private readonly Type _type0, _type1, _type2, _type3, _type4, _type5, _type6, _type7;

            public BuiltinMethodCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, object>> site, OptimizingInfo info, BuiltinFunction func, Type selfType, Type type0, Type type1, Type type2, Type type3, Type type4, Type type5, Type type6, Type type7) {
                _selfType = selfType;
                _data = func._data;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, object>(Call8);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
                _type4 = type4;
                _type5 = type5;
                _type6 = type6;
                _type7 = type7;
            }

            public object Call8(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7) {
                BuiltinFunction bf = func as BuiltinFunction;
                if (bf != null && !bf.IsUnbound && bf._data == _data &&
                    !_info.ShouldOptimize &&
                    (_selfType == null || CompilerHelpers.GetType(bf.__self__) == _selfType) &&
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3) &&
                    (_type4 == null || CompilerHelpers.GetType(arg4) == _type4) &&
                    (_type5 == null || CompilerHelpers.GetType(arg5) == _type5) &&
                    (_type6 == null || CompilerHelpers.GetType(arg6) == _type6) &&
                    (_type7 == null || CompilerHelpers.GetType(arg7) == _type7)
                    ) {
                    return _info.Caller(new object[] { context, bf.__self__, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
            }
        }

        class BuiltinFunctionCaller<TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, object> MyDelegate;
            private readonly BuiltinFunction _func;
            private readonly Type _type0, _type1, _type2, _type3, _type4, _type5, _type6, _type7, _type8;

            public BuiltinFunctionCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, object>> site, OptimizingInfo info, BuiltinFunction func, Type type0, Type type1, Type type2, Type type3, Type type4, Type type5, Type type6, Type type7, Type type8) {
                _func = func;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, object>(Call9);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
                _type4 = type4;
                _type5 = type5;
                _type6 = type6;
                _type7 = type7;
                _type8 = type8;
            }

            public object Call9(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8) {
                if (((BuiltinFunction)(object)func) == _func &&
                    !_info.ShouldOptimize && 
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3) &&
                    (_type4 == null || CompilerHelpers.GetType(arg4) == _type4) &&
                    (_type5 == null || CompilerHelpers.GetType(arg5) == _type5) &&
                    (_type6 == null || CompilerHelpers.GetType(arg6) == _type6) &&
                    (_type7 == null || CompilerHelpers.GetType(arg7) == _type7) &&
                    (_type8 == null || CompilerHelpers.GetType(arg8) == _type8)
                   ) {
                    return _info.Caller(new object[] { context, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
            }
        }

        class BuiltinMethodCaller<TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, object> MyDelegate;
            private readonly Type _selfType;
            private readonly BuiltinFunctionData _data;
            private readonly Type _type0, _type1, _type2, _type3, _type4, _type5, _type6, _type7, _type8;

            public BuiltinMethodCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, object>> site, OptimizingInfo info, BuiltinFunction func, Type selfType, Type type0, Type type1, Type type2, Type type3, Type type4, Type type5, Type type6, Type type7, Type type8) {
                _selfType = selfType;
                _data = func._data;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, object>(Call9);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
                _type4 = type4;
                _type5 = type5;
                _type6 = type6;
                _type7 = type7;
                _type8 = type8;
            }

            public object Call9(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8) {
                BuiltinFunction bf = func as BuiltinFunction;
                if (bf != null && !bf.IsUnbound && bf._data == _data &&
                    !_info.ShouldOptimize &&
                    (_selfType == null || CompilerHelpers.GetType(bf.__self__) == _selfType) &&
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3) &&
                    (_type4 == null || CompilerHelpers.GetType(arg4) == _type4) &&
                    (_type5 == null || CompilerHelpers.GetType(arg5) == _type5) &&
                    (_type6 == null || CompilerHelpers.GetType(arg6) == _type6) &&
                    (_type7 == null || CompilerHelpers.GetType(arg7) == _type7) &&
                    (_type8 == null || CompilerHelpers.GetType(arg8) == _type8)
                    ) {
                    return _info.Caller(new object[] { context, bf.__self__, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
            }
        }

        class BuiltinFunctionCaller<TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, object> MyDelegate;
            private readonly BuiltinFunction _func;
            private readonly Type _type0, _type1, _type2, _type3, _type4, _type5, _type6, _type7, _type8, _type9;

            public BuiltinFunctionCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, object>> site, OptimizingInfo info, BuiltinFunction func, Type type0, Type type1, Type type2, Type type3, Type type4, Type type5, Type type6, Type type7, Type type8, Type type9) {
                _func = func;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, object>(Call10);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
                _type4 = type4;
                _type5 = type5;
                _type6 = type6;
                _type7 = type7;
                _type8 = type8;
                _type9 = type9;
            }

            public object Call10(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9) {
                if (((BuiltinFunction)(object)func) == _func &&
                    !_info.ShouldOptimize && 
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3) &&
                    (_type4 == null || CompilerHelpers.GetType(arg4) == _type4) &&
                    (_type5 == null || CompilerHelpers.GetType(arg5) == _type5) &&
                    (_type6 == null || CompilerHelpers.GetType(arg6) == _type6) &&
                    (_type7 == null || CompilerHelpers.GetType(arg7) == _type7) &&
                    (_type8 == null || CompilerHelpers.GetType(arg8) == _type8) &&
                    (_type9 == null || CompilerHelpers.GetType(arg9) == _type9)
                   ) {
                    return _info.Caller(new object[] { context, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
            }
        }

        class BuiltinMethodCaller<TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, object> MyDelegate;
            private readonly Type _selfType;
            private readonly BuiltinFunctionData _data;
            private readonly Type _type0, _type1, _type2, _type3, _type4, _type5, _type6, _type7, _type8, _type9;

            public BuiltinMethodCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, object>> site, OptimizingInfo info, BuiltinFunction func, Type selfType, Type type0, Type type1, Type type2, Type type3, Type type4, Type type5, Type type6, Type type7, Type type8, Type type9) {
                _selfType = selfType;
                _data = func._data;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, object>(Call10);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
                _type4 = type4;
                _type5 = type5;
                _type6 = type6;
                _type7 = type7;
                _type8 = type8;
                _type9 = type9;
            }

            public object Call10(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9) {
                BuiltinFunction bf = func as BuiltinFunction;
                if (bf != null && !bf.IsUnbound && bf._data == _data &&
                    !_info.ShouldOptimize &&
                    (_selfType == null || CompilerHelpers.GetType(bf.__self__) == _selfType) &&
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3) &&
                    (_type4 == null || CompilerHelpers.GetType(arg4) == _type4) &&
                    (_type5 == null || CompilerHelpers.GetType(arg5) == _type5) &&
                    (_type6 == null || CompilerHelpers.GetType(arg6) == _type6) &&
                    (_type7 == null || CompilerHelpers.GetType(arg7) == _type7) &&
                    (_type8 == null || CompilerHelpers.GetType(arg8) == _type8) &&
                    (_type9 == null || CompilerHelpers.GetType(arg9) == _type9)
                    ) {
                    return _info.Caller(new object[] { context, bf.__self__, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
            }
        }

        class BuiltinFunctionCaller<TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, object> MyDelegate;
            private readonly BuiltinFunction _func;
            private readonly Type _type0, _type1, _type2, _type3, _type4, _type5, _type6, _type7, _type8, _type9, _type10;

            public BuiltinFunctionCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, object>> site, OptimizingInfo info, BuiltinFunction func, Type type0, Type type1, Type type2, Type type3, Type type4, Type type5, Type type6, Type type7, Type type8, Type type9, Type type10) {
                _func = func;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, object>(Call11);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
                _type4 = type4;
                _type5 = type5;
                _type6 = type6;
                _type7 = type7;
                _type8 = type8;
                _type9 = type9;
                _type10 = type10;
            }

            public object Call11(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10) {
                if (((BuiltinFunction)(object)func) == _func &&
                    !_info.ShouldOptimize && 
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3) &&
                    (_type4 == null || CompilerHelpers.GetType(arg4) == _type4) &&
                    (_type5 == null || CompilerHelpers.GetType(arg5) == _type5) &&
                    (_type6 == null || CompilerHelpers.GetType(arg6) == _type6) &&
                    (_type7 == null || CompilerHelpers.GetType(arg7) == _type7) &&
                    (_type8 == null || CompilerHelpers.GetType(arg8) == _type8) &&
                    (_type9 == null || CompilerHelpers.GetType(arg9) == _type9) &&
                    (_type10 == null || CompilerHelpers.GetType(arg10) == _type10)
                   ) {
                    return _info.Caller(new object[] { context, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
            }
        }

        class BuiltinMethodCaller<TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, object> MyDelegate;
            private readonly Type _selfType;
            private readonly BuiltinFunctionData _data;
            private readonly Type _type0, _type1, _type2, _type3, _type4, _type5, _type6, _type7, _type8, _type9, _type10;

            public BuiltinMethodCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, object>> site, OptimizingInfo info, BuiltinFunction func, Type selfType, Type type0, Type type1, Type type2, Type type3, Type type4, Type type5, Type type6, Type type7, Type type8, Type type9, Type type10) {
                _selfType = selfType;
                _data = func._data;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, object>(Call11);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
                _type4 = type4;
                _type5 = type5;
                _type6 = type6;
                _type7 = type7;
                _type8 = type8;
                _type9 = type9;
                _type10 = type10;
            }

            public object Call11(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10) {
                BuiltinFunction bf = func as BuiltinFunction;
                if (bf != null && !bf.IsUnbound && bf._data == _data &&
                    !_info.ShouldOptimize &&
                    (_selfType == null || CompilerHelpers.GetType(bf.__self__) == _selfType) &&
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3) &&
                    (_type4 == null || CompilerHelpers.GetType(arg4) == _type4) &&
                    (_type5 == null || CompilerHelpers.GetType(arg5) == _type5) &&
                    (_type6 == null || CompilerHelpers.GetType(arg6) == _type6) &&
                    (_type7 == null || CompilerHelpers.GetType(arg7) == _type7) &&
                    (_type8 == null || CompilerHelpers.GetType(arg8) == _type8) &&
                    (_type9 == null || CompilerHelpers.GetType(arg9) == _type9) &&
                    (_type10 == null || CompilerHelpers.GetType(arg10) == _type10)
                    ) {
                    return _info.Caller(new object[] { context, bf.__self__, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
            }
        }

        class BuiltinFunctionCaller<TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, object> MyDelegate;
            private readonly BuiltinFunction _func;
            private readonly Type _type0, _type1, _type2, _type3, _type4, _type5, _type6, _type7, _type8, _type9, _type10, _type11;

            public BuiltinFunctionCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, object>> site, OptimizingInfo info, BuiltinFunction func, Type type0, Type type1, Type type2, Type type3, Type type4, Type type5, Type type6, Type type7, Type type8, Type type9, Type type10, Type type11) {
                _func = func;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, object>(Call12);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
                _type4 = type4;
                _type5 = type5;
                _type6 = type6;
                _type7 = type7;
                _type8 = type8;
                _type9 = type9;
                _type10 = type10;
                _type11 = type11;
            }

            public object Call12(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11) {
                if (((BuiltinFunction)(object)func) == _func &&
                    !_info.ShouldOptimize && 
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3) &&
                    (_type4 == null || CompilerHelpers.GetType(arg4) == _type4) &&
                    (_type5 == null || CompilerHelpers.GetType(arg5) == _type5) &&
                    (_type6 == null || CompilerHelpers.GetType(arg6) == _type6) &&
                    (_type7 == null || CompilerHelpers.GetType(arg7) == _type7) &&
                    (_type8 == null || CompilerHelpers.GetType(arg8) == _type8) &&
                    (_type9 == null || CompilerHelpers.GetType(arg9) == _type9) &&
                    (_type10 == null || CompilerHelpers.GetType(arg10) == _type10) &&
                    (_type11 == null || CompilerHelpers.GetType(arg11) == _type11)
                   ) {
                    return _info.Caller(new object[] { context, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
            }
        }

        class BuiltinMethodCaller<TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, object> MyDelegate;
            private readonly Type _selfType;
            private readonly BuiltinFunctionData _data;
            private readonly Type _type0, _type1, _type2, _type3, _type4, _type5, _type6, _type7, _type8, _type9, _type10, _type11;

            public BuiltinMethodCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, object>> site, OptimizingInfo info, BuiltinFunction func, Type selfType, Type type0, Type type1, Type type2, Type type3, Type type4, Type type5, Type type6, Type type7, Type type8, Type type9, Type type10, Type type11) {
                _selfType = selfType;
                _data = func._data;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, object>(Call12);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
                _type4 = type4;
                _type5 = type5;
                _type6 = type6;
                _type7 = type7;
                _type8 = type8;
                _type9 = type9;
                _type10 = type10;
                _type11 = type11;
            }

            public object Call12(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11) {
                BuiltinFunction bf = func as BuiltinFunction;
                if (bf != null && !bf.IsUnbound && bf._data == _data &&
                    !_info.ShouldOptimize &&
                    (_selfType == null || CompilerHelpers.GetType(bf.__self__) == _selfType) &&
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3) &&
                    (_type4 == null || CompilerHelpers.GetType(arg4) == _type4) &&
                    (_type5 == null || CompilerHelpers.GetType(arg5) == _type5) &&
                    (_type6 == null || CompilerHelpers.GetType(arg6) == _type6) &&
                    (_type7 == null || CompilerHelpers.GetType(arg7) == _type7) &&
                    (_type8 == null || CompilerHelpers.GetType(arg8) == _type8) &&
                    (_type9 == null || CompilerHelpers.GetType(arg9) == _type9) &&
                    (_type10 == null || CompilerHelpers.GetType(arg10) == _type10) &&
                    (_type11 == null || CompilerHelpers.GetType(arg11) == _type11)
                    ) {
                    return _info.Caller(new object[] { context, bf.__self__, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
            }
        }

        class BuiltinFunctionCaller<TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, object> MyDelegate;
            private readonly BuiltinFunction _func;
            private readonly Type _type0, _type1, _type2, _type3, _type4, _type5, _type6, _type7, _type8, _type9, _type10, _type11, _type12;

            public BuiltinFunctionCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, object>> site, OptimizingInfo info, BuiltinFunction func, Type type0, Type type1, Type type2, Type type3, Type type4, Type type5, Type type6, Type type7, Type type8, Type type9, Type type10, Type type11, Type type12) {
                _func = func;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, object>(Call13);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
                _type4 = type4;
                _type5 = type5;
                _type6 = type6;
                _type7 = type7;
                _type8 = type8;
                _type9 = type9;
                _type10 = type10;
                _type11 = type11;
                _type12 = type12;
            }

            public object Call13(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12) {
                if (((BuiltinFunction)(object)func) == _func &&
                    !_info.ShouldOptimize && 
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3) &&
                    (_type4 == null || CompilerHelpers.GetType(arg4) == _type4) &&
                    (_type5 == null || CompilerHelpers.GetType(arg5) == _type5) &&
                    (_type6 == null || CompilerHelpers.GetType(arg6) == _type6) &&
                    (_type7 == null || CompilerHelpers.GetType(arg7) == _type7) &&
                    (_type8 == null || CompilerHelpers.GetType(arg8) == _type8) &&
                    (_type9 == null || CompilerHelpers.GetType(arg9) == _type9) &&
                    (_type10 == null || CompilerHelpers.GetType(arg10) == _type10) &&
                    (_type11 == null || CompilerHelpers.GetType(arg11) == _type11) &&
                    (_type12 == null || CompilerHelpers.GetType(arg12) == _type12)
                   ) {
                    return _info.Caller(new object[] { context, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
            }
        }

        class BuiltinMethodCaller<TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> where TFuncType : class {
            private readonly CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, object>> _site;
            private readonly OptimizingInfo _info;
            public readonly Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, object> MyDelegate;
            private readonly Type _selfType;
            private readonly BuiltinFunctionData _data;
            private readonly Type _type0, _type1, _type2, _type3, _type4, _type5, _type6, _type7, _type8, _type9, _type10, _type11, _type12;

            public BuiltinMethodCaller(CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, object>> site, OptimizingInfo info, BuiltinFunction func, Type selfType, Type type0, Type type1, Type type2, Type type3, Type type4, Type type5, Type type6, Type type7, Type type8, Type type9, Type type10, Type type11, Type type12) {
                _selfType = selfType;
                _data = func._data;
                _info = info;
                _site = site;
                MyDelegate = new Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, object>(Call13);
                _type0 = type0;
                _type1 = type1;
                _type2 = type2;
                _type3 = type3;
                _type4 = type4;
                _type5 = type5;
                _type6 = type6;
                _type7 = type7;
                _type8 = type8;
                _type9 = type9;
                _type10 = type10;
                _type11 = type11;
                _type12 = type12;
            }

            public object Call13(CallSite site, CodeContext context, TFuncType func, T0 arg0, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12) {
                BuiltinFunction bf = func as BuiltinFunction;
                if (bf != null && !bf.IsUnbound && bf._data == _data &&
                    !_info.ShouldOptimize &&
                    (_selfType == null || CompilerHelpers.GetType(bf.__self__) == _selfType) &&
                    (_type0 == null || CompilerHelpers.GetType(arg0) == _type0) &&
                    (_type1 == null || CompilerHelpers.GetType(arg1) == _type1) &&
                    (_type2 == null || CompilerHelpers.GetType(arg2) == _type2) &&
                    (_type3 == null || CompilerHelpers.GetType(arg3) == _type3) &&
                    (_type4 == null || CompilerHelpers.GetType(arg4) == _type4) &&
                    (_type5 == null || CompilerHelpers.GetType(arg5) == _type5) &&
                    (_type6 == null || CompilerHelpers.GetType(arg6) == _type6) &&
                    (_type7 == null || CompilerHelpers.GetType(arg7) == _type7) &&
                    (_type8 == null || CompilerHelpers.GetType(arg8) == _type8) &&
                    (_type9 == null || CompilerHelpers.GetType(arg9) == _type9) &&
                    (_type10 == null || CompilerHelpers.GetType(arg10) == _type10) &&
                    (_type11 == null || CompilerHelpers.GetType(arg11) == _type11) &&
                    (_type12 == null || CompilerHelpers.GetType(arg12) == _type12)
                    ) {
                    return _info.Caller(new object[] { context, bf.__self__, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12 }, out _info.ShouldOptimize);
                }

                return ((CallSite<Func<CallSite, CodeContext, TFuncType, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, object>>)site).Update(site, context, func, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
            }
        }


        // *** END GENERATED CODE ***

        #endregion

    }
}

