/* ****************************************************************************
 *
 * Copyright (c) Microsoft Corporation. 
 *
 * This source code is subject to terms and conditions of the Microsoft Public License. A 
 * copy of the license can be found in the License.html file at the root of this distribution. If 
 * you cannot locate the  Microsoft Public License, please send an email to 
 * dlr@microsoft.com. By using this source code in any fashion, you are agreeing to be bound 
 * by the terms of the Microsoft Public License.
 *
 * You must not remove this notice, or any other, from this software.
 *
 *
 * ***************************************************************************/

using System;
using System.Collections.Generic;
using System.Reflection.Emit;

#if !SILVERLIGHT
namespace IronPython.Modules {
    /// <summary>
    /// Provides support for interop with native code from Python code.
    /// </summary>
    public static partial class CTypes {
        /// <summary>
        /// Common functionality that all of the meta classes provide which is part of
        /// our implementation.  This is used to implement the serialization/deserialization
        /// of values into/out of memory, emit the marshalling logic for call stubs, and
        /// provide common information (size/alignment) for the types.
        /// </summary>
        internal interface INativeType {
            /// <summary>
            /// Gets the native size of the type
            /// </summary>
            int Size {
                get;
            }

            /// <summary>
            /// Gets the required alignment for the type
            /// </summary>
            int Alignment {
                get;
            }

            /// <summary>
            /// Deserialized the value of this type from the given address at the given
            /// offset.  Any new objects which are created will keep the provided 
            /// MemoryHolder alive.
            /// 
            /// raw determines if the cdata is returned or if the primitive value is
            /// returned.  This is only applicable for subtypes of simple cdata types.
            /// </summary>
            object GetValue(MemoryHolder/*!*/ owner, object readingFrom, int offset, bool raw);

            /// <summary>
            /// Serializes the provided value into the specified address at the given
            /// offset.
            /// </summary>
            object SetValue(MemoryHolder/*!*/ address, int offset, object value);

            /// <summary>
            /// Gets the .NET type which is used when calling or returning the value
            /// from native code.
            /// </summary>
            Type/*!*/ GetNativeType();

            /// <summary>
            /// Gets the .NET type which the native type is converted into when going to Python
            /// code.  This is usually int, BigInt, double, object, or a CData type.
            /// </summary>
            Type/*!*/ GetPythonType();

            /// <summary>
            /// Emits marshalling of an object from Python to native code.  This produces the
            /// native type from the Python type.
            /// </summary>
            MarshalCleanup EmitMarshalling(ILGenerator/*!*/ method, LocalOrArg/*!*/ argIndex, List<object>/*!*/ constantPool, int constantPoolArgument);

            /// <summary>
            /// Emits marshalling from native code to Python code This produces the python type 
            /// from the native type.  This is used for return values and parameters 
            /// to Python callable objects that are passed back out to native code.
            /// </summary>
            void EmitReverseMarshalling(ILGenerator/*!*/ method, LocalOrArg/*!*/ value, List<object>/*!*/ constantPool, int constantPoolArgument);
        }
    }
}
#endif