/* song.c --
 *
 * Copyright (c) 1998-2002  Mike Oliphant <oliphant@gtk.org>
 *
 *   http://www.nostatic.org/grip
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <mysql.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <glib.h>
#include <sys/stat.h>
#include "mp3db.h"
#include "idlist.h"
#include "dblist.h"
#include "fileutil.h"
#include "song.h"

/* Grab all of the songs in the database, and put them in a songlist */
void GetAllSongs(MYSQL *mysql,IDList *slist)
{
  GetListFromQuery(mysql,slist,"SELECT id FROM song",TRUE);
}

gboolean LookUpSong(MYSQL *mysql,int id,Song *song)
{
  MYSQL_RES *res=NULL;
  MYSQL_ROW row;
  char query[256];
  char *tok;

  g_snprintf(query,256,"SELECT filename,title,artistid,discid,genre,"
	     "track_num,start_frame,num_frames,play_time,bpm,num_plays,"
	     "last_play,year,gain_adjustment FROM song WHERE id=%d",id);

  if(mysql_query(mysql,query)||
     !(res = mysql_store_result(mysql))||
     !(row=mysql_fetch_row(res))) {
    printf("Query error\n");
    
    return FALSE;
  }

  song->id=id;
  DBString(song->filename,row[0],256);
  DBString(song->title,row[1],80);
  song->artistid=DBNum(row[2]);
  song->discid=DBNum(row[3]);
  DBString(song->genre,row[4],20);
  song->track_num=DBNum(row[5]);
  song->start_frame=DBNum(row[6]);
  song->num_frames=DBNum(row[7]);
  song->mins=song->secs=-1;
  if(row[8]) {
    tok=strtok(row[8],":");

    if(tok) {
      song->mins=atoi(tok);

      tok=strtok(NULL,"");
      
      if(tok) song->secs=atoi(tok);
    }
  }
  song->bpm=DBNum(row[9]);
  song->year=DBNum(row[12]);
  if(song->year==-1) song->year=0;
  song->gain_adjustment=DBNum(row[13]);

  mysql_free_result(res);

  return TRUE;
}

void SongListTimeCalc(MYSQL *mysql,IDList *slist,unsigned long long *bytes,
		      unsigned long long *secs)
{
  int pos;
  Song song_data;
  int filesize;

  *bytes=0;
  *secs=0;

  for(pos=0;pos<slist->num_ids;pos++) {
    if(LookUpSong(mysql,slist->ids[pos],&song_data)) {
      printf("filename is [%s]\n",song_data.filename);

      filesize=FileSize(song_data.filename);

      if(filesize>0) {
	*bytes+=filesize;
	*secs+=song_data.mins*60+song_data.secs;
      }
    }
  }
}
