/* playlist.h -- header file for playlist.c
 *
 * Copyright (c) 1998-2002  Mike Oliphant <oliphant@gtk.org>
 *
 *   http://www.nostatic.org/grip
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <gtk/gtk.h>
#include <mysql.h>
#include "idlist.h"

/* Structure to pass playlist info in */
typedef struct {
  int id;
  char name[256];
  int size;
  int type;
  IDList *idlist;
  GtkWidget *entry;
} PlaylistInfo;

gboolean StorePlaylistToDB(MYSQL *mysql,PlaylistInfo *list_info,IDList *idlist,
			   gboolean overwrite);
int PlaylistTypeFromStr(char *type_str);
gboolean GetPlaylistInfoFromDB(MYSQL *mysql,int list_id,PlaylistInfo *pinfo);
gboolean LoadPlaylistFromDB(MYSQL *mysql,int list_id,IDList *idlist);
GtkWidget *PlaylistCList(MYSQL *mysql,GtkWidget **in_clist);
void SelectPlaylist(MYSQL *mysql,gboolean allow_new,
		    GtkSignalFunc resultfunc,PlaylistInfo *list_info);

