#!/usr/bin/perl

use lib '/usr/share/digitaldj';
use DDJDB;
use CGI;
use strict;

my $album_dir="/mp3/album_covers";

my $cgi=new CGI;

my $disc_pos=$cgi->param("disc_pos") || 0;
my $selected_disc=$cgi->param("disc");
my $queue_song=$cgi->param("queue");
my $start_letter=$cgi->param("letter");

if($queue_song) {
  my $cmd=qq(/var/www/cgi-bin/ddj-remote 127.0.0.1 "juke_add_song $queue_song");

  `$cmd`;
}

my $ddjdb=DDJDB->new(dbname=>"ddj_new",
                     dbserver=>"mp3box",
                     dbuser=>"ddj",
                     dbpswd=>"ddj");

die "unable to connect to db" if(!$ddjdb);


my $discs=GetDiscs($ddjdb);

my $num_discs=scalar @$discs;

if($start_letter) {
  for($disc_pos=0;$disc_pos<$num_discs;$disc_pos++) {
    my $disc_info=$discs->[$disc_pos];

    last if((lc NoThe($disc_info->{artist_name}))
	    gt (lc NoThe($start_letter)));
  }
}

my $disc;

print "Content-type: text/html\n\n";
print "<html><head><title>DDJ Jukebox</title></head>\n";
print qq(<body bgcolor="#000000" link="white" vlink="white"
	 text="white" TOPMARGIN="0" LEFTMARGIN="10" MARGINWIDTH="0"
	 MARGINHEIGHT="0">\n);

print "<table><tr><td>\n";

print "<table>\n";

my $pos=0;

for($disc=$disc_pos;$disc<$num_discs && $disc<($disc_pos+4);$disc++) {
  my $disc_info=$discs->[$disc];

  if(!($pos%2)) {
    if($pos) {
      print "</tr>";
    }
    print "<tr>";
  }

  print "<td><center>";
  print qq(<a href="juke.cgi?disc_pos=$disc_pos&disc=$disc_info->{disc_id}"><img width="150" height="150" src="http://192.168.1.201/album_covers/$disc_info->{disc_id}.jpg"></a>);
  print qq(<font size="1">\n);
  print "<br>$disc_info->{disc_title}<br>$disc_info->{artist_name}\n";
  print "</center></td>\n";

  $pos++;
}

my $next_disc=$disc_pos+4;
my $prev_disc=$disc_pos-4;
$prev_disc=0 if($prev_disc<0);

print "<tr>\n";
print qq(<td><a href="juke.cgi?disc_pos=$prev_disc"><<</a></td>\n);
print qq(<td align="right"><a href="juke.cgi?disc_pos=$next_disc">>></a></td>\n);
print "</tr>\n";


print "</table></td>\n";

print "<td>\n";

print qq(<font size="2">\n);

if($selected_disc) {
  my $songs=GetTracks($ddjdb,$selected_disc);

  foreach my $song_info (@$songs) {
    print qq(<a href="juke.cgi?disc_pos=$disc_pos&disc=$selected_disc&queue=$song_info->{song_id}">
	     $song_info->{song_title}</a><br>\n);
  }
}

print "</td></table>\n";

my $char;

for($char='A';$char ne 'AA';$char++) {
  if($char ne 'A') {
    print "--";
  }

  print qq(<a href="juke.cgi?letter=$char">$char</a>);
}

print qq(<br><a href="http://winesnob.org/cgi-bin/playlist.cgi">Playlists</a>);

print "\n</body></html>\n";

$ddjdb->Disconnect();

sub GetDiscs
{
  my ($ddjdb)=@_;

  my $result=$ddjdb->DBCmd("SELECT artist.artist,disc.id,disc.title FROM ".
			   "artist,disc WHERE disc.artistid=artist.id");

  my @discs;

  while (my ($artist_name,$disc_id,$disc_title)=$result->fetchrow()) {
    my $disc_info={artist_name=>$artist_name,
		   disc_id=>$disc_id,
		   disc_title=>$disc_title};
    
    push @discs,$disc_info;
  }

  @discs=sort { NoThe($a->{artist_name}) cmp NoThe($b->{artist_name})} @discs;

  return \@discs;
}

sub NoThe
{
  my ($str)=@_;

  if($str=~m/^(The |the )(.*)/) {
    return $2;
  }

  return $str;
}

sub GetTracks
{
  my ($ddjdb,$disc_id)=@_;

  my $result=$ddjdb->DBCmd("SELECT title,id,play_time FROM song WHERE ".
			   "discid=$disc_id ".
			   "ORDER BY track_num");

  my @songs;

  while (my ($song_title,$song_id,$play_time)=$result->fetchrow()) {
    my $song_info={song_title=>$song_title,
		   song_id=>$song_id,
		   play_time=>$play_time};

    push @songs,$song_info;
  }

  return \@songs;
}
