/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_data.hpp
 *
 * @brief [LEVEL: beta] @ref diagnostics::unittest::Test_Data Interface
 *
 * $Id: test_data.hpp,v 1.15 2005/06/23 09:54:24 esdentem Exp $
 * 
 * @author Christian Schallhart
 *
 * @test none
 */

#ifndef DIAGNOSTICS__UNITTEST__TEST_DATA_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UNITTEST__TEST_DATA_HPP__INCLUDE_GUARD

#include <diagnostics/frame/namespace.hpp>
#include <diagnostics/unittest/namespace.hpp>

// used in the interface by reference
#include <string>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;


/**
 * @class Test_Data diagnostics/unittest/test_data.hpp
 *
 * @brief A Test_Data Interface is supplied to each @ref Test_Case
 * when its run method is called to access test-relevant data.
 *
 * The @ref Test_Case can use this interface to obtain data by using
 * the @ref get method and to check whether some results match by
 * invoking the @ref compare method.  The handling in the case of an
 * error (non-existing entry or mismatch) depends on the underlying
 * implementation.
 *
 * @note A concrete implementation might interact with the user in the
 * case of an error and allow the user to modify the underlying
 * Test_Data. This is useful for building up Test_Data for Test_Cases.
 *
 * @nosubgrouping
 */
class Test_Data
{
public:
    /**
     * @brief noop
     *
     * @throw never
     */
    virtual ~Test_Data();


    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Accessors
     * @{
     */
public:
    /**
     * @brief gives a reference to the string with @a id
     *
     * @throw Test_Exception if no string with @a id can be supplied
     * 
     * @throw Test_System_Exception if an internal error occurs (not
     * caused by the testcase but by the test environment).
     */
    virtual ::std::string const & get(::std::string const & id) const =0;

    /**
     * @brief compares @a data with the string of @a id (returns
     * true in case of a match)
     *
     * @throw Test_Exception if no string with @a id can be supplied.
     *
     * @throw Test_System_Exception if an internal error occurs (not
     * caused by the testcase but by the test environment).
     */
    virtual bool compare(::std::string const & id,::std::string const & data) const =0;
    // @}
};

UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif
// vim:ts=4:sw=4
