/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "detect.h"
#include "utils.h"

struct cpu_info *cpu_detect(void){
  char *line;
  char line2[80] = { 0 };
  char *temp;
  static struct cpu_info *first = (struct cpu_info *)NULL;
  struct cpu_info *result = (struct cpu_info *)NULL;
  unsigned short proc_id = 0; /* Processor ID */
  FILE *cpuinfo = NULL;
  size_t len = 0;

  if(first){
    return first;
  }/*endif*/
  
  if(!(cpuinfo = fopen(PATH_PROC_CPUINFO, "r"))){
    fprintf(stderr, FOPEN_READ_ERROR, PATH_PROC_CPUINFO);
    return first;
  }/*endif*/

  if(debug)
    printf(_("\nProbing CPU...\n"));

  while(getline(&line, &len, cpuinfo) >= 0){
#if defined(__alpha__)
    if(strstr(line, "cpu	")){
#elif defined(__PPC__)
    if(strstr(line, "processor")) {
#else /*ix86 or __powerpc__ */
    if(strstr(line, "vendor_id")){
#endif
      if((debug) && (first)){
        printf(_("\tFound %s %s\n"), result->vendor, result->model);
      }/*endif*/
      proc_id++;
      /* We found a new CPU */
      if(!first){
        first = result = (struct cpu_info *)
                                     my_malloc(sizeof(struct cpu_info));
      }else{
        result->next = (struct cpu_info *)
                                     my_malloc(sizeof(struct cpu_info));
        result = result->next;
      }/*endif*/
      result->next = (struct cpu_info *)NULL;
      
      /* Fill in single_cpu */
      result->proc_id = proc_id;
      //result->vendor = s_unknown;
      result->vendor = extract_word(line, 2, ": ");
      result->model = s_unknown;
      result->cache = s_unknown;
      result->freq = 0;
      result->options = 0;
      result->bugs = s_none;
      result->bogomips = s_unknown;
#if defined(__alpha__)
    }else if(strstr(line, "cpu model")){
#elif defined(__powerpc__)
    }else if(strstr(line, "cpu  ")){
#else /*ix86*/
    }else if(strstr(line, "model name")){
#endif
      result->model = extract_word(line, 2, ": ");
    }else if((strstr(line, "bogomips")) || (strstr(line, "BogoMIPS"))){
          result->bogomips = extract_word(line, 2, ": ");
          //sscanf(line, "bogomips	: %s", &(result->bogomips));
          break;
    }else if(strstr(line, "cache size")){
      result->cache = extract_word(line, 2, ":");
#if defined(__alpha__)
    }else if(strstr(line, "cycle frequency [Hz]")){
      result->freq = atoi(temp=extract_word(line, 2, ":"))/1000000;
      free(temp);
#elif defined(__powerpc__)
    }else if(strstr(line, "clock")){
      result->freq = atoi(temp=extract_word(line, 2, ":"));
      free(temp);
#else /*ix86*/
    }else if(strstr(line, "cpu MHz")){
      result->freq = atoi(temp=extract_word(line, 2, ":"));
      free(temp);
#endif
    }else if(strstr(line, "flags")){
      if(strstr(line, "fpu")){
        result->options += HAS_FPU;
      }/*endif*/
      if(strstr(line, "mmx")){
        result->options += HAS_MMX;
      }/*endif*/
      if(strstr(line, "3dnow")){
        result->options += HAS_TDNOW;
      }/*endif*/
    }else if(strstr (line, "bug")){
      if(strstr(line, "fdiv") && strstr(line, "yes")){
        strcat(line2, "fdiv ");
      }else if(strstr (line, "hlt") && strstr(line, "yes")){
        strcat(line2, "hlt ");
      }else if (strstr (line, "sep") && strstr(line, "yes")){
        strcat(line2, "sep ");
      }else if(strstr (line, "f00f") && strstr(line, "yes")){
        strcat(line2, "f00f ");
      }else if (strstr (line, "coma") && strstr(line, "yes")){
        strcat(line2, "coma ");
      }/*endif*/
      if(line2[0]){
        result->bugs = (char *)my_malloc(strlen(line2)+1);
        strcpy(result->bugs, line2);
      }/*endif*/
    }/*endif*/
  }/*endwhile*/
  if(debug){
    printf(_("\tFound %s %s\n"), result->vendor, result->model);
  }/*endif*/
  len = 0;
  free(line);
  fclose(cpuinfo);
  return first;
}/*endfunc cpu_detect*/
