//
// C++ Interface: denemo_objects
//
// Description: 
//
//
// Author: Adam Tee <adam@ajtee.plus.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef DENEMOOBJECTS_H
#define DENEMOOBJECTS_H

#include <gtk/gtk.h>


enum headtype
{ 
  DENEMO_NORMAL_NOTEHEAD,
  DENEMO_CROSS_NOTEHEAD,
  DENEMO_HARMONIC_NOTEHEAD,
  DENEMO_DIAMOND_NOTEHEAD
};

typedef struct grace
{
 
  gboolean on_beat;
  gint duration;
}
grace;
  
typedef struct note
{
  gint mid_c_offset;
  gint enshift;
  gboolean reversealign;
  gboolean showaccidental;
  /* Holds number of pixels to the left of the notehead that the
     accidental should be drawn at.  */
  gint position_of_accidental;
  /* Holds y co-ordinate for drawing rather than recalculating it each
     run through the drawing loop.  */
  gint y;
  /* Holds note head type.  */
  enum headtype noteheadtype;
  /* Holds x offset from default position.  */
  gint x_off;
  /* Holds y offset from default position.  */
  gint y_off;
 
}
note;

enum ornament {
  STACCATO=1,
  D_ACCENT,
  CODA,
  FERMATA,
  TENUTO,
  TRILL,
  TURN,
  REVERSETURN,
  MORDENT,
  STACCATISSIMO,
  MARCATO,
  UBOW,
  DBOW,
  RHEEL,
  LHEEL,
  RTOE,
  LTOE,
  FLAGEOLET,
  OPEN,
  PRALLMORDENT,
  PRALL,
  PRALLPRALL,
  SEGNO,
  SFORZATO,
  STOPPED,
  THUMB,
  TRILL_ELEMENT,
  TRILLELEMENT,
  UPPRALL,
  D_ARPEGGIO
};
 


typedef struct chord
{
  GList *tones;			/* Holds pointers to actual note structures */
  /* test for new dynamic handling */
  GList *dynamics;
  gboolean has_dynamic;
  gint highestpitch;
  gint lowestpitch;
  gint highesty;
  gint lowesty;
  gint baseduration;
  gint numdots;
  gint sum_mid_c_offset;
  gint numtones;

  gboolean is_tied;
  gboolean is_stemup;
  gboolean is_reversealigned;
  gboolean slur_begin_p;
  gboolean slur_end_p;
  gboolean crescendo_begin_p;
  gboolean crescendo_end_p;
  gboolean diminuendo_begin_p;
  gboolean diminuendo_end_p;
  gboolean hasanacc;
  /*Flag to show whether note is a grace note*/
  gboolean is_grace;
  gboolean struck_through; /*Flag for a struck through stem*/
  gint stemy;		/* Stores the y position of the end of the stem */
  GList *ornamentlist;
 
  /* Note highlighting flag if
   * true change notes colour
   */
  gboolean is_highlighted; 

  GString *lyric;
  gboolean is_syllable;
  gboolean center_lyric;
  gboolean is_figure; /* the reason for using this boolean is to exploit 
			 the fact that all the spacing and printing of 
			 figures can use the code for the CHORD type */
  gpointer figure; /* when this chord is a bass note 
		      (figure !=NULL && is_figure==FALSE) this
		      pointer points to an objnode in a FiguredBassStaff.
		      That objnode's data is a mudelaobject of type CHORD.
		      It is linked into the corresponding FiguredBassStaff if
		      one exists.
		      When this chord is_figure then figure is a 
		      GString* containing the
		      figures in lilypond format. */
}
chord;

/* Indicator that a tuplet is starting */

typedef struct tupopen
{
  gint numerator;
  gint denominator;
}
tupopen;

enum clefs
{
  DENEMO_TREBLE_CLEF,
  DENEMO_BASS_CLEF,
  DENEMO_ALTO_CLEF,
  DENEMO_G_8_CLEF,
  DENEMO_TENOR_CLEF,
  DENEMO_SOPRANO_CLEF
};

/* Indicator for a clef change */

typedef struct clef
{
  enum clefs type;
}
clef;

/* Indicator for a time-signature change. Only appears at the
 * beginning of a measure */

typedef struct timesig
{
  gint time1;
  gint time2;
}
timesig;

/* Indicator for a key-signature change. */

typedef struct keysig
{
  gint number;  //key number -7 to 7 for major/minor 0 to 40 for mode
  gint isminor; //Type of key 0-major 1-minor 2-mode
  gint mode;  //Mode indicator
  gint accs[7];
}
keysig;

/* Dynamic */

typedef struct dynamic 
{
  GString *type;
}
dynamic;

enum barline_type {
  ORDINARY_BARLINE,
  DOUBLE_BARLINE,
  END_BARLINE,
  OPENREPEAT_BARLINE,
  CLOSE_REPEAT,
  OPEN_CLOSE_REPEAT
};

typedef struct barline
{
  gint type;
}
barline;

/* Data structure for an arbitrary directive to be passed to
 * Lilypond that Denemo doesn't understand. This type is useful
 * in that the user can insert such directives into a mudela file
 * by hand and have Denemo respect them when it loads a file and
 * write them back when it saves it */


/* Lyric datastructure */
typedef struct lyric
{
  GString *lyrics;
  gint position;
  gboolean is_syllable;
  gboolean center_lyric;
}lyric;

/*
typedef struct lilydirective
{
  GString *directive;
}
lilydirective;
*/
enum stemdirections
{
  DENEMO_STEMDOWN=1,
  DENEMO_STEMBOTH,
  DENEMO_STEMUP
};

/* Indicator that the following music should be all stemup, all
 * stemdown, or stemmed normally */

typedef struct stemdirective
{
  enum stemdirections type;
}
stemdirective;

/* A comment in the mudela file; treated similarly to a lilydirective.  */
/*
typedef struct mudelacomment
{
  GString *text;
}
mudelacomment;
*/

#endif
