/*
 * search_line.c
 *   $Last modified: Wed Dec 29 14:47:26 1999$
 * $Id: qanda.c,v 1.3 1999/12/29 06:42:21 kamop Exp $
 */

#define _QANDA_C
#include "debwrap.h"

/*
 * MODULE: set_qanda_type
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
void set_qanda_type(qanda_type_t type)
{
  switch(type){
    case PACKAGE:
      qanda = qanda_package;
      qanda_size = qanda_package_size;
      qanda_end = qanda_package_end;
      break;
    case PRESET:
      qanda = qanda_preset;
      qanda_size = qanda_preset_size;
      qanda_end = qanda_preset_end;
      break;
    case FREQ:
      qanda = qanda_freq;
      qanda_size = QANDA_FREQ_SIZE;
      qanda_end = QANDA_FREQ_SIZE;
      break;
    default:
      qanda = NULL;
      qanda_size = 0;
      qanda_end = 0;
      break;
  };
}

/*
 * MODULE: store_qanda_type
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
void store_qanda_type(qanda_type_t type)
{
  switch(type){
    case PACKAGE:
      qanda_package = qanda;
      qanda_package_size = qanda_size;
      qanda_package_end = qanda_end;
      break;
    case PRESET:
      qanda_preset = qanda;
      qanda_preset_size = qanda_size;
      qanda_preset_end = qanda_end;
      break;
    case FREQ:
      break;
    default:
      break;
  };
}

/*
 * MODULE: init_qanda
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
void init_qanda()
{
  dwrap_t *dwrap;
  dwrap = get_dwrap();

#ifdef DEBUG
  fprintf(logfp, "qanda_dir = %s\n", dwrap->qanda_dir);
#endif
  set_qanda_dir(dwrap->qanda_dir);

  qanda_dir[0] = filename[0] = package[0] = up_ver[0] = deb_ver[0] = '\0';
  qanda_dir[0] = '\0';

  init_qanda_type();
  store_qanda_type(PACKAGE);

  if(dwrap->qanda_file[0] != '\0'){
    init_qanda_type();
    setup_preset_qanda();
    store_qanda_type(PRESET);
  }
  init_qanda_freq();
} /* init_qanda() */

/*
 * MODULE: init_qanda_type
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
void init_qanda_type()
{
  if((qanda = (qanda_t *)malloc
      (sizeof(qanda_t) * QANDA_DEFAULT_SIZE)) == NULL){
    exit(1);
  }
  qanda_size = QANDA_DEFAULT_SIZE;
  qanda_end = 0;
}

/*
 * MODULE: expand_qanda
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
void expand_qanda()
{
  if((qanda = (qanda_t *)
      realloc(qanda, sizeof(qanda_t) * (qanda_size + QANDA_EXPAND_SIZE))) == NULL){
    exit(1);
  }
  qanda_size += QANDA_EXPAND_SIZE;
} /* expand_qanda() */

/*
 * MODULE: setup_preset_qanda
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
void setup_preset_qanda()
{
  dwrap_t *dwrap;
  FILE *fp;

  dwrap = get_dwrap();
  if((fp = f_open(dwrap->qanda_file, "r"))){
    parse_qanda_file(fp);
    f_close(fp, dwrap->qanda_file);
    /*store_qanda_type(PRESET);*/
  }
} /* setup_preset_qanda */

/*
 * MODULE: setup_qanda
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
void setup_qanda()
{
  FILE *fp;

  if((fp = open_qanda_file()) != NULL){
#ifdef DEBUG
    fprintf(logfp, "[dwrap] Open QANDA file\n");
#endif
    parse_qanda_file(fp);
    f_close(fp, filename);
  }else{
#ifdef DEBUG
    fprintf(logfp, "[dwrap] Failed\n");
#endif
  }
} /* setup_qanda() */

/*
 * MODULE: clear_qanda
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
void clear_qanda()
{
  qanda_end = 0;
}

/*
 * MODULE: init_qanda_freq
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
void init_qanda_freq()
{
  int i;

  for(i = 0; i < QANDA_FREQ_SIZE; i++){
    regcomp(&qanda_freq[i].qr, qanda_freq[i].q, REG_EXTENDED);
  } /* for(i) */
} /* init_qanda_freq() */

/*
 * MODULE: parse_qanda_file
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
void parse_qanda_file(FILE *fp)
{
  char line[BUFSIZE];
  char question[BUFSIZE];
  char answer[BUFSIZE];
  while((fgets(line, BUFSIZE, fp)) != NULL){
    if(line[0] == '#'){
      continue;
    }
    if(strcmp(line, START_QANDA_STR) > 0){
      if((fgets(question, BUFSIZE, fp)) != NULL){
        if(qanda_end == qanda_size){
          expand_qanda();
        }
        strncpy(qanda[qanda_end].q, question, (strlen(question) - 1));
        fgets(answer, BUFSIZE, fp);
        strcpy(qanda[qanda_end].a, answer);
        /*strcat(qanda[qanda_end].a, "\n");*/
        /*strncpy(qanda[qanda_end].a, answer, (strlen(answer) - 1));*/
#ifdef DEBUG
        fprintf(logfp, "[%d]Q:%s A:%s\n", qanda_end,
               qanda[qanda_end].q, qanda[qanda_end].a);
#endif
        regcomp(&qanda[qanda_end].qr, question, REG_EXTENDED);
        qanda_end++;
        continue;
      } /* if(fgets) */
    } /* if(strcmp) */
  } /* while() */
} /* parse_qanda_file() */

/*
 * MODULE: open_qanda_file
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
FILE *open_qanda_file()
{
  FILE *fp;
  char *qanda_dir;
  dwrap_t *dwrap;
  dwrap = get_dwrap();
  qanda_dir = dwrap->qanda_dir;

  sprintf(filename, "%s/%s_%s%s", qanda_dir, package, up_ver, deb_ver);
#ifdef DEBUG
  fprintf(logfp, "TRY QANDA file: %s\n", filename);
#endif
  if((fp = f_open(filename, "r")) != NULL){
#ifdef DEBUG
  fprintf(logfp, "OPEN QANDA file: %s\n", filename);
#endif
    return(fp);
  }
  sprintf(filename, "%s/%s_%s", qanda_dir, package, up_ver);
#ifdef DEBUG
  fprintf(logfp, "TRY QANDA file: %s\n", filename);
#endif
  if((fp = f_open(filename, "r")) != NULL){
#ifdef DEBUG
  fprintf(logfp, "OPEN QANDA file: %s\n", filename);
#endif
    return(fp);
  }
  sprintf(filename, "%s/%s", qanda_dir, package);
#ifdef DEBUG
  fprintf(logfp, "TRY QANDA file: %s\n", filename);
#endif
  if((fp = f_open(filename, "r")) != NULL){
#ifdef DEBUG
  fprintf(logfp, "OPEN QANDA file: %s\n", filename);
#endif
    return(fp);
  }
  sprintf(filename, "%s", package);
#ifdef DEBUG
  fprintf(logfp, "TRY QANDA file: %s\n", filename);
#endif
  if((fp = f_open(filename, "r")) != NULL){
#ifdef DEBUG
  fprintf(logfp, "OPEN QANDA file: %s\n", filename);
#endif
    return(fp);
  }
#ifdef DEBUG
  fprintf(logfp, "FAILED QANDA %s\n", filename);
#endif
  return(NULL);
} /* open_qanda_file */

/*
 * MODULE: close_qanda_file
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
void close_qanda_file(FILE *fp)
{
  f_close(fp, filename);
} /* qanda_close() */

/*--------------------------------------------------------------------*/

/*
 * MODULE: get_qanda
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
qanda_t *get_qanda(int num)
{
  if(num < qanda_end){
    return(&qanda[num]);
  }else{
    return(NULL);
  }
} /* get_qanda() */

/*
 * MODULE: get_qanda_question
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
char *get_qanda_question(int num)
{
  if(num < qanda_end){
    return(qanda[num].q);
  }else{
    return(NULL);
  }
} /* get_qanda_question() */

/*
 * MODULE: get_qanda_answer
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
char *get_qanda_answer(int num)
{
  if(num < qanda_end){
    return(qanda[num].a);
  }else{
    return(NULL);
  }
} /* get_qanda_answer() */

/*
 * MODULE: get_qanda_regex
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
regex_t *get_qanda_regex(int num)
{
  if(num < qanda_end){
    return(&qanda[num].qr);
  }else{
    return(NULL);
  }
} /* get_qanda_reges() */

/*
 * MODULE: set_qanda_dir
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
void set_qanda_dir(char *dir)
{
  dwrap_t *dwrap;
  dwrap = get_dwrap();
} /* setup_qanda_dir() */

/*
 * MODULE: get_qanda_end
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
int get_qanda_end()
{
  return(qanda_end);
} /* get_qanda_end() */

/*
 * MODULE: get_qanda_size
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
int get_qanda_size()
{
  return(qanda_size);
} /* get_qanda_size() */


/*--------------------------------------------------------------------*/

/*
 * MODULE: set_qanda_package
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
void set_qanda_package(char *str)
{
  strcpy(package, str);
} /* set_qanda_package() */

/*
 * MODULE: set_qanda_up_ver
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
void set_qanda_up_ver(char *str)
{
  strcpy(up_ver, str);
} /* set_qanda_up_ver */

/*
 * MODULE: set_qanda_deb_ver
 * DESC:
 * IN:
 * OUT:
 * OP:
 * STATUS:
 * END:
 */
void set_qanda_deb_ver(char *str)
{
  strcpy(deb_ver, str);
} /* set_qanda_deb_ver() */
