/* Distributed Checksum Clearinghouse
 *
 * Copyright (c) 2005 by Rhyolite Software
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.2.74-1.15 $Revision$
 */

#include "dcc_defs.h"
#include "dcc_xhdr.h"
#include <ctype.h>


static struct tbl {
    char	nm[DCC_XHDR_MAX_TYPE_LEN];
    DCC_CK_TYPES type;
} tbl[] = {
    {DCC_XHDR_TYPE_IP,		DCC_CK_IP},
    {DCC_XHDR_TYPE_ENV_FROM,	DCC_CK_ENV_FROM},
    {DCC_XHDR_TYPE_FROM,	DCC_CK_FROM},
    {DCC_XHDR_TYPE_SUB,		DCC_CK_SUB},
    {DCC_XHDR_TYPE_MESSAGE_ID,	DCC_CK_MESSAGE_ID},
    {DCC_XHDR_TYPE_RECEIVED,	DCC_CK_RECEIVED},
    {DCC_XHDR_TYPE_BODY,	DCC_CK_BODY},
    {DCC_XHDR_TYPE_FUZ1,	DCC_CK_FUZ1},
    {DCC_XHDR_TYPE_FUZ2,	DCC_CK_FUZ2},
    {DCC_XHDR_TYPE_GREY_MSG,	DCC_CK_GREY_MSG},
    {DCC_XHDR_TYPE_GREY_TRIPLE,	DCC_CK_GREY_TRIPLE},
    {DCC_XHDR_TYPE_ENV_TO,	DCC_CK_ENV_TO},
    {DCC_XHDR_TYPE_FLOD_PATH,	DCC_CK_FLOD_PATH},
    /* omit DCC_CK_DCC_SRVR_ID to prevent funny business */
};


static u_char
cknm_cmp(const char *nmp, const char *tgtp)
{
	char nmc, tgtc;

	for (;;) {
		nmc = *nmp++;
		tgtc = *tgtp++;
		if (nmc == '\0') {
			if (tgtc == '\0')
				return 1;
			/* ignore trailing blanks and colons */
			--tgtp;
			tgtp += strspn(tgtp, DCC_WHITESPACE":");
			return *tgtp == '\0';
		}
		if (nmc == tgtc)
			continue;
		nmc = tolower(nmc);
		tgtc = tolower(tgtc);
		if (nmc == tgtc)
			continue;
		if ((nmc == '-' || nmc == '.' || nmc == '_')
		    && (tgtc == '-' || tgtc == '.' || tgtc == '_'))
			continue;
		return 0;
	}
}


DCC_CK_TYPES
dcc_str2type(const char *str)
{
	struct tbl *tp;

	/* ignore leading blanks */
	str += strspn(str, DCC_WHITESPACE);

	for (tp = tbl; tp <= LAST(tbl); ++tp) {
		if (cknm_cmp(tp->nm, str))
			return tp->type;
	}

	return DCC_CK_INVALID;
}
