/************************************************************************
 *   IRC - Internet Relay Chat, include/s_user.h
 *   This file is copyright (C) 2001 Andrew Suffield
 *                                    <asuffield@users.sourceforge.net>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 */

#include "config.h"
#include "umodes.h"

FLAG_ITEM user_mode_table[] =
{ 
  {UMODE_AUSPEX, 'a'},
  {UMODE_BOTS,  'b'},
  {UMODE_CHANGEOTHER, 'B'},
  {UMODE_CCONN, 'c'},
  {UMODE_NOCTCP, 'C'},
  {UMODE_DEBUG, 'd'},
  {UMODE_DIE, 'D'},
  {UMODE_IDENTIFIED, 'e'},
  {UMODE_BLOCK_NOTID, 'E'},
  {UMODE_FULL,  'f'},
  {UMODE_FLUDPROOF, 'F'},
  {UMODE_GLINE, 'g'},
  {UMODE_GLOBAL_KILL, 'G'},
  {UMODE_HIGHPRIORITY, 'h'},
  {UMODE_REHASH, 'H'},
  {UMODE_INVISIBLE, 'i'},
  {UMODE_NOINVITE, 'I'},
  {UMODE_SKILL, 'k'},
  {UMODE_KILL, 'K'},
#ifdef CHANNEL_CREATION_NOTICE
  {UMODE_CHCREATE, 'l'},
#endif
  {UMODE_FORCELUSERS, 'L'},
  {UMODE_IMMUNE, 'm'},
  {UMODE_MASSNOTICE, 'M'},
  {UMODE_NCHANGE, 'n'},
  {UMODE_ANYNICK, 'N'},
  {UMODE_OPER, 'o'},
  /*  {UMODE_LOCOP, 'O'},*/
  {UMODE_GOD,   'p'},
  {UMODE_SETNAME, 'P'},
  {UMODE_REJ, 'r'},
  {UMODE_REMOTE, 'R'},
  {UMODE_SERVNOTICE, 's'},
  {UMODE_REMOTEINFO, 'S'},
  {UMODE_UNKLINE, 'U'},
  {UMODE_SEEOPERPRIVS, 'v'},
  {UMODE_SEEROUTING, 'V'},
  {UMODE_WALLOP, 'w'},
  {UMODE_SENDWALLOPS, 'W'},
  {UMODE_EXTERNAL, 'x'},
  {UMODE_EXPERIMENTAL, 'X'},
  {UMODE_SPY, 'y'},
  {UMODE_SERVCONNECT, 'Y'},
  {UMODE_OPERWALL, 'z'},
  {UMODE_SENDOPERWALL, 'Z'},
  {UMODE_SEESOPERS, '0'},
  {UMODE_SEEILINES, '1'},
  {UMODE_SEEKLINES, '2'},
  {UMODE_SEEQLINES, '3'},
  {UMODE_SEESTATST, '4'},
  {UMODE_SEESTATSSERV,'5'},
  {UMODE_TESTLINE, '9'},
  {UMODE_GRANT, '*'},
  {UMODE_FREESPOOF, '@'},
  {0, 0}
};

int user_modes_from_c_to_bitmask[256];
char umode_list[256];

void init_umodes(void)
{
  unsigned int i, field, bit;
  char *p = umode_list;
  /* Fill out the reverse umode map */
  for (i = 0; user_mode_table[i].letter; i++)
    {
      user_modes_from_c_to_bitmask[(unsigned char)user_mode_table[i].letter] = user_mode_table[i].mode;
      *p++ = user_mode_table[i].letter;
    }
  *p = '\0';
  /* Fill out the bitfield map */
  bit = 1;
  field = 0;
  for (i = 0; i < BITFIELD_SIZE; i++)
    {
      bitfield_lookup[i].bit = bit;
      bitfield_lookup[i].field = field;
      if (bit == 0x80000000)
	{
	  field++;
	  bit = 1;
	}
      else
	bit = bit << 1;
    }

  /* These are the umodes which any user can set */
  SetBit(user_umodes, UMODE_INVISIBLE);
  SetBit(user_umodes, UMODE_WALLOP);
  SetBit(user_umodes, UMODE_NOINVITE);
  SetBit(user_umodes, UMODE_BLOCK_NOTID);
  SetBit(user_umodes, UMODE_NOCTCP);
}

/* Neither argument may be null */
char *
umode_difference(user_modes *old_modes, user_modes *new_modes)
{
  static char buf[MAX_UMODE_COUNT+3];
  int i,flag;
  char *p = buf;
  char t = '=';

  /* Do this twice because we don't want +a-b+c-d and so on, we
   * want -bd+ac
   */
  for (i = 0; user_mode_table[i].letter; i++ )
    {
      flag = user_mode_table[i].mode;
      
      if (TestBit(*old_modes, flag) && !TestBit(*new_modes, flag))
	{
	  if (t != '-')
	    t = *p++ = '-';
	  *p++ = user_mode_table[i].letter;
	}
    }

  for (i = 0; user_mode_table[i].letter; i++ )
    {
      flag = user_mode_table[i].mode;

      if (!TestBit(*old_modes, flag) && TestBit(*new_modes, flag))
	{
	  if (t != '+')
	    t = *p++ = '+';
	  *p++ = user_mode_table[i].letter;
	}
    }
  *p = '\0';
  return buf;
}
