/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef __CVC4__OPTIONS__THEORY_H
#define __CVC4__OPTIONS__THEORY_H

#include "options/options.h"

#include "options/theoryof_mode.h"


#define CVC4_OPTIONS__THEORY__FOR_OPTION_HOLDER \
  assignFunctionValues__option_t::type assignFunctionValues;\
  bool assignFunctionValues__setByUser__; \
  condenseFunctionValues__option_t::type condenseFunctionValues;\
  bool condenseFunctionValues__setByUser__; \
  theoryOfMode__option_t::type theoryOfMode;\
  bool theoryOfMode__setByUser__; \
  useTheoryList__option_t::type useTheoryList;\
  bool useTheoryList__setByUser__;


namespace CVC4 {

namespace options {

extern struct CVC4_PUBLIC assignFunctionValues__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} assignFunctionValues CVC4_PUBLIC;
extern struct CVC4_PUBLIC condenseFunctionValues__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} condenseFunctionValues CVC4_PUBLIC;
extern struct CVC4_PUBLIC theoryOfMode__option_t
{
  typedef CVC4::theory::TheoryOfMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} theoryOfMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC useTheoryList__option_t
{
  typedef std::string type;
  type operator()() const;
  bool wasSetByUser() const;
} useTheoryList CVC4_PUBLIC;


}  // namespace options

template <> void Options::set(
    options::assignFunctionValues__option_t,
    const options::assignFunctionValues__option_t::type& x);
template <> const options::assignFunctionValues__option_t::type& Options::operator[](
    options::assignFunctionValues__option_t) const;
template <> bool Options::wasSetByUser(options::assignFunctionValues__option_t) const;
template <> void Options::assignBool(
    options::assignFunctionValues__option_t,
    std::string option,
    bool value);
template <> const options::condenseFunctionValues__option_t::type& Options::operator[](
    options::condenseFunctionValues__option_t) const;
template <> bool Options::wasSetByUser(options::condenseFunctionValues__option_t) const;
template <> void Options::assignBool(
    options::condenseFunctionValues__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::theoryOfMode__option_t,
    const options::theoryOfMode__option_t::type& x);
template <> const options::theoryOfMode__option_t::type& Options::operator[](
    options::theoryOfMode__option_t) const;
template <> bool Options::wasSetByUser(options::theoryOfMode__option_t) const;
template <> void Options::assign(
    options::theoryOfMode__option_t,
    std::string option,
    std::string value);
template <> const options::useTheoryList__option_t::type& Options::operator[](
    options::useTheoryList__option_t) const;
template <> bool Options::wasSetByUser(options::useTheoryList__option_t) const;
template <> void Options::assign(
    options::useTheoryList__option_t,
    std::string option,
    std::string value);


namespace options {

inline assignFunctionValues__option_t::type assignFunctionValues__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool assignFunctionValues__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void assignFunctionValues__option_t::set(const assignFunctionValues__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline condenseFunctionValues__option_t::type condenseFunctionValues__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool condenseFunctionValues__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline theoryOfMode__option_t::type theoryOfMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool theoryOfMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void theoryOfMode__option_t::set(const theoryOfMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline useTheoryList__option_t::type useTheoryList__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool useTheoryList__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}


}  // namespace options
}  // namespace CVC4

#endif /* __CVC4__OPTIONS__THEORY_H */
