/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_SYSTEMINFODISKS_H
#define INCLUDED_SYSTEMINFODISKS_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QLISTVIEW_H
#include <qlistview.h>
#define INCLUDED_QLISTVIEW_H
#endif // INCLUDED_QLISTVIEW_H

class SystemCall;

class SystemInfoDisks : public QListView
{
	Q_OBJECT

// ******* TYPES *******
private:
	typedef enum {
		FileSystem = 0,
		Type,
		Size,
		Used,
		Avail,
		Use,
		Mount,
		NumberOfColumns
	};

// ******* CONSTRUCTION *******
public:
	SystemInfoDisks( QWidget* );
	~SystemInfoDisks();
private:
	SystemInfoDisks( const SystemInfoDisks& );
	SystemInfoDisks& operator=( const SystemInfoDisks& );

// ******* MEMBERS *******
private:
	static const QString d_hdr_label[NumberOfColumns];
	SystemCall* d_syscall;

// ******* METHODS *******
private:
//	void show();
	void add_item( const QString& );
private slots:
	void finished( int );
};

#endif // INCLUDED_SYSTEMINFODISKS_H
