/******************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "SFtp.h"


//*******************************************************************
// SFtp                                                  CONSTRUCTOR
//*******************************************************************
SFtp::SFtp( const QString& in_server, const QString& in_user, const QString& in_passwd )
: QProcess ()
, d_server ( in_server )
, d_user   ( in_user )
, d_passwd ( in_passwd )
, d_op     ( None )
{
/*
    qWarning( "SFtp::SFtp" );
    qWarning( in_server );
    qWarning( in_user );
    qWarning( in_passwd );
*/
}
// end of SFtp

//*******************************************************************
// ~SFtp                                                  DESTRUCTOR
//*******************************************************************
SFtp::~SFtp()
{
}
// end of ~SFtp

//*******************************************************************
// run                                                        PUBLIC
//*******************************************************************
bool SFtp::run()
{
    clearArguments();
    addArgument( "sftp" );
    addArgument( d_user + "@" + d_server + ":/" );

    connect( this, SIGNAL( readyReadStdout () ), this, SLOT( read_stdout() ));
    connect( this, SIGNAL( readyReadStderr () ), this, SLOT( read_stderr() ));
    
    d_op = Login;
    return start();
}
// end of run

//*******************************************************************
// stop                                                       PUBLIC
//*******************************************************************
void SFtp::stop()
{
    qWarning( "kill him" );
    writeToStdin( "quit" );
}
// end of stop

//*******************************************************************
// read_stdout                                          PRIVATE slot
//*******************************************************************
void SFtp::read_stdout()
{
    qWarning( "read_stdout" );
    
    const QString line = readLineStdout();
    qWarning( line );
    
    if( Login == d_op ) {
        if( line.find( "password:", 0, FALSE ) != -1 ) {
            qWarning( "pass" );
            writeToStdin( d_passwd );
        }
    }
}
// end of read_stdout

//*******************************************************************
// read_stderr                                          PRIVATE slot
//*******************************************************************
void SFtp::read_stderr()
{
    const QString line = readLineStderr();
    qWarning( line );
}
// end of read_stderr

