/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "Help.h"
#include "Shared.h"
#include "Config.h"
#include <qtextbrowser.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qapplication.h>
#include <qdesktopwidget.h>


/*------- local constants:
-------------------------------------------------------------------*/
const QString Help::help_text[] = {
	QT_TR_NOOP("<b>F1 Help</b> - you are here, information about navigation keys."),
	QT_TR_NOOP("<b>F2 Attr</b> - allow you to change access permission for selected files/directories (recursive too)."),
	QT_TR_NOOP("<b>F3 View</b> - allow you to see what is inside a file."),
	QT_TR_NOOP("<b>F4 Edit</b> - edit a text file."),
	QT_TR_NOOP("<b>F5 Copy/Move</b> - copy/move selected files/directories (recursive)"),
	QT_TR_NOOP("<b>F6 Rename</b> - allow you to change a name for selected file or directory."),
	QT_TR_NOOP("<b>F7 MkDir</b> - you can create new subdirectory"),
	QT_TR_NOOP("<b>F8 Delete</b> - remove selected files/directories(recursive)"),
	QT_TR_NOOP("<b>F9 Pack</b> - pack with 'tar'/'gzip' selected files/directories(recursive),"),
	QT_TR_NOOP("<b>F10 Quit</b> - end of program, come back to operating system."),
	" ",
	QT_TR_NOOP("<b>Ctrl+PageUp</b> - jump to a parent directory."),
	QT_TR_NOOP("<b>Ctrl+Home</b> - jump to a user home directory. "),
	QT_TR_NOOP("<b>Home/PageUp</b> - jump to a first item."),
	QT_TR_NOOP("<b>End/PageDown</b> - jump to a last item."),
	QT_TR_NOOP("<b>ArrowUp</b> - go to previous item."),
	QT_TR_NOOP("<b>ArrowDown</b> - go to next item."),
	" ",
	QT_TR_NOOP("<b>+ (plus)</b> - select items via mask"),
	QT_TR_NOOP("<b>- (minus)</b> - unselect items via mask"),
	QT_TR_NOOP("<b>* (asterix)</b> - inverts current selections."),
	" ",
	QT_TR_NOOP("<b>Del</b> - see F8."),
	QT_TR_NOOP("<b>Backspace</b> - see Ctrl+PageUp."),
	QT_TR_NOOP("<b>Ctrl+Backspace</b> - jump to '/' directory."),
	QT_TR_NOOP("<b>Enter</b> - when current item is '..' go to a parent directory."),
	QT_TR_NOOP("<b>Ctrl+E</b> - emptying selected directory." ),
	QT_TR_NOOP("<b>Ctrl+R</b> - re-read current directory (update content)."),
	QT_TR_NOOP("<b>Ctrl+N</b> - creates new empty file."),
	QT_TR_NOOP("<b>Ctrl+Space</b> - computes total files size for selected directory."),
	QT_TR_NOOP("<b>Ctrl+F7</b> - search files on whole file system."),
	" ",
	QT_TR_NOOP("<b>Ctrl+5</b> - create a file with MD5 control sum." ),
	QT_TR_NOOP("<b>Alt+5</b> - check a MD5 control sum" ),
	" ",
	QT_TR_NOOP("<b>Ctrl+S</b> - switch panels" ),
	QT_TR_NOOP("<b>Ctrl+T</b> - create new tab,"),
	QT_TR_NOOP("<b>Ctrl+W</b> - remove current tab,"),
	QT_TR_NOOP("<b>Ctrl+L</b> - jump to edit field of current path"),
	QT_TR_NOOP("<b>Ctrl+O</b> - both panels displays the same directory"),
};

//*******************************************************************
// Help                                                  CONSTRUCTOR
//*******************************************************************
Help::Help( QWidget* const in_parent )
: QDialog( in_parent )
, d_viewer( new QTextBrowser( this ))
, d_return_btn( new QPushButton( tr(Shared::CloseBtnLabel), this ))
{
	setCaption( tr(Shared::MenuHelp) );
	d_viewer->setWordWrap( QTextBrowser::NoWrap );
	d_viewer->setPaletteBackgroundColor( Config::instance()->lfs_default_bkg_color() );
	d_viewer->setFont( Config::instance()->lfs_default_font() );
	
	set_viewer_text();
	Shared::add_icon( d_return_btn, Shared::CloseIcon );
	connect( d_return_btn, SIGNAL( clicked() ), this, SLOT( accept() ));
	
	QVBoxLayout* const main_layout = new QVBoxLayout( this );
	main_layout->setMargin( Shared::LayoutMargin );
	main_layout->setSpacing( Shared::LayoutSpacing );
	main_layout->addWidget( d_viewer );
		
	QHBoxLayout* const btn_layout = new QHBoxLayout;
	btn_layout->addStretch( Shared::OverStretch );
	btn_layout->addWidget( d_return_btn );
	main_layout->addLayout( btn_layout );
}
// end of Help

//*******************************************************************
// polish                                          PRIVATE inherited
//*******************************************************************
void Help::polish()
{
	Shared::polish( this, 45, 40 );
}
// end of polish

//*******************************************************************
// set_viewer_text                                           PRIVATE
//*******************************************************************
void Help::set_viewer_text()
{
	const int n = sizeof( help_text ) / sizeof( help_text[0] );
	for( int i = 0; i < n; ++i ) {
		d_viewer->append( tr(help_text[i]) );
	}
	d_viewer->setCursorPosition( 0, 0 );
}
// end of set_viewer_text
