/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BSCommander is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BSCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_FTPSERVER_H
#define INCLUDED_FTPSERVER_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

#ifndef INCLUDED_FTPSERVERINFO_H
#include "FtpServerInfo.h"
#endif // INCLUDED_FTPSERVERINFO_H


/*------- forward declarations:
-------------------------------------------------------------------*/
class QPushButton;
class QLineEdit;
class QCheckBox;
class QIntValidator;
class QHBoxLayout;
class QVBoxLayout;
class QGroupBox;
class QLabel;

/*------- class declaration:
-------------------------------------------------------------------*/
class FtpServer : public QDialog
{
	Q_OBJECT
	
// ******* CONSTRUCTION *******
public:
	FtpServer( QWidget* const in_widget, FtpServerInfo& in_fsi );
	~FtpServer();
private:
	FtpServer( const FtpServer& );
	FtpServer& operator=( const FtpServer& );

// ******* CONSTANTS *******
private:
	static const QString CAPTION;
	static const int     OVER_STRETCH;
	static const int     SPACING_WIDTH;
	static const int     MARGIN_WIDTH;
	static const QString BTN_OK;
	static const QString SRV_SETTINGS;
	static const QString NAME_LABEL;
	static const QString ADDR_LABEL;
	static const QString DIR_LABEL;
	static const QString PORT_LABEL;
	static const QString USR_SETTINGS;
	static const QString USER_LABEL;
	static const QString PASS_LABEL;
	static const QString ANONYM_CB;
	static const QString SSL_CB;
	static const QString ANONYM_NAME;
	static const QString ANONYM_PASS;

// ******* MEMBERS *******
private:
	QHBoxLayout* const d_main_layout;
	//....................................
	QVBoxLayout* const d_data_layout;
	QGroupBox*   const d_data_box;
	QLabel*      const d_name_lbl;
	QLineEdit*   const d_name_le;
	QLabel*      const d_addr_lbl;
	QLineEdit*   const d_addr_le;
	QLabel*      const d_port_lbl;
	QLineEdit*   const d_port_le;
	QLabel*      const d_dir_lbl;
	QLineEdit*   const d_dir_le;
	QCheckBox*   const d_ssl_cb;
	QCheckBox*   const d_anonym_cb;
	QGroupBox*   const d_user_box;
	QLabel*      const d_user_lbl;
	QLineEdit*   const d_user_le;
	QLabel*      const d_pass_lbl;
	QLineEdit*   const d_pass_le;
	//....................................
	QVBoxLayout* const d_btn_layout;
	QPushButton* const d_ok_btn;
	QPushButton* const d_cancel_btn;
	//....................................
	QIntValidator*     d_validator;
	FtpServerInfo d_fsi;
	
// ******* METHODS *******
public:
	const FtpServerInfo& get_fsi() const { return d_fsi; }
private:
	void show();
	bool check();
private slots:
	void slot_ok();
	void slot_cancel();
	void slot_anonym( bool );
	void slot_ssl( bool );
};

#endif // INCLUDED_FTPSERVER_H
