/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BSCommander is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BSCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_CONFIG_H
#define INCLUDED_CONFIG_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QFONT_H
#include <qfont.h>
#define INCLUDED_QFONT_H
#endif // INCLUDED_QFONT_H

#ifndef INCLUDED_QCOLOR_H
#include <qcolor.h>
#define INCLUDED_QCOLOR_H
#endif // INCLUDED_QCOLOR_H

/*------- class declaration:
-------------------------------------------------------------------*/
class Config
{
// ******* TYPES *******
public:
	enum {
		Lang_EN = 0,
		Lang_RU,
		Lang_PL,
		Lang_DE,
		Lang_ES,
		Lang_CS
	};
	enum {
		NC = 0,
		KDE
	};
	enum {
		ONLY_FN = 0,
		ONLY_TEXT,
		FULL_DESC,
		TWO_LINES
	};
private:
	Config();
	Config( const Config& );
	Config& operator=( const Config& );
public:
	virtual ~Config();
	
// ******* CONSTANTS *******
private:
	static const QString LFS_DefaultFont;
	static const QString FTP_DefaultFont;
	static const QString FN_DefaultFont;
	static const QString LFS_DefaultBkgColor;
	static const QString FTP_DefaultBkgColor;
public:
	static const QString PanelConfigGroupName;
	static const QString AppConfigGroup;
	static const QString LFS_FontKey;
	static const QString FTP_FontKey;
	static const QString LFS_BkgColorKey;
	static const QString FTP_BkgColorKey;
	static const QString LangKey;
	static const QString SelectionModeKey;
	static const QString FnDispModeKey;
	static const QString FnFontKey;
	static const QString TerminalKey; 
	static const QString ColumnsResizeKey;

// ******* MEMBERS *******
private:
	static Config* d_instance;
	QFont   d_lfs_font;
	QFont   d_ftp_font;
	QFont   d_fn_font;
	QColor  d_lfs_bkg_color;
	QColor  d_ftp_bkg_color;
	int     d_lang;
	int     d_selection_mode;
	int     d_fn_disp_mode;
	QString d_terminal_call;
	int     d_disable_columns_resize;
public:
	static Config* instance();
	void   refresh();	
	
	const QFont   lfs_default_font     () const;
	const QFont   ftp_default_font     () const;
	const QColor  lfs_default_bkg_color() const;
	const QColor  ftp_default_bkg_color() const;
	
	const QFont&   lfs_font              () const { return d_lfs_font;               }
	const QFont&   ftp_font              () const { return d_ftp_font;               }
	const QFont&   fn_font               () const { return d_fn_font;                }
	const QColor&  lfs_bkg_color         () const { return d_lfs_bkg_color;          }
	const QColor&  ftp_bkg_color         () const { return d_ftp_bkg_color;          }
	const int      lang                  () const { return d_lang;                   }
	const int      selection_mode        () const { return d_selection_mode;         }
	const int      fn_disp_mode          () const { return d_fn_disp_mode;           }
	const QString& terminal_call         () const { return d_terminal_call;          }
	const int      disable_columns_resize() const { return d_disable_columns_resize; }
};

//******* lfs_default_font ******************************************
inline const QFont Config::lfs_default_font() const
{
	QFont fnt;
	fnt.fromString( LFS_DefaultFont );
	return fnt;
}
//******* ftp_default_font ******************************************
inline const QFont Config::ftp_default_font() const
{
	QFont fnt;
	fnt.fromString( FTP_DefaultFont );
	return fnt;
}
//******* lfs_default_bkg_color *************************************
inline const QColor Config::lfs_default_bkg_color() const
{
	QColor clr;
	clr.setNamedColor( LFS_DefaultBkgColor );
	return clr;
}
//******* ftp_default_bkg_color *************************************
inline const QColor Config::ftp_default_bkg_color() const
{
	QColor clr;
	clr.setNamedColor( FTP_DefaultBkgColor );
	return clr;
}

#endif // INCLUDED_CONFIG_H
