#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#if defined(_TESTING_) && defined(USE_LANGUAGE_CHOOSER)
#include <locale.h>
#endif /* _TESTING_ and USE_LANGUAGE_CHOOSER */

#include "dbootstrap.h"
#include "lang.h"

#ifdef _TESTING_
#  define RELEASE_FILE	"../../scripts/rootdisk/messages/C/release_notes"
#  define RELEASE_FILE_FMT "../../scripts/rootdisk/messages/%s/release_notes"
#else
#  define RELEASE_FILE	"/release_notes"
#  define RELEASE_FILE_FMT "/release_notes.%s"
#endif

static int
display_notes(const char *filename)
{
    struct stat s;
    int fd;
    if (NAME_ISREG (filename, &s) && (fd=open (filename, O_RDONLY)) >= 0)
    {
        char *buf = (char *)malloc (s.st_size+1);
        size_t num;

	num = read (fd, buf, s.st_size);
	close(fd);
	buf[s.st_size] = '\0';

	wideMessageBox (buf, _("Release Notes"));

        free (buf);
	return 0;
    } else {
        ERRMSG("cannot find release notes file %s", filename);
	return -1;
    }
}

int
release_notes (const char *suffix)
{
#ifdef USE_LANGUAGE_CHOOSER
    if (suffix != NULL)
    {
        /* If malloc() fails, it will display RELEASE_FILE */
        char *fname = (char *)malloc (PATH_MAX);
	if (fname)
	{
	    snprintf (fname, PATH_MAX, RELEASE_FILE_FMT, suffix);
	    if (display_notes(fname) == 0)
	    {
	        free (fname);
		return 0;
	    }
	    free(fname);
	}
    }
#endif /* USE_LANGUAGE_CHOOSER */

    if (display_notes(RELEASE_FILE) != 0)
        return -1;


    return (0);
}

#ifdef _TESTING_
/* To test, compile using: make release_notes_test */
int main(int argc, char *argv[]){
    char *msgcat = NULL;

#ifdef USE_LANGUAGE_CHOOSER
    setlocale(LC_ALL, "");
#endif /* USE_LANGUAGE_CHOOSER */
    LOAD_TRMFILE("test.trm");
    get_kver();
    boxInit();

    if (2 == argc)
        msgcat = argv[1];

    release_notes (msgcat);

    boxFinished();
    return 0;
}
#endif

