#!/bin/bash

. ./common.sh

case "$1" in
	atari|Atari)
		#
		# Atari install kit
		#
		mkdir -p release/atari
		mkdir -p release/atari/debian
		cp resc1440atari.bin release/atari/debian/resc1440.bin
		cp drv1440atari.bin release/atari/debian/drv1440.bin
		cp linuxatari.bin release/atari/debian/linux.bin
		cp sys_mapatari.gz release/atari/debian/sysmap.gz
		cp rootatari.bin release/atari/debian/root.bin
		cp m68k-specials/bootstra.ttp release/atari/debian/bootstra.prg
		# hardcoded; was: cp m68k-specials/bootargs release/atari/debian/bootargs
		cat <<EOF > release/atari/debian/bootargs
-s -k linux -r root.bin root=/dev/ram video=keep load_ramdisk=1
EOF
		cp m68k-specials/debian-atari.txt release/atari/debian/install.doc
		# create lzh archive
		(cd release/atari/ && lha a ../atariinstall.lzh debian/)
		# clean up
		rm -rf release/atari
		;;
	amiga|Amiga)
		#
		# Amiga install kit 
		#
		mkdir -p release/amiga
		mkdir -p release/amiga/debian
		# unpack AmigaOS magic from m68k support directory
		(cd release/amiga/ && lha x ../../m68k-specials/amiga-kit.lzh)
		cp resc1440amiga.bin release/amiga/debian/resc1440.bin
		cp drv1440amiga.bin release/amiga/debian/drv1440.bin
		cp linuxamiga.bin release/amiga/debian/linux.bin
		cp sys_mapamiga.gz release/amiga/debian/
		cp rootamiga.bin release/amiga/debian/root.bin
		# create lzh archive
		(cd release/amiga/ && lha a ../amigainstall.lzh debian/)
		# clean up
		rm -rf release/amiga
		;;
	mac|Mac)
		#
		# Mac install kit
		#
		# mkdir -p release/mac
		# mkdir -p release/mac/debian
		# create HFS floppy image
		dd if=/dev/zero of=release/macinstall-floppy-hfs.img bs=1024 count=1440
		hformat -l "Debian/68k" release/macinstall-floppy-hfs.img
		# mount it (':' is top dir)
		hmount release/macinstall-floppy-hfs.img
		# copy kernel/sysmap/ramdisk as raw
		hcopy -r linuxmac.bin :linux.bin
		hcopy -r sys_mapmac.gz :System-Map.gz
		hcopy -r rootmac.bin :root.bin
		# copy booter as BinHex (MacBinary: -m)
		hcopy -b m68k-specials/Penguin-16.hqx :
		# copy Preferences as BinHex
		hcopy -b m68k-specials/Penguin_Prefs_floppy.hqx :"Penguin Prefs"
		# hcopy -b m68k-specials/Penguin_Prefs_autoboot.hqx :"Penguin Prefs (autoboot)"
		# copy color maps as BinHex
		hcopy -b m68k-specials/Penguin_Colors.hqx :
		# copy install doc as text
		hcopy -t m68k-specials/debian-mac.txt :Install.doc
		humount release/macinstall-floppy-hfs.img

		## create HFS install dir image (for CD-ROM)
		#dd if=/dev/zero of=release/macinstall-hfs.img bs=1024 count=4500
		#hformat -l "Debian/68k" release/macinstall-hfs.img
		## mount it (':' is top dir)
		#hmount release/macinstall-hfs.img
		## copy kernel/sysmap/ramdisk as raw
		#hcopy -r linuxmac.bin :linux.bin
		#hcopy -r sys_mapmac.gz :System-Map.gz
		#hcopy -r rootmac.bin :root.bin
		#hcopy -r resc1440mac.bin :resc1440.bin
		#hcopy -r drv1440mac.bin :drv1440.bin
		## copy booter as BinHex (MacBinary: -m)
		#hcopy -b m68k-specials/Penguin-16.hqx :
		## copy Preferences as BinHex
		#hcopy -b m68k-specials/Penguin_Prefs_CD.hqx :
		#hcopy -b m68k-specials/Penguin_Prefs_CD_autoboot.hqx :"Penguin Prefs (autoboot)"
		## copy color maps as BinHex
		#hcopy -b m68k-specials/Penguin_Colors.hqx :
		## copy install doc as text
		#hcopy -t m68k-specials/debian-mac.txt :Install.doc
		#humount release/macinstall-hfs.img

		# package Mac booter stuff for the CD install dir
		# (tar format until I can come up with something nicer)
		mkdir -p release/mac
		mkdir -p release/mac/install/
		mkdir -p release/mac/install/mac/
		cp m68k-specials/Penguin-16.hqx release/mac/install/mac/
		#cp m68k-specials/Penguin_Prefs_CD.hqx release/mac/install/mac/
		#cp m68k-specials/Penguin_Prefs_CD_autoboot.hqx release/mac/install/mac/
		dd if=/dev/zero of=release/macinstall-temp.img bs=1024 count=1440
		hformat release/macinstall-temp.img
		# mount it (':' is top dir)
		hmount release/macinstall-temp.img
		hcopy -b m68k-specials/Penguin_Prefs_CD.hqx :"Penguin Prefs"
		hcopy -b m68k-specials/Penguin_Prefs_CD_autoboot.hqx :"Penguin Prefs (autoboot)"
		hcopy -b :"Penguin Prefs" release/mac/install/mac/
		hcopy -b :"Penguin Prefs (autoboot)" release/mac/install/mac/
		humount release/macinstall-temp.img
		rm release/macinstall-temp.img
		cp m68k-specials/debian-mac.txt release/mac/install/mac/
		(cd release/mac && tar cfvz ../macinstall.tar.gz install/)
		# clean up
		rm -rf release/mac

		;;
	*)
		echo "Unknown subarch \"$1\" !"
		;;
esac
