#
__copyright__ = '''
 Copyright (C) 1999-2001 The Software in the Public Interest (SPI)
 Written by Mikhail Sobolev <mss@mawhrin.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
'''

import string, time

from helpers import Storage, compare_by_ename

class produce:
    def __init__ (self, charset):
        self.charset = charset

    def convert (self, what):
        return what.encode (self.charset)

def dumper (arch):
    if available_dumpers.has_key (arch):
        result = available_dumpers[arch]
    else:
        result = dump_c

    return result

def dump_list_c (outfile, engine, storage, items, lists, name, list):
    outfile.write ('static struct language_list %s = {\n' % name)
    outfile.write ('  "%s",\n' % engine.convert (list.name))
    outfile.write ('  {\n')

    for i in range (len (list.items)):
        item = list.items[i]

        if item.__dict__.has_key ('locale'):    # is there other way for the same check?
            ref = len (items)

            items.append ((engine, item))

            lists.append ('%s.items[%s].p = (void *)(items + %s)' % (name, i, ref))

            outfile.write ('    { 1, NULL },\n')
        else:
            lists.append ('%s.items[%s].p = &%s_%s' % (name, i, name, i))

            outfile.write ('    { 2, NULL },\n')

    outfile.write ('    { 0 }\n  }\n};\n')

    for i in range (len (list.items)):
        item = list.items[i]

        if not item.__dict__.has_key ('locale'):    # is there other way for the same check?
            dump_list_c (outfile, engine, storage, items, lists, '%s_%s' % (name, i), item)

def dump_c (do_convert, outfile, what):
    outfile.write ('''\
/*
 This is an automatically generated file.  DO NOT CHANGE!
 %s
 Date: %s
 */

#include <stdlib.h>

#include "langs.h"

''' % (__copyright__, time.ctime (time.time ())))

    what.sort (compare_by_ename)

    strings = Storage ('strings')

    items = []
    lists = []

    outfile.write ('static struct language_definition all_langs[] = {\n')

    for lang in what:
        if do_convert:
            e = produce (lang.charset)
        else:
            e = produce ('utf-8')

        outfile.write ('  {\n')
        outfile.write ('    "%s",\n' % lang.ename)
        outfile.write ('    "%s",\n' % e.convert (lang.name))
        outfile.write ('    NULL,\n')
        outfile.write ('    NULL,\n')
        outfile.write ('    "%s",\n' % e.convert (lang.hint))
        outfile.write ('    NULL\n')
        outfile.write ('  },\n')

        strings.add (lang.font)
        strings.add (lang.acm)

    outfile.write ('  { NULL }\n};\n')

    for lang in what:
        if do_convert:
            e = produce (lang.charset)
        else:
            e = produce ('utf-8')

        dump_list_c (outfile, e, strings, items, lists, string.lower (lang.ename), lang.list)

    outfile.write ('static struct language_item items[] = {\n')

    for e, item in items:
        outfile.write ('  {\n')
        outfile.write ('    "%s",\n' % e.convert (item.name))
        outfile.write ('    NULL,\n')
        outfile.write ('    NULL,\n')
        outfile.write ('    NULL,\n')
        outfile.write ('    NULL,\n')
        outfile.write ('    NULL\n')
        outfile.write ('  },\n')

        strings.add (item.locale)
        strings.add (item.font)
        strings.add (item.acm)
        strings.add (item.keymap)
        strings.add (item.msgcat)

    outfile.write ('};\n\n')

    outfile.write (strings.declaration ())

    outfile.write ('\n\nconst struct language_definition *\navailable_languages (void)\n{\n')

    for i in range (len (what)):
        lang = what[i]

        outfile.write ('    all_langs[%s].font = %s;\n' % (i, strings.reference (lang.font)))
        outfile.write ('    all_langs[%s].acm = %s;\n' % (i, strings.reference (lang.acm)))
        outfile.write ('    all_langs[%s].list = &%s;\n' % (i, string.lower (lang.ename)))

    for line in lists:
        outfile.write ('    %s;\n' % line)

    for i in range (len (items)):
        item = items[i][1]

        outfile.write ('    items[%s].locale = %s;\n' % (i, strings.reference (item.locale)))
        outfile.write ('    items[%s].font = %s;\n' % (i, strings.reference (item.font)))
        outfile.write ('    items[%s].acm = %s;\n' % (i, strings.reference (item.acm)))
        outfile.write ('    items[%s].keymap = %s;\n' % (i, strings.reference (item.keymap)))
        outfile.write ('    items[%s].msgcat = %s;\n' % (i, strings.reference (item.msgcat)))

    outfile.write ('    return all_langs;\n}\n')

    outfile.write ('\n')    # eol at the end of file.

def dump_alpha (outfile, what):
    pass

available_dumpers = {
    'i386' : dump_c
}
