#DESC: qeth: OSA-Express in QDIO mode / HiperSockets

# initial network setup for s390 installation
#
# written by Stefan Gybas and Frank Kirschner
# maintained by the boot-floppies team, debian-boot@lists.debian.org
# copyright (c) 2001
# This is free software under the GNU General Public License.

get_portname() {
  cat <<__EOF__

Please enter the portname of your OSA-Express card. This name must be 1 to 8
characters long and must be equal on all systems accessing the same card!
Leave it empty if you want to use HiperSockets. This parameter is required
for cards with microcode level 2.10 or later or when you want to share a
card. The name will be converted to uppercase letters automatically! See
"LINUX for S/390: Device Drivers and Installation Commands" for details.
__EOF__

  readln_mixed "qeth portname: "
  if [ -z "$ans" ]; then
    if [ -z "$chandev_module_parm" ]; then
      chandev_parm=""
    else
      chandev_parm="noauto"
    fi
  else
    portname=`echo $ans | tr [a-z] [A-Z]`
    if [ -z "$chandev_module_parm" ]; then
      chandev_parm="add_parms,$chantype,0x0000,0xffff,portname:$portname"
    else
      chandev_parm="noauto;add_parms,$chantype,0x0000,0xffff,portname:$portname"
    fi
  fi
}

get_chantype $network_module
chantype=$ans
devno_list=`print_chandevnos $chantype | cut -d\  -f2`
list_length $devno_list
devno_count=$?

if [ $devno_count -eq 3 ]; then
  element_from_list 1 $devno_list
  read_devno=$element
  element_from_list 2 $devno_list
  write_devno=$element
  element_from_list 3 $devno_list
  data_devno=$element
else
  read_devno=""
  write_devno=""
  data_devno=""
fi

if [ $devno_count -ge 1 ]; then
  print_chandevheader 
  print_chandevnos $chantype
else 
  cat <<__EOF__
No OSA-Express QDIO cards / HiperSockets were detected. If you are running VM
please make sure that your card is attached to this guest. If you want to use
an OSA-2 or OSA-Express card in non-QDIO mode please use the lcs driver
instead:
__EOF__
  return 1
fi

while :; do

  echo "The following device numbers belong to OSA-Express QDIO / HiperSockets devices:"
  echo $devno_list

  cat <<__EOF__

Please enter the read device numbers for your device in hexadecimal notation
preceeded by 0x, e.g. "0x2000" or "auto" for automatic probing.
Note: The read device must be an even number, the write device must be the
following odd number.
Advanced users may also enter all chandev parameters for the qeth module, e.g.
"qeth0,0x1000,0x1001,0x1002,0,0,0". See the chapter about the "Channel device
layer" in "LINUX for S/390: Device Drivers and Installation Commands" for
details.
__EOF__

  readln "qeth read device number: " $read_devno
  if [ "$ans" = "auto" ]; then
    module_parm=""
    chandev_module_parm=""
    get_portname
    break;
  fi

  # Test if it's a complete qeth chandev parameter line
  echo $ans | grep -q '^qeth.*,0x.*,0x.*,0x.*'
  if [ $? = 0 ]; then
    module_parm=""
    chandev_module_parm="$ans"
    get_portname
    break;
  fi

  # It must be the read device number then...
  echo $ans | grep -q '^0x[0-9a-f]*'
  if [ $? -eq 0 ]; then
    read_devno=$ans
    # ash does not support hexadecimal numbers, so convert to decimal first
    ans=`printf "%d" $ans`
    write_devno=`printf "0x%x" $(($ans + 1))`

    echo "Please enter the data device number of your card."
    readln "qeth data device number: " $data_devno
    data_devno=$ans

    echo "Please enter the relative port number to use on your card (0 or 1)"
    readln "qeth port number: " 0

    module_parm=""
    chandev_module_parm="${network_module}-1,$read_devno,$write_devno,$data_devno,0,$ans"
    get_portname
    break;
  fi

  echo ""
  echo "Your answer is not valid. Please retry!"
done

# If not in auto mode, test if the device numbers are in the list
echo $chandev_module_parm | grep -q '^qeth'
if [ $? -eq 0 ]; then
  read_devno=`echo $chandev_module_parm | cut -d, -f2`
  write_devno=`echo $chandev_module_parm | cut -d, -f3`
  data_devno=`echo $chandev_module_parm | cut -d, -f4`
  # TODO: test if devices are in list
fi

