/***************************************************************************
                   xmlparser.h  -  XmlParser Class Definition
                             -------------------
    begin                : Sat Sep 21 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This class implements a base class for a generic re-usable XML        *
 *   parser.  The base class in and of itself is not usable.  A derived    *
 *   class defines which elements in which it is interested, and numeric   *
 *   states used to determine the parser's position within the XML         *
 *   document's nested element hierarchy.  This class utilizes the SAX2    *
 *   interface from the libxml Gnome library.  A plethora of comments      *
 *   later in this file document the process for implementing an actual    *
 *   parser.                                                               *
 *                                                                         *
 ***************************************************************************/

#ifndef XMLPARSER_H
#define XMLPARSER_H

#include <libxml/parser.h>
#include <time.h>

#include "bkexcept.h"

#define SAXSTATE_STARTEND		0
#define SAXSTATE_UNKNOWN		1
#define SAXSTATE_USER			99

#define BRIDGE_URI			"http://bookmarkbridge.sourceforge.net"

void	EncodeString(const QString &str, QString &outstr);

typedef void (*BEGIN_DOC_HANDLER)(void *);
typedef bool (*BEGIN_ELEM_HANDLER)(void *, const xmlChar *, const xmlChar **, short);
typedef void (*END_DOC_HANDLER)(void *);
typedef void (*END_ELEM_HANDLER)(void *, const xmlChar *, const xmlChar *pChars, short, short);
typedef void (*CHAR_HANDLER)(void *, short state, const xmlChar *, int len);

typedef struct {
	short			state;
	const char		*elem;
	BEGIN_ELEM_HANDLER	startElem;
	END_ELEM_HANDLER	endElem;
} ELEMHANDLER;

void	ParseHtmlDocument(
		const QString &filename,			// filename of document to parse
		void *ctx,						// pointer to context data
		ELEMHANDLER *elems,				// array of element handlers
		BEGIN_DOC_HANDLER funcBegin,	// begin document handler
		END_DOC_HANDLER funcEnd,		// end document handler
		CHAR_HANDLER charHandler=NULL)	// optional character handler
		throw(BkException);

void	ParseXmlDocument(
		const QString &filename,			// filename of document to parse
		void *ctx,						// pointer to context data
		ELEMHANDLER *elems,				// array of element handlers
		BEGIN_DOC_HANDLER funcBegin,	// begin document handler
		END_DOC_HANDLER funcEnd,		// end document handler
		CHAR_HANDLER charHandler=NULL)	// optional character handler
		throw(BkException);

#endif	// end of XMLPARSER_H
