#!/usr/bin/perl
#############################################################################
#                  autodocs.pl  -  Perl Documentation Generator
#                              -------------------
#     begin                : Sun Jan 19 2003
#     copyright            : (C) 2003 by Ken Schenke
#     email                : kenschenke at yahoo dot com
#############################################################################

###########################################################################
#                                                                         #
#   This program is free software; you can redistribute it and/or modify  #
#   it under the terms of the GNU General Public License as published by  #
#   the Free Software Foundation; either version 2 of the License, or     #
#   (at your option) any later version.                                   #
#                                                                         #
###########################################################################

if(@ARGV < 1)
{
	die("Usage: -a | pml_file");
}

if($ARGV[0] eq "-a")
{
	opendir(PMLFILES, ".") || die("Unable to open directory");

	while($filename = readdir(PMLFILES))
	{
		if($filename =~ /.pml$/)
		{
			do_pml($filename);
		}
	}

	closedir(PMLFILES);
}
else
{
	do_pml($ARGV[0]);
}

sub do_pml
{
	my ($filename) = @_;

	$template = "";
	%defines = ();

	readtags($filename);

	if(length($template) < 1) {
		die("Must specify a template!"); }

	convert_pml($filename);
}

sub convert_pml
{
	my ($filename) = @_;
	my $i, $output_filename, $si, $ei, $cmd;

	$i = rindex($filename, ".");
	if($i == -1) {
		die("Malformed Filename"); }
	$output_filename = substr($filename, 0, $i) . ".html";

	print("Converting $filename to $output_filename\n");

	open(PMLFILE, $filename)  || die("Unable to Open PML File");
	open(TEMPLATE, $template) || die("Unable to Open Template File");
	open(OUTPUT, ">$output_filename") || die("Unable to Open Output HTML File");

	while($line = <TEMPLATE>)
	{
		$line = trim($line);
		$si = index($line, "[--");
		$ei = index($line, "--]");
		if($si==-1 || $ei==-1)
		{
			print OUTPUT "$line\n";
			next;
		}
		$cmd = lc(trim(substr($line, $si+3, $ei-$si-3)));
		if(index($cmd, '$') == 0)
		{
			$define = substr($cmd, 1);
			if(!exists($defines{$define})) {
				die("Unrecognized Variable \"$define\" in Template"); }
			substr($line, $si, $ei-$si+3, $defines{$define});
			print OUTPUT "$line\n";
		}
		elsif($cmd eq "content")
		{
			while($line = <PMLFILE>)
			{
				$line = trim($line);
				if(($line=~/^\[--/) && ($line=~/--\]$/)) {
					next; }
				print OUTPUT "$line\n";
			}
		}
		else {
			die("Unrecognized Template Tag \"$cmd\""); }
	}

	close(TEMPLATE);
	close(PMLFILE);
	close(OUTOUT);
}

sub extract_tag
{
	my ($t) = @_;
	my $parts, $i;

	$parts = trim($t);
	$i = index($parts, " ");
	if($i == -1) {
		die("Malformed PML Tag"); }

	return (
		lc(trim(substr($parts, 0, $i))),
		trim(substr($parts, $i)));
}

sub readtags
{
	my ($filename) = @_;

	open(PMLFILE, $filename) || die("Unable to open PML file");

	while($line = <PMLFILE>)
	{
		$line = trim($line);
		if(($line=~/^\[--/)==0 || ($line=~/--\]$/)==0) {
			next; }
		@tags = extract_tag(trim(substr($line, 4, length($line)-7)));
		if($tags[0] eq "#") {
			next; }
		elsif($tags[0] eq "define")
		{
			$i = index($tags[1], "=");
			if($i == -1) {
				die("Malformed DEFINE Tag"); }
			$var = trim(substr($tags[1], 0, $i));
			$val = trim(substr($tags[1], $i+1));
			$defines{$var} = $val
		}
		elsif($tags[0] eq "template")
		{
			if(length($template) > 0) {
				die("A PML file can only have one template!"); }
			$template = $tags[1];
		}
		else {
			die("Unrecognized tag \"$tags[0]\""); }
	}
	
	close(PMLFILE);
}

sub trim
{
	my ($str) = @_;

	$str =~ s/^(\s+)|(\s+)$//g;
	return $str;
}
