package aQute.junit.osgi;

import java.util.*;
import java.util.logging.*;

import junit.framework.*;

import org.osgi.framework.*;
import org.osgi.util.tracker.*;

import aQute.junit.runtime.*;

public class Activator extends Thread implements BundleActivator {
    BundleContext    context;
    String           reportName;
    BundleTracker    tracker;
    volatile boolean active;
    Logger logger = Logger.getLogger(Activator.class.getName());
    
    public Activator() {
        super("bnd Runtime Test Bundle");
    }

    public void start(BundleContext context) throws Exception {
        logger.info("Runtime started");
        this.context = context;
        active = true;
        start();        
    }

    public void stop(BundleContext context) throws Exception {
        active = false;
        interrupt();
        join(10000);
    }

    public void run() {
        logger.info("Thread run started");
        reportName = System.getProperty("aQute.runtime.report.name");
        if (reportName == null)
            reportName = "testreport-%s.xml";

        final List queue = new ArrayList();

        tracker = new BundleTracker(context, Bundle.ACTIVE, null) {
            public Object addingBundle(Bundle bundle, BundleEvent event) {
                String testcases = (String) bundle.getHeaders().get(
                        "Test-Cases");
                logger.info("Found bundle "+bundle.getBundleId()+", Test-Cases: "+ testcases );
                if (testcases == null)
                    return null;

                logger.info("Enqueueing bundle " + bundle );
                queue.add(bundle);
                synchronized (queue) {
                    queue.notifyAll();
                }
                return bundle;
            }
        };
        tracker.open();
        
        logger.info("Starting loop" );
        try {
        outer: while (active) {
            Bundle bundle;
            synchronized (queue) {
                logger.info("Will wait" );
                while (queue.isEmpty() && active)
                    try {
                        queue.wait();
                    } catch (InterruptedException e) {
                        interrupt();
                        break outer;
                    }
            }
            bundle = (Bundle) queue.remove(0);
            logger.info("Dequeueing bundle " + bundle );
            test(bundle);
            logger.info("All tests done " + bundle );
        }
        } finally {
            logger.info("Exiting loop");
            tracker.close();
        }
    }

    void test(Bundle bundle) {
        Bundle fw = context.getBundle(0);
        try {

            List names = new ArrayList();
            Target.checkTestCases(bundle, names);
            final TestResult result = new TestResult();
            BasicTestReport otl = new BasicTestReport() {
                public void startTest(Test test) {
                    if (!active)
                        throw new ThreadDeath();
                    super.startTest(test);
                }
            };

            String path = reportName.replaceAll("%s", bundle.getSymbolicName());
            XMLReport report = new XMLReport(path);

            try {
                TestSuite suite = Target.createSuite(bundle, names);
                List flattened = new ArrayList();
                int realcount = Target.flatten(flattened, suite);
                report.begin(fw, bundle, flattened, realcount);
                otl.begin(fw, bundle, flattened, realcount);
                result.addListener(report);
                result.addListener(otl);
                suite.run(result);
            } catch (ThreadDeath td) {
                report.aborted();
                otl.aborted();
            } catch (Throwable t) {
                result.addError(null, t);
            } finally {
                report.end();
                otl.end();
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
