#include <set>
#include <vector>
#include <string>
#include <cstring>
#include <cstdlib>
#include <iostream>
#include <fstream>
#include <istream>
#include <algorithm>

using namespace std;

set<string> acc, cur;
bool is_shuffling = false;

void printHelp(void)
{
  cerr << "blm is a boolean line manipulator utility." << endl;
  cerr << "blm was written by Rudi Cilibrasi (cilibrar@cilibrar.com)." << endl;
  cerr << "blm is a utility to perform set operations on strings" << endl;
  cerr << "It reads one or more files as input, with results to stdout" << endl;
  cerr << "Usage: blm startingfile [+opfile1]... [-opfile2]... [%opfile3]... [\\&opfile4] [@]..." << endl;
  cerr << "+opfile1 or just opfile1 means to add the file with the or." << endl;
  cerr << "-opfile1 means to subtract the file with set difference." << endl;
  cerr << "&opfile1 means set intersection (quote the & using \\&)." << endl;
  cerr << "%opfile1 means to xor the file with accumulator." << endl;
  cerr << "Output is sorted lexicographically, one string per line." << endl;
  cerr << "Unless the optional shuffling symbol '@' appears as an argument." << endl;
  cerr << "Using - as a filename represents standard input." << endl;
}

set<string> readfile(const char *fname) {
  set<string> result;
  string s;
  istream *ins;
  ifstream fil;
  if (strcmp(fname, "-") == 0) {
    ins = &cin;
  } else {
    fil.open(fname);
    if (fil.is_open())
      ins = &fil;
    else {
      cerr << "Error, cannot open file " << fname << endl;
      exit(1);
    }
  }
  while (!ins->eof()) {
    getline(*ins, s);
    if (s.size() == 0)
      continue;
    result.insert(s);
  }
  return result;
}

void doand(const char *fname)
{
  set<string> res;
  cur = readfile(fname);
  set_intersection(acc.begin(), acc.end(), cur.begin(), cur.end(), inserter(res, res.end()));
  acc = res;
}

void doadd(const char *fname)
{
  set<string> res;
  cur = readfile(fname);
  set_union(acc.begin(), acc.end(), cur.begin(), cur.end(), inserter(res, res.end()));
  acc = res;
}

void dodiff(const char *fname)
{
  set<string> res;
  cur = readfile(fname);
  set_difference(acc.begin(), acc.end(), cur.begin(), cur.end(), inserter(res, res.end()));
  acc = res;
}

void doxor(const char *fname)
{
  set<string> res, base, togo;
  base = acc;
  doand(fname);
  togo = acc;
  acc = base;
  doadd(fname);
  set_difference(acc.begin(), acc.end(), togo.begin(), togo.end(), inserter(res, res.end()));
  acc = res;
}

unsigned int zrand() {
  unsigned int bigval;
  static bool have_initted = false;
  static FILE *fp = 0;
  if (!have_initted) {
    FILE *fp = fopen("/dev/urandom", "rb");
    srand(time(NULL));
    have_initted = true;
  }
  if (fp) {
    fread(&bigval, 1, sizeof(bigval), fp);
    return bigval;
  }
  bigval = rand();
  return bigval;
}

void scramble_vector(vector<string> &vs)
{
  string tmp;
  int i, j;
  for (i = vs.size() - 1; i > 0; i -= 1) {
    j = zrand() % (i+1);
    if (i != j) {
      tmp = vs[i];
      vs[i] = vs[j];
      vs[j] = tmp;
    }
  }
}

void printresult(void)
{
  set<string>::iterator i;
  vector<string> vs;
  vector<string>::iterator vsi;
  for (i = acc.begin(); i != acc.end(); i++) {
    vs.push_back(*i);
  }
  if (is_shuffling) {
    scramble_vector(vs);
  }
  for (vsi = vs.begin(); vsi != vs.end(); vsi++) {
      cout << (*vsi) << endl;
  }
}


int main(int argc, char **argv)
{
  if (argc == 1) {
    printHelp();
    exit(1);
  }
  int i;
  for (i = 1; i < argc; i += 1) {
    char op = argv[i][0];
    char *fname = &(argv[i][1]);
    int flen = strlen(fname);
    if (flen == 0 && op == '-') { // interpret '-' as "+-"
      op = '+';
      fname = strdup("-");
    }
    switch (op) {
      case '+':
        doadd(fname);
        break;
      case '-':
        dodiff(fname);
        break;
      case '&':
        doand(fname);
        break;
      case '%':
        doxor(fname);
        break;
      case '@':
        is_shuffling = true;
        break;
      default:
        doadd(argv[i]);
        break;
    }
  }
  printresult();
  return 0;
}
