/* (PD) 2001 The Bitzi Corporation
 * Please see file COPYING or http://bitzi.com/publicdomain 
 * for more info.
 *
 * $Id: gui.c,v 1.4 2001/04/06 01:48:13 mayhemchaos Exp $
 */

#include <windows.h>
#include <stdlib.h>
#include "bitcollider.h"
#include "list.h"
#include "dirsearch.h"
#include "gui_win32.h"
#include "resource.h"

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	MSG    msg;
    HWND   hWnd;
    DWORD  dwThreadId;
    List  *list;
    int    argIndex = 1;

    list = create_list();
    for(; argIndex < __argc; argIndex++)
    {
       add_to_list(list, __argv[argIndex]);
    }

	// Perform application initialization:
	hWnd = init_gui();
    if (hWnd == NULL) 
	{
		return FALSE;
	}

    if (CreateThread(NULL, 0, BitcolliderThread, list, 0, &dwThreadId) == NULL)
       MessageBox(NULL, "Cannot create thread.", "Bitcollider", MB_OK);

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
        if (!IsDialogMessage(hWnd, &msg))
        {
            TranslateMessage(&msg);
  		    DispatchMessage(&msg);
        }
	}
    delete_list(list);

	return msg.wParam;
}



