/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Initial Developer of the Original Code is Saleem Mohammed.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * by the Initial Developer. All Rights Reserved.
 *
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
//  selection code by Roman Stukalov
//  some functions from Paul Stothard (SMS) 

const kWindowMediatorContractID = "@mozilla.org/appshell/window-mediator;1";
const kWindowMediatorIID = Components.interfaces.nsIWindowMediator;
const kWindowMediator = Components.classes[kWindowMediatorContractID].getService(kWindowMediatorIID);
var biofoxPrefs = Components.classes["@mozilla.org/preferences-service;1"]
					.getService(Components.interfaces.nsIPrefService)
					.getBranch("biofox.");

var elementTags = new Array('menu-sep',
				    'pubmed-link',
				    'scirus-link'
				   );

//showHide and init function taken from textlink (Ted Mielczarek)
function showHide() {
	var isTextSelection = false;
    if(gContextMenu) { isTextSelection = gContextMenu.isTextSelected; }
    for(var i=0; i<elementTags.length; i++) {
    	var menuitem = document.getElementById(elementTags[i]);
    	if(menuitem) {
        	menuitem.hidden = !isTextSelection;
      	}
    }
}

function init () {
    var menu = document.getElementById("contentAreaContextMenu");
    menu.addEventListener("popupshowing",showHide,false);
}

function search_pubmed(){
	var searchTerm = getSelection();
	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
	var browser = browserWindow.getBrowser();
	browser.selectedTab = browser.addTab("http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?CMD=search&DB=pubmed&term="+searchTerm);
}

function search_scirus(){
	var searchTerm = getSelection();
	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
	var browser = browserWindow.getBrowser();
	browser.selectedTab = browser.addTab("http://www.scirus.com/srsapp/search?ds=jnl&ds=nom&ds=web&t=phrase&g=s&t=all&q="+searchTerm);
}

function biofoxLoadOptions() {
	var biofoxPrefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch).getBranch("biofox.");
    document.getElementById('biofoxEmail').value = biofoxPrefs.getCharPref('sEmail');
    document.getElementById('biofoxFirstname').value = biofoxPrefs.getCharPref('sFirstname');
    document.getElementById('biofoxLastname').value = biofoxPrefs.getCharPref('sLastname');
}

function biofoxSaveOptions(){
    var email;
    var firstname;
    var lastname;

    email = document.getElementById('biofoxEmail').value;
    firstname = document.getElementById('biofoxFirstname').value;
    lastname = document.getElementById('biofoxLastname').value;

    biofoxPrefs.setCharPref("sEmail", email);
    biofoxPrefs.setCharPref("sFirstname", firstname);
    biofoxPrefs.setCharPref("sLastname", lastname);

    return true;
}

function biofoxShowOptions(){
	window.openDialog("chrome://biofox/content/biofox-pref.xul");
}

function getSelection() {
	var text = content.window.getSelection().toString();
	
	// if nothing selected in the document then perhaps there is a
	// selection contained within a frame of the current document
	if (!text) {
		for (var i = 0; i < _content.frames.length; i++) {
			text = _content.frames[i].document.getSelection().toString();
		//	text = _content.frames[i].document.getSelection.createRange();
			if (text) break;
		}
	}
	return text;
}

function showLines(max, text) {
	max--;
	text = "" + text;
	var temp = "";
	var chcount = 0; 
	for (var i = 0; i < text.length; i++) {   
		var ch = text.substring(i, i+1); // first character
		var ch2 = text.substring(i+1, i+2); // next character
		if (ch == '\n') {  
			temp += ch;
			chcount = 1;
		} else {
			if (chcount == max) {
				temp += '\n' + ch; // go to next line
				chcount = 1; // reset chcount
			} else  {
				temp += ch;
				chcount++; // so add 1 to chcount
	      	}
   		}
   }
	return (temp); // sends value of temp back
}

function openWindow(url, processedSeq, flag) {
	var j=0;
	processedSeq=trim(processedSeq);
	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
	var browser = browserWindow.getBrowser();
	//var tab = browser.selectedTab = browser.addTab("data:text/html;charset=utf-8,"+processedSeq);
 	
	if (flag<10){
		if (flag==0){
			var tab = browser.selectedTab = browser.addTab("data:text/html;charset=utf-8,<html><head><title></title></head><body><table width='700' bgcolor=eeeeee><tr><td width='700'><font face=courier size=2><b>>Sequence</b><br></font></td></tr></table></body></html>");		
		} 
		if (flag==1){
			var tab = browser.selectedTab = browser.addTab("data:text/html;charset=utf-8,<html><head><title></title></head><body><table width='700' bgcolor=eeeeee><tr><td width='700'><font face=courier size=2><b>>Error Code</b><br></font></td></tr></table></body></html>");
		}
	//	if (flag==2){
	//		var tab = browser.selectedTab = browser.addTab("data:text/html;charset=utf-8,<html><head><title></title></head><body><table width='700' bgcolor=eeeeee><tr><td width='700'><font face=courier size=2><br></font></td></tr></table></body></html>");
	//	}
			var tab = browser.selectedTab = browser.addTab("data:text/html;charset=utf-8,<html><head><title></title></head><body><table width='700' bgcolor=eeeeee><tr><td width='700'><font face=courier size=2>"+processedSeq+"<br></font></td></tr></table></body></html>"); 
   	} else {
  		var tab = browser.selectedTab = browser.addTab("data:text/html;charset=utf-8,<html><head><title></title></head><body><table width=400 bgcolor=eeeeee><tr><td><font face=courier size=2>"+processedSeq+"</font></td></tr></table></body></html>");

   	}
}

function trim(str){
	while(str.charAt(0) == (" ") )
		{str = str.substring(1);}
	while(str.charAt(str.length-1) == " " )
		{str = str.substring(0,str.length-1);}
	return str;
}

function strip(selectedSeq){
	selectedSeq = selectedSeq.replace(/[\n\t\s]/g, "");
	selectedSeq = selectedSeq.replace(/[@#\$%\^\&\*\({}_\+\/=:;<~`|\.,\'\"\)\?!>\]-]/g, "");
	selectedSeq = selectedSeq.replace(/[0-9]/g, "");
	selectedSeq = selectedSeq.toLowerCase();
	if ((selectedSeq.indexOf("b")!=-1)||(selectedSeq.indexOf("j")!=-1)||(selectedSeq.indexOf("o")!=-1)||(selectedSeq.indexOf("u")!=-1)||
	(selectedSeq.indexOf("z")!=-1)||(selectedSeq.indexOf("x")!=-1)){ 
		selectedSeq="Contains Illegal chars";
		return selectedSeq;
	} else {
		selectedSeq = selectedSeq.toUpperCase();
		//selectedSeq = selectedSeq+"*";
      	return selectedSeq;
	}
}

function filterSeq(selectedSeq, frameNo) {
	//if (!(selectedSeq.indexOf("*")!=-1))
	processedSeq=strip(selectedSeq);
	return processedSeq;
}

function dnatoProt(triplet){
	if (triplet.search(/gc[agtcn]/gi)!=-1)
		triplet="A";
	if (triplet.search(/tg[ct]/gi)!=-1)
		triplet="C";
	if (triplet.search(/ga[tc]/gi)!=-1)
		triplet="D";
	if (triplet.search(/ga[ag]/gi)!=-1)
		triplet="E";
	if (triplet.search(/tt[tc]/gi)!=-1)
		triplet="F";
	if (triplet.search(/gg[agctn]/gi)!=-1)
		triplet="G";
	if (triplet.search(/ca[tc]/gi)!=-1)
		triplet="H";
	if (triplet.search(/at[atc]/gi)!=-1)
		triplet="I";
	if (triplet.search(/aa[ag]/gi)!=-1)
		triplet="K";
	if (triplet.search(/ct[agtcn]|tt[ag]/gi)!=-1)
		triplet="L";
	if (triplet.search(/atg/gi)!=-1)
		triplet="M";
	if (triplet.search(/aa[tc]/gi)!=-1)
		triplet="N";
	if (triplet.search(/cc[atgcn]/gi)!=-1)
		triplet="P";
	if (triplet.search(/ca[ag]/gi)!=-1)
		triplet="Q";
	if (triplet.search(/cg[agctn]|ag[ag]/gi)!=-1)
		triplet="R";
	if (triplet.search(/tc[agctn]|ag[ct]/gi)!=-1)
		triplet="S";
	if (triplet.search(/ac[agctn]/gi)!=-1)
		triplet="T";
	if (triplet.search(/gt[agctn]/gi)!=-1)
		triplet="V";
	if (triplet.search(/tgg/gi)!=-1)
		triplet="W";
	if (triplet.search(/ta[tc]/gi)!=-1)
		triplet="Y";
	if (triplet.search(/ta[ga]|tga/gi)!=-1)
		triplet="*";
	return triplet;
}

function alignment(flag) {
	var selectedSeq = getSelection();
	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
	var browser = browserWindow.getBrowser();
	if (selectedSeq.length < 1)
	    	return;
	selectedSeq = selectedSeq.replace(/(\* \>)|(\*\>)/g, "*\r\n>"); 
	selectedSeq = selectedSeq.replace(/\>/g,"\r\n>");
	selectedSeq = selectedSeq.replace(/<br>/g,"\r\n>");
	selectedSeq = escape(selectedSeq);
	if (flag==0) 
		browser.selectedTab = browser.addTab("http://www.ebi.ac.uk/cgi-bin/submit?tool=clustalw&sequence="+selectedSeq);
}

function blast(selectedSeq, flag) {
	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
	var browser = browserWindow.getBrowser();
	if (selectedSeq.length < 1)
      	return;
	else {
	if (flag==0) 
		browser.selectedTab = browser.addTab("http://www.ncbi.nlm.nih.gov/BLAST/Blast.cgi?CMD=Web&LAYOUT=TwoWindows&AUTO_FORMAT=Semiauto&ALIGNMENTS=50&ALIGNMENT_VIEW=Pairwise&CLIENT=web&DATABASE=nr&DESCRIPTIONS=100&ENTREZ_QUERY=%28none%29&EXPECT=10&FILTER=L&FORMAT_OBJECT=Alignment&FORMAT_TYPE=HTML&NCBI_GI=on&PAGE=Nucleotides&PROGRAM=blastn&SERVICE=plain&SET_DEFAULTS.x=34&SET_DEFAULTS.y=8&SHOW_OVERVIEW=on&END_OF_HTTPGET=Yes&SHOW_LINKOUT=yes&GET_SEQUENCE=yes&QUERY="+selectedSeq);
	if (flag==1)
		browser.selectedTab = browser.addTab("http://www.ncbi.nlm.nih.gov/BLAST/Blast.cgi?CMD=Web&LAYOUT=TwoWindows&AUTO_FORMAT=Semiauto&ALIGNMENTS=50&ALIGNMENT_VIEW=Pairwise&CDD_SEARCH=on&CLIENT=web&COMPOSITION_BASED_STATISTICS=on&DATABASE=nr&DESCRIPTIONS=100&ENTREZ_QUERY=%28none%29&EXPECT=10&FILTER=L&FORMAT_OBJECT=Alignment&FORMAT_TYPE=HTML&I_THRESH=0.005&MATRIX_NAME=BLOSUM62&NCBI_GI=on&PAGE=Proteins&PROGRAM=blastp&SERVICE=plain&SET_DEFAULTS.x=41&SET_DEFAULTS.y=5&SHOW_OVERVIEW=on&END_OF_HTTPGET=Yes&SHOW_LINKOUT=yes&GET_SEQUENCE=yes&QUERY="+selectedSeq);
	if (flag==2)
		browser.selectedTab = browser.addTab("http://www.ncbi.nlm.nih.gov/BLAST/Blast.cgi?CMD=Web&LAYOUT=TwoWindows&AUTO_FORMAT=Semiauto&ALIGNMENTS=50&ALIGNMENT_VIEW=Pairwise&CLIENT=web&DATABASE=nr&DESCRIPTIONS=100&ENTREZ_QUERY=%28none%29&EXPECT=10&FILTER=L&FORMAT_OBJECT=Alignment&FORMAT_TYPE=HTML&GENETIC_CODE=0&NCBI_GI=on&PAGE=Translations&PROGRAM=tblastn&SERVICE=plain&SET_DEFAULTS.x=23&SET_DEFAULTS.y=10&SHOW_OVERVIEW=on&UNGAPPED_ALIGNMENT=no&END_OF_HTTPGET=Yes&SHOW_LINKOUT=yes&GET_SEQUENCE=yes&QUERY="+selectedSeq);
	if (flag==3) 
		browser.selectedTab = browser.addTab("http://www.ncbi.nlm.nih.gov/BLAST/Blast.cgi?CMD=Web&LAYOUT=TwoWindows&AUTO_FORMAT=Semiauto&ALIGNMENTS=250&ALIGNMENT_VIEW=Pairwise&CLIENT=web&COMPOSITION_BASED_STATISTICS=on&DATABASE=nr&CDD_SEARCH=on&DESCRIPTIONS=500&ENTREZ_QUERY=%28none%29&EXPECT=10&FORMAT_OBJECT=Alignment&FORMAT_TYPE=HTML&I_THRESH=0.005&MATRIX_NAME=BLOSUM62&NCBI_GI=on&PAGE=Proteins&PROGRAM=blastp&RUN_PSIBLAST=on&SERVICE=plain&SET_DEFAULTS.x=36&SET_DEFAULTS.y=5&SHOW_OVERVIEW=on&END_OF_HTTPGET=Yes&SHOW_LINKOUT=yes&GET_SEQUENCE=yes&QUERY="+selectedSeq);
	}
}

function blat(selectedSeq, flag){
	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
	var browser = browserWindow.getBrowser();
	browser.selectedTab = browser.addTab("http://genome.ucsc.edu/cgi-bin/hgBlat?command=start");
}

function string_db(selectedSeq, flag){
	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
	var browser = browserWindow.getBrowser();
	if (selectedSeq.length < 1)
      	return;
	if (flag==0){
		browser.selectedTab = browser.addTab("http://string.embl.de/newstring_cgi/show_link_summary.pl?targetmode=proteins&sequence="+selectedSeq);
	} else {
		browser.selectedTab = browser.addTab("http://string.embl.de//newstring_cgi/show_link_summary.pl?targetmode=cogs&sequence="+selectedSeq);
	}
}

function pfam(selectedSeq, flag){
	selectedSeq=strip(selectedSeq);
	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
	var browser = browserWindow.getBrowser();
	if (selectedSeq.length < 1)
      	return;
	if (flag==0){
		browser.selectedTab = browser.addTab("http://pfam.sanger.ac.uk/search/sequence?seq="+selectedSeq);
	} else {
		browser.selectedTab = browser.addTab("http://www.sanger.ac.uk/cgi-bin/Pfam/querypfam.pl?loc=http://www.sanger.ac.uk/cgi-bin/Pfam&db=pfam&db=prosite&terms="+selectedSeq+"&size=100");
	}
}

function prosite(selectedSeq, flag){
	selectedSeq=strip(selectedSeq);
	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
	var browser = browserWindow.getBrowser();
	if (selectedSeq.length < 1)
      	return;
	browser.selectedTab = browser.addTab("http://us.expasy.org/cgi-bin/prosite/PSScan.cgi?skip=on&noprofile=1&maxhits=1000&display=nice&db=sp&seq="+selectedSeq);
}

function hydropathy(selectedSeq, frameNo){
	selectedSeq=strip(selectedSeq);
	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
	var browser = browserWindow.getBrowser();
	if (selectedSeq.length < 1)
      	return;
		browser.selectedTab = browser.addTab("http://fasta.bioch.virginia.edu/fasta_www2/fasta_www.cgi?rm=misc1&query="+selectedSeq);
}

function smart(selectedSeq, flag) {
	selectedSeq=strip(selectedSeq);
	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
	var browser = browserWindow.getBrowser();
	if (selectedSeq.length < 1)
      	return;
	browser.selectedTab = browser.addTab("http://smart.embl-heidelberg.de/smart/show_motifs.pl?INCLUDE_BLAST=true&DO_PFAM=true&INCLUDE_SIGNALP=true&DO_PROSPERO=true&DO_DISEMBL=true&SEQUENCE="+selectedSeq);
}


function protparam(selectedSeq, flag){
	selectedSeq=strip(selectedSeq);
	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
	var browser = browserWindow.getBrowser();
	if (selectedSeq.length < 1)
      	return;
	browser.selectedTab = browser.addTab("http://us.expasy.org/cgi-bin/protparam?sequence="+selectedSeq);
}

function kegg_db(selectedSeq, flag){
	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
	var browser = browserWindow.getBrowser();
	selectedSeq=strip(selectedSeq);
	if (selectedSeq.length < 1)
      	return;
	if (flag==0){
		browser.selectedTab = browser.addTab("http://blast.genome.jp/sit-bin/blast?prog=blastn&dbname=genes-nt&sequence="+selectedSeq);
	} else {
		browser.selectedTab = browser.addTab("http://blast.genome.jp/sit-bin/blast?prog=blastp&dbname=genesall&sequence="+selectedSeq);
	}
}

function countcodon(selectedSeq, frameNo){
	selectedSeq=strip(selectedSeq);
	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
	var browser = browserWindow.getBrowser();
	if (selectedSeq.length < 1)
      	return;
	browser.selectedTab = browser.addTab("http://www.kazusa.or.jp/codon/cgi-bin/countcodon.cgi?t=1&s="+selectedSeq);
}

function target(flag){
	var selectedSeq = window.getSelection().toString();
	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
	var browser = browserWindow.getBrowser();
	selectedSeq=strip(selectedSeq);
	if (selectedSeq.length < 1)
      	return;
		if (selectedSeq.charAt(0)!="M")
			selectedSeq="M"+selectedSeq;
		if (flag==0){
			browser.selectedTab = browser.addTab("http://urgi.versailles.inra.fr/predotar/test.seq?plastids=1&sequence="+selectedSeq);
			browser.selectedTab = browser.addTab("http://hc.ims.u-tokyo.ac.jp/iPSORT/predict.cgi?seqs="+selectedSeq+"&PROTEINTYPE=plant");
			browser.selectedTab = browser.addTab("http://psort.ims.u-tokyo.ac.jp/cgi-bin/okumura.pl?origin=animal&sequence="+selectedSeq+"&origin=plant");
		} 
		if (flag==1){
			browser.selectedTab = browser.addTab("http://urgi.versailles.inra.fr/predotar/test.seq?plastids=0&sequence="+selectedSeq);
			browser.selectedTab = browser.addTab("http://hc.ims.u-tokyo.ac.jp/iPSORT/predict.cgi?seqs="+selectedSeq+"&PROTEINTYPE=nonplant");
			browser.selectedTab = browser.addTab("http://psort.ims.u-tokyo.ac.jp/cgi-bin/okumura.pl?origin=animal&sequence="+selectedSeq+"&origin=animal");	
		}
}

function checkprot(selectedSeq){
	if ((selectedSeq.indexOf("b")!=-1)||(selectedSeq.indexOf("j")!=-1)||(selectedSeq.indexOf("o")!=-1)||(selectedSeq.indexOf("u")!=-1)||
	    (selectedSeq.indexOf("z")!=-1)||(selectedSeq.indexOf("x")!=-1)){ 
		return false;
	} else {
		return true;
	}
}

function checkdna(seq){
	if ((seq.indexOf("A")!=-1)||(seq.indexOf("T")!=-1)||(seq.indexOf("C")!=-1)||(seq.indexOf("G")!=-1)||(seq.indexOf("U")!=-1)){ 
		return true;
	}
}

function mol_wt(selectedSeq, flag){
	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
	var browser = browserWindow.getBrowser();
	selectedSeq=strip(selectedSeq);
	if (selectedSeq.length < 1)
      	return;
	browser.selectedTab = browser.addTab('http://www.expasy.org/cgi-bin/pi_tool?protein='+selectedSeq);
}

function swiss_model(selectedSeq, flag){
	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
	var browser = browserWindow.getBrowser();
	var title = "Structure_Prediction";
	if (selectedSeq.length < 1)
      	return;
	selectedSeq=strip(selectedSeq);
	if (biofoxPrefs.getCharPref('sEmail')=="") {
		selectedSeq="I am sorry but this feature requires a valid email address. Please go to <b>bioFOX options</b> and enter the details.";
		openWindow("about:blank", selectedSeq, 1);	
	} else {
		if (!(selectedSeq=="Contains Illegal chars")){
		      var tempEmail = biofoxPrefs.getCharPref('sEmail');
      		var tempFn = biofoxPrefs.getCharPref('sFirstname');
		      var tempLn = biofoxPrefs.getCharPref('sLastname');
			browser.selectedTab = browser.addTab("http://swissmodel.expasy.org//cgi-bin/sm-submit-request.cgi?FOC=F&FOC=F&FOC=P&FOC=P&blast=0.00001&results=Spdbv&NOATTACH=true&WHATCHECKreport=true&PREDICTPROTEIN=Never&FOLDREC=Never&email="+tempEmail+"&name="+tempFn+"&title="+title+"&remember=remember&sequence="+selectedSeq);
		} else {
			openWindow("about:blank", selectedSeq, 1);
		}
	}
}

function pssm(selectedSeq, flag){
	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
	var browser = browserWindow.getBrowser();
	var title = "Structure_Prediction";
	if (selectedSeq.length < 1)
      	return;
	selectedSeq=strip(selectedSeq);
	//selectedSeq=selectedSeq.toUpperCase();
	if (biofoxPrefs.getCharPref('sEmail')=="") {
		selectedSeq="I am sorry but this feature requires a valid email address. Please go to <b>bioFOX options</b> and enter the details.";
		openWindow("about:blank", selectedSeq, 1);	
	} else {
		if (!(selectedSeq=="Contains Illegal chars")){
		      var tempEmail = biofoxPrefs.getCharPref('sEmail');
			browser.selectedTab = browser.addTab("http://www.sbg.bio.ic.ac.uk/~3dpssm/scripts/3dpssm_submit.cgi?usr-email="+tempEmail+"&seq-desc=Structure_Prediction&seq_format=single&global_local=yes&seg=yes&DataFormat=yes&three_iter=no&sequence="+selectedSeq);
		} else {
			openWindow("about:blank", selectedSeq, 1);
		}
	}
}

function complement(selectedSeq, frameNo){
	if (selectedSeq.length < 1)
      	return;
	selectedSeq=strip(selectedSeq);
	selectedSeq=selectedSeq.toUpperCase();
	if(checkdna(selectedSeq)==true){
		selectedSeq=comp(selectedSeq);
		return selectedSeq;
	} else {
		selectedSeq="The sequence doesnt seem to be Nucleotide";
		return selectedSeq;
	}
}

function reverse(selectedSeq, frameNo){
	if (selectedSeq.length < 1)
      	return;
	selectedSeq=strip(selectedSeq);
	selectedSeq=selectedSeq.toUpperCase();
	if(checkdna(selectedSeq)==true){
		selectedSeq=rev(selectedSeq);
		return selectedSeq;
	} else {
		selectedSeq="The sequence doesnt seem to be Nucleotide";
		return selectedSeq;
	}
}

function revcomp(selectedSeq, frameNo){
	if (selectedSeq.length < 1)
      	return;
	selectedSeq=strip(selectedSeq);
	selectedSeq=selectedSeq.toUpperCase();
	if(checkdna(selectedSeq)==true){
		selectedSeq=rev(comp(selectedSeq, frameNo));
		return selectedSeq;
	} else {
		selectedSeq="The sequence doesnt seem to be Nucleotide";
		return selectedSeq;
	}
}

function comp(selectedSeq){
	selectedSeq=strip(selectedSeq);
	selectedSeq=selectedSeq.toUpperCase();
	selectedSeq = selectedSeq.replace(/G/g,"1");
	selectedSeq = selectedSeq.replace(/C/g,"2");
	selectedSeq = selectedSeq.replace(/1/g,"C");
	selectedSeq = selectedSeq.replace(/2/g,"G");	
	selectedSeq = selectedSeq.replace(/A/g,"1");
	selectedSeq = selectedSeq.replace(/T/g,"2");
	selectedSeq = selectedSeq.replace(/1/g,"T");
	selectedSeq = selectedSeq.replace(/2/g,"A");
	selectedSeq = selectedSeq.replace(/u/g,"a");
	selectedSeq = selectedSeq.replace(/U/g,"A");
	return selectedSeq;
}

function rev(selectedSeq){
	var revseq='';
   	for (i=selectedSeq.length-1; i>=0; i--){
      	revseq+=selectedSeq.charAt(i)
	}
	return revseq;
}

//function installbiobar() {
//   	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
//	var browser = browserWindow.getBrowser();
//	browser.selectedTab = browser.addTab('https://addons.mozilla.org/extensions/moreinfo.php?application=firefox&category=Search%20Tools&numpg=10&id=169');
//}

function workspace(){
	var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
	var browser = browserWindow.getBrowser();
	browser.selectedTab = browser.addTab("chrome://biofox/content/workspace.html");
}

function translateSeq(selectedSeq, frameNo){
	if (selectedSeq.length < 1)
      	return;
	var j="";
	var translatedSeq="";
	selectedSeq=strip(selectedSeq);
	if (frameNo>2){
		selectedSeq=rev(comp(selectedSeq));
		frameNo=-(3-frameNo);
		}
	for (var i=frameNo; i<(selectedSeq.length-2); i=i+3){
		codon = selectedSeq.substring(i,(i+3));
		codon = dnatoProt(codon);
		translatedSeq=translatedSeq+codon;
	}
	return translatedSeq;
}

function checkFasta(functionName, functionArg1){
	var selectedSeq = window.getSelection().toString();
	if (selectedSeq.length < 1)
      	return;
	var seq_arr=selectedSeq.split("\n");
	var seq_num=0;
	var tempseqholder="";
	var processedSeq="";
	var functionedSeq="";
	while (seq_num < seq_arr.length){
		var sequence = seq_arr[seq_num];
		if ( (sequence != null) || (sequence != "") ){
			if ( (sequence.indexOf(">") != -1) ){
				if (seq_num == 0) {processedSeq=processedSeq + seq_arr[seq_num]+"<br>";}
				if (tempseqholder!=""){
					functionedSeq = eval('functionName(tempseqholder,functionArg1)');
                                 if (functionName != stripSearch) 
					  	functionedSeq=showLines(100, functionedSeq);
					processedSeq=processedSeq + functionedSeq + "<br><br>";
					tempseqholder = "";
				}
				if (seq_num > 0) {processedSeq=processedSeq + seq_arr[seq_num]+"<br>";}
			} else {
				tempseqholder = tempseqholder + seq_arr[seq_num];
			}
			seq_num+=1;
		}
  	}
	functionedSeq = eval('functionName(tempseqholder,functionArg1)');
	if  (functionName!=stripSearch) {functionedSeq=showLines(100, functionedSeq); }
	processedSeq=processedSeq + functionedSeq + "<br>";
	if (functionName==stripSearch){
		openWindow("about:blank", processedSeq, 11); 
	} 
	else if ( (functionName==countcodon) || (functionName==blast) ||(functionName==mol_wt)||(functionName==blat) ||(functionName==pssm)||
		    (functionName==swiss_model)||(functionName==prosite)||(functionName==pfam)||(functionName==protparam)||(functionName==swiss_model)||
		    (functionName==string_db) ||(functionName==smart)||(functionName==hydropathy)||(functionName==kegg_db)) {
		//Do nothing
	} 
	else {
		openWindow("about:blank", processedSeq, 2); 
	}
}

function stripSearch(selectedSeq, frameNo){
	if (selectedSeq.length < 1)
      	return;
	selectedSeq=strip(selectedSeq);
	selectedSeq=selectedSeq.toUpperCase();
	var searchedSeq="";
	searchedSeq=selectedSeq + "<br>";
	for (var i=1; i<=((selectedSeq.length)/25); i++){
		var str=(i-1)*25;
		str=str.toString();
		if (((i-1)*25)%25==0){
		   if (str!='0'){searchedSeq=searchedSeq+str;}
			if (str.length==1){
			  for (var k=0; k<24; k++){
				searchedSeq=searchedSeq+"&nbsp;";
			  }
			}
			if (str.length==2){
			  for (var k=0; k<23; k++){
				searchedSeq=searchedSeq+"&nbsp;";
			  }
			}
			if (str.length==3){
			  for (var k=0; k<22; k++){
				searchedSeq=searchedSeq+"&nbsp;";
  			  }	
			}
			if (str.length==4){
			  for (var k=0; k<21; k++){
				searchedSeq=searchedSeq+"&nbsp;";
			  }
			}
			if (str.length==5){
			  for (var k=0; k<20; k++){
				searchedSeq=searchedSeq+"&nbsp;";
			  }
			}
		}
	}			
	return searchedSeq;
}
