;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/expdsrfi0.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Feb 24 15:25:03 1999                          */
;*    Last change :  Wed May 21 11:45:49 2003 (serrano)                */
;*    Copyright   :  2001-03 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The expander for srfi forms.                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __expander_srfi-0
   
   (import  __error
	    __bigloo
	    __tvector
	    __structure
	    __tvector
	    __bexit
	    
	    __r4_numbers_6_5
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_characters_6_6
	    __r4_equivalence_6_2
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_strings_6_7
	    __r4_pairs_and_lists_6_3
	    __r4_input_6_10_2
	    __r4_control_features_6_9
	    __r4_vectors_6_8
	    __r4_ports_6_10_1
	    __r4_output_6_10_3
	    
	    __progn)
   
   (use     __type
	    __evenv)
   
   (export  (expand-cond-expand x e)
	    (register-eval-srfi! ::symbol)))

;*---------------------------------------------------------------------*/
;*    bigloo-major-version ...                                         */
;*---------------------------------------------------------------------*/
(define-macro (bigloo-major-version)
   `',(string->symbol
       (string-append "bigloo"
		      (substring *bigloo-version*
				 0
				 (-fx (string-length *bigloo-version*) 1)))))
					     

;*---------------------------------------------------------------------*/
;*    bigloo-version ...                                               */
;*---------------------------------------------------------------------*/
(define-macro (bigloo-version)
   `',(string->symbol (string-append "bigloo" *bigloo-version*)))

;*---------------------------------------------------------------------*/
;*    *srfi-eval-list* ...                                             */
;*    -------------------------------------------------------------    */
;*    The list of supported srfi by the interpreter                    */
;*    -------------------------------------------------------------    */
;*    The four initial supported srfi are:                             */
;*       - srfi-0                                                      */
;*       - srfi-xxx                                                    */
;*       - ...                                                         */
;*       - srfi-xxx                                                    */
;*       - bigloo                                                      */
;*       - bigloo<major-num>                                           */
;*       - bigloo<major-num><minor-num>                                */
;*    -------------------------------------------------------------    */
;*    When a library is used for compiling the name of that library    */
;*    is added to the supported srfis.                                 */
;*    -------------------------------------------------------------    */
;*    @label srfi-eval-list@                                           */
;*    This list mirrors the one defined in                             */
;*    comptime/Expand/srfi-0.scm.                                      */
;*    @ref ../../comptime/Expand/srfi-0.scm:srfi-list@                 */
;*---------------------------------------------------------------------*/
(define *srfi-eval-list*
   (cons* (bigloo-version)
	  (bigloo-major-version)
	  '(bigloo-eval bigloo srfi-0 srfi-2 srfi-6 srfi-8 srfi-9 srfi-22 srfi-28 srfi-30)))

;*---------------------------------------------------------------------*/
;*    register-eval-srfi! ...                                          */
;*---------------------------------------------------------------------*/
(define (register-eval-srfi! srfi::symbol)
   (set! *srfi-eval-list* (cons srfi *srfi-eval-list*)))

;*---------------------------------------------------------------------*/
;*    expand-cond-exapnd ...                                           */
;*---------------------------------------------------------------------*/
(define (expand-cond-expand x e)
   (match-case x
      ((cond-expand)
       (error "cond-expand" "Illegal form" x))
      ((?- ?clause . ?else)
       (match-case clause
	  (((kwote else) . ?body)
	   (if (null? else)
	       (e (epairify `(begin ,@body) x) e)
	       (error "cond-expand" "Illegal form" x)))
	  ((((kwote and)) . ?body)
	   (e (epairify `(begin ,@body) x) e))
	  ((((kwote and) ?req1) . ?body)
	   (e (epairify `(cond-expand
			    (,req1 ,@body)
			    ,@else)
			x)
	      e))
	  ((((kwote and) ?req1 ?req2 . ?reqs) . ?body)
	   (expand-cond-expand-and x e req1 req2 reqs body else))
	  ((((kwote or)) . ?body)
	   (e (epairify `(cond-expand ,@else) x) e))
	  ((((kwote or) ?req1) . ?body)
	   (e (epairify `(cond-expand
			    (,req1 ,@body)
			    ,@else)
			x)
	      e))
	  ((((kwote or) ?req1 ?req2 . ?reqs) . ?body)
	   (expand-cond-expand-or x e req1 req2 reqs body else))
	  ((((kwote not) ?req) . ?body)
	   (e (epairify `(cond-expand
			    (,req (cond-expand ,@else))
			    (else ,@body))
			x)
	      e))
	  (((and (? symbol?) ?feature) . ?body)
	   (e (epairify (if (memq feature *srfi-eval-list*)
			    `(begin ,@body)
			    `(cond-expand ,@else))
			x)
	      e))
	  (else
	   (error "cond-expand" "Illegal form" x))))
      (else
       (error "cond-expand" "Illegal form" x))))

;*---------------------------------------------------------------------*/
;*    expand-cond-expand-and ...                                       */
;*---------------------------------------------------------------------*/
(define (expand-cond-expand-and x e req1 req2 reqs body else)
   (e (epairify `(cond-expand
		    (,req1 (cond-expand
			      ((and ,req2 ,@reqs) ,@body)
			      ,@else))
		    ,@else)
		x)
      e))

;*---------------------------------------------------------------------*/
;*    expand-cond-expand-or ...                                        */
;*---------------------------------------------------------------------*/
(define (expand-cond-expand-or x e req1 req2 reqs body else)
   (let ((bd (gensym 'body)))
      (e (epairify `(let ((,bd ,(epairify `(begin ,@body) body)))
		       (cond-expand
			  (,req1 ,bd)
			  (else
			   (cond-expand
			      ((or ,req2 ,@reqs)
			       ,bd)
			      ,@else))))
		   x)
	 e)))

;*---------------------------------------------------------------------*/
;*    epairify ...                                                     */
;*    -------------------------------------------------------------    */
;*    If the struct definition was an extended pair (that is if we     */
;*    were tracking the source location of the structure), we          */
;*    propagate inside the generated function, the define-struct       */
;*    location.                                                        */
;*---------------------------------------------------------------------*/
(define (epairify pair epair)
   (if (epair? epair)
       (econs (car pair) (cdr pair) (cer epair))
       pair))
