/** 
 * @namespace   biewlib
 * @file        biewlib/sysdep/generic/unix/os_dep.c
 * @brief       This file contains implementation of unix compatible OS dependent part.
 * @version     -
 * @remark      this source file is part of Binary vIEW project (BIEW).
 *              The Binary vIEW (BIEW) is copyright (C) 1995 Nick Kurshev.
 *              All rights reserved. This software is redistributable under the
 *              licence given in the file "Licence.en" ("Licence.ru" in russian
 *              translation) distributed in the BIEW archive.
 * @note        Requires POSIX compatible development system
 *
 * @author      Konstantin Boldyshev
 * @since       1999
 * @note        Development, fixes and improvements
**/

/* $Id: os_dep.c,v 1.2 2000/10/29 09:17:15 konst Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "biewlib/biewlib.h"
#include "console.h"

#define LIBDIR "/usr/lib"

static char _ini_name[FILENAME_MAX + 1];
static char _rc_dir_name[FILENAME_MAX + 1];

int terminal = TERM_UNKNOWN, transparent = 0;

static struct {
    char *name;
    char type;
} termtab[] = {
{ "linux",	TERM_LINUX },
{ "console",	TERM_LINUX },
{ "xterm",	TERM_XTERM },
{ "xterm-color", TERM_XTERM },
{ "color-xterm", TERM_XTERM },
{ "beterm",	TERM_XTERM },
{ "vt100",	TERM_VT100 },
{ "ansi",	TERM_ANSI },
{ NULL,		TERM_UNKNOWN}};

/*

*/

char * __FASTCALL__ __get_ini_name(const char *progname)
{
    char *p;

    if ((p = getenv("HOME")) == NULL || strlen(p) > FILENAME_MAX - 10)
	strcpy(_ini_name, "/tmp");
    else
	strcpy(_ini_name, p);

    strcat(_ini_name, "/.");
    strcat(_ini_name, progname);
    strcat(_ini_name, "rc");

    return _ini_name;
}

char * __FASTCALL__ __get_rc_dir(const char *progname)
{
  strcpy(_rc_dir_name, LIBDIR"/");
  strcat(_rc_dir_name, progname);
  strcat(_rc_dir_name, "/");
  return _rc_dir_name;
}


static void cleanup(int sig)
{
	__term_keyboard();
	__term_vio();
	__term_sys();
	printm("Terminated by signal %d\n", sig);
	_exit(1);
}

void __FASTCALL__ __OsYield(void)
{
/*
	usleep(10000);
*/
#ifdef	__BEOS__
#else
	struct timespec t = { 0, 100000 };
	nanosleep(&t, NULL);
#endif
}

/* static struct sigaction sa; */

void __FASTCALL__ __init_sys(void)
{
    int i = 0;
    char *t = getenv("TERM");

    if (t != NULL) for (i = 0; termtab[i].name != NULL && strcasecmp(t, termtab[i].name); i++);
    terminal = termtab[i].type;
    if (terminal == TERM_XTERM) {
	t = getenv("COLORTERM");
	if (t != NULL && !strcasecmp(t, "Eterm")) transparent = 1;
    }
#ifdef _VT100_
    if (terminal == TERM_UNKNOWN) {
        printm("\nSorry, I can't handle terminal type '%s'.\nIf you are sure it is vt100 compatible, try setting TERM to vt100:\n\n$ TERM=vt100 biew filename\n\nIf you will not succeed, use slang/curses version of BIEW.\n\n", t);
        exit(2);
    }
#endif
    umask(0077);
    signal(SIGTERM, cleanup);
    signal(SIGINT,  cleanup);
    signal(SIGQUIT, cleanup);
    signal(SIGILL, cleanup);
/*
    sa.sa_handler = cleanup;
    sigaction(SIGTERM, &sa, NULL);
    sigaction(SIGINT, &sa, NULL);
    sigaction(SIGQUIT, &sa, NULL);
    sigaction(SIGILL, &sa, NULL);
*/
}

void __FASTCALL__ __term_sys(void)
{
}
