%define topdir %(pwd)/rpmbuild
%define _topdir %{topdir} 
Summary: bdii
Name: bdii
Version:  4.0.1
Vendor: LCG
Release: 2
License: LCG
Group: LCG
Source: %{name}.src.tgz
BuildArch: noarch
Requires: openldap-clients
Requires: openldap-servers
Requires: perl-libwww-perl
Obsoletes: lcg-bdii
Prefix: /opt/bdii
BuildRoot: %{_tmppath}/%{name}-%{version}-build
Packager: LCG

%description
BDII is an "Information Index" based on a standard OpenLDAP server.

%prep

%setup -c

%build
make install prefix=%{buildroot}%{prefix}

%post
if [ $1 -eq 1 -a -d "/etc/rc.d/init.d" ]; then
    ln -s ${RPM_INSTALL_PREFIX}/sbin/bdii /etc/rc.d/init.d/bdii
fi
${RPM_INSTALL_PREFIX}/sbin/bdii condrestart || true

%preun
if [ $1 -eq 0 ]; then
    ${RPM_INSTALL_PREFIX}/sbin/bdii stop || true
fi

%postun
# this is the final remove case
if [ $1 -eq 0 -a -L "/etc/rc.d/init.d/bdii" ]; then
    rm -f /etc/rc.d/init.d/bdii
fi
# This is the upgrade case, when the previous
# package contained the symlink as a file.
if [ $1 -eq 1 -a ! -L "/etc/rc.d/init.d/bdii" ]; then
    ln -s ${RPM_INSTALL_PREFIX}/sbin/bdii /etc/rc.d/init.d/bdii
fi

%files
%defattr(-,root,root)
%dir %{prefix}
%dir %{prefix}/etc
%config %{prefix}/etc/bdii.conf
%config %{prefix}/etc/bdii-update.conf
%config %{prefix}/etc/glue-slapd.conf
%config %{prefix}/etc/BDII.schema
%config %{prefix}/etc/DB_CONFIG
%config %{prefix}/etc/default.ldif
%dir %{prefix}/doc
%{prefix}/doc/README
%dir %{prefix}/bdii/man
%dir %{prefix}/bdii/man/man5
%{prefix}/bdii/man/man5/bdii.5
%dir %{prefix}/bdii/man/man8
%{prefix}/bdii/man/man8/bdii.8
%dir %{prefix}/sbin
/etc/logrotate.d/bdii
%{prefix}/sbin/bdii
%{prefix}/sbin/bdii-fwd
%{prefix}/sbin/bdii-proxy
%{prefix}/sbin/bdii-update
/var/bdii
/var/log/bdii

%clean
rm -rf %{buildroot}
