#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Simple file-diff tla compatibilty tests
# Copyright © 2003 Colin Walters <walters@verbum.org>
#             2004 Canonical Ltd
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_tla_archives

test_class "file-diff (tla)"

setup () {
  tla get jane@example.com--2003/hello-world--mainline--1.0 hello-world
  cd hello-world
}  

cleanup () {
  :
}

do_file_diffs () {
  tla file-diff "$@" || test "$?" = 1
}

begin_test "diffs for unmodified file"
setup
do_file_diffs hello-world.c > ../hello-world.patch || test_fail "could not diff hello-world.c"
file_is_empty ../hello-world.patch || test_fail "hello-world.c patch is not empty"
cleanup
end_test

begin_test "diffs for single file modification"
setup
sed -e 's/Hello world/Hello, world/' < hello-world.c > hello-world.c.new
mv hello-world.c.new hello-world.c
do_file_diffs hello-world.c > ../hello-world.patch
file_matches '^-.*Hello world' ../hello-world.patch
file_matches '^\+.*Hello, world' ../hello-world.patch
cleanup
end_test 

begin_test 'diff | patch -R => identity'
setup
cd ..
copy_tree hello-world hello-world.good
cd hello-world
sed -e 's/Hello world/Hello, world/' < hello-world.c > hello-world.c.new
mv hello-world.c.new hello-world.c
patch_prog=$("$srcroot/build-tools/scripts/option" gnu-patch)
do_file_diffs hello-world.c | $patch_prog -p1 -R
cd ..
assert_trees_equal hello-world hello-world.good
cleanup
end_test 

clean_workdir

# tag: Colin Walters Wed, 17 Sep 2003 18:55:57 -0400 (test-file-diffs.sh)
#
