Template: apt-setup/security-updates-failed
Type: note
Description: Cannot access security updates.
 I cannot access the security updates on security.debian.org, so those
 updates will not be made available to you at this time. You may want to
 invesitgate this later.. Commented out entries for security.debian.org
 have been added to the bottom of /etc/apt/sources.list . The error message
 I received from apt was:
 .
 ${apt_error}
Description-ru:     .
         security.debian.org, 
      .    
   .   /etc/apt/sources.list   
 ,   security.debian.org.    , 
  apt:
 .
 ${apt_error}

Template: apt-setup/badsource
Type: note
Description: Failed to access the Debian archive
 When I tried to access the debian archive using the information you
 provided, apt gave the following error. I will run through the questions
 again, try to correct the error. 
 .
 ${apt_error} 
Description-ru:     Debian
        Debian, apt  
 .     ,     .
 .
 ${apt_error} 

Template: apt-setup/cd/dev
Type: string
Description: Enter CD ROM device file:
 This program was unable to auto-detect a CD ROM drive, or there is no
 usable CD in the drive. Enter the device file to use to access your CD
 ROM, and place a Debian CD in the drive. 
Description-ru:     CD-ROM
       CD-ROM,  
 .    ,    
   CD-ROM   Debian CD  .

Template: apt-setup/directory
Type: string
Default: /debian
Description: Enter mirror directory:
 Enter the directory the Debian mirror is located in. 
Description-ru:    :
  ,     Debian

Template: apt-setup/non-free
Type: boolean
Default: false
Description: Use non-free software?
 Some non-free software has been made to work with Debian. Though this
 software is not at all a part of Debian, standard Debian tools can be 
 used to install it. This software has varying licenses which may prevent
 you from using, modifying, or sharing it. Do you want to have it available
 anyway?
Description-ru:    ?
         Debian. 
       Debian,   Debian 
  .      ,
      ,   
   .  -     ?

Template: apt-setup/cd/another
Type: boolean
Default: false
Description: Scan another CD?
 If you have another Debian CD (for example, the second in a two CD set),
 you should insert and scan it now. 
Description-ru:   CD?
      Debian CD (,    ),
      .

Template: apt-setup/another
Type: boolean
Default: false
Description: Add another apt source?
 Apt is now configured, and should be able to install Debian packages.
 However, you may want to add another source to apt, so it can download
 packages from more than one location.
Description-ru:    apt?
  apt       Debian. 
       apt,    
   ,   .

Template: apt-setup/distribution
Type: select
Choices: stable, unstable, testing
Default: stable
Description: Select Debian distribution to use:
 Debian comes in several flavors. Stable is well-tested and rarely changes.
 Unstable is untested and frequently changing. Testing is a middle ground,
 that receives many of the new versions from unstable if they are not too
 buggy. Which version of Debian do you wish to install?
Choices-ru: , , 
Description-ru:    Debian  :
 Debian    .  (stable) - 
    .  (unstable) - 
   .  (testing) -   - ,
        ,    
  .    Debian   ?

Template: apt-setup/badedit
Type: select
Choices: edit, revert to backup
Description: What do you want to do?
 The entries you made in sources.list did not work. Here is the error
 message from apt: 
 .
 ${apt_error} 
 .
 I have a backup of the sources.list from before you edited it. Should I
 revert to that backup, or would you like to edit the existing file and fix
 it? 
Choices-ru: ,    
Description-ru:    ?
    sources.list  . apt   :
 .
 ${apt_error} 
 .
       sources.list.   
    ,     
  ?

Template: apt-setup/uri_type
Type: select
Choices: cdrom, http, ftp, filesystem, edit sources list by hand
Default: cdrom
Description: Choose the method apt should use to access the Debian archive:
 Apt can access the Debian archive in a variety of ways. Choose the access
 method apt should use. For example if you have a Debian cd, select
 "cdrom", while if you plan to install via a Debian mirror, choose "ftp" or
 "http". 
 .
 ${note} 
Choices-ru: -, http, ftp,  ,   
Description-ru:    apt   Debian:
 Apt     Debian  .  
  . ,    - Debian,  
 "-",      Debian,   "ftp"
  "http".
 .
 ${note} 

Template: apt-setup/hostname
Type: string
Description: Enter mirror hostname:
 Enter the hostname of the Debian mirror you want to use. 
Description-ru:    :
     Debian,    .

Template: apt-setup/contrib
Type: boolean
Default: false
Description: Use contrib software?
 Some additional software has been made to work with Debian. Though this
 software is free, it depends on non-free software for its operation. This
 software is not at all a part of Debian, but standard Debian  tools can be
 used to install it. Would you like to have it available?
Description-ru:  contrib ?
    Debian   .   
 ,        
 .         Debian,
   Debian   .    
   ?

Template: apt-setup/non-us-failed
Type: note
Description: Cannot access non-US software.
 I cannot access the Debian archive site that contains non-US software, so
 that software will not be made available to you. The error message I
 received from apt was: 
 .
 ${apt_error} 
Description-ru:    - (non-US)  .
       Debian,   non-US , 
     .    , 
  apt:
 .
 ${apt_error}

Template: apt-setup/mirror
Type: select
Choices: ${mirrors}
Default: http.us.debian.org
Description: Choose the Debian mirror to use:
 Select the Debian mirror apt should use. You should select a mirror that
 is close to you on the net. 
Choices-ru: ${mirrors}
Description-ru:    Debian:
   Debian,    apt.  
       .

Template: apt-setup/cd/bad
Type: note
Description: Bad CD
 Your CD drive was detected, but it does not seem to have a Debian CD in
 it. 
Description-ru:   -.
  ,   -   Debian.

Template: apt-setup/not-mirror
Type: note
Description: Mirror not found.
 The directory you entered does not contain a subdirectory named "dists",
 so it doesn't seem to be a Debian mirror. 
Description-ru:   .
 ,   ,      "dists",
 , ,    Debian.

Template: apt-setup/baddir
Type: note
Description: Mirror not found.
 The directory you entered does not exist. 
Description-ru:   .
 ,   ,  .

Template: apt-setup/http_proxy
Type: string
Description: Enter http proxy information, or leave blank for none:
 If you need to use a http proxy to access the outside world, enter the
 proxy information here. Otherwise, leave this blank. 
 .
 When entering proxy information, use the standard form of
 "http://[[user][:pass]@]host[:port]"
Description-ru:    http-,     :
        ,   
   . ,   .
 .
         :
 "http://[[][:]@][:]"

Template: apt-setup/non-us
Type: boolean
Default: true
Description: Use non-US software?
 Some software in Debian must be downloaded from sites outside the United
 States. This includes some cryptographic software, and some software with
 patent problems in the US. Do you want this software to be made available
 to you? 
Description-ru:  non-US  ?
    Debian       .  
     ,   , 
     .     ?

Template: apt-setup/security-updates
Type: boolean
Default: true
Description: Use security updates from security.debian.org?
 Debian provides timely security updates via the website
 http://security.debian.org/ . Should these updates be tracked each time
 you upgrade your system? If you are on the internet, this is generally a
 good idea.
Description-ru:      security.debian.org?
 Debian      -
 http://security.debian.org/ .       
  ?      ,  
   .

Template: apt-setup/country
Type: select
Choices: ${countries}
Default: United States
Description: Select a country:
 Select the country the mirror should be in. The goal is to find a mirror
 that is close to you on the network -- be aware that near countries, or
 even your own, may not be the best choice. 
Choices-ru: ${countries}
Description-ru:  :
  ,    . 
