#ifndef _GLOBALS_H_
#define _GLOBALS_H_
/*
 * asmail is the AfterStep mailbox monitor
 * Copyright (c) 2002-2005 Albert Dorofeev <albert@tigr.net>
 * For the updates see http://www.tigr.net/
 *
 * This software is distributed under GPL. For details see LICENSE file.
 */

#include <pthread.h>

#define VERSION "1.8"
#define RCFILE ".asmailrc"
/* Watch out! The MAX_INPUT_LENGTH must be a multiple of 64! */
#define MAX_INPUT_LENGTH 255

#define pthread_attr_default NULL

struct pixfile {
	char name[MAX_INPUT_LENGTH+1];
	struct pixfile * next;
};

struct x11_set_struct {
	pthread_t thread;
	int argc;
	char **argv;
	int beep;
	int shape;
	int use_frame;
	int withdrawn;
	int iconic;
	char geometry[MAX_INPUT_LENGTH+1];
	char title[MAX_INPUT_LENGTH+1];
	char on_left[MAX_INPUT_LENGTH+1];
	char on_middle[MAX_INPUT_LENGTH+1];
	char on_right[MAX_INPUT_LENGTH+1];
	char on_new_mail[MAX_INPUT_LENGTH+1];
	int each;
	int total;
	int status;
	int old;
	int new;
	int x;
	int y;
	char delimiter[MAX_INPUT_LENGTH+1];
	char color[MAX_INPUT_LENGTH+1];
	char font[MAX_INPUT_LENGTH+1];
	int refresh;
	struct pixfile * nomail;
	struct pixfile * oldmail;
	struct pixfile * newmail;
	struct pixfile * frame;
};

/* Mailbox flags */
#define FLAG_DEFAULT		0
#define FLAG_UNREAD_AS_NEW	1
#define FLAG_ARRIVED		2
#define FLAG_USE_MH_SEQ		4
#define FLAG_PERSISTENT_CONN	8
/* Mailbox types */
#define MBOX_FILE	1
#define MBOX_DIR	2
#define MBOX_POP3	3
#define MBOX_IMAP	4
#define MBOX_MH		5
/* Mailbox status */
#define STAT_IDLE	0
#define STAT_RUN	1
#define STAT_FAIL	2
#define STAT_CONN	4
#define STAT_LOGIN	8
#define STAT_TIMEOUT	16
/* Mailbox new mail status */
#define MAIL_NONE	0
#define MAIL_OLD	1
#define MAIL_NEW	2
/* Allowed ways to authorize user */
#define AUTH_NONE	0
#define AUTH_PLAIN	1
#define AUTH_MD5	2

struct mbox_struct {
	pthread_t thread;
	pthread_mutex_t mutex; /* used to protect data written by 2 threads */
	int type;
	int flags;
	char file[MAX_INPUT_LENGTH+1];
	char server[MAX_INPUT_LENGTH+1];
	char user[MAX_INPUT_LENGTH+1];
	char pass[MAX_INPUT_LENGTH+1];
	char mbox[MAX_INPUT_LENGTH+1];
	int auth;
	int port;
	int timeout; /* seconds */
	int update;
	int status;
	int mail;
	int ctotal;
	int cnew;
	struct mbox_struct * next;
};

extern char config_file_name[MAX_INPUT_LENGTH+1];
extern int flag_verbose;
extern int flag_allow_insecure;
extern int flag_no_x;
extern int flag_no_config;
extern int flag_config_specified;
extern struct x11_set_struct x11_set;
extern struct mbox_struct * mbox;

/*
 * This is used to signal that the update of mailbox status occured
 */
extern pthread_mutex_t update_lock;
extern pthread_cond_t update_cv;
extern int update_count;

void signal_update();
/* returns 1 if signalled, 0 if timed out */
int sleep_update(const int msec);

/* Used to lock the MD5 calculation library */
extern pthread_mutex_t md5_lock;

/*
 * This is used to signal to all mailbox monitor threads that
 * they need to verify the mailboxes right away.
 */
extern pthread_mutex_t check_lock;
extern pthread_cond_t check_cv;
extern int check_count;

void signal_check();
/* returns 1 if signalled, 0 if timed out */
int sleep_check(const int sec);

#endif

