/* <!-- copyright */
/*
 * aria2 - The high speed download utility
 *
 * Copyright (C) 2006 Tatsuhiro Tsujikawa
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */
/* copyright --> */
#ifndef _D_TORRENT_DOWNLOAD_ENGINE_H_
#define _D_TORRENT_DOWNLOAD_ENGINE_H_

#include "DownloadEngine.h"
#include "TimeA2.h"
#include "BtContext.h"
#include "BtRuntime.h"
#include "PieceStorage.h"
#include "PeerStorage.h"
#include "BtAnnounce.h"
#include "BtProgressInfoFile.h"

class TorrentDownloadEngine : public DownloadEngine {
private:
  bool filenameFixed;

  void initStatistics();
  void calculateStatistics();
protected:
  Time cp;
  Time lastCalcStat;
  int downloadSpeed;
  int uploadSpeed;
  long long int selectedDownloadLengthDiff;
  long long int selectedTotalLength;
  // The time when startup
  Time startup;
  // The average speed(bytes per second) since startup
  int avgSpeed;
  // The estimated remaining time to complete the download.
  int eta;
  long long int downloadLength;
  long long int uploadLength;
  long long int totalLength;

  BtContextHandle btContext;
  BtRuntimeHandle btRuntime;
  PieceStorageHandle pieceStorage;
  PeerStorageHandle peerStorage;
  BtAnnounceHandle btAnnounce;
  BtProgressInfoFileHandle btProgressInfoFile;

  int calculateSpeed(long long int sessionLength, int elapsed);
  void calculateStat();

  virtual void onEndOfRun();
  virtual void sendStatistics() = 0;
public:
  TorrentDownloadEngine();
  virtual ~TorrentDownloadEngine();

  bool isFilenameFixed() const { return filenameFixed; }

  void setBtContext(const BtContextHandle& btContext);
};

#endif // _D_TORRENT_DOWNLOAD_ENGINE_H_
