# push-new-revisions.sh: send email notices about new revisions
# 
################################################################
# Copyright (C) 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

command_line="$*"

################################################################
# special options
# 
# Some options are special:
# 
#       --version | -V
#       --help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
                printf "send email notices about new revisions\\n"
                printf "usage: push-new-revisions [options] recipient archive/version revision ..."
                printf "\\n"
                printf " -V --version                  print version info\\n"
                printf " -h --help                     display help\\n"
                printf "\\n"
		printf "Invoke:\\n"
		printf "\\n"
		printf "	larch push-mirror ARCHIVE RECIPIENT VERSION\\n"
		printf "\\n"
                exit 0
                ;;

      *)
                ;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

while test $# -ne 0 ; do

  case "$1" in 

    --)			shift
    			break
			;;

    -*)                 printf "push-new-revisions: unrecognized option (%s)\\n" "$1" 1>&2
                        printf "try --help\\n" 1>&2
                        exit 1
                        ;;

    *)                  break
                        ;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -lt 3 ; then
  printf "usage: push-new-revisions [options] recipient version branch ..." 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

recipient="$1"
shift

version="$1"
shift


################################################################
# Push
# 

from_archive="`larch parse-package-name --arch \"$version\"`"
version="`larch parse-package-name --package-version \"$version\"`"
larch push-mirror "$from_archive" "$recipient" "$version"

# tag: Tom Lord Wed Jan 23 15:56:08 2002 (notify/push-new-revisions.sh)
#
