# mail-new-categories.sh: send email notices about new categories
# 
################################################################
# Copyright (C) 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

command_line="$*"

################################################################
# special options
# 
# Some options are special:
# 
#       --version | -V
#       --help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
                printf "send email notices about new categories\\n"
                printf "usage: mail-new-categories [options] recipient archive category ..."
                printf "\\n"
                printf " -V --version                  print version info\\n"
                printf " -h --help                     display help\\n"
                printf "\\n"
		printf "Send an email notice to RECIPIENT about the newly created\\n"
                printf "CATEGORIES.\\n"
		printf "\\n"
                exit 0
                ;;

      *)
                ;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

while test $# -ne 0 ; do

  case "$1" in 

    --)			shift
    			break
			;;

    -*)                 printf "mail-new-categories: unrecognized option (%s)\\n" "$1" 1>&2
                        printf "try --help\\n" 1>&2
                        exit 1
                        ;;

    *)                  break
                        ;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -lt 3 ; then
  printf "usage: mail-new-categories [options] recipient archive category ..." 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

recipient="$1"
shift

archive="$1"
shift


################################################################
# Send Email
# 

( printf "\\n" ; \
  printf "New categories created in %s\\n" "$archive" ; \
  printf "\\n" ; \
  for c in "$@" ; do \
    printf "    %s\\n" "$c" ; \
  done ; \
  printf "\\n" ; \
  printf "\\n" ; \
  printf "regards,\\n" ; \
  printf "\"larch mail-new-categories\"\\n" ; \
  printf "\\n" ) \
| $ARCH_MAILER -s "Changes to archive $archive" "$recipient"


# tag: Tom Lord Sun Jan 20 04:48:17 2002 (notify/mail-new-categories.sh)
#
