# 
# delete-pristine.sh: remove a pristine trees from a project tree
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "remove a pristine trees from a project tree\\n"
		printf "usage: delete-pristine [options] [archive/]revision\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " -R --root root                specify the local archive root\\n"
		printf " -A --archive archive          specify the archive name\\n"
		printf "\\n"
                printf " -d --dir DIR                  cd to DIR first\\n"
		printf "\\n"
		printf "Delete the cached pristine revision REVISION from DIR (or the\\n"
		printf "current directory)."
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

archroot=
archive=
dir=.

while test $# -ne 0 ; do

  case "$1" in 

    -d|--dir)		shift
			if test $# -eq 0 ; then
			  printf "delete-pristine: -d and --dir require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			dir="$1"
			shift
			;;

    -R|--root)		shift
    			if test $# -eq 0 ; then
			  printf "delete-pristine: -R and --root require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			archroot="$1"
			shift
			;;

    -A|--archive)	shift
    			if test $# -eq 0 ; then
			  printf "delete-pristine: -A and --archive require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			archive="$1"
			shift
			;;

    --)			shift
    			break
			;;


    -*)			printf "delete-pristine: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;


    *)			break
    			;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 1 ; then
  printf "usage: delete-pristine [options] [archive/]revision\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

archive_revision="$1"
shift

################################################################
# Sanity Check and Process Defaults
# 

cd "$dir"
dir="`pwd`"

cd "$dir"
wdroot="`larch tree-root`"

larch valid-package-name -e delete-pristine --lvl "$archive_revision"
archive="`larch parse-package-name -R \"$archroot\" -A \"$archive\" --arch \"$archive_revision\"`"
revision="`larch parse-package-name -R \"$archroot\" -A \"$archive\" --non-arch \"$archive_revision\"`"
category="`larch parse-package-name -R \"$archroot\" -A \"$archive\" --basename \"$archive_revision\"`"
branch="`larch parse-package-name -R \"$archroot\" -A \"$archive\" --package \"$archive_revision\"`"
version="`larch parse-package-name -R \"$archroot\" -A \"$archive\" --package-version \"$archive_revision\"`"


################################################################
# Delete It
# 

tmpdir="$wdroot/,,junk--delete-pristine--$$"

cd "$wdroot/{arch}/++pristine-trees/unlocked/$category/$branch/$version/$archive"
if test -e $revision ; then
  mv $revision "$tmpdir"
  rm -rf "$tmpdir"
fi

# tag: Tom Lord Mon Dec 10 23:29:52 2001 (local-cache/delete-pristine.sh)
#
