# library-archives.sh: list the archives in the revision library
# 
################################################################
# Copyright (C) 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#       --version | -V
#       --help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
                printf "list the archives in the revision library\\n"
                printf "usage: library-archives [options]"
                printf "\\n"
                printf " -V --version                  print version info\\n"
                printf " -h --help                     display help\\n"
                printf "\\n"
                printf " -r --reverse                  reverse the listing\\n"
                printf "\\n"
		printf "List all archives with records in the revision library.\\n"
		printf "\\n"
                exit 0
                ;;

      *)
                ;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

reverse=

while test $# -ne 0 ; do

  case "$1" in 

    -r|--reverse)	shift
    			reverse=-r
			;;

    -*)                 printf "library-archives: unrecognized option (%s)\\n" "$1" 1>&2
                        printf "try --help\\n" 1>&2
                        exit 1
                        ;;

    *)                  break
                        ;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 0 ; then
  printf "usage: library-archives [options]" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

################################################################
# Sanity Check and Process Defaults
# 

library="`larch my-revision-library -e library-archives`"


################################################################
# Do It
# 

cd "$library"

for f in `ls | sort $reverse` ; do
  if larch valid-archive-name "$f" ; then
    printf "%s\\n" "$f"
  fi
done


# tag: Tom Lord Sun Jan 20 00:38:00 2002 (library/library-archives.sh)
#
