# 
# missing-tags.sh - list files missing tags
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "list files missing inventory tags\\n"
		printf "usage: missing-tags [options] [dir]\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " --files                        list files only\\n"
		printf " --directories                  list files only\\n"
		printf "\\n"
		printf "List files missing inventory tags.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

type=

while test $# -ne 0 ; do

  case "$1" in 

    --directories)	shift
			type=--directories
			;;

    --files)		shift
			type=--files
			;;

    -*)			printf "missing-tags: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -gt 1 ; then
  printf "usage: missing-tags [options] [dir]\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

if test $# -eq 1 ; then
  dir="$1"
  shift
else
  dir="."
fi

cd "$dir"
dir="`pwd`"


################################################################
# Proces Defaults
# 


################################################################
# Do It
# 

cd "$dir"

larch inventory --source $type --tags | grep -E -e "^[^[:space:]]*[[:space:]]+-\$" | sed -e "s/[[:space:]].*//"
