# archive-readme.sh: print the =README of an archive
# 
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "print the =README of an archive\\n"
		printf "usage: archive-readme [options] [archive]\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " -R --root root                specify the local archive root\\n"
		printf " -A --archive archive          specify the archive name\\n"
		printf "\\n"
		printf "Print the contents of the =README file of a particular archive.\\n"
		printf "If the archive has no =README, nothing is printed.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

archroot=
archive=

while test $# -ne 0 ; do

  case "$1" in 

    -R|--root)		shift
    			if test $# -eq 0 ; then
			  printf "make-category: -R and --root require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			archroot="$1"
			shift
			;;

    -A|--archive)	shift
    			if test $# -eq 0 ; then
			  printf "make-category: -A and --archive require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			archive="$1"
			shift
			;;


    -*)			printf "archive-readme: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -gt 1 ; then
  printf "usage: archive-readme [options] [[archive/]category]\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

if test $# -ne 0 ; then
  archive="$1"
  shift
fi

################################################################
# Sanity Check and Process Defaults
# 

if test -z "$archive" ; then
  archive=`larch tree-version 2> /dev/null || larch my-default-archive`
  archive=`larch parse-package-name -R "$root" -A "$archive" --arch "$archive"`
fi

larch valid-archive-name -e archive-readme "$archive"

################################################################
# Establish an Archive Connection
# 

if test "$WITHARCHIVE" != "$archive" ; then
  exec larch with-archive -A "$archive" larch archive-readme "$archive"
fi


################################################################
# Print the List
# 

wftp-home

if wftp-ls | grep -q -E "^=README$" ; then
  wftp-get =README
fi

# tag: Tom Lord Wed Jan 23 01:54:30 2002 (archives/archive-readme.sh)
#
