/***************************************************************************
                          main.c  -  description
                             -------------------
    begin                : Mon Feb 26 15:52:20 EST 2001
    copyright            : (C) 2001 by Danny Rodriguez
    email                : messiah@optonline.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "main.h"

extern char *MANUAL_VAL;
extern char *DISTRO_VAL;
extern char *FILE_VAL;
extern char *SAVE_VAL;
extern char *TOP_VAL;

extern FILE *FILE_FILE;
extern FILE *SAVE_FILE;

extern bench_struct benched[25];

//extern int option_flags;

FILE *Get_File(char *, int);
int Get_Lines(FILE *);
FILE *Benchmark_List(FILE *);
int compar(const void *, const void *);


void main(int argc, char **argv)
{
	FILE *MIRRORS_LIST;
	int top1,top2,top3;
	char tmp[256];
	//   system("clear");
	GetOpt(argc, argv);
	Make_Files();

	if(!if_flag(FILE_FLAG))
		//	if(!(option_flags & FILE_FLAG))
	{
		MIRRORS_LIST = Get_FTP_File("ftp://ftp.us.debian.org/debian/README.mirrors.html", BINARY, NULL);

		if(MIRRORS_LIST == NULL)
			post_message("Unrecoverable Error [1]: Could not retrieve list from DEBIAN.ORG");
		else
		{
			MIRRORS_LIST = Parse_Tags(MIRRORS_LIST);
			if(MIRRORS_LIST == NULL)
				post_message("Unrecoverable Error [2]: Some kind of parsing error.");
			else
			{
				MIRRORS_LIST = Parse_Tag_Values(MIRRORS_LIST);
				if(MIRRORS_LIST == NULL)
					post_message("Unrecoverable Error [3]: Some kind of parsing error.");
			}
		}
	}


	if(if_flag(FILE_FLAG))
	{
		clr_line();
		post_message("[|s] Using list for benchmarking.");
		fflush(stdout);
		MIRRORS_LIST = Benchmark_List(FILE_FILE);
	}
	else if(MIRRORS_LIST != NULL)
	{
		MIRRORS_LIST = Benchmark_List(MIRRORS_LIST);
	}

	newline;

	if(if_flag(TOP_FLAG))
	{
		clr_line();
		post_message("[|s] Saving TOP FILE LIST.");
		fflush(stdout);
		if(!Copy_File(MIRRORS_LIST, TOP_VAL))
		{
			post_message("[*] FILE/IO error on %s - Skipping save.\n", TOP_VAL);
		}
	}


	//fseek(MIRRORS_LIST, 0L, SEEK_SET);


	if(MIRRORS_LIST != NULL)
	{

		fclose(MIRRORS_LIST);

		if(if_flag(SAVE_FLAG))
		{
			MIRRORS_LIST = SAVE_FILE;
			post_message("\nNow saving %s\n", SAVE_VAL);
		}
		else
		{
			post_message("\nNow saving sources.list\n");
			MIRRORS_LIST = fopen("/etc/apt/sources.list", "r+");
			if(MIRRORS_LIST == NULL)
			{
				MIRRORS_LIST = fopen("/etc/apt/sources.list", "w");
				if(MIRRORS_LIST == NULL)
				{
					post_message("Cannot access /etc/apt/sources.list. Defaulting to ./sources.list.\n");
					MIRRORS_LIST = fopen("sources.list", "r+");
					if(MIRRORS_LIST == NULL)
					{
						MIRRORS_LIST = fopen("sources.list", "w");
						if(MIRRORS_LIST == NULL)
						{
							post_message("Cannot access ./sources.list. Not saving final cut, sorry.\n");
							goto Sorry;
						}
					}
					else
					{
						fclose(MIRRORS_LIST);
						sprintf(tmp, "sources.list.backup.%d", time(NULL));
						rename("sources.list", tmp);
						MIRRORS_LIST = fopen("sources.list", "w");
					}
				}
			}
			else
			{
				sprintf(tmp, "/etc/apt/sources.list.old.%d", time(NULL));
				rename("/etc/apt/sources.list", tmp);
				MIRRORS_LIST = fopen("/etc/apt/sources.list", "w");
			}
		}



		top1 = 24;
		top2 = 23;
		top3 = 22;

		if(benched[top3].domain == NULL || strlen(benched[top3].domain) < 1)
		{
			post_message("Top Benchmark #3 was empty. Attempting to correct.\n");
			for(; benched[top3].domain == NULL && strlen(benched[top3].domain) < 1 && top3 > 0; top3--)
				;
			if(top3 == 0 && (benched[top3].domain == NULL || strlen(benched[top3].domain) < 1))
				top3 = -1;
		}
		if(benched[top2].domain == NULL || strlen(benched[top2].domain) < 1)
		{
			post_message("Top Benchmark #2 was empty. Attempting to correct.\n");
			for(; benched[top2].domain == NULL && strlen(benched[top2].domain) < 1 && top2 > 0; top2--)
				;
			if(top2 == 0 && (benched[top2].domain == NULL || strlen(benched[top2].domain) < 1))
				top2 = -1;
		}
		if(benched[top1].domain == NULL || strlen(benched[top1].domain) < 1)
		{
			post_message("Top Benchmark #1 was empty. Attempting to correct.\n");
			for(; benched[top1].domain == NULL && strlen(benched[top1].domain) < 1 && top1 > 0; top1--)
				;
			if(top1 == 0 && (benched[top1].domain == NULL || strlen(benched[top1].domain) < 1))
				top1 = -1;
		}

		if(top1 == -1 && top2 == -1 && top3 == -1)
		{
			post_message("I could not save any benchmarked sites. Sorry.\n");
			goto Sorry;
		}


		fprintf(MIRRORS_LIST, "# This sources.list was generated by apt-sources v%1.2f\n", MY_VERSION);
		fprintf(MIRRORS_LIST, "# Copyright(c) 2001 by Danny Rodriguez\n");
		fprintf(MIRRORS_LIST, "#\n");

		if(top1 != -1)
		{

			fprintf(MIRRORS_LIST, "# The following site was benchmarked at %2.2f kB/s\n", benched[top1].speed);
			fprintf(MIRRORS_LIST, "deb %s %s main\n\n", benched[top1].domain, (if_flag(DISTRO_FLAG)) ? DISTRO_VAL : "stable");

		}

		if(top2 != -1)
		{

			fprintf(MIRRORS_LIST, "# The following site was benchmarked at %2.2f kB/s\n", benched[top2].speed);
			fprintf(MIRRORS_LIST, "deb %s %s contrib\n\n", benched[top2].domain, (if_flag(DISTRO_FLAG)) ? DISTRO_VAL : "stable");

		}


		if(top3 != -1)
		{

			fprintf(MIRRORS_LIST, "# The following site was benchmarked at %2.2f kB/s\n", benched[top3].speed);
			fprintf(MIRRORS_LIST, "deb %s %s non-free\n\n", benched[top3].domain, (if_flag(DISTRO_FLAG)) ? DISTRO_VAL : "stable");

		}

		if(if_flag(MANUAL_FLAG))
			fprintf(MIRRORS_LIST, "# The following site was MANUALLY ADDED with the -a option\n%s\n#\n", MANUAL_VAL);


		fprintf(MIRRORS_LIST, "###########################################################################\n");
		fprintf(MIRRORS_LIST, "# Below are sites you may want to consider adding but are commented out\n#\n");
		fprintf(MIRRORS_LIST, "# -----[ Uncomment below for HELIX CODE site (GNOME) ]-----\n");
		fprintf(MIRRORS_LIST, "# deb http://spidermonkey.ximian.com/distributions/debian unstable main\n");
		fprintf(MIRRORS_LIST, "# -----[ Uncomment below for KDE site (& Kdevelop)   ]-----\n");
		fprintf(MIRRORS_LIST, "# deb http://kde.tdyc.com potato main crypto optional qt1apps\n");
		fprintf(MIRRORS_LIST, "# -----[ Uncomment below for debian security         ]-----\n");
		fprintf(MIRRORS_LIST, "# deb http://security.debian.org stable/updates main contrib non-free\n");


	}

Sorry:
	newline;

	if(MIRRORS_LIST != NULL)
		fclose(MIRRORS_LIST);

	newline;
	post_message("Cleaning up ... have a nice day.");
	newline;
	GetOpt_Free();
	exit(0);
}

