#include "Record.h"
#include "Animal.h"
#include "Question.h"

#include "db2++-stuff.h"

#include <iostream.h>
#include <strstream.h>
// #include <gdbm.h>
#include <malloc.h>
#include <signal.h>

#include <string>

// Copyright (c) 1997 by Jim Lynch.
// This software comes with NO WARRANTY WHATSOEVER.
//
// This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; version 2 dated June, 1991, or, at your
//    option, any LATER version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program;  if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// On Debian Linux systems, the complete text of the GNU General
// Public License can be found in `/usr/doc/copyright/GPL' (on some
// installations) or /usr/share/common-licenses/GPL (on newer 
// ones).

// There are two possible datum formats, both strings; and the records
// in both formats are separated by |.
//
// The first format is for an animal. Its format is simply:
//
// "a|nameofanimal|".
//
// The second format is for a yes-or-no question, which has a pair
// of gdbm keys in it. The format is:
//
// "q|text of question without the question mark|yes key|no key|".
//
// The keys will be simply numeric strings, converted using a strstream.
// Because of this, the program can later be expanded to allow larger
// numbers of animals and questions, without changing the file format
// _at_ _all_.
//
// There will be one key/value pair in the database, called "last" whose
// value is the ascii digits of the key of the last added. If 0, there
// are no animals.

Db *theFileHandle = NULL;
string progName;
string lineBuf;

void readline(istream &in, string &it)
{
  getline(in, it);
}

int IsSpace(const char theChar)
{
  int result = 0;
  
  switch(theChar)
    {
    case ' ':
    case '\n':
    case '\t':
    case '\r':
    case '\v':
    case '\f':
      result = 1;
      break;
    }
  
  return result;
}

void ChopTrailingWhiteSpace(string &it)
{
  int n = it.size();

  while(IsSpace( it[--n] ))
    ;

  it = it.substr(0, n + 1);
}

void ChopQuestionMark(string &it)
{
  ChopTrailingWhiteSpace(it);

  if(*(it.end() - 1) == '?')
    {
      it = it.substr(0, it.size() - 1);
      ChopTrailingWhiteSpace(it);
    }
}

void PlayGame(Db &handle)
{
  string theAnimal;
  string last(GetLast(handle));
  
  if(last == "0")
  {
    cout << "I give up! You win! What was your animal? " << flush;
    readline(cin, theAnimal);
    
    Animal it(theAnimal);
    it.Write(handle, "1");
    SetLast(handle, "1");
    
    cout << "I now know 1 animals!\07" << endl << endl;
  }
  else
  {
    string browseIndex = "1";
    Record *theRecordPtr;
    
    if(IsAnimal(handle, browseIndex))
      theRecordPtr = new Animal(handle, browseIndex);
    else
      theRecordPtr = new Question(handle, browseIndex);
    
    while(! IsAnimal(handle, browseIndex))
    {
      Question theQuestion = *((Question *) theRecordPtr);
      delete theRecordPtr;
      
      cout << theQuestion << "? ";
      
      readline(cin, lineBuf);
      
      if(lineBuf[0] == 'y')
      {
	browseIndex = theQuestion.GetYesKey();
      }
      else if(lineBuf[0] == 'n')
      {
	browseIndex = theQuestion.GetNoKey();
      }
      
      if(IsAnimal(handle, browseIndex))
	theRecordPtr = new Animal(handle, browseIndex);
      else
	theRecordPtr = new Question(handle, browseIndex);
    }
    
    cout << endl << "I think I'll try a guess now...\07" << endl;
    cout << "Is your animal a " << (*theRecordPtr) << "? " << flush;
    readline(cin, lineBuf);
    if(lineBuf[0] == 'y')
    {
      cout << "I win! I guessed your animal!" << endl << endl;
    }
    else
    {
      cout << endl << "I give up! You win! What was your animal? " << flush;
      readline(cin, theAnimal);
      
      string questionBuf;
      int goodQuestion = 0;
      long guessedAnimalKey;
      long newAnimalKey;
      int guessedAnimalAnswer;
      int newAnimalAnswer;
      Animal newAnimal;
      Animal guessedAnimal = *((Animal *) theRecordPtr);
      
      while(! goodQuestion)
      {
	newAnimal = Animal(theAnimal);
	
	cout << endl << "I need a yes-or-no question so I can later" << endl;
	cout << "tell the difference between a " << guessedAnimal;
	cout << " and a " << newAnimal << "." << endl;
	
	readline(cin, questionBuf);
	
	ChopQuestionMark(questionBuf);
	
	guessedAnimalKey = CStringToLong( GetLast(handle).c_str() ) + 1;
	newAnimalKey = guessedAnimalKey + 1;
	
	newAnimalAnswer = -1;
	
	while(newAnimalAnswer == -1)
	{
	  cout << "what would be the answer be for a ";
	  cout << newAnimal << "? ";
	  
	  readline(cin, lineBuf);
	  
	  newAnimalAnswer = ((lineBuf[0] == 'y') ? 1 :
			     (lineBuf[0] == 'n') ? 0 : -1);
	}
	
	guessedAnimalAnswer = -1;
	
	while(guessedAnimalAnswer == -1)
	{
	  cout << "what would be the answer be for a ";
	  cout << guessedAnimal << "? ";
	  
	  readline(cin, lineBuf);
	  
	  guessedAnimalAnswer = ((lineBuf[0] == 'y') ? 1 :
				 (lineBuf[0] == 'n') ? 0 : -1);
	}
	
	if(newAnimalAnswer != guessedAnimalAnswer)
	  goodQuestion = 1;
	else
	{
	  cout << endl;
	  cout << "I don't understand! If both answers are the" << endl;
	  cout << "same, maybe I can't use the question! Maybe" << endl;
	  cout << "I misunderstood? Please tell me again!" << endl;
	}
      }
      
      const char *newKeyString = LongToNewCString(newAnimalKey);
      const char *guessedKeyString = LongToNewCString(guessedAnimalKey);
      Question newQuestion
	(
	  // watch for memory leaks in the next line
	  questionBuf.c_str(),
	  (newAnimalAnswer ? newKeyString : guessedKeyString),
	  (newAnimalAnswer ? guessedKeyString : newKeyString)
	);
      
      newQuestion.Write(handle, browseIndex.c_str());
      guessedAnimal.Write(handle, guessedKeyString);
      newAnimal.Write(handle, newKeyString);
      
      SetLast(handle, newKeyString);
      
      cout << endl;
      cout << "I now know " << (newAnimalKey + 1) / 2 << " animals!" << endl;
      cout << endl;
    }
  }
}

void SigHandler(int sig)
{
  if (theFileHandle) {
    CloseFile(*theFileHandle);
  }
  cout << "Killed..." << endl;
  exit(0);
}

int main(int argc, char *argv)
{
  string wantsToContinue("y");
  char ret[3];
  
  progName = argv[0];
 
  signal(SIGHUP, SigHandler);
  signal(SIGTERM, SigHandler);
  signal(SIGINT, SigHandler);
 
  cout << endl << "Welcome to animals!" << endl << endl;
  
  do
  {
    cout << "Think of an animal." << endl;
    cout << "Press <Enter> or <Return> to continue...";
    readline(cin, lineBuf);
    cout << endl;
    
    theFileHandle = OpenFile();
    PlayGame(*theFileHandle);
    CloseFile(*theFileHandle);
    
    cout << "Want to play again? " << flush;
    readline(cin, lineBuf);
    cout << endl;
    
    wantsToContinue = lineBuf[0];
  }
  while(wantsToContinue == "y");

  return 0;
}

