// Copyright (c) 1997 by Jim Lynch.
// This software comes with NO WARRANTY WHATSOEVER.
//
// This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; version 2 dated June, 1991, or, at your
//    option, any LATER version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program;  if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// On Debian Linux systems, the complete text of the GNU General
// Public License can be found in `/usr/doc/copyright/GPL' (on some
// installations) or /usr/share/common-licenses/GPL (on newer 
// ones).

#ifndef Animal_h
#define Animal_h

#include "Record.h"
#include <strstream.h>

class Animal : public Record
{
private:
  string *animal;

  void Default(void)
    {
      animal = new string;
    }
  
  void Set(const char *anAnimal)
    {
      animal = new string(anAnimal);
    }

  void Copy(const Animal &orig)
    {
      if(orig.animal)
      {
	animal = new string(*orig.animal);
      }
      else
      {
	animal = 0;
      }
    }

protected:
  
  virtual void Destroy(void)
    {
      if(animal)
	delete animal;

      animal = 0;
    }

  virtual void SetNull(void)
    {
      animal = new string;
    }

  virtual void SetFromDataString(const char *theDataString)
    {
      const char *data = theDataString;

      if(data[0] == 'a')
      {
	istrstream it(data + 2);
	ostrstream theAnimal;

	// grab the animal text
	char nextCh = it.get();
	
	while(nextCh != '|')
	{
	  theAnimal << nextCh;

	  nextCh = it.get();
	}

	animal = new string(MakeCStringCopy(theAnimal));
      }
      else
	SetNull();
    }

public:
  Animal()
    {
      Default();
    }
  
  Animal(const char *anAnimal)
    {
      Set(anAnimal);
    }

  Animal(string &anAnimal)
    {
      Set(anAnimal.c_str());
    }

  Animal(const Animal &orig)
    {
      Copy(orig);
    }

  Animal &operator=(const Animal &orig)
    {
      Destroy();
      Copy(orig);

      return *this;
    }

  virtual ~Animal()
    {
      Destroy();
    }

  Animal(Db &handle, const char *animalKey)
    {
      Default();
      
      Read(handle, animalKey);
    }
  
  Animal(Db &handle, const string &animalKey)
    {
      Default();
      
      Read(handle, animalKey);
    }
  
  virtual const char *FormNewDataCString() const
    {
      string temp = "a|";

      if(animal)
	temp += (*animal);
      
      temp += "|";

      return MakeCStringCopy(temp);
    }

  virtual void Print(ostream &out) const
    {
      out << (animal ? (*animal) : string());
    }
};

#endif

