{-# OPTIONS_GHC -w #-}
{-# OPTIONS -fglasgow-exts -cpp #-}
{-| The parser is generated by Happy (<http://www.haskell.org/happy>).
 -
 - Ideally, ranges should be as precise as possible, to get messages that
 - emphasize precisely the faulting term(s) upon error.
 -
 - However, interactive highlighting is only applied at the end of each
 - mutual block, keywords are only highlighted once (see
 - `TypeChecking.Rules.Decl'). So if the ranges of two declarations
 - interleave, one must ensure that keyword ranges are not included in
 - the intersection. (Otherwise they are uncolored by the interactive
 - highlighting.)
 -
 -}
module Agda.Syntax.Parser.Parser (
      moduleParser
    , exprParser
    , tokensParser
    , tests
    ) where

import Control.Monad

import Data.Char
import Data.Functor
import Data.List
import Data.Maybe
import qualified Data.Traversable as T

import Agda.Syntax.Position hiding (tests)
import Agda.Syntax.Parser.Monad
import Agda.Syntax.Parser.Lexer
import Agda.Syntax.Parser.Tokens
import Agda.Syntax.Concrete as C
import Agda.Syntax.Concrete.Pretty ()
import Agda.Syntax.Common hiding (Arg, Dom, NamedArg)
import qualified Agda.Syntax.Common as Common
import Agda.Syntax.Fixity
import Agda.Syntax.Notation
import Agda.Syntax.Literal

import Agda.Utils.Hash
import Agda.Utils.List (spanJust)
import Agda.Utils.Monad
import Agda.Utils.QuickCheck
import Agda.Utils.TestHelpers
import Agda.Utils.Tuple
import qualified Data.Array as Happy_Data_Array
import qualified GHC.Exts as Happy_GHC_Exts

-- parser produced by Happy Version 1.19.3

newtype HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71 = HappyAbsSyn HappyAny
#if __GLASGOW_HASKELL__ >= 607
type HappyAny = Happy_GHC_Exts.Any
#else
type HappyAny = forall a . a
#endif
happyIn6 :: ([Token]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn6 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn6 #-}
happyOut6 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Token])
happyOut6 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut6 #-}
happyIn7 :: ([Token]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn7 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn7 #-}
happyOut7 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Token])
happyOut7 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut7 #-}
happyIn8 :: (Token) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn8 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn8 #-}
happyOut8 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Token)
happyOut8 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut8 #-}
happyIn9 :: (([Pragma], [Declaration])) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn9 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn9 #-}
happyOut9 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (([Pragma], [Declaration]))
happyOut9 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut9 #-}
happyIn10 :: t10 -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn10 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn10 #-}
happyOut10 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> t10
happyOut10 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut10 #-}
happyIn11 :: t11 -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn11 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn11 #-}
happyOut11 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> t11
happyOut11 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut11 #-}
happyIn12 :: t12 -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn12 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn12 #-}
happyOut12 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> t12
happyOut12 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut12 #-}
happyIn13 :: (()) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn13 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn13 #-}
happyOut13 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (())
happyOut13 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut13 #-}
happyIn14 :: (Integer) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn14 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn14 #-}
happyOut14 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Integer)
happyOut14 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut14 #-}
happyIn15 :: (Name) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn15 #-}
happyOut15 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Name)
happyOut15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut15 #-}
happyIn16 :: ([Name]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn16 #-}
happyOut16 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Name])
happyOut16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut16 #-}
happyIn17 :: (Range) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn17 #-}
happyOut17 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Range)
happyOut17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut17 #-}
happyIn18 :: (Arg Name) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn18 #-}
happyOut18 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Arg Name)
happyOut18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut18 #-}
happyIn19 :: ([Arg Name]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn19 #-}
happyOut19 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Arg Name])
happyOut19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut19 #-}
happyIn20 :: ([Arg Name]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn20 #-}
happyOut20 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Arg Name])
happyOut20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut20 #-}
happyIn21 :: (QName) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn21 #-}
happyOut21 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (QName)
happyOut21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut21 #-}
happyIn22 :: (QName) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn22 #-}
happyOut22 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (QName)
happyOut22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut22 #-}
happyIn23 :: (Name) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn23 #-}
happyOut23 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Name)
happyOut23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut23 #-}
happyIn24 :: ([Name]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn24 #-}
happyOut24 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Name])
happyOut24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut24 #-}
happyIn25 :: ([Name]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn25 #-}
happyOut25 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Name])
happyOut25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut25 #-}
happyIn26 :: (Either [Name] [Expr]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn26 #-}
happyOut26 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Either [Name] [Expr])
happyOut26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut26 #-}
happyIn27 :: ([String]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn27 #-}
happyOut27 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([String])
happyOut27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut27 #-}
happyIn28 :: (String) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn28 #-}
happyOut28 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (String)
happyOut28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut28 #-}
happyIn29 :: (QName) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn29 #-}
happyOut29 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (QName)
happyOut29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut29 #-}
happyIn30 :: (Expr) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn30 #-}
happyOut30 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Expr)
happyOut30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut30 #-}
happyIn31 :: t31 -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn31 #-}
happyOut31 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> t31
happyOut31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut31 #-}
happyIn32 :: ([Expr]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn32 #-}
happyOut32 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Expr])
happyOut32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut32 #-}
happyIn33 :: ([Expr]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn33 #-}
happyOut33 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Expr])
happyOut33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut33 #-}
happyIn34 :: t34 -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn34 #-}
happyOut34 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> t34
happyOut34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut34 #-}
happyIn35 :: (Expr) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn35 #-}
happyOut35 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Expr)
happyOut35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut35 #-}
happyIn36 :: ([Expr]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn36 #-}
happyOut36 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Expr])
happyOut36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut36 #-}
happyIn37 :: t37 -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn37 #-}
happyOut37 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> t37
happyOut37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut37 #-}
happyIn38 :: t38 -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn38 #-}
happyOut38 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> t38
happyOut38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut38 #-}
happyIn39 :: t39 -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn39 #-}
happyOut39 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> t39
happyOut39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut39 #-}
happyIn40 :: ([(Name, Expr)]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn40 #-}
happyOut40 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([(Name, Expr)])
happyOut40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut40 #-}
happyIn41 :: ([(Name, Expr)]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn41 #-}
happyOut41 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([(Name, Expr)])
happyOut41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut41 #-}
happyIn42 :: ((Name, Expr)) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn42 #-}
happyOut42 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ((Name, Expr))
happyOut42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut42 #-}
happyIn43 :: t43 -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn43 #-}
happyOut43 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> t43
happyOut43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut43 #-}
happyIn44 :: t44 -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn44 #-}
happyOut44 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> t44
happyOut44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut44 #-}
happyIn45 :: ([TypedBindings]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn45 #-}
happyOut45 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([TypedBindings])
happyOut45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut45 #-}
happyIn46 :: (TypedBindings) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn46 #-}
happyOut46 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (TypedBindings)
happyOut46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut46 #-}
happyIn47 :: (( [Color], TypedBinding )) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn47 #-}
happyOut47 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (( [Color], TypedBinding ))
happyOut47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut47 #-}
happyIn48 :: ([LamBinding]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn48 #-}
happyOut48 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([LamBinding])
happyOut48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut48 #-}
happyIn49 :: (Either ([LamBinding], Hiding) [Expr]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn49 #-}
happyOut49 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Either ([LamBinding], Hiding) [Expr])
happyOut49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut49 #-}
happyIn50 :: ([Either Hiding LamBinding]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn50 #-}
happyOut50 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Either Hiding LamBinding])
happyOut50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut50 #-}
happyIn51 :: (Either [Either Hiding LamBinding] [Expr]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn51 #-}
happyOut51 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Either [Either Hiding LamBinding] [Expr])
happyOut51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut51 #-}
happyIn52 :: ((LHS,RHS,WhereClause)) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn52 #-}
happyOut52 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ((LHS,RHS,WhereClause))
happyOut52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut52 #-}
happyIn53 :: ((LHS,RHS,WhereClause)) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn53 #-}
happyOut53 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ((LHS,RHS,WhereClause))
happyOut53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut53 #-}
happyIn54 :: ((LHS,RHS,WhereClause)) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn54 #-}
happyOut54 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ((LHS,RHS,WhereClause))
happyOut54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut54 #-}
happyIn55 :: ([(LHS,RHS,WhereClause)]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn55 #-}
happyOut55 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([(LHS,RHS,WhereClause)])
happyOut55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut55 #-}
happyIn56 :: ([LamBinding]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn56 #-}
happyOut56 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([LamBinding])
happyOut56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut56 #-}
happyIn57 :: ([LamBinding]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn57 #-}
happyOut57 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([LamBinding])
happyOut57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut57 #-}
happyIn58 :: ([LamBinding]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn58 #-}
happyOut58 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([LamBinding])
happyOut58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut58 #-}
happyIn59 :: ([LamBinding]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn59 #-}
happyOut59 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([LamBinding])
happyOut59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut59 #-}
happyIn60 :: (Either [LamBinding] [Expr]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn60 #-}
happyOut60 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Either [LamBinding] [Expr])
happyOut60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut60 #-}
happyIn61 :: (ImportDirective) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn61 #-}
happyOut61 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (ImportDirective)
happyOut61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut61 #-}
happyIn62 :: ([ImportDirective]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn62 #-}
happyOut62 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([ImportDirective])
happyOut62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut62 #-}
happyIn63 :: (ImportDirective) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn63 #-}
happyOut63 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (ImportDirective)
happyOut63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut63 #-}
happyIn64 :: ((UsingOrHiding , Range)) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn64 #-}
happyOut64 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ((UsingOrHiding , Range))
happyOut64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut64 #-}
happyIn65 :: (([Renaming] , Range)) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn65 #-}
happyOut65 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (([Renaming] , Range))
happyOut65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut65 #-}
happyIn66 :: ([Renaming]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn66 #-}
happyOut66 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Renaming])
happyOut66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut66 #-}
happyIn67 :: (Renaming) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn67 #-}
happyOut67 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Renaming)
happyOut67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut67 #-}
happyIn68 :: (ImportedName) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn68 #-}
happyOut68 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (ImportedName)
happyOut68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut68 #-}
happyIn69 :: (ImportedName) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn69 #-}
happyOut69 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (ImportedName)
happyOut69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut69 #-}
happyIn70 :: ([ImportedName]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn70 #-}
happyOut70 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([ImportedName])
happyOut70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut70 #-}
happyIn71 :: t71 -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn71 #-}
happyOut71 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> t71
happyOut71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut71 #-}
happyIn72 :: (LHS) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn72 #-}
happyOut72 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (LHS)
happyOut72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut72 #-}
happyIn73 :: ([Pattern]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn73 #-}
happyOut73 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Pattern])
happyOut73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut73 #-}
happyIn74 :: ([Expr]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn74 #-}
happyOut74 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Expr])
happyOut74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut74 #-}
happyIn75 :: ([Expr]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn75 #-}
happyOut75 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Expr])
happyOut75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut75 #-}
happyIn76 :: (WhereClause) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn76 #-}
happyOut76 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (WhereClause)
happyOut76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut76 #-}
happyIn77 :: ([Declaration]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn77 #-}
happyOut77 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Declaration])
happyOut77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut77 #-}
happyIn78 :: ([Declaration]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn78 #-}
happyOut78 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Declaration])
happyOut78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut78 #-}
happyIn79 :: ([Declaration]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn79 #-}
happyOut79 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Declaration])
happyOut79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut79 #-}
happyIn80 :: ([Arg Declaration]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn80 #-}
happyOut80 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Arg Declaration])
happyOut80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut80 #-}
happyIn81 :: ([Declaration]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn81 #-}
happyOut81 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Declaration])
happyOut81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut81 #-}
happyIn82 :: (RHSOrTypeSigs) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn82 #-}
happyOut82 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (RHSOrTypeSigs)
happyOut82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut82 #-}
happyIn83 :: (Declaration) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn83 #-}
happyOut83 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Declaration)
happyOut83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut83 #-}
happyIn84 :: (Declaration) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn84 #-}
happyOut84 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Declaration)
happyOut84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut84 #-}
happyIn85 :: (Declaration) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn85 #-}
happyOut85 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Declaration)
happyOut85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut85 #-}
happyIn86 :: (Declaration) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn86 #-}
happyOut86 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Declaration)
happyOut86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut86 #-}
happyIn87 :: (Name) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn87 #-}
happyOut87 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Name)
happyOut87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut87 #-}
happyIn88 :: (Declaration) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn88 #-}
happyOut88 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Declaration)
happyOut88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut88 #-}
happyIn89 :: ([Declaration]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn89 #-}
happyOut89 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Declaration])
happyOut89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut89 #-}
happyIn90 :: (Declaration) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn90 #-}
happyOut90 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Declaration)
happyOut90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut90 #-}
happyIn91 :: (Declaration) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn91 #-}
happyOut91 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Declaration)
happyOut91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut91 #-}
happyIn92 :: (Declaration) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn92 #-}
happyOut92 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Declaration)
happyOut92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut92 #-}
happyIn93 :: (Declaration) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn93 #-}
happyOut93 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Declaration)
happyOut93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut93 #-}
happyIn94 :: (Declaration) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn94 #-}
happyOut94 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Declaration)
happyOut94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut94 #-}
happyIn95 :: (Declaration) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn95 #-}
happyOut95 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Declaration)
happyOut95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut95 #-}
happyIn96 :: (Declaration) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn96 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn96 #-}
happyOut96 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Declaration)
happyOut96 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut96 #-}
happyIn97 :: ([Arg Name]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn97 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn97 #-}
happyOut97 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Arg Name])
happyOut97 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut97 #-}
happyIn98 :: ([RString]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn98 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn98 #-}
happyOut98 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([RString])
happyOut98 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut98 #-}
happyIn99 :: ([NamedArg HoleName]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn99 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn99 #-}
happyOut99 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([NamedArg HoleName])
happyOut99 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut99 #-}
happyIn100 :: (NamedArg HoleName) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn100 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn100 #-}
happyOut100 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (NamedArg HoleName)
happyOut100 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut100 #-}
happyIn101 :: (HoleName) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn101 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn101 #-}
happyOut101 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (HoleName)
happyOut101 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut101 #-}
happyIn102 :: (HoleName) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn102 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn102 #-}
happyOut102 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (HoleName)
happyOut102 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut102 #-}
happyIn103 :: (RString) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn103 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn103 #-}
happyOut103 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (RString)
happyOut103 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut103 #-}
happyIn104 :: (Maybe Range) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn104 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn104 #-}
happyOut104 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Maybe Range)
happyOut104 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut104 #-}
happyIn105 :: ([Declaration]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn105 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn105 #-}
happyOut105 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Declaration])
happyOut105 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut105 #-}
happyIn106 :: ([Expr]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn106 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn106 #-}
happyOut106 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Expr])
happyOut106 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut106 #-}
happyIn107 :: ([TypedBindings] -> Parser ModuleApplication) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn107 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn107 #-}
happyOut107 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([TypedBindings] -> Parser ModuleApplication)
happyOut107 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut107 #-}
happyIn108 :: (Declaration) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn108 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn108 #-}
happyOut108 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Declaration)
happyOut108 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut108 #-}
happyIn109 :: (Declaration) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn109 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn109 #-}
happyOut109 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Declaration)
happyOut109 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut109 #-}
happyIn110 :: (Name) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn110 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn110 #-}
happyOut110 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Name)
happyOut110 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut110 #-}
happyIn111 :: ([Declaration]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn111 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn111 #-}
happyOut111 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Declaration])
happyOut111 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut111 #-}
happyIn112 :: (Declaration) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn112 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn112 #-}
happyOut112 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Declaration)
happyOut112 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut112 #-}
happyIn113 :: (Pragma) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn113 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn113 #-}
happyOut113 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Pragma)
happyOut113 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut113 #-}
happyIn114 :: (Pragma) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn114 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn114 #-}
happyOut114 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Pragma)
happyOut114 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut114 #-}
happyIn115 :: (Pragma) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn115 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn115 #-}
happyOut115 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Pragma)
happyOut115 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut115 #-}
happyIn116 :: (Pragma) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn116 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn116 #-}
happyOut116 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Pragma)
happyOut116 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut116 #-}
happyIn117 :: (Pragma) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn117 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn117 #-}
happyOut117 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Pragma)
happyOut117 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut117 #-}
happyIn118 :: (Pragma) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn118 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn118 #-}
happyOut118 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Pragma)
happyOut118 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut118 #-}
happyIn119 :: (Pragma) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn119 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn119 #-}
happyOut119 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Pragma)
happyOut119 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut119 #-}
happyIn120 :: (Pragma) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn120 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn120 #-}
happyOut120 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Pragma)
happyOut120 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut120 #-}
happyIn121 :: (Pragma) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn121 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn121 #-}
happyOut121 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Pragma)
happyOut121 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut121 #-}
happyIn122 :: (Pragma) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn122 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn122 #-}
happyOut122 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Pragma)
happyOut122 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut122 #-}
happyIn123 :: (Pragma) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn123 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn123 #-}
happyOut123 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Pragma)
happyOut123 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut123 #-}
happyIn124 :: (Pragma) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn124 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn124 #-}
happyOut124 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Pragma)
happyOut124 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut124 #-}
happyIn125 :: (Pragma) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn125 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn125 #-}
happyOut125 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Pragma)
happyOut125 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut125 #-}
happyIn126 :: (Pragma) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn126 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn126 #-}
happyOut126 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Pragma)
happyOut126 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut126 #-}
happyIn127 :: ([TypeSignature]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn127 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn127 #-}
happyOut127 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([TypeSignature])
happyOut127 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut127 #-}
happyIn128 :: ([TypeSignature]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn128 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn128 #-}
happyOut128 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([TypeSignature])
happyOut128 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut128 #-}
happyIn129 :: ([TypeSignature]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn129 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn129 #-}
happyOut129 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([TypeSignature])
happyOut129 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut129 #-}
happyIn130 :: ([TypeSignature]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn130 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn130 #-}
happyOut130 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([TypeSignature])
happyOut130 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut130 #-}
happyIn131 :: ([Arg TypeSignature]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn131 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn131 #-}
happyOut131 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Arg TypeSignature])
happyOut131 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut131 #-}
happyIn132 :: ([Arg TypeSignature]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn132 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn132 #-}
happyOut132 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Arg TypeSignature])
happyOut132 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut132 #-}
happyIn133 :: ([Constructor]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn133 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn133 #-}
happyOut133 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Constructor])
happyOut133 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut133 #-}
happyIn134 :: ((Maybe (Ranged Induction), Maybe Name, [Declaration])) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn134 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn134 #-}
happyOut134 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ((Maybe (Ranged Induction), Maybe Name, [Declaration]))
happyOut134 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut134 #-}
happyIn135 :: (Ranged Induction) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn135 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn135 #-}
happyOut135 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Ranged Induction)
happyOut135 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut135 #-}
happyIn136 :: ([Declaration]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn136 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn136 #-}
happyOut136 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Declaration])
happyOut136 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut136 #-}
happyIn137 :: ([Declaration]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn137 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn137 #-}
happyOut137 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Declaration])
happyOut137 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut137 #-}
happyIn138 :: ([Declaration]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn138 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn138 #-}
happyOut138 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Declaration])
happyOut138 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut138 #-}
happyIn139 :: ([Declaration]) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyIn139 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn139 #-}
happyOut139 :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> ([Declaration])
happyOut139 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut139 #-}
happyInTok :: (Token) -> (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71)
happyInTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyInTok #-}
happyOutTok :: (HappyAbsSyn t10 t11 t12 t31 t34 t37 t38 t39 t43 t44 t71) -> (Token)
happyOutTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOutTok #-}


happyActOffsets :: HappyAddr
happyActOffsets = HappyA# "\x00\x00\x43\x08\x4d\x05\x00\x00\x9f\x04\x38\x05\x4d\x04\x4b\x05\x00\x00\x34\x05\x49\x05\x00\x00\x00\x00\x00\x00\x00\x00\xb3\x00\x00\x00\x00\x00\x0d\x08\xe9\x07\x3f\x05\x00\x00\xf4\x03\x32\x05\xff\x09\x00\x00\x00\x00\xad\x0e\x2b\x05\x2b\x05\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x03\xd2\x09\x00\x00\x00\x00\x9d\x0e\xf1\x05\xc4\x05\xd2\x06\x00\x00\x00\x00\x00\x00\x25\x05\x37\x05\x00\x00\x2d\x05\x52\x01\x2c\x05\x00\x00\x00\x00\xaa\x01\xaa\x01\x00\x00\x27\x05\x2a\x05\x29\x05\x57\x05\x24\x05\x16\x05\x3b\x03\x00\x00\x00\x00\x00\x00\x54\x0e\xe9\x07\x00\x00\x1f\x05\x00\x00\x9a\x0e\x7c\x08\xc8\x03\xae\x03\x00\x00\xbc\x07\x98\x07\xae\x08\x00\x00\xb9\x09\xa5\x06\xc4\x05\x78\x06\xe7\x08\xe7\x08\xe7\x08\x5b\x05\x5a\x05\x8a\x0e\x74\x07\x1c\x05\x8a\x0e\x00\x00\x95\x08\xe7\x08\xe7\x08\x13\x05\x4b\x06\xc4\x05\x0b\x05\x56\x05\x33\x05\x00\x00\x2c\x02\xe7\x08\xe7\x08\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x06\x74\x07\xe7\x08\x74\x07\xb9\x09\x52\x05\x14\x05\x3d\x03\x44\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe5\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0c\x05\x09\x05\x35\x00\x58\x00\xf9\x04\xf9\x04\x8c\x09\xff\x04\xe8\xff\xe8\xff\xe8\xff\xfd\x04\xfd\x04\xfd\x04\xdc\x04\xdc\x04\xfe\x04\xda\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xed\x04\xe8\x04\xe6\x04\xe4\x04\xe2\x04\xdf\x04\xdb\x04\xdb\x04\xdb\x04\xdb\x04\xdb\x04\xdb\x04\xdb\x04\x19\x05\x73\x09\x7a\x0e\x4e\x01\x00\x00\x00\x00\x00\x00\xef\x00\x00\x00\x00\x00\xef\x00\xef\x00\x00\x00\x2e\x01\x77\x0e\x67\x0e\x67\x0e\x00\x00\x00\x00\x67\x0e\x67\x0e\x00\x00\x46\x09\xda\x04\x00\x00\xda\x04\x00\x00\xe7\xff\x00\x00\x00\x00\x33\x05\x00\x00\x00\x00\x0f\x01\x74\x07\x74\x07\x18\x05\xe7\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe7\x08\xe7\x08\xe7\x08\xe7\x08\x12\x00\x74\x07\xe1\x04\xde\x04\x00\x00\xe0\x04\xca\x04\xdd\x04\xec\xff\x00\x00\x00\x00\x00\x00\x00\x00\x74\x07\x74\x07\xd1\x04\xaa\x01\xd7\x04\xcf\x04\xaa\x01\xd2\x04\xd9\x00\xd6\x04\x00\x00\x9f\x00\xc8\x00\xd5\x04\xd4\x04\xd3\x04\x00\x00\xe7\x08\xe7\x08\x00\x00\xe7\x08\xe7\x08\x57\x0e\xd0\x04\x57\x0e\x47\x07\x23\x07\x5c\x08\x00\x00\x00\x00\xc6\x04\x02\x00\x00\x00\x26\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\x06\x00\x00\x2d\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5c\x00\xec\xff\x57\x00\xec\xff\xe7\x08\x00\x00\xe7\x08\xff\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbc\x04\xaf\x04\x00\x00\xff\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\x06\x00\x00\x00\x00\x00\x00\xb5\x04\x7d\x00\x00\x00\x00\x00\xe7\xff\xc1\x04\x00\x00\xd5\x00\xad\x04\xad\x04\xbf\x04\x00\x00\xd5\x00\xfd\x02\x2d\x09\xde\x02\x97\x05\xfd\x02\xf6\x04\xfd\x02\x5e\x00\x7e\x00\x3d\x00\x06\x00\xe7\x08\x2e\x01\xba\x04\x00\x00\xd5\x00\x8c\x01\x66\x01\xe7\xff\xe7\xff\x61\x00\x00\x00\x00\x00\x00\x00\x13\x03\x00\x00\x00\x00\x00\x00\xb4\x04\xc3\xff\xc3\xff\x00\x00\x00\x00\x5a\x04\xb1\x04\x2d\x09\x84\x04\x50\x04\x00\x00\xa2\x04\xa2\x04\xa2\x04\x4a\x04\x48\x04\x45\x04\x00\x00\x46\x04\x00\x00\x42\x04\x41\x04\x3f\x04\x3e\x04\x00\x00\x00\x00\x3c\x04\x00\x00\x00\x00\x3a\x04\x38\x04\x00\x00\x33\x04\x35\x04\x2e\x04\x2d\x04\x00\x00\x00\x00\x00\x00\xff\x06\x31\x04\x3b\x04\x2a\x04\x30\x04\x39\x04\x26\x04\x00\x00\x26\x04\x00\x00\x2b\x04\xf8\x00\x00\x00\x24\x04\x24\x04\x24\x04\x24\x04\x00\x00\x2e\x01\xff\x06\x00\x00\xdc\x00\x28\x04\xff\x06\x27\x04\xff\x06\x27\x04\xff\x06\x19\x04\x26\x03\x00\x00\x19\x04\x00\x00\xf8\x00\x00\x00\x00\x00\xde\x02\x00\x00\x00\x00\x2c\x04\x29\x04\x1e\x04\x00\x00\x00\x00\x1f\x04\x00\x00\x12\x04\xff\x06\x00\x00\x00\x00\xe7\xff\xff\x06\x00\x00\x57\x04\x56\x04\x00\x00\x00\x00\x01\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xde\x02\x00\x00\x00\x00\x0f\x04\x0f\x04\x00\x00\x00\x00\x00\x00\x00\x00\x26\x03\x6d\x00\x0f\x00\x0f\x00\x00\x00\xde\x02\x00\x00\x00\x09\xde\x02\x00\x00\x54\x04\x00\x00\x00\x00\x0d\x00\x53\x04\x00\x00\x49\x04\x00\x00\xaf\x03\x00\x00\x00\x00\x09\x04\xf8\x00\x02\x04\xf8\x00\x2e\x01\x2e\x01\xf5\x03\x00\x00\x08\x04\xc3\xff\x00\x00\x06\x04\xc3\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\x03\x00\x00\x00\x00\x00\x00\x00\x00\xfa\x03\x00\x00\xf2\x03\xf7\x03\xe1\x03\x00\x00\x00\x00\x00\x00\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x00\x00\xd5\x00\xd5\x00\x12\x00\xe0\x03\x00\x00\x00\x00\xf3\x03\xed\x03\x00\x00\xed\x03\x00\x00\x00\x00\x6a\x05\x00\x00\x00\x00\xf1\x03\xe6\x03\x00\x00\xdb\x03\xe4\x03\xd9\x03\xe2\x03\xeb\x03\x17\x04\x00\x00\x00\x00\xde\x02\x00\x00\x00\x00\x00\x00\xd2\x03\xd2\x03\x14\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\xf8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x04\x00\x00\x33\x05\x00\x00\x00\x00\x00\x00\x00\x00\xd1\x03\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\xd5\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x05\x00\x00\x12\x00\x00\x00\x00\x00"#

happyGotoOffsets :: HappyAddr
happyGotoOffsets = HappyA# "\x70\x03\x63\x0e\x11\x04\x0d\x04\x04\x04\x00\x00\xe0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x05\x49\x0e\x00\x00\x00\x00\x16\x03\x8a\x03\x6b\x01\x00\x00\x00\x00\xc1\x01\xf6\x03\xe7\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdf\x01\x00\x00\x00\x00\x57\x01\x82\x03\x78\x0a\xc9\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf9\x03\xf8\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\x03\x4b\x02\x00\x00\x00\x00\x00\x00\xfa\x08\x2f\x0e\x00\x00\x00\x00\x00\x00\x17\x03\x00\x00\xc7\x00\x22\x00\x00\x00\xfa\x00\xf9\x0a\x36\x0a\x00\x00\xdf\x01\xae\x0a\x57\x0a\x93\x0a\xda\x0b\xcb\x0b\xbc\x0b\x00\x00\x00\x00\x58\x05\x15\x0e\x00\x00\x86\x03\x00\x00\xfa\x00\xad\x0b\x9e\x0b\x00\x00\xfb\x0d\xf3\x0b\x02\x01\x00\x00\x10\x03\x00\x00\x00\x00\x8f\x0b\x80\x0b\x00\x00\x00\x00\x00\x00\x00\x00\xe1\x0d\xc7\x0d\x80\x07\xad\x0d\x69\x01\xb3\x03\x00\x00\xab\x03\xe8\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe5\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6f\x03\x6e\x03\x4b\x02\x1d\x00\xd4\x03\xd3\x03\x01\x00\x5e\x03\xc6\x03\xb5\x03\xaa\x03\x38\x03\x32\x03\x31\x03\xa8\x03\xa4\x03\x69\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x84\x03\x00\x00\x00\x00\x00\x00\x8f\x03\x00\x00\x8e\x03\x8d\x03\x81\x03\x7c\x03\x7b\x03\x45\x03\x42\x03\x0f\x03\xc5\x02\x51\x01\x2f\x03\x00\x00\x00\x00\x00\x00\xd9\x01\x00\x00\x00\x00\xc5\x01\xa7\x01\x00\x00\x16\x00\x14\x03\x11\x03\xa7\x02\x00\x00\x00\x00\xa4\x02\xa1\x02\x00\x00\xad\x00\x47\x03\x00\x00\x2e\x00\x00\x00\x1c\x00\x00\x00\x00\x00\xa0\x02\x00\x00\x00\x00\x08\x03\x93\x0d\x79\x0d\xdf\x02\xde\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x59\x02\x71\x0b\x62\x0b\x53\x0b\x1c\x03\x5f\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x7f\x00\x00\x00\x36\x03\x00\x00\x00\x00\x00\x00\x00\x00\x45\x0d\x2b\x0d\x00\x00\x30\x03\x00\x00\x00\x00\x29\x03\x00\x00\x00\x00\x00\x00\x00\x00\x18\x03\xeb\x02\x00\x00\x00\x00\x00\x00\x00\x00\x44\x0b\x35\x0b\x00\x00\x26\x0b\x17\x0b\x37\x02\x00\x00\x34\x02\xfa\x00\xea\x0a\x08\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfa\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x0d\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc2\x02\x00\x00\x89\x02\x84\x06\x00\x00\x2a\x06\xf7\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0b\x00\x00\x00\xdd\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc3\x0c\x00\x00\x00\x00\x00\x00\xb5\x02\x1a\x00\x00\x00\x00\x00\x8c\x02\x00\x00\x00\x00\x2d\x03\x84\x02\x1d\x03\x00\x00\x00\x00\xff\x02\x31\x02\x8a\x00\x9f\x03\xf3\x0b\xc7\x01\x00\x00\xc4\x01\x00\x00\x00\x00\x00\x00\x00\x00\x0b\x0a\xa5\x02\x00\x00\x00\x00\xfb\x02\x00\x00\x84\x02\x18\x02\xf8\x01\x33\x01\x00\x00\x00\x00\x00\x00\x69\x02\x00\x00\x00\x00\x00\x00\x00\x00\xbb\x02\xa8\x02\x00\x00\x00\x00\x00\x00\x3e\x02\xfd\x01\x87\x02\x00\x00\x00\x00\x67\x02\x4f\x02\x4c\x02\x00\x00\xfb\x01\xf3\x01\x00\x00\x00\x00\x00\x00\x00\x00\xde\x01\x00\x00\xdc\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9c\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa9\x0c\x00\x00\x00\x00\x4d\x01\x00\x00\x00\x00\x38\x01\x00\x00\x3f\x00\x00\x00\x00\x00\x89\x01\x00\x00\xd7\x02\xad\x02\x54\x02\x3d\x02\x00\x00\x31\x00\x8f\x0c\x00\x00\x00\x00\x10\x01\x75\x0c\x6e\x01\x5b\x0c\x36\x01\x41\x0c\x5c\x02\x21\x00\x00\x00\x50\x02\x00\x00\x7a\x01\x00\x00\x00\x00\xab\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x32\x00\x27\x0c\x00\x00\x00\x00\xa7\x00\x0d\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9a\x03\x00\x00\x00\x00\x4e\x02\x29\x02\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\xec\x00\xc6\x00\xac\x00\x00\x00\x34\x03\x00\x00\x39\x00\xc4\x02\x00\x00\x00\x00\x00\x00\x00\x00\xfd\xff\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xff\x00\x00\x00\x00\x00\x00\x75\x01\x00\x00\x58\x01\x83\x02\x82\x02\x1a\x01\x00\x00\x00\x00\xdb\x01\x00\x00\x00\x00\xc8\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfd\x00\x00\x00\xe7\x00\x00\x00\x00\x00\x00\x00\x62\x02\x4a\x02\x49\x02\x35\x02\x00\x00\x1a\x02\xc6\x01\x3a\x01\x13\x01\x00\x00\x00\x00\xb1\x00\xe2\x00\x00\x00\xc2\x00\x00\x00\x00\x00\xf3\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\x00\x00\x00\xfb\x00\x00\x00\x00\x00\x00\x00\xca\x00\x00\x00\x8b\x02\x00\x00\x00\x00\x00\x00\xaf\x00\x9c\x00\xba\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x00\x7c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x01\x00\x00\x30\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x00\x71\x01\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x01\x00\x00\x07\x00\x00\x00\x00\x00"#

happyDefActions :: HappyAddr
happyDefActions = HappyA# "\xfa\xff\x00\x00\x00\x00\x00\x00\xfc\xff\x00\x00\xb3\xfe\x86\xff\x64\xff\x00\x00\x76\xff\x75\xff\x73\xff\x72\xff\x6f\xff\x00\x00\x52\xff\x51\xff\x6d\xff\x00\x00\x00\x00\x4a\xff\x48\xff\x00\x00\x00\x00\x60\xff\x5f\xff\x00\x00\x00\x00\x00\x00\x5e\xff\x5d\xff\x5c\xff\x5b\xff\x00\x00\x00\x00\x61\xff\x62\xff\x00\x00\xb3\xfe\x00\x00\x00\x00\x9e\xff\x87\xff\x63\xff\x00\x00\x00\x00\x80\xff\x00\x00\x7f\xff\x00\x00\x65\xff\x57\xff\x00\x00\x00\x00\x9b\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb4\xfe\x58\xff\x84\xff\x1b\xff\x2f\xff\x00\x00\x69\xff\x00\x00\x3a\xff\x37\xff\x30\xff\x00\x00\x00\x00\x83\xff\xb3\xfe\x00\x00\x00\x00\x55\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\xff\x00\x00\x00\x00\x21\xff\x1c\xff\xb3\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\xff\x00\x00\xb3\xfe\x49\xff\x00\x00\x00\x00\x00\x00\x4b\xff\x7a\xff\x71\xff\x67\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf7\xfe\x00\x00\xd9\xfe\x71\xfe\xf0\xfe\xef\xfe\xee\xfe\xed\xfe\xec\xfe\xeb\xfe\xf1\xfe\xea\xfe\xe9\xfe\xe8\xfe\xe7\xfe\xe6\xfe\xe1\xfe\xe0\xfe\xe5\xfe\xe4\xfe\xe3\xfe\xa7\xff\xe2\xfe\xa5\xfe\x98\xfe\xa4\xfe\xa3\xfe\xa2\xfe\xa0\xfe\xa1\xfe\x9f\xfe\x9e\xfe\x9d\xfe\x9a\xfe\x99\xfe\x9c\xfe\x9b\xfe\x6f\xfe\xa6\xfe\x00\x00\x00\x00\xb4\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfb\xfe\x00\x00\xfb\xff\xf9\xff\xf8\xff\xf7\xff\xf6\xff\xf5\xff\xf4\xff\xf3\xff\xf2\xff\xf1\xff\xf0\xff\xef\xff\xee\xff\xed\xff\xec\xff\xeb\xff\xea\xff\xe9\xff\xe8\xff\xe7\xff\xe6\xff\xe5\xff\xe4\xff\xe3\xff\xe2\xff\xe1\xff\xe0\xff\xdf\xff\xde\xff\xdd\xff\xdc\xff\xdb\xff\xda\xff\xd9\xff\xd8\xff\xd7\xff\xd6\xff\xce\xff\xcd\xff\xcc\xff\xd5\xff\xd4\xff\xd3\xff\xd2\xff\xd1\xff\xd0\xff\xcf\xff\xcb\xff\xca\xff\xc9\xff\xc8\xff\xc7\xff\xc6\xff\xc5\xff\xc4\xff\xc3\xff\xc2\xff\xc1\xff\xc0\xff\xbf\xff\xbe\xff\xbd\xff\xbc\xff\xbb\xff\xba\xff\xb9\xff\xb8\xff\xb7\xff\xb6\xff\xb5\xff\xb4\xff\xb3\xff\xb2\xff\xb1\xff\xb0\xff\xaf\xff\xae\xff\xad\xff\xac\xff\xab\xff\xaa\xff\xa9\xff\x7e\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf7\xfe\x00\x00\xc4\xfe\x00\x00\xc9\xfe\xca\xfe\xcb\xfe\x00\x00\x9f\xff\xa0\xff\x00\x00\x00\x00\xcc\xfe\x00\x00\x1d\xff\x1d\xff\x1d\xff\x86\xff\x85\xff\x1d\xff\x1d\xff\xa7\xfe\xaf\xfe\x00\x00\xc7\xfe\x00\x00\xc8\xfe\x00\x00\xa8\xff\xa6\xff\xb3\xfe\xa3\xff\xa2\xff\xf5\xfe\x00\x00\x00\x00\xf9\xfe\x00\x00\x56\xff\x77\xff\x74\xff\x78\xff\x7f\xff\x6d\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\xff\x4e\xff\x50\xff\x80\xff\x00\x00\x23\xff\x24\xff\x79\xff\x22\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\xff\x00\x00\x25\xff\x00\x00\x00\x00\x2d\xff\x2c\xff\x2e\xff\x1a\xff\x00\x00\x00\x00\x19\xff\x00\x00\x00\x00\x36\xff\x32\xff\x37\xff\xb3\xfe\x00\x00\x00\x00\x3b\xff\x70\xff\x31\xff\x00\x00\x3e\xff\x00\x00\x41\xff\x59\xff\x9a\xff\x40\xff\x5a\xff\x3f\xff\x66\xff\x00\x00\x3c\xff\xaf\xfe\x3d\xff\x34\xff\x33\xff\x35\xff\x39\xff\x38\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\xff\x00\x00\x00\x00\x47\xff\x45\xff\x46\xff\x44\xff\x42\xff\x43\xff\x6b\xff\x6c\xff\x17\xff\x18\xff\x00\x00\x00\x00\x54\xff\x00\x00\x6e\xff\x75\xfe\xa4\xff\xa5\xff\xf6\xfe\xfd\xfe\x00\x00\xdb\xfe\xda\xfe\xdc\xfe\x00\x00\x00\x00\x72\xfe\x98\xff\x96\xff\x00\x00\x85\xfe\x00\x00\x00\x00\x9c\xff\x00\x00\x88\xfe\x00\x00\x1d\xff\xaf\xfe\x10\xff\x00\x00\x1d\xff\x00\x00\x1d\xff\x00\x00\x00\x00\x00\x00\x00\x00\x50\xff\x94\xff\x00\x00\x82\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x81\xff\xcf\xfe\xce\xfe\xcd\xfe\x00\x00\xc0\xfe\xbe\xfe\xb9\xfe\x00\x00\x00\x00\x00\x00\xb5\xfe\xc3\xfe\x00\x00\xfb\xfe\x68\xff\xf9\xfe\x00\x00\x7b\xff\x7e\xff\x7e\xff\x7e\xff\x00\x00\x00\x00\x7e\xff\x8d\xfe\x00\x00\x8b\xfe\x00\x00\x00\x00\x00\x00\x7e\xff\x7d\xff\x97\xfe\x00\x00\x8c\xfe\x8e\xfe\x00\x00\x00\x00\x7c\xff\x7e\xff\x00\x00\x00\x00\x00\x00\x8f\xfe\xfc\xfe\xfa\xfe\x00\x00\x00\x00\xb7\xfe\x00\x00\x00\x00\xb7\xfe\x00\x00\xbf\xfe\x00\x00\x82\xff\x00\x00\x00\x00\x99\xff\x00\x00\x00\x00\x00\x00\x00\x00\x84\xfe\x00\x00\x00\x00\x95\xff\x86\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1f\xff\x00\x00\x1e\xff\x00\x00\xb1\xfe\x12\xff\x10\xff\x0e\xff\x0d\xff\x00\x00\x00\x00\x00\x00\x0f\xff\xae\xfe\x00\x00\x8a\xfe\x00\x00\x00\x00\x9d\xff\x87\xfe\x00\x00\x00\x00\x97\xff\x00\x00\x00\x00\x73\xfe\xf4\xfe\x00\x00\xf8\xfe\x4c\xff\x4d\xff\x53\xff\x2b\xff\x2a\xff\x29\xff\x28\xff\x26\xff\x27\xff\x15\xff\x16\xff\x13\xff\x14\xff\x10\xff\xb2\xfe\x74\xfe\x00\x00\x00\x00\xde\xfe\x86\xfe\xdf\xfe\x89\xfe\x00\x00\xa1\xff\x01\xff\x01\xff\x11\xff\x10\xff\xa8\xfe\xaf\xfe\x10\xff\xa9\xfe\xd4\xfe\x80\xfe\xd6\xfe\x00\x00\x00\x00\xd5\xfe\xd1\xfe\xd2\xfe\x00\x00\xdd\xfe\x83\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x92\xff\x90\xff\xc6\xfe\xc2\xfe\x00\x00\x00\x00\xbc\xfe\x00\x00\x00\x00\xbd\xfe\xc5\xfe\x90\xfe\x91\xfe\x93\xfe\x00\x00\x94\xfe\x95\xfe\x96\xfe\x92\xfe\x00\x00\xb7\xfe\x00\x00\x00\x00\x00\x00\xc1\xfe\x91\xff\x93\xff\x8c\xff\x8e\xff\x88\xff\x8a\xff\x7f\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x77\xfe\x76\xfe\x00\x00\x00\x00\x81\xfe\x00\x00\xab\xfe\xac\xfe\x00\x00\xb0\xfe\x03\xff\xff\xfe\x00\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x00\x07\xff\x00\x00\xa1\xff\x09\xff\x10\xff\xf3\xfe\xf2\xfe\xaa\xfe\x00\x00\x00\x00\xa1\xff\x0a\xff\x05\xff\x0b\xff\x02\xff\x0c\xff\x00\x00\x00\x00\xd8\xfe\xd7\xfe\xd3\xfe\xd0\xfe\x7c\xfe\x7b\xfe\xb3\xfe\x7e\xfe\xb3\xfe\x8b\xff\x89\xff\x8f\xff\x8d\xff\x00\x00\xba\xfe\xb6\xfe\xbb\xfe\xb8\xfe\x00\x00\x00\x00\x00\x00\xad\xfe\xfe\xfe\x08\xff\x06\xff\x04\xff\x78\xfe\x7a\xfe\xb3\xfe\x7d\xfe\x00\x00\x79\xfe"#

happyCheck :: HappyAddr
happyCheck = HappyA# "\xff\xff\x05\x00\x05\x00\x40\x00\x02\x00\x09\x00\x09\x00\x0a\x00\x09\x00\x03\x00\x09\x00\x0f\x00\x05\x00\x00\x00\x0f\x00\x10\x00\x0f\x00\x4e\x00\x00\x00\x05\x00\x09\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x0f\x00\x09\x00\x39\x00\x20\x00\x0c\x00\x09\x00\x0e\x00\x09\x00\x09\x00\x3b\x00\x0c\x00\x0d\x00\x09\x00\x09\x00\x0f\x00\x10\x00\x23\x00\x24\x00\x0f\x00\x10\x00\x46\x00\x11\x00\x48\x00\x4e\x00\x4e\x00\x09\x00\x0a\x00\x51\x00\x09\x00\x09\x00\x0a\x00\x0c\x00\x42\x00\x0e\x00\x03\x00\x3b\x00\x09\x00\x47\x00\x0f\x00\x48\x00\x44\x00\x4b\x00\x0f\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x4a\x00\x1f\x00\x20\x00\x21\x00\x4e\x00\x4a\x00\x4e\x00\x62\x00\x63\x00\x4a\x00\x03\x00\x66\x00\x67\x00\x65\x00\x49\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x05\x00\x48\x00\x7a\x00\x3b\x00\x09\x00\x48\x00\x4a\x00\x0f\x00\x81\x00\x05\x00\x0f\x00\x84\x00\x03\x00\x68\x00\x4e\x00\x4f\x00\x68\x00\x65\x00\x0b\x00\x09\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x3b\x00\x09\x00\x7e\x00\x3d\x00\x09\x00\x3b\x00\x7c\x00\x0f\x00\x3c\x00\x5c\x00\x0f\x00\x64\x00\x3d\x00\x48\x00\x61\x00\x22\x00\x23\x00\x24\x00\x48\x00\x09\x00\x4e\x00\x4f\x00\x7a\x00\x1f\x00\x20\x00\x21\x00\x1f\x00\x20\x00\x21\x00\x4e\x00\x09\x00\x44\x00\x42\x00\x0c\x00\x0d\x00\x09\x00\x09\x00\x47\x00\x09\x00\x3b\x00\x3d\x00\x4b\x00\x0f\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x07\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x4e\x00\x1f\x00\x20\x00\x21\x00\x09\x00\x09\x00\x07\x00\x62\x00\x63\x00\x09\x00\x00\x00\x66\x00\x67\x00\x11\x00\x3a\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x09\x00\x4b\x00\x3f\x00\x40\x00\x41\x00\x64\x00\x0f\x00\x49\x00\x64\x00\x3f\x00\x07\x00\x84\x00\x42\x00\x3c\x00\x3d\x00\x3e\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x3a\x00\x09\x00\x09\x00\x3f\x00\x40\x00\x41\x00\x09\x00\x0f\x00\x3f\x00\x09\x00\x41\x00\x13\x00\x14\x00\x3a\x00\x48\x00\x64\x00\x03\x00\x4b\x00\x3b\x00\x1b\x00\x1c\x00\x1d\x00\x3c\x00\x1f\x00\x20\x00\x21\x00\x09\x00\x41\x00\x0f\x00\x4a\x00\x4b\x00\x48\x00\x42\x00\x29\x00\x22\x00\x23\x00\x24\x00\x47\x00\x3c\x00\x3d\x00\x3e\x00\x4b\x00\x3d\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x80\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x79\x00\x09\x00\x4e\x00\x46\x00\x05\x00\x48\x00\x7f\x00\x62\x00\x63\x00\x11\x00\x12\x00\x66\x00\x67\x00\x61\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x09\x00\x09\x00\x79\x00\x62\x00\x63\x00\x61\x00\x0f\x00\x09\x00\x7f\x00\x11\x00\x0b\x00\x84\x00\x85\x00\x38\x00\x39\x00\x11\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x09\x00\x45\x00\x09\x00\x47\x00\x05\x00\x06\x00\x0f\x00\x28\x00\x0f\x00\x61\x00\x4e\x00\x2c\x00\x3a\x00\x28\x00\x0b\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x0b\x00\x35\x00\x36\x00\x1f\x00\x20\x00\x21\x00\x20\x00\x35\x00\x36\x00\x3c\x00\x4b\x00\x80\x00\x43\x00\x42\x00\x45\x00\x0b\x00\x47\x00\x44\x00\x47\x00\x46\x00\x61\x00\x48\x00\x4b\x00\x4e\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x45\x00\x5b\x00\x47\x00\x61\x00\x79\x00\x09\x00\x15\x00\x62\x00\x63\x00\x4e\x00\x7f\x00\x66\x00\x67\x00\x11\x00\x12\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x09\x00\x09\x00\x05\x00\x06\x00\x09\x00\x09\x00\x0f\x00\x09\x00\x45\x00\x11\x00\x47\x00\x84\x00\x11\x00\x11\x00\x12\x00\x11\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x09\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x79\x00\x09\x00\x28\x00\x11\x00\x12\x00\x28\x00\x7f\x00\x0f\x00\x28\x00\x46\x00\x15\x00\x48\x00\x32\x00\x33\x00\x17\x00\x35\x00\x36\x00\x34\x00\x35\x00\x36\x00\x34\x00\x35\x00\x36\x00\x1f\x00\x20\x00\x21\x00\x09\x00\x42\x00\x09\x00\x0c\x00\x0d\x00\x09\x00\x47\x00\x15\x00\x0f\x00\x10\x00\x4b\x00\x0f\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x16\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x05\x00\x06\x00\x09\x00\x62\x00\x63\x00\x0c\x00\x0d\x00\x66\x00\x67\x00\x60\x00\x61\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x09\x00\x09\x00\x60\x00\x61\x00\x09\x00\x09\x00\x0f\x00\x09\x00\x0c\x00\x11\x00\x0e\x00\x84\x00\x11\x00\x09\x00\x0a\x00\x11\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x09\x00\x09\x00\x09\x00\x0c\x00\x0c\x00\x0e\x00\x0e\x00\x28\x00\x0f\x00\x10\x00\x28\x00\x09\x00\x0a\x00\x28\x00\x2c\x00\x15\x00\x09\x00\x2c\x00\x15\x00\x34\x00\x35\x00\x36\x00\x0f\x00\x35\x00\x36\x00\x09\x00\x35\x00\x36\x00\x0c\x00\x43\x00\x0e\x00\x45\x00\x42\x00\x47\x00\x1b\x00\x1c\x00\x1d\x00\x47\x00\x1f\x00\x20\x00\x21\x00\x4b\x00\x15\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x43\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x09\x00\x09\x00\x09\x00\x0c\x00\x0c\x00\x0e\x00\x0e\x00\x62\x00\x63\x00\x0b\x00\x09\x00\x66\x00\x67\x00\x0c\x00\x0d\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x09\x00\x09\x00\x82\x00\x83\x00\x09\x00\x09\x00\x0f\x00\x09\x00\x0c\x00\x11\x00\x0e\x00\x84\x00\x11\x00\x09\x00\x0a\x00\x11\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x5e\x00\x5f\x00\x28\x00\x61\x00\x44\x00\x28\x00\x0b\x00\x09\x00\x28\x00\x82\x00\x83\x00\x82\x00\x83\x00\x0f\x00\x34\x00\x35\x00\x36\x00\x34\x00\x35\x00\x36\x00\x34\x00\x35\x00\x36\x00\x82\x00\x83\x00\x09\x00\x0a\x00\x42\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x47\x00\x0a\x00\x0b\x00\x0c\x00\x4b\x00\x0e\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x06\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x05\x00\x06\x00\x62\x00\x63\x00\x05\x00\x06\x00\x66\x00\x67\x00\x60\x00\x61\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x09\x00\x09\x00\x60\x00\x61\x00\x09\x00\x06\x00\x0f\x00\x09\x00\x05\x00\x11\x00\x44\x00\x84\x00\x11\x00\x09\x00\x0a\x00\x11\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x05\x00\x06\x00\x0b\x00\x38\x00\x39\x00\x82\x00\x83\x00\x28\x00\x3d\x00\x0b\x00\x28\x00\x27\x00\x28\x00\x28\x00\x43\x00\x0b\x00\x45\x00\x2c\x00\x47\x00\x34\x00\x35\x00\x36\x00\x34\x00\x35\x00\x36\x00\x4e\x00\x35\x00\x36\x00\x46\x00\x3c\x00\x09\x00\x43\x00\x42\x00\x45\x00\x45\x00\x47\x00\x43\x00\x47\x00\x45\x00\x17\x00\x47\x00\x4b\x00\x17\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x4e\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x00\x00\x01\x00\x62\x00\x63\x00\x4e\x00\x4f\x00\x66\x00\x67\x00\x3b\x00\x3c\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x4e\x00\x4f\x00\x09\x00\x5d\x00\x5e\x00\x5f\x00\x09\x00\x61\x00\x0f\x00\x17\x00\x17\x00\x84\x00\x13\x00\x14\x00\x11\x00\x17\x00\x15\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x17\x00\x17\x00\x17\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x43\x00\x09\x00\x28\x00\x00\x00\x01\x00\x09\x00\x08\x00\x82\x00\x82\x00\x06\x00\x07\x00\x08\x00\x09\x00\x33\x00\x82\x00\x35\x00\x36\x00\x08\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x08\x00\x20\x00\x21\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x7d\x00\x09\x00\x09\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x62\x00\x63\x00\x37\x00\x79\x00\x39\x00\x04\x00\x7b\x00\x3d\x00\x3d\x00\x3e\x00\x06\x00\x40\x00\x09\x00\x43\x00\x43\x00\x45\x00\x45\x00\x47\x00\x47\x00\x4c\x00\x45\x00\x4a\x00\x82\x00\x4c\x00\x4e\x00\x4e\x00\x4f\x00\x09\x00\x51\x00\x00\x00\x01\x00\x0b\x00\x0b\x00\x3d\x00\x02\x00\x06\x00\x07\x00\x08\x00\x09\x00\x43\x00\x82\x00\x45\x00\x01\x00\x47\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x03\x00\x44\x00\x4e\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x4e\x00\x20\x00\x21\x00\x0f\x00\x0d\x00\x3a\x00\x44\x00\x4e\x00\x44\x00\x4e\x00\x44\x00\x3a\x00\x38\x00\x39\x00\x4e\x00\x4e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x49\x00\x43\x00\x37\x00\x45\x00\x39\x00\x47\x00\x49\x00\x46\x00\x3d\x00\x3e\x00\x4e\x00\x40\x00\x48\x00\x4e\x00\x43\x00\x3f\x00\x45\x00\x3f\x00\x47\x00\x4d\x00\x48\x00\x4a\x00\x03\x00\x4c\x00\x01\x00\x4e\x00\x4f\x00\x48\x00\x51\x00\x06\x00\x07\x00\x08\x00\x03\x00\x03\x00\x49\x00\x03\x00\x03\x00\x3c\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x4e\x00\x43\x00\x49\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x43\x00\x20\x00\x21\x00\x43\x00\x49\x00\x49\x00\x4e\x00\x48\x00\x4e\x00\x3c\x00\x46\x00\x3c\x00\x4e\x00\x48\x00\x4d\x00\x4d\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x4d\x00\x50\x00\x37\x00\x4d\x00\x39\x00\x4d\x00\x04\x00\x4d\x00\x3d\x00\x3e\x00\x4d\x00\x40\x00\x50\x00\x4d\x00\x43\x00\x50\x00\x45\x00\x4d\x00\x47\x00\x50\x00\x3c\x00\x4a\x00\x50\x00\x4c\x00\x50\x00\x4e\x00\x4f\x00\x4d\x00\x51\x00\x52\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x01\x00\x50\x00\x42\x00\x40\x00\x3b\x00\x06\x00\x07\x00\x08\x00\x03\x00\x3b\x00\x4e\x00\x3b\x00\x4e\x00\x49\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x48\x00\x3f\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x3f\x00\x20\x00\x21\x00\x3f\x00\x3f\x00\x3f\x00\x3f\x00\x44\x00\x48\x00\x4e\x00\x48\x00\x3a\x00\x44\x00\x04\x00\x3c\x00\x05\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x48\x00\x48\x00\x37\x00\x4e\x00\x39\x00\x4e\x00\x50\x00\x4d\x00\x3d\x00\x3e\x00\x4a\x00\x40\x00\x4d\x00\x50\x00\x43\x00\x01\x00\x45\x00\x50\x00\x47\x00\x50\x00\x06\x00\x07\x00\x08\x00\x4c\x00\x50\x00\x4e\x00\x4f\x00\x42\x00\x51\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x49\x00\x4e\x00\x49\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x49\x00\x20\x00\x21\x00\x49\x00\x42\x00\x05\x00\x02\x00\x4e\x00\x47\x00\x3f\x00\x02\x00\x02\x00\x3f\x00\x49\x00\x09\x00\x09\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x44\x00\x11\x00\x37\x00\x01\x00\x39\x00\x44\x00\x44\x00\x48\x00\x3d\x00\x3e\x00\x3b\x00\x40\x00\x48\x00\x48\x00\x43\x00\x52\x00\x45\x00\x4e\x00\x47\x00\x49\x00\x12\x00\x09\x00\x3f\x00\x4c\x00\x28\x00\x4e\x00\x4f\x00\x0f\x00\x51\x00\x3c\x00\x52\x00\x1d\x00\x1e\x00\x1f\x00\x52\x00\x33\x00\x41\x00\x35\x00\x36\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x49\x00\xff\xff\x01\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\xff\xff\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\x12\x00\x40\x00\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\x46\x00\x47\x00\x48\x00\xff\xff\x1d\x00\x1e\x00\x1f\x00\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\xff\xff\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\x12\x00\x40\x00\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\x46\x00\x47\x00\x48\x00\xff\xff\x1d\x00\x1e\x00\x1f\x00\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x08\x00\xff\xff\xff\xff\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\x12\x00\x40\x00\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\x46\x00\x47\x00\x48\x00\xff\xff\x1d\x00\x1e\x00\x1f\x00\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\x12\x00\x40\x00\xff\xff\x09\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x0f\x00\xff\xff\x1d\x00\x1e\x00\x1f\x00\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\xff\xff\xff\xff\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x01\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\x38\x00\x39\x00\x2e\x00\x2f\x00\x30\x00\x3d\x00\x3e\x00\x12\x00\x40\x00\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x1d\x00\x1e\x00\x1f\x00\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\x12\x00\x40\x00\xff\xff\x09\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x0f\x00\xff\xff\x1d\x00\x1e\x00\x1f\x00\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\xff\xff\xff\xff\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x01\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\x38\x00\x39\x00\x2e\x00\x2f\x00\x30\x00\x3d\x00\x3e\x00\x12\x00\x40\x00\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x1d\x00\x1e\x00\x1f\x00\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\x12\x00\x40\x00\xff\xff\x09\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x0f\x00\xff\xff\x1d\x00\x1e\x00\x1f\x00\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x01\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\x12\x00\x40\x00\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x1d\x00\x1e\x00\x1f\x00\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\x12\x00\xff\xff\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\x40\x00\x1d\x00\x1e\x00\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\x4f\x00\x08\x00\x51\x00\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\x12\x00\xff\xff\xff\xff\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\x40\x00\x1d\x00\x1e\x00\x43\x00\xff\xff\x45\x00\x46\x00\x47\x00\x48\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\x01\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\x12\x00\x40\x00\xff\xff\x09\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x0f\x00\xff\xff\x1d\x00\x1e\x00\x1f\x00\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\x01\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\x12\x00\xff\xff\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\x40\x00\x1d\x00\x1e\x00\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\xff\xff\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\x4f\x00\x08\x00\x51\x00\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\x12\x00\xff\xff\xff\xff\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\x40\x00\x1d\x00\x1e\x00\x43\x00\xff\xff\x45\x00\x46\x00\x47\x00\x48\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\x01\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\xff\xff\xff\xff\xff\xff\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\x12\x00\x40\x00\xff\xff\xff\xff\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\xff\xff\xff\xff\x1d\x00\x1e\x00\x1f\x00\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\x01\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\x12\x00\xff\xff\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\x40\x00\x1d\x00\x1e\x00\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\xff\xff\x01\x00\xff\xff\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\x3f\x00\x40\x00\xff\xff\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\x4f\x00\x01\x00\x51\x00\xff\xff\x1d\x00\x1e\x00\x1f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\x1d\x00\x1e\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\x40\x00\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x4e\x00\x4f\x00\xff\xff\x51\x00\x39\x00\x01\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\x40\x00\x08\x00\xff\xff\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\xff\xff\x01\x00\xff\xff\xff\xff\x1d\x00\x1e\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\xff\xff\x3f\x00\xff\xff\xff\xff\xff\xff\x43\x00\x12\x00\x45\x00\xff\xff\x47\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x4e\x00\x1d\x00\x1e\x00\xff\xff\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\x40\x00\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x4e\x00\x4f\x00\xff\xff\x51\x00\x39\x00\x01\x00\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\x40\x00\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\xff\xff\xff\xff\xff\xff\x09\x00\x1d\x00\x1e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x11\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\x1d\x00\x1e\x00\xff\xff\x39\x00\xff\xff\x28\x00\xff\xff\x3d\x00\x3e\x00\x2c\x00\x40\x00\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\x35\x00\x36\x00\x31\x00\x32\x00\x33\x00\x34\x00\x4e\x00\x4f\x00\xff\xff\x51\x00\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\x12\x00\xff\xff\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\xff\xff\xff\xff\x1d\x00\x1e\x00\xff\xff\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\x1d\x00\x1e\x00\xff\xff\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\xff\xff\xff\xff\x31\x00\x32\x00\x33\x00\x34\x00\x4e\x00\x4f\x00\xff\xff\x51\x00\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\x12\x00\xff\xff\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\xff\xff\xff\xff\x1d\x00\x1e\x00\xff\xff\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\x1d\x00\x1e\x00\xff\xff\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\xff\xff\xff\xff\x31\x00\x32\x00\x33\x00\x34\x00\x4e\x00\x4f\x00\xff\xff\x51\x00\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\x12\x00\xff\xff\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\xff\xff\xff\xff\x1d\x00\x1e\x00\xff\xff\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\x32\x00\x33\x00\x34\x00\xff\xff\x1d\x00\x1e\x00\xff\xff\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\xff\xff\xff\xff\x31\x00\x32\x00\x33\x00\x34\x00\x4e\x00\x4f\x00\xff\xff\x51\x00\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\x12\x00\xff\xff\xff\xff\x09\x00\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\x0f\x00\xff\xff\x1d\x00\x1e\x00\x13\x00\x14\x00\x4e\x00\x4f\x00\xff\xff\x51\x00\xff\xff\xff\xff\x1b\x00\x1c\x00\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x31\x00\x32\x00\x33\x00\x34\x00\x29\x00\xff\xff\xff\xff\xff\xff\x39\x00\xff\xff\xff\xff\xff\xff\x3d\x00\x3e\x00\xff\xff\x09\x00\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\x0f\x00\x47\x00\xff\xff\xff\xff\x13\x00\x14\x00\xff\xff\xff\xff\x4e\x00\x4f\x00\xff\xff\x51\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x29\x00\x09\x00\xff\xff\x0b\x00\xff\xff\x2e\x00\x2f\x00\x0f\x00\x31\x00\xff\xff\xff\xff\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x09\x00\xff\xff\x0b\x00\xff\xff\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x09\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x0f\x00\xff\xff\xff\xff\xff\xff\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x09\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x0f\x00\xff\xff\xff\xff\xff\xff\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\x09\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x0f\x00\xff\xff\xff\xff\xff\xff\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x09\x00\xff\xff\x0b\x00\xff\xff\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x0b\x00\x1b\x00\x1c\x00\x1d\x00\x0f\x00\x1f\x00\x20\x00\x21\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x29\x00\x1b\x00\x1c\x00\x1d\x00\x0f\x00\x1f\x00\x20\x00\x21\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x29\x00\x1b\x00\x1c\x00\x1d\x00\x0f\x00\x1f\x00\x20\x00\x21\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x29\x00\x1b\x00\x1c\x00\x1d\x00\x0f\x00\x1f\x00\x20\x00\x21\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x29\x00\x1b\x00\x1c\x00\x1d\x00\x0f\x00\x1f\x00\x20\x00\x21\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x29\x00\x1b\x00\x1c\x00\x1d\x00\x0f\x00\x1f\x00\x20\x00\x21\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x29\x00\x1b\x00\x1c\x00\x1d\x00\x0f\x00\x1f\x00\x20\x00\x21\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x29\x00\x1b\x00\x1c\x00\x1d\x00\x0f\x00\x1f\x00\x20\x00\x21\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x29\x00\x1b\x00\x1c\x00\x1d\x00\x0f\x00\x1f\x00\x20\x00\x21\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x29\x00\x1b\x00\x1c\x00\x1d\x00\x0f\x00\x1f\x00\x20\x00\x21\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x29\x00\x1b\x00\x1c\x00\x1d\x00\x0f\x00\x1f\x00\x20\x00\x21\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x29\x00\x1b\x00\x1c\x00\x1d\x00\x0f\x00\x1f\x00\x20\x00\x21\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x29\x00\x1b\x00\x1c\x00\x1d\x00\x0f\x00\x1f\x00\x20\x00\x21\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x29\x00\x1b\x00\x1c\x00\x1d\x00\x0f\x00\x1f\x00\x20\x00\x21\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x29\x00\x1b\x00\x1c\x00\x1d\x00\x0f\x00\x1f\x00\x20\x00\x21\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x29\x00\x1b\x00\x1c\x00\x1d\x00\x0f\x00\x1f\x00\x20\x00\x21\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x29\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\x1f\x00\x20\x00\x21\x00\x09\x00\xff\xff\x0b\x00\xff\xff\xff\xff\xff\xff\x0f\x00\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x09\x00\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\xff\xff\xff\xff\xff\xff\x25\x00\x26\x00\x27\x00\x28\x00\x38\x00\x39\x00\xff\xff\x38\x00\x39\x00\x3d\x00\xff\xff\x3f\x00\x3d\x00\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\x43\x00\x47\x00\x45\x00\xff\xff\x47\x00\x38\x00\x39\x00\xff\xff\x4e\x00\xff\xff\x3d\x00\x4e\x00\xff\xff\xff\xff\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\x38\x00\x39\x00\xff\xff\x38\x00\x39\x00\x3d\x00\x4e\x00\xff\xff\x3d\x00\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\x43\x00\x47\x00\x45\x00\xff\xff\x47\x00\x38\x00\x39\x00\xff\xff\x4e\x00\xff\xff\x3d\x00\x4e\x00\xff\xff\xff\xff\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\x38\x00\x39\x00\xff\xff\x38\x00\x39\x00\x3d\x00\x4e\x00\xff\xff\x3d\x00\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\x43\x00\x47\x00\x45\x00\xff\xff\x47\x00\x38\x00\x39\x00\xff\xff\x4e\x00\xff\xff\x3d\x00\x4e\x00\xff\xff\xff\xff\xff\xff\xff\xff\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"#

happyTable :: HappyAddr
happyTable = HappyA# "\x00\x00\x73\x02\x7c\x02\xee\x01\x3d\x01\x07\x00\xa3\x01\xa4\x01\x1d\x01\x01\x02\x07\x00\x08\x00\xbb\x02\x93\x01\x1e\x01\x42\x02\x08\x00\xc7\x01\x93\x01\xb6\x02\x3d\x01\x74\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x75\x00\x10\x00\x11\x00\x12\x00\x87\x02\x9d\x01\xa3\x01\x1a\x01\xb3\x01\x1f\x02\xb4\x01\x9d\x01\x1d\x01\x72\x01\x9e\x01\x9f\x01\x1d\x01\x40\x00\x1e\x01\x1f\x01\x26\x02\x40\x01\x1e\x01\x42\x02\x38\x00\x58\x01\x39\x00\x2b\x00\x15\x01\xa3\x01\xa4\x01\x16\x01\x9d\x01\xa3\x01\xa4\x01\xb3\x01\x76\x00\xb4\x01\x03\x02\x02\x02\x07\x00\x77\x00\x24\x01\xa5\x01\x75\x01\x78\x00\x08\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x74\x02\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x94\x01\x10\x00\x11\x00\xa8\x01\x2b\x00\x94\x01\x2b\x00\x3b\x00\x86\x00\xb5\x01\x07\x02\x87\x00\x88\x00\x8e\x02\xa0\x01\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x34\x02\xa5\x01\xa6\x01\x04\x02\x07\x00\x3a\x02\x4f\x02\x8d\x02\x75\x02\xb9\x02\x08\x00\x76\x02\x05\x02\x20\x02\x2b\x00\x2c\x00\x20\x01\x43\x02\xb1\x02\x3d\x01\x74\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x75\x00\x10\x00\x11\x00\x12\x00\x72\x01\x07\x00\xb6\x01\x22\x01\x07\x00\x72\x01\xa1\x01\x08\x00\x08\x02\x56\x02\x08\x00\x7f\x02\x4c\x00\x30\x02\x57\x02\x8c\x01\x3f\x01\x40\x01\x32\x02\xb4\x02\x2b\x00\x2c\x00\xa6\x01\x10\x00\x11\x00\xa8\x01\x10\x00\x11\x00\xa8\x01\x2b\x00\x9d\x01\x8e\x02\x76\x00\x9e\x01\x9f\x01\x82\x02\x07\x00\x77\x00\xb5\x02\x06\x02\x22\x01\x78\x00\x08\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x88\x02\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x2b\x00\x10\x00\x11\x00\xa8\x01\x82\x02\x40\x00\x92\x02\x3b\x00\x86\x00\x82\x02\x93\x01\x87\x00\x88\x00\x5b\x01\x2c\x01\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x07\x00\x2d\x01\x83\x02\x84\x02\x85\x02\x15\x02\x08\x00\x38\x02\x32\x02\x71\x00\x88\x02\x3b\x01\x72\x00\xb3\x02\x8a\x02\x8b\x02\x74\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x75\x00\x10\x00\x11\x00\x12\x00\x2c\x01\x07\x00\x96\x02\x83\x02\x87\x02\x85\x02\x98\x02\x08\x00\x83\x02\x3d\x01\xb2\x02\x2e\x00\x2f\x00\x2c\x01\x80\x01\xa9\x01\x9b\x01\x2d\x01\x7f\xff\x36\x01\x0d\x00\x0e\x00\x90\x01\x10\x00\x11\x00\x37\x01\x9f\x02\x74\x00\x9c\x01\x94\x01\x2d\x01\x7f\xff\x76\x00\x3a\x00\x3e\x01\x3f\x01\x40\x01\x77\x00\x89\x02\x8a\x02\x8b\x02\x78\x00\x4c\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x9e\x02\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x46\x02\x40\x00\x2b\x00\x38\x00\xa0\x02\x39\x00\x9c\x02\x3b\x00\x86\x00\xbb\x01\xf3\x01\x87\x00\x88\x00\xa9\x02\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x07\x00\x40\x00\x46\x02\x3b\x00\x3c\x00\xab\x02\x08\x00\x40\x00\x9d\x02\x41\x00\x6f\x02\x99\x00\x9a\x00\xb8\x01\xb9\x01\x41\x00\x74\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x75\x00\x10\x00\x11\x00\x12\x00\x07\x00\xba\x01\x07\x00\xbb\x01\xb7\x02\xb8\x02\x08\x00\x5e\x01\x08\x00\x6c\x02\x2b\x00\xc7\x01\x2c\x01\x42\x00\x71\x02\x43\x00\x44\x00\x45\x00\x46\x00\x40\x02\x60\x01\x5d\x00\x10\x00\x11\x00\x32\x01\x61\x00\x47\x00\x48\x00\x73\xff\x2d\x01\x4c\x02\xc4\x01\x76\x00\xc5\x01\x54\x02\xc6\x01\x73\xff\x77\x00\x73\xff\x58\x02\x73\xff\x78\x00\xc7\x01\x79\x00\x7a\x00\x7b\x00\x7c\x00\xaf\x02\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\xf8\x01\xc8\x01\xf9\x01\x5b\x02\x46\x02\x40\x00\x62\x02\x3b\x00\x86\x00\x2b\x00\x47\x02\x87\x00\x88\x00\xbb\x01\xbc\x01\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x07\x00\x40\x00\xa1\x02\xa2\x02\x40\x00\x40\x00\x08\x00\x40\x00\xfa\x01\x41\x00\xfb\x01\xb0\x02\x41\x00\xbb\x01\xbd\x01\x41\x00\x74\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x75\x00\x10\x00\x11\x00\x12\x00\x40\x00\x3f\x02\x0e\x02\x0f\x02\x10\x02\x46\x02\x07\x00\x59\x00\xbb\x01\xbe\x01\xab\x01\x4a\x02\x08\x00\xab\x01\x38\x00\xdb\x01\x39\x00\x5a\x00\x5b\x00\xdd\x01\x5c\x00\x5d\x00\x08\x02\xad\x01\x5d\x00\x0a\x02\xad\x01\x5d\x00\x10\x00\x11\x00\x4f\x00\x9d\x01\x76\x00\x1d\x01\x9e\x01\xf4\x01\x07\x00\x77\x00\xe0\x01\x1e\x01\x73\x01\x78\x00\x08\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\xe1\x01\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x6e\x00\x10\x00\x11\x00\xca\x01\xa3\x02\xa4\x02\x9d\x01\x3b\x00\x86\x00\x9e\x01\xf5\x01\x87\x00\x88\x00\x67\x02\x68\x02\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x07\x00\x40\x00\x6a\x02\x68\x02\x40\x00\x9d\x01\x08\x00\x40\x00\xb3\x01\x41\x00\xa5\x02\xba\x02\x41\x00\xa3\x01\x50\x02\x41\x00\x74\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x75\x00\x10\x00\x11\x00\x12\x00\x9d\x01\x9d\x01\x1d\x01\xb3\x01\xb3\x01\xa6\x02\xa7\x02\xab\x01\x1e\x01\x22\x01\x5e\x01\xa3\x01\x51\x02\x5e\x01\x78\x01\xe4\x01\x07\x00\x79\x01\xe5\x01\x16\x02\xad\x01\x5d\x00\x08\x00\x60\x01\x5d\x00\x9d\x01\x60\x01\x5d\x00\xb3\x01\x39\x01\xa8\x02\x3a\x01\x76\x00\x3b\x01\x6d\x00\x0d\x00\x0e\x00\x77\x00\x10\x00\x11\x00\x37\x01\x78\x00\xe6\x01\x79\x00\x7a\x00\x7b\x00\x7c\x00\xe9\x01\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x9d\x01\x9d\x01\xf6\x01\xb3\x01\xb3\x01\x6d\x02\x6e\x02\x3b\x00\x86\x00\x2e\x02\x9d\x01\x87\x00\x88\x00\x9e\x01\x1e\x02\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x07\x00\x40\x00\x21\x02\x8f\x02\x40\x00\x9d\x01\x08\x00\x40\x00\xb3\x01\x41\x00\xfe\x01\xae\x02\x41\x00\xa3\x01\x52\x02\x41\x00\x74\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x75\x00\x10\x00\x11\x00\x12\x00\x91\x02\x0d\x02\x0e\x02\x0f\x02\x10\x02\xf1\x01\xc1\x01\xab\x01\xc2\x01\xe8\x01\xab\x01\x30\x02\x07\x00\xab\x01\x21\x02\x90\x02\x21\x02\x41\x02\x08\x00\xac\x01\xad\x01\x5d\x00\xae\x01\xad\x01\x5d\x00\xaf\x01\xad\x01\x5d\x00\x21\x02\x44\x02\xa3\x01\x53\x02\x76\x00\xc9\x01\x10\x00\x11\x00\xca\x01\x77\x00\x12\x02\x13\x02\x14\x02\x78\x00\x15\x02\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7e\x01\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x7e\x02\x0d\x02\x0e\x02\x0f\x02\x10\x02\xfb\x01\xfc\x01\x3b\x00\x86\x00\x17\x02\x18\x02\x87\x00\x88\x00\xeb\x01\xec\x01\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x07\x00\x40\x00\xee\x01\xef\x01\x40\x00\x80\x01\x08\x00\x40\x00\x91\x01\x41\x00\x95\x01\x9c\x01\x41\x00\xa3\x01\x1a\x02\x41\x00\x74\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x75\x00\x10\x00\x11\x00\x12\x00\x1b\x02\x1c\x02\x83\x01\x4a\x00\x4b\x00\x21\x02\x22\x02\xab\x01\x4c\x00\x86\x01\xab\x01\x67\x00\x16\x00\x5e\x01\x5f\x00\x8a\x01\x60\x00\x5f\x01\x61\x00\xb0\x01\xad\x01\x5d\x00\xb1\x01\xad\x01\x5d\x00\x2b\x00\x60\x01\x5d\x00\x99\x01\xf3\x01\xa7\x01\x55\x00\x76\x00\x56\x00\xcb\x01\x57\x00\xc4\x01\x77\x00\xc5\x01\xcc\x01\xc6\x01\x78\x00\xce\x01\x79\x00\x7a\x00\x7b\x00\x7c\x00\xc7\x01\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x81\x02\x0d\x02\x0e\x02\x0f\x02\x10\x02\x2d\x00\x04\x00\x3b\x00\x86\x00\x2b\x00\x2c\x00\x87\x00\x88\x00\x2f\x01\x30\x01\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x2b\x00\x2c\x00\x07\x00\xbf\x01\xc0\x01\xc1\x01\x40\x00\xc2\x01\x08\x00\xcf\x01\xd0\x01\x3b\x01\x2e\x00\x2f\x00\x41\x00\xd1\x01\xd9\x01\x39\x00\x0a\x00\x0b\x00\x31\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\xd2\x01\xd3\x01\xd5\x01\x13\x00\x14\x00\x15\x00\x16\x00\x3a\x00\x0c\x01\x0e\x01\x59\x00\x93\x01\x18\x00\x0f\x01\x13\x01\x10\x01\x11\x01\x9c\x00\x9d\x00\x9e\x00\xb3\xfe\x44\x01\x12\x01\x5c\x00\x5d\x00\x16\x01\x9f\x00\xa0\x00\xa1\x00\xa2\x00\x78\x02\x79\x02\x7a\x02\xa3\x00\xa4\x00\xa5\x00\xa6\x00\xa7\x00\xa8\x00\xa9\x00\x1a\x00\x1b\x00\x17\x01\xaa\x00\xab\x00\x33\x02\x0d\x02\x0e\x02\x0f\x02\x10\x02\x0c\x02\x0d\x02\x0e\x02\x0f\x02\x10\x02\x18\x01\x1b\x01\x1c\x01\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x3b\x00\x3c\x00\xac\x00\x24\x01\x51\x00\x28\x01\x26\x01\x4c\x00\x25\x00\x26\x00\x2a\x01\x27\x00\x57\x00\x39\x01\x63\x00\x5a\x01\x64\x00\x5b\x01\x70\x00\x2d\x01\x30\x01\x94\x01\x67\x01\xad\x00\x2b\x00\x2b\x00\x2c\x00\x58\x00\x2d\x00\x93\x01\x18\x00\x6d\x01\x6e\x01\x4c\x00\xad\x00\x9c\x00\x9d\x00\x9e\x00\xb3\xfe\x55\x00\x65\x00\x5d\x01\x04\x00\x5e\x01\x9f\x00\xa0\x00\xa1\x00\xa2\x00\x05\x00\xae\x02\x2b\x00\xa3\x00\xa4\x00\xa5\x00\xa6\x00\xa7\x00\xa8\x00\xa9\x00\x1a\x00\x1b\x00\x2b\x00\xaa\x00\xab\x00\x8d\x02\x94\x02\x95\x02\x96\x02\x2b\x00\x98\x02\x2b\x00\x9a\x02\x9b\x02\x23\x00\x69\x00\x2b\x00\xc7\x01\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x49\x02\x5f\x00\xac\x00\x6a\x00\x51\x00\x6b\x00\x4e\x02\xab\x02\x25\x00\x26\x00\xc7\x01\x27\x00\xad\x02\xc7\x01\x63\x00\x6a\x02\x64\x00\x6c\x02\x70\x00\x67\x02\x71\x02\x94\x01\x7b\x02\xad\x00\x18\x00\x2b\x00\x2c\x00\x73\x02\x2d\x00\x9c\x00\x9d\x00\x9e\x00\x7c\x02\x7e\x02\x24\x02\x36\x02\x37\x02\x3c\x02\x9f\x00\xa0\x00\xa1\x00\xa2\x00\x2b\x00\x3d\x02\x24\x02\xa3\x00\xa4\x00\xa5\x00\xa6\x00\xa7\x00\xa8\x00\xa9\x00\x1a\x00\x1b\x00\x3e\x02\xaa\x00\xab\x00\x3f\x02\x49\x02\x4e\x02\x2b\x00\x56\x02\xc7\x01\x5a\x02\x5b\x02\x5d\x02\xc7\x01\x5e\x02\x60\x02\x61\x02\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x62\x02\xdb\x01\xac\x00\x64\x02\x51\x00\x65\x02\x97\x01\x66\x02\x25\x00\x26\x00\xdd\x01\x27\x00\xdb\x01\xdf\x01\x63\x00\xce\x01\x64\x00\xe0\x01\x70\x00\xdb\x01\xeb\x01\x70\xfe\xe3\x01\xad\x00\xe4\x01\x2b\x00\x2c\x00\xe8\x01\x2d\x00\x70\xfe\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\xbc\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\xc2\x00\xc3\x00\xc4\x00\xc5\x00\xc6\x00\xc7\x00\xc8\x00\xc9\x00\xca\x00\xcb\x00\xcc\x00\xcd\x00\xce\x00\xcf\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\xd7\x00\xd8\x00\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x18\x00\xdb\x01\x0e\x01\xf1\x01\xfe\x01\x9c\x00\x9d\x00\x9e\x00\x0a\x02\x1a\x02\x2b\x00\x1e\x02\x2b\x00\x24\x02\x9f\x00\xa0\x00\xa1\x00\xa2\x00\x78\x02\x28\x02\x38\xff\xa3\x00\xa4\x00\xa5\x00\xa6\x00\xa7\x00\xa8\x00\xa9\x00\x1a\x00\x1b\x00\x39\xff\xaa\x00\xab\x00\x35\xff\x33\xff\x34\xff\x82\x01\x83\x01\x85\x01\x2b\x00\x88\x01\x8e\x01\x86\x01\x97\x01\x90\x01\x32\x01\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x8c\x01\x8f\x01\xac\x00\x2b\x00\x51\x00\x2b\x00\xce\x01\xd5\x01\x25\x00\x26\x00\x2a\x01\x27\x00\xd7\x01\xce\x01\x63\x00\x18\x00\x64\x00\xd8\x01\x70\x00\xd9\x01\x9c\x00\x9d\x00\x9e\x00\xad\x00\xdb\x01\x2b\x00\x2c\x00\x0e\x01\x2d\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\x67\x00\x2b\x00\x1a\x01\xa3\x00\xa4\x00\xa5\x00\xa6\x00\xa7\x00\xa8\x00\xa9\x00\x1a\x00\x1b\x00\x26\x01\xaa\x00\xab\x00\x28\x01\x72\x00\x32\x01\x3d\x01\x2b\x00\x42\x01\x46\x01\x49\x01\x4a\x01\x65\x01\x67\x00\x6a\x01\x40\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x69\x01\x41\x00\xac\x00\x18\x00\x51\x00\x6b\x01\x6c\x01\x6d\x01\x25\x00\x26\x00\x72\x01\x27\x00\x70\x01\x71\x01\x63\x00\xff\xff\x64\x00\x2b\x00\x70\x00\x67\x00\x19\x00\x07\x00\x6c\x00\xad\x00\x59\x00\x2b\x00\x2c\x00\x08\x00\x2d\x00\x73\x00\xff\xff\x1a\x00\x1b\x00\x1c\x00\xff\xff\x47\x01\x74\x00\x5c\x00\x5d\x00\x6d\x00\x0d\x00\x0e\x00\x6e\x00\x10\x00\x11\x00\x12\x00\x07\x00\x00\x00\x18\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x9c\x02\x23\x00\x24\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x19\x00\x27\x00\x00\x00\x00\x00\x28\x00\x00\x00\x29\x00\x38\x00\x2a\x00\x39\x00\x00\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x0c\x02\x23\x00\x24\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x19\x00\x27\x00\x00\x00\x00\x00\x28\x00\x00\x00\x29\x00\x38\x00\x2a\x00\x39\x00\x00\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3e\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x3f\x00\x00\x00\x00\x00\x23\x00\x24\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x19\x00\x27\x00\x00\x00\x00\x00\x28\x00\x00\x00\x29\x00\x38\x00\x2a\x00\x39\x00\x00\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x23\x00\x24\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x19\x00\x27\x00\x00\x00\x07\x00\x28\x00\x40\x00\x29\x00\x00\x00\x2a\x00\x08\x00\x00\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x00\x00\x29\x02\x0d\x00\x0e\x00\x51\x01\x10\x00\x11\x00\x12\x00\x18\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x23\x00\x24\x00\x2a\x02\x2b\x02\x2c\x02\x25\x00\x26\x00\x19\x00\x27\x00\x00\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x2a\x00\x34\x00\x00\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x23\x00\x24\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x19\x00\x27\x00\x00\x00\x07\x00\x28\x00\x40\x00\x29\x00\x00\x00\x2a\x00\x08\x00\x00\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x00\x00\x29\x02\x0d\x00\x0e\x00\x51\x01\x10\x00\x11\x00\x12\x00\x18\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x23\x00\x24\x00\x2a\x02\x2b\x02\x2d\x02\x25\x00\x26\x00\x19\x00\x27\x00\x00\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x2a\x00\x34\x00\x00\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x23\x00\x24\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x19\x00\x27\x00\x00\x00\x07\x00\x28\x00\x40\x00\x29\x00\x00\x00\x2a\x00\x08\x00\x00\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x94\x01\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x75\x00\x10\x00\x11\x00\x12\x00\x18\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x23\x00\x24\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x19\x00\x27\x00\x00\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x2a\x00\x34\x00\x00\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x19\x00\x00\x00\x23\x00\x24\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x00\x00\x27\x00\x1a\x00\x1b\x00\x28\x00\x00\x00\x29\x00\x00\x00\x2a\x00\x00\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x3f\x00\x2d\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x19\x00\x00\x00\x00\x00\x51\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x00\x00\x27\x00\x1a\x00\x1b\x00\x63\x00\x00\x00\x64\x00\x38\x00\x70\x00\x39\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x18\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x19\x00\x27\x00\x00\x00\x07\x00\x63\x00\x78\x01\x64\x00\x00\x00\x70\x00\x08\x00\x00\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x18\x00\x34\x01\x0c\x00\x0d\x00\x0e\x00\x75\x00\x10\x00\x11\x00\x12\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x19\x00\x00\x00\x23\x00\x24\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x00\x00\x27\x00\x1a\x00\x1b\x00\x28\x00\x00\x00\x29\x00\x00\x00\x2a\x00\x00\x00\x3e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x3f\x00\x2d\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x19\x00\x00\x00\x00\x00\x51\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x00\x00\x27\x00\x1a\x00\x1b\x00\x63\x00\x00\x00\x64\x00\x38\x00\x70\x00\x39\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x18\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x19\x00\x27\x00\x00\x00\x00\x00\x63\x00\x58\x01\x64\x00\x00\x00\x70\x00\x00\x00\x00\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x19\x00\x00\x00\x23\x00\x24\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x00\x00\x27\x00\x1a\x00\x1b\x00\x28\x00\x00\x00\x29\x00\x00\x00\x2a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x18\x00\x00\x00\x51\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x68\xff\x27\x00\x00\x00\x68\xff\x63\x00\x00\x00\x64\x00\x00\x00\x70\x00\x19\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x18\x00\x2d\x00\x00\x00\x1a\x00\x1b\x00\x1c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x19\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x1a\x00\x1b\x00\x23\x00\x24\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x2a\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x51\x00\x3e\x00\x00\x00\x00\x00\x25\x00\x26\x00\x00\x00\x27\x00\x3f\x00\x00\x00\x63\x00\x00\x00\x64\x00\x00\x00\x70\x00\x76\x01\x00\x00\x00\x00\x19\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x18\x00\x00\x00\x00\x00\x1a\x00\x1b\x00\x1c\xff\x1c\xff\x00\x00\x00\x00\x00\x00\x1c\xff\x00\x00\x1c\xff\x00\x00\x00\x00\x00\x00\x1c\xff\x19\x00\x1c\xff\x00\x00\x1c\xff\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x1c\xff\x1a\x00\x1b\x00\x00\x00\x51\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x63\x00\x00\x00\x64\x00\x00\x00\x70\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x51\x00\x18\x00\x00\x00\x00\x00\x25\x00\x26\x00\x00\x00\x27\x00\x00\x00\x00\x00\x63\x00\x00\x00\x64\x00\x00\x00\x70\x00\x56\x01\x00\x00\x00\x00\x19\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x00\x00\x00\x00\x40\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x19\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x1a\x00\x1b\x00\x00\x00\x51\x00\x00\x00\x5e\x01\x00\x00\x25\x00\x26\x00\x66\x01\x27\x00\x00\x00\x00\x00\x63\x00\x00\x00\x64\x00\x00\x00\x70\x00\x60\x01\x5d\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x51\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x19\x00\x00\x00\x00\x00\x00\x00\x63\x00\x00\x00\x81\x02\x00\x00\x70\x00\x00\x00\x00\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x19\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x1a\x00\x1b\x00\x00\x00\x51\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x00\x00\x00\x00\x00\x00\x00\x00\x63\x00\x00\x00\x64\x00\x00\x00\x70\x00\x00\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x51\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x19\x00\x00\x00\x00\x00\x00\x00\x63\x00\x00\x00\xab\x01\x00\x00\x70\x00\x00\x00\x00\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x19\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x1a\x00\x1b\x00\x00\x00\x51\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x00\x00\x00\x00\x00\x00\x00\x00\x63\x00\x00\x00\x64\x00\x00\x00\x70\x00\x00\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x51\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x19\x00\x00\x00\x00\x00\x00\x00\x63\x00\x00\x00\x64\x00\x00\x00\x65\x00\x00\x00\x00\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x19\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x1a\x00\x1b\x00\x00\x00\x51\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x00\x00\x00\x00\x00\x00\x00\x00\x63\x00\x00\x00\x64\x00\x00\x00\x70\x00\x00\x00\x00\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x51\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x19\x00\x00\x00\x00\x00\xff\x01\x52\x00\x00\x00\x53\x00\x00\x00\x54\x00\x08\x00\x00\x00\x1a\x00\x1b\x00\x2e\x00\x42\x01\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x00\x00\x36\x01\x0d\x00\x0e\x00\x00\x00\x10\x00\x11\x00\x37\x01\x8c\x01\x3f\x01\x40\x01\x1f\x00\x20\x00\x21\x00\x22\x00\x32\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x00\x00\x00\x00\x25\x00\x26\x00\x00\x00\x07\x00\x00\x00\x00\x00\x63\x00\x00\x00\x64\x00\x08\x00\x65\x00\x00\x00\x00\x00\x2e\x00\x42\x01\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x50\x01\x0d\x00\x0e\x00\x51\x01\x10\x00\x11\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x32\x00\x07\x00\x00\x00\x34\x00\x00\x00\x52\x01\x53\x01\x08\x00\x54\x01\x00\x00\x00\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x35\x00\x0a\x00\x0b\x00\x31\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x00\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x4e\x01\x07\x00\x00\x00\x34\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x35\x00\x0a\x00\x0b\x00\x31\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x00\x00\x07\x00\x13\x00\x14\x00\x15\x00\x16\x00\x36\x00\x08\x00\x00\x00\x00\x00\x00\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x0a\x00\x0b\x00\x31\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x00\x00\x07\x00\x13\x00\x14\x00\x15\x00\x16\x00\x4d\x01\x08\x00\x00\x00\x00\x00\x00\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x39\x00\x0a\x00\x0b\x00\x31\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x00\x00\x07\x00\x13\x00\x14\x00\x15\x00\x16\x00\x4f\x01\x08\x00\x00\x00\x00\x00\x00\x00\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x30\x00\x0a\x00\x0b\x00\x31\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x00\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x32\x00\x07\x00\x00\x00\x76\x01\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x43\x01\x2f\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x56\x01\x36\x01\x0d\x00\x0e\x00\x08\x00\x10\x00\x11\x00\x37\x01\x43\x01\x2f\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x36\x00\x36\x01\x0d\x00\x0e\x00\x08\x00\x10\x00\x11\x00\x37\x01\x2e\x00\x42\x01\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x36\x00\x36\x01\x0d\x00\x0e\x00\x08\x00\x10\x00\x11\x00\x37\x01\x7a\x01\x2f\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x32\x00\x36\x01\x0d\x00\x0e\x00\x08\x00\x10\x00\x11\x00\x37\x01\x7b\x01\x2f\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x4a\x01\x36\x01\x0d\x00\x0e\x00\x08\x00\x10\x00\x11\x00\x37\x01\x7c\x01\x2f\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x4b\x01\x36\x01\x0d\x00\x0e\x00\x08\x00\x10\x00\x11\x00\x37\x01\x7d\x01\x2f\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x4d\x01\x36\x01\x0d\x00\x0e\x00\x08\x00\x10\x00\x11\x00\x37\x01\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x4e\x01\x36\x01\x0d\x00\x0e\x00\x08\x00\x10\x00\x11\x00\x37\x01\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x4d\x01\x36\x01\x0d\x00\x0e\x00\x08\x00\x10\x00\x11\x00\x37\x01\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x4e\x01\x36\x01\x0d\x00\x0e\x00\x08\x00\x10\x00\x11\x00\x37\x01\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x4f\x01\x36\x01\x0d\x00\x0e\x00\x08\x00\x10\x00\x11\x00\x37\x01\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x32\x00\x36\x01\x0d\x00\x0e\x00\x08\x00\x10\x00\x11\x00\x37\x01\x2e\x00\x42\x01\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x36\x00\x36\x01\x0d\x00\x0e\x00\x08\x00\x10\x00\x11\x00\x37\x01\x43\x01\x2f\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x32\x00\x36\x01\x0d\x00\x0e\x00\x08\x00\x10\x00\x11\x00\x37\x01\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x36\x00\x36\x01\x0d\x00\x0e\x00\x08\x00\x10\x00\x11\x00\x37\x01\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x4a\x01\x36\x01\x0d\x00\x0e\x00\x08\x00\x10\x00\x11\x00\x37\x01\x2e\x00\x2f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x01\x36\x01\x0d\x00\x0e\x00\x00\x00\x10\x00\x11\x00\x37\x01\x07\x00\x00\x00\x34\x00\x00\x00\x00\x00\x00\x00\x08\x00\x4c\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x37\x02\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x02\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x45\x02\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x02\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4b\x02\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x02\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5e\x02\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x02\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x25\x02\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x02\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x72\x01\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x01\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x89\x01\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x01\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x01\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x01\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x01\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x01\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x39\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x46\x01\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x65\x01\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x07\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x00\x00\x00\x00\x00\x00\x13\x00\x14\x00\x15\x00\x16\x00\x4a\x00\x4b\x00\x00\x00\x4a\x00\x4b\x00\x4c\x00\x00\x00\x36\xff\x4c\x00\x00\x00\x00\x00\x62\x01\x00\x00\x63\x01\x62\x01\x64\x01\x63\x01\x00\x00\x64\x01\x4a\x00\x4b\x00\x00\x00\x2b\x00\x00\x00\x4c\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5f\x00\x00\x00\x60\x00\x00\x00\x61\x00\x4a\x00\x4b\x00\x00\x00\x4a\x00\x4b\x00\x4c\x00\x2b\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x5f\x00\x00\x00\x60\x00\x62\x01\xb3\x01\x63\x01\x00\x00\x64\x01\x4a\x00\x4b\x00\x00\x00\x2b\x00\x00\x00\x4c\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5f\x00\x00\x00\x60\x00\x00\x00\x61\x00\x4a\x00\x4b\x00\x00\x00\x4a\x00\x4b\x00\x4c\x00\x2b\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x62\x01\x00\x00\x63\x01\x4d\x00\x64\x01\x4e\x00\x00\x00\x4f\x00\x4a\x00\x4b\x00\x00\x00\x2b\x00\x00\x00\x4c\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5f\x00\x00\x00\x60\x00\x00\x00\x61\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x00\x01\x01\x01\x02\x01\x03\x01\x04\x01\x05\x01\x06\x01\x07\x01\x08\x01\x09\x01\x0a\x01\x0b\x01\x0c\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyReduceArr = Happy_Data_Array.array (3, 400) [
	(3 , happyReduce_3),
	(4 , happyReduce_4),
	(5 , happyReduce_5),
	(6 , happyReduce_6),
	(7 , happyReduce_7),
	(8 , happyReduce_8),
	(9 , happyReduce_9),
	(10 , happyReduce_10),
	(11 , happyReduce_11),
	(12 , happyReduce_12),
	(13 , happyReduce_13),
	(14 , happyReduce_14),
	(15 , happyReduce_15),
	(16 , happyReduce_16),
	(17 , happyReduce_17),
	(18 , happyReduce_18),
	(19 , happyReduce_19),
	(20 , happyReduce_20),
	(21 , happyReduce_21),
	(22 , happyReduce_22),
	(23 , happyReduce_23),
	(24 , happyReduce_24),
	(25 , happyReduce_25),
	(26 , happyReduce_26),
	(27 , happyReduce_27),
	(28 , happyReduce_28),
	(29 , happyReduce_29),
	(30 , happyReduce_30),
	(31 , happyReduce_31),
	(32 , happyReduce_32),
	(33 , happyReduce_33),
	(34 , happyReduce_34),
	(35 , happyReduce_35),
	(36 , happyReduce_36),
	(37 , happyReduce_37),
	(38 , happyReduce_38),
	(39 , happyReduce_39),
	(40 , happyReduce_40),
	(41 , happyReduce_41),
	(42 , happyReduce_42),
	(43 , happyReduce_43),
	(44 , happyReduce_44),
	(45 , happyReduce_45),
	(46 , happyReduce_46),
	(47 , happyReduce_47),
	(48 , happyReduce_48),
	(49 , happyReduce_49),
	(50 , happyReduce_50),
	(51 , happyReduce_51),
	(52 , happyReduce_52),
	(53 , happyReduce_53),
	(54 , happyReduce_54),
	(55 , happyReduce_55),
	(56 , happyReduce_56),
	(57 , happyReduce_57),
	(58 , happyReduce_58),
	(59 , happyReduce_59),
	(60 , happyReduce_60),
	(61 , happyReduce_61),
	(62 , happyReduce_62),
	(63 , happyReduce_63),
	(64 , happyReduce_64),
	(65 , happyReduce_65),
	(66 , happyReduce_66),
	(67 , happyReduce_67),
	(68 , happyReduce_68),
	(69 , happyReduce_69),
	(70 , happyReduce_70),
	(71 , happyReduce_71),
	(72 , happyReduce_72),
	(73 , happyReduce_73),
	(74 , happyReduce_74),
	(75 , happyReduce_75),
	(76 , happyReduce_76),
	(77 , happyReduce_77),
	(78 , happyReduce_78),
	(79 , happyReduce_79),
	(80 , happyReduce_80),
	(81 , happyReduce_81),
	(82 , happyReduce_82),
	(83 , happyReduce_83),
	(84 , happyReduce_84),
	(85 , happyReduce_85),
	(86 , happyReduce_86),
	(87 , happyReduce_87),
	(88 , happyReduce_88),
	(89 , happyReduce_89),
	(90 , happyReduce_90),
	(91 , happyReduce_91),
	(92 , happyReduce_92),
	(93 , happyReduce_93),
	(94 , happyReduce_94),
	(95 , happyReduce_95),
	(96 , happyReduce_96),
	(97 , happyReduce_97),
	(98 , happyReduce_98),
	(99 , happyReduce_99),
	(100 , happyReduce_100),
	(101 , happyReduce_101),
	(102 , happyReduce_102),
	(103 , happyReduce_103),
	(104 , happyReduce_104),
	(105 , happyReduce_105),
	(106 , happyReduce_106),
	(107 , happyReduce_107),
	(108 , happyReduce_108),
	(109 , happyReduce_109),
	(110 , happyReduce_110),
	(111 , happyReduce_111),
	(112 , happyReduce_112),
	(113 , happyReduce_113),
	(114 , happyReduce_114),
	(115 , happyReduce_115),
	(116 , happyReduce_116),
	(117 , happyReduce_117),
	(118 , happyReduce_118),
	(119 , happyReduce_119),
	(120 , happyReduce_120),
	(121 , happyReduce_121),
	(122 , happyReduce_122),
	(123 , happyReduce_123),
	(124 , happyReduce_124),
	(125 , happyReduce_125),
	(126 , happyReduce_126),
	(127 , happyReduce_127),
	(128 , happyReduce_128),
	(129 , happyReduce_129),
	(130 , happyReduce_130),
	(131 , happyReduce_131),
	(132 , happyReduce_132),
	(133 , happyReduce_133),
	(134 , happyReduce_134),
	(135 , happyReduce_135),
	(136 , happyReduce_136),
	(137 , happyReduce_137),
	(138 , happyReduce_138),
	(139 , happyReduce_139),
	(140 , happyReduce_140),
	(141 , happyReduce_141),
	(142 , happyReduce_142),
	(143 , happyReduce_143),
	(144 , happyReduce_144),
	(145 , happyReduce_145),
	(146 , happyReduce_146),
	(147 , happyReduce_147),
	(148 , happyReduce_148),
	(149 , happyReduce_149),
	(150 , happyReduce_150),
	(151 , happyReduce_151),
	(152 , happyReduce_152),
	(153 , happyReduce_153),
	(154 , happyReduce_154),
	(155 , happyReduce_155),
	(156 , happyReduce_156),
	(157 , happyReduce_157),
	(158 , happyReduce_158),
	(159 , happyReduce_159),
	(160 , happyReduce_160),
	(161 , happyReduce_161),
	(162 , happyReduce_162),
	(163 , happyReduce_163),
	(164 , happyReduce_164),
	(165 , happyReduce_165),
	(166 , happyReduce_166),
	(167 , happyReduce_167),
	(168 , happyReduce_168),
	(169 , happyReduce_169),
	(170 , happyReduce_170),
	(171 , happyReduce_171),
	(172 , happyReduce_172),
	(173 , happyReduce_173),
	(174 , happyReduce_174),
	(175 , happyReduce_175),
	(176 , happyReduce_176),
	(177 , happyReduce_177),
	(178 , happyReduce_178),
	(179 , happyReduce_179),
	(180 , happyReduce_180),
	(181 , happyReduce_181),
	(182 , happyReduce_182),
	(183 , happyReduce_183),
	(184 , happyReduce_184),
	(185 , happyReduce_185),
	(186 , happyReduce_186),
	(187 , happyReduce_187),
	(188 , happyReduce_188),
	(189 , happyReduce_189),
	(190 , happyReduce_190),
	(191 , happyReduce_191),
	(192 , happyReduce_192),
	(193 , happyReduce_193),
	(194 , happyReduce_194),
	(195 , happyReduce_195),
	(196 , happyReduce_196),
	(197 , happyReduce_197),
	(198 , happyReduce_198),
	(199 , happyReduce_199),
	(200 , happyReduce_200),
	(201 , happyReduce_201),
	(202 , happyReduce_202),
	(203 , happyReduce_203),
	(204 , happyReduce_204),
	(205 , happyReduce_205),
	(206 , happyReduce_206),
	(207 , happyReduce_207),
	(208 , happyReduce_208),
	(209 , happyReduce_209),
	(210 , happyReduce_210),
	(211 , happyReduce_211),
	(212 , happyReduce_212),
	(213 , happyReduce_213),
	(214 , happyReduce_214),
	(215 , happyReduce_215),
	(216 , happyReduce_216),
	(217 , happyReduce_217),
	(218 , happyReduce_218),
	(219 , happyReduce_219),
	(220 , happyReduce_220),
	(221 , happyReduce_221),
	(222 , happyReduce_222),
	(223 , happyReduce_223),
	(224 , happyReduce_224),
	(225 , happyReduce_225),
	(226 , happyReduce_226),
	(227 , happyReduce_227),
	(228 , happyReduce_228),
	(229 , happyReduce_229),
	(230 , happyReduce_230),
	(231 , happyReduce_231),
	(232 , happyReduce_232),
	(233 , happyReduce_233),
	(234 , happyReduce_234),
	(235 , happyReduce_235),
	(236 , happyReduce_236),
	(237 , happyReduce_237),
	(238 , happyReduce_238),
	(239 , happyReduce_239),
	(240 , happyReduce_240),
	(241 , happyReduce_241),
	(242 , happyReduce_242),
	(243 , happyReduce_243),
	(244 , happyReduce_244),
	(245 , happyReduce_245),
	(246 , happyReduce_246),
	(247 , happyReduce_247),
	(248 , happyReduce_248),
	(249 , happyReduce_249),
	(250 , happyReduce_250),
	(251 , happyReduce_251),
	(252 , happyReduce_252),
	(253 , happyReduce_253),
	(254 , happyReduce_254),
	(255 , happyReduce_255),
	(256 , happyReduce_256),
	(257 , happyReduce_257),
	(258 , happyReduce_258),
	(259 , happyReduce_259),
	(260 , happyReduce_260),
	(261 , happyReduce_261),
	(262 , happyReduce_262),
	(263 , happyReduce_263),
	(264 , happyReduce_264),
	(265 , happyReduce_265),
	(266 , happyReduce_266),
	(267 , happyReduce_267),
	(268 , happyReduce_268),
	(269 , happyReduce_269),
	(270 , happyReduce_270),
	(271 , happyReduce_271),
	(272 , happyReduce_272),
	(273 , happyReduce_273),
	(274 , happyReduce_274),
	(275 , happyReduce_275),
	(276 , happyReduce_276),
	(277 , happyReduce_277),
	(278 , happyReduce_278),
	(279 , happyReduce_279),
	(280 , happyReduce_280),
	(281 , happyReduce_281),
	(282 , happyReduce_282),
	(283 , happyReduce_283),
	(284 , happyReduce_284),
	(285 , happyReduce_285),
	(286 , happyReduce_286),
	(287 , happyReduce_287),
	(288 , happyReduce_288),
	(289 , happyReduce_289),
	(290 , happyReduce_290),
	(291 , happyReduce_291),
	(292 , happyReduce_292),
	(293 , happyReduce_293),
	(294 , happyReduce_294),
	(295 , happyReduce_295),
	(296 , happyReduce_296),
	(297 , happyReduce_297),
	(298 , happyReduce_298),
	(299 , happyReduce_299),
	(300 , happyReduce_300),
	(301 , happyReduce_301),
	(302 , happyReduce_302),
	(303 , happyReduce_303),
	(304 , happyReduce_304),
	(305 , happyReduce_305),
	(306 , happyReduce_306),
	(307 , happyReduce_307),
	(308 , happyReduce_308),
	(309 , happyReduce_309),
	(310 , happyReduce_310),
	(311 , happyReduce_311),
	(312 , happyReduce_312),
	(313 , happyReduce_313),
	(314 , happyReduce_314),
	(315 , happyReduce_315),
	(316 , happyReduce_316),
	(317 , happyReduce_317),
	(318 , happyReduce_318),
	(319 , happyReduce_319),
	(320 , happyReduce_320),
	(321 , happyReduce_321),
	(322 , happyReduce_322),
	(323 , happyReduce_323),
	(324 , happyReduce_324),
	(325 , happyReduce_325),
	(326 , happyReduce_326),
	(327 , happyReduce_327),
	(328 , happyReduce_328),
	(329 , happyReduce_329),
	(330 , happyReduce_330),
	(331 , happyReduce_331),
	(332 , happyReduce_332),
	(333 , happyReduce_333),
	(334 , happyReduce_334),
	(335 , happyReduce_335),
	(336 , happyReduce_336),
	(337 , happyReduce_337),
	(338 , happyReduce_338),
	(339 , happyReduce_339),
	(340 , happyReduce_340),
	(341 , happyReduce_341),
	(342 , happyReduce_342),
	(343 , happyReduce_343),
	(344 , happyReduce_344),
	(345 , happyReduce_345),
	(346 , happyReduce_346),
	(347 , happyReduce_347),
	(348 , happyReduce_348),
	(349 , happyReduce_349),
	(350 , happyReduce_350),
	(351 , happyReduce_351),
	(352 , happyReduce_352),
	(353 , happyReduce_353),
	(354 , happyReduce_354),
	(355 , happyReduce_355),
	(356 , happyReduce_356),
	(357 , happyReduce_357),
	(358 , happyReduce_358),
	(359 , happyReduce_359),
	(360 , happyReduce_360),
	(361 , happyReduce_361),
	(362 , happyReduce_362),
	(363 , happyReduce_363),
	(364 , happyReduce_364),
	(365 , happyReduce_365),
	(366 , happyReduce_366),
	(367 , happyReduce_367),
	(368 , happyReduce_368),
	(369 , happyReduce_369),
	(370 , happyReduce_370),
	(371 , happyReduce_371),
	(372 , happyReduce_372),
	(373 , happyReduce_373),
	(374 , happyReduce_374),
	(375 , happyReduce_375),
	(376 , happyReduce_376),
	(377 , happyReduce_377),
	(378 , happyReduce_378),
	(379 , happyReduce_379),
	(380 , happyReduce_380),
	(381 , happyReduce_381),
	(382 , happyReduce_382),
	(383 , happyReduce_383),
	(384 , happyReduce_384),
	(385 , happyReduce_385),
	(386 , happyReduce_386),
	(387 , happyReduce_387),
	(388 , happyReduce_388),
	(389 , happyReduce_389),
	(390 , happyReduce_390),
	(391 , happyReduce_391),
	(392 , happyReduce_392),
	(393 , happyReduce_393),
	(394 , happyReduce_394),
	(395 , happyReduce_395),
	(396 , happyReduce_396),
	(397 , happyReduce_397),
	(398 , happyReduce_398),
	(399 , happyReduce_399),
	(400 , happyReduce_400)
	]

happy_n_terms = 83 :: Int
happy_n_nonterms = 134 :: Int

happyReduce_3 = happySpecReduce_1  0# happyReduction_3
happyReduction_3 happy_x_1
	 =  case happyOut7 happy_x_1 of { happy_var_1 -> 
	happyIn6
		 (reverse happy_var_1
	)}

happyReduce_4 = happySpecReduce_2  1# happyReduction_4
happyReduction_4 happy_x_2
	happy_x_1
	 =  case happyOut7 happy_x_1 of { happy_var_1 -> 
	case happyOut8 happy_x_2 of { happy_var_2 -> 
	happyIn7
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_5 = happySpecReduce_0  1# happyReduction_5
happyReduction_5  =  happyIn7
		 ([]
	)

happyReduce_6 = happySpecReduce_1  2# happyReduction_6
happyReduction_6 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwLet happy_var_1) -> 
	happyIn8
		 (TokKeyword KwLet happy_var_1
	)}

happyReduce_7 = happySpecReduce_1  2# happyReduction_7
happyReduction_7 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwIn happy_var_1) -> 
	happyIn8
		 (TokKeyword KwIn happy_var_1
	)}

happyReduce_8 = happySpecReduce_1  2# happyReduction_8
happyReduction_8 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwWhere happy_var_1) -> 
	happyIn8
		 (TokKeyword KwWhere happy_var_1
	)}

happyReduce_9 = happySpecReduce_1  2# happyReduction_9
happyReduction_9 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwWith happy_var_1) -> 
	happyIn8
		 (TokKeyword KwWith happy_var_1
	)}

happyReduce_10 = happySpecReduce_1  2# happyReduction_10
happyReduction_10 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwRewrite happy_var_1) -> 
	happyIn8
		 (TokKeyword KwRewrite happy_var_1
	)}

happyReduce_11 = happySpecReduce_1  2# happyReduction_11
happyReduction_11 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPostulate happy_var_1) -> 
	happyIn8
		 (TokKeyword KwPostulate happy_var_1
	)}

happyReduce_12 = happySpecReduce_1  2# happyReduction_12
happyReduction_12 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPrimitive happy_var_1) -> 
	happyIn8
		 (TokKeyword KwPrimitive happy_var_1
	)}

happyReduce_13 = happySpecReduce_1  2# happyReduction_13
happyReduction_13 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwOpen happy_var_1) -> 
	happyIn8
		 (TokKeyword KwOpen happy_var_1
	)}

happyReduce_14 = happySpecReduce_1  2# happyReduction_14
happyReduction_14 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwImport happy_var_1) -> 
	happyIn8
		 (TokKeyword KwImport happy_var_1
	)}

happyReduce_15 = happySpecReduce_1  2# happyReduction_15
happyReduction_15 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUsing happy_var_1) -> 
	happyIn8
		 (TokKeyword KwUsing happy_var_1
	)}

happyReduce_16 = happySpecReduce_1  2# happyReduction_16
happyReduction_16 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwHiding happy_var_1) -> 
	happyIn8
		 (TokKeyword KwHiding happy_var_1
	)}

happyReduce_17 = happySpecReduce_1  2# happyReduction_17
happyReduction_17 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwRenaming happy_var_1) -> 
	happyIn8
		 (TokKeyword KwRenaming happy_var_1
	)}

happyReduce_18 = happySpecReduce_1  2# happyReduction_18
happyReduction_18 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwTo happy_var_1) -> 
	happyIn8
		 (TokKeyword KwTo happy_var_1
	)}

happyReduce_19 = happySpecReduce_1  2# happyReduction_19
happyReduction_19 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPublic happy_var_1) -> 
	happyIn8
		 (TokKeyword KwPublic happy_var_1
	)}

happyReduce_20 = happySpecReduce_1  2# happyReduction_20
happyReduction_20 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwModule happy_var_1) -> 
	happyIn8
		 (TokKeyword KwModule happy_var_1
	)}

happyReduce_21 = happySpecReduce_1  2# happyReduction_21
happyReduction_21 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwData happy_var_1) -> 
	happyIn8
		 (TokKeyword KwData happy_var_1
	)}

happyReduce_22 = happySpecReduce_1  2# happyReduction_22
happyReduction_22 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCoData happy_var_1) -> 
	happyIn8
		 (TokKeyword KwCoData happy_var_1
	)}

happyReduce_23 = happySpecReduce_1  2# happyReduction_23
happyReduction_23 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	happyIn8
		 (TokKeyword KwRecord happy_var_1
	)}

happyReduce_24 = happySpecReduce_1  2# happyReduction_24
happyReduction_24 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwConstructor happy_var_1) -> 
	happyIn8
		 (TokKeyword KwConstructor happy_var_1
	)}

happyReduce_25 = happySpecReduce_1  2# happyReduction_25
happyReduction_25 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInductive happy_var_1) -> 
	happyIn8
		 (TokKeyword KwInductive happy_var_1
	)}

happyReduce_26 = happySpecReduce_1  2# happyReduction_26
happyReduction_26 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCoInductive happy_var_1) -> 
	happyIn8
		 (TokKeyword KwCoInductive happy_var_1
	)}

happyReduce_27 = happySpecReduce_1  2# happyReduction_27
happyReduction_27 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwField happy_var_1) -> 
	happyIn8
		 (TokKeyword KwField happy_var_1
	)}

happyReduce_28 = happySpecReduce_1  2# happyReduction_28
happyReduction_28 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfix happy_var_1) -> 
	happyIn8
		 (TokKeyword KwInfix happy_var_1
	)}

happyReduce_29 = happySpecReduce_1  2# happyReduction_29
happyReduction_29 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfixL happy_var_1) -> 
	happyIn8
		 (TokKeyword KwInfixL happy_var_1
	)}

happyReduce_30 = happySpecReduce_1  2# happyReduction_30
happyReduction_30 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfixR happy_var_1) -> 
	happyIn8
		 (TokKeyword KwInfixR happy_var_1
	)}

happyReduce_31 = happySpecReduce_1  2# happyReduction_31
happyReduction_31 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwMutual happy_var_1) -> 
	happyIn8
		 (TokKeyword KwMutual happy_var_1
	)}

happyReduce_32 = happySpecReduce_1  2# happyReduction_32
happyReduction_32 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwAbstract happy_var_1) -> 
	happyIn8
		 (TokKeyword KwAbstract happy_var_1
	)}

happyReduce_33 = happySpecReduce_1  2# happyReduction_33
happyReduction_33 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPrivate happy_var_1) -> 
	happyIn8
		 (TokKeyword KwPrivate happy_var_1
	)}

happyReduce_34 = happySpecReduce_1  2# happyReduction_34
happyReduction_34 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwProp happy_var_1) -> 
	happyIn8
		 (TokKeyword KwProp happy_var_1
	)}

happyReduce_35 = happySpecReduce_1  2# happyReduction_35
happyReduction_35 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwSet happy_var_1) -> 
	happyIn8
		 (TokKeyword KwSet happy_var_1
	)}

happyReduce_36 = happySpecReduce_1  2# happyReduction_36
happyReduction_36 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwForall happy_var_1) -> 
	happyIn8
		 (TokKeyword KwForall happy_var_1
	)}

happyReduce_37 = happySpecReduce_1  2# happyReduction_37
happyReduction_37 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwSyntax happy_var_1) -> 
	happyIn8
		 (TokKeyword KwSyntax happy_var_1
	)}

happyReduce_38 = happySpecReduce_1  2# happyReduction_38
happyReduction_38 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPatternSyn happy_var_1) -> 
	happyIn8
		 (TokKeyword KwPatternSyn happy_var_1
	)}

happyReduce_39 = happySpecReduce_1  2# happyReduction_39
happyReduction_39 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwOPTIONS happy_var_1) -> 
	happyIn8
		 (TokKeyword KwOPTIONS happy_var_1
	)}

happyReduce_40 = happySpecReduce_1  2# happyReduction_40
happyReduction_40 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwBUILTIN happy_var_1) -> 
	happyIn8
		 (TokKeyword KwBUILTIN happy_var_1
	)}

happyReduce_41 = happySpecReduce_1  2# happyReduction_41
happyReduction_41 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwIMPORT happy_var_1) -> 
	happyIn8
		 (TokKeyword KwIMPORT happy_var_1
	)}

happyReduce_42 = happySpecReduce_1  2# happyReduction_42
happyReduction_42 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED happy_var_1) -> 
	happyIn8
		 (TokKeyword KwCOMPILED happy_var_1
	)}

happyReduce_43 = happySpecReduce_1  2# happyReduction_43
happyReduction_43 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED_EXPORT happy_var_1) -> 
	happyIn8
		 (TokKeyword KwCOMPILED_EXPORT happy_var_1
	)}

happyReduce_44 = happySpecReduce_1  2# happyReduction_44
happyReduction_44 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED_DATA happy_var_1) -> 
	happyIn8
		 (TokKeyword KwCOMPILED_DATA happy_var_1
	)}

happyReduce_45 = happySpecReduce_1  2# happyReduction_45
happyReduction_45 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED_TYPE happy_var_1) -> 
	happyIn8
		 (TokKeyword KwCOMPILED_TYPE happy_var_1
	)}

happyReduce_46 = happySpecReduce_1  2# happyReduction_46
happyReduction_46 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED_EPIC happy_var_1) -> 
	happyIn8
		 (TokKeyword KwCOMPILED_EPIC happy_var_1
	)}

happyReduce_47 = happySpecReduce_1  2# happyReduction_47
happyReduction_47 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED_JS happy_var_1) -> 
	happyIn8
		 (TokKeyword KwCOMPILED_JS happy_var_1
	)}

happyReduce_48 = happySpecReduce_1  2# happyReduction_48
happyReduction_48 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwSTATIC happy_var_1) -> 
	happyIn8
		 (TokKeyword KwSTATIC happy_var_1
	)}

happyReduce_49 = happySpecReduce_1  2# happyReduction_49
happyReduction_49 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwIMPOSSIBLE happy_var_1) -> 
	happyIn8
		 (TokKeyword KwIMPOSSIBLE happy_var_1
	)}

happyReduce_50 = happySpecReduce_1  2# happyReduction_50
happyReduction_50 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwETA happy_var_1) -> 
	happyIn8
		 (TokKeyword KwETA happy_var_1
	)}

happyReduce_51 = happySpecReduce_1  2# happyReduction_51
happyReduction_51 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNO_TERMINATION_CHECK happy_var_1) -> 
	happyIn8
		 (TokKeyword KwNO_TERMINATION_CHECK happy_var_1
	)}

happyReduce_52 = happySpecReduce_1  2# happyReduction_52
happyReduction_52 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuoteGoal happy_var_1) -> 
	happyIn8
		 (TokKeyword KwQuoteGoal happy_var_1
	)}

happyReduce_53 = happySpecReduce_1  2# happyReduction_53
happyReduction_53 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuoteContext happy_var_1) -> 
	happyIn8
		 (TokKeyword KwQuoteContext happy_var_1
	)}

happyReduce_54 = happySpecReduce_1  2# happyReduction_54
happyReduction_54 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuote happy_var_1) -> 
	happyIn8
		 (TokKeyword KwQuote happy_var_1
	)}

happyReduce_55 = happySpecReduce_1  2# happyReduction_55
happyReduction_55 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuoteTerm happy_var_1) -> 
	happyIn8
		 (TokKeyword KwQuoteTerm happy_var_1
	)}

happyReduce_56 = happySpecReduce_1  2# happyReduction_56
happyReduction_56 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUnquote happy_var_1) -> 
	happyIn8
		 (TokKeyword KwUnquote happy_var_1
	)}

happyReduce_57 = happySpecReduce_1  2# happyReduction_57
happyReduction_57 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSetN happy_var_1) -> 
	happyIn8
		 (TokSetN happy_var_1
	)}

happyReduce_58 = happySpecReduce_1  2# happyReduction_58
happyReduction_58 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokTeX happy_var_1) -> 
	happyIn8
		 (TokTeX happy_var_1
	)}

happyReduce_59 = happySpecReduce_1  2# happyReduction_59
happyReduction_59 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokComment happy_var_1) -> 
	happyIn8
		 (TokComment happy_var_1
	)}

happyReduce_60 = happySpecReduce_1  2# happyReduction_60
happyReduction_60 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymEllipsis happy_var_1) -> 
	happyIn8
		 (TokSymbol SymEllipsis happy_var_1
	)}

happyReduce_61 = happySpecReduce_1  2# happyReduction_61
happyReduction_61 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDotDot happy_var_1) -> 
	happyIn8
		 (TokSymbol SymDotDot happy_var_1
	)}

happyReduce_62 = happySpecReduce_1  2# happyReduction_62
happyReduction_62 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDot happy_var_1) -> 
	happyIn8
		 (TokSymbol SymDot happy_var_1
	)}

happyReduce_63 = happySpecReduce_1  2# happyReduction_63
happyReduction_63 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymSemi happy_var_1) -> 
	happyIn8
		 (TokSymbol SymSemi happy_var_1
	)}

happyReduce_64 = happySpecReduce_1  2# happyReduction_64
happyReduction_64 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymColon happy_var_1) -> 
	happyIn8
		 (TokSymbol SymColon happy_var_1
	)}

happyReduce_65 = happySpecReduce_1  2# happyReduction_65
happyReduction_65 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymEqual happy_var_1) -> 
	happyIn8
		 (TokSymbol SymEqual happy_var_1
	)}

happyReduce_66 = happySpecReduce_1  2# happyReduction_66
happyReduction_66 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymUnderscore happy_var_1) -> 
	happyIn8
		 (TokSymbol SymUnderscore happy_var_1
	)}

happyReduce_67 = happySpecReduce_1  2# happyReduction_67
happyReduction_67 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymQuestionMark happy_var_1) -> 
	happyIn8
		 (TokSymbol SymQuestionMark happy_var_1
	)}

happyReduce_68 = happySpecReduce_1  2# happyReduction_68
happyReduction_68 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymArrow happy_var_1) -> 
	happyIn8
		 (TokSymbol SymArrow happy_var_1
	)}

happyReduce_69 = happySpecReduce_1  2# happyReduction_69
happyReduction_69 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymLambda happy_var_1) -> 
	happyIn8
		 (TokSymbol SymLambda happy_var_1
	)}

happyReduce_70 = happySpecReduce_1  2# happyReduction_70
happyReduction_70 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymAs happy_var_1) -> 
	happyIn8
		 (TokSymbol SymAs happy_var_1
	)}

happyReduce_71 = happySpecReduce_1  2# happyReduction_71
happyReduction_71 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymBar happy_var_1) -> 
	happyIn8
		 (TokSymbol SymBar happy_var_1
	)}

happyReduce_72 = happySpecReduce_1  2# happyReduction_72
happyReduction_72 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	happyIn8
		 (TokSymbol SymOpenParen happy_var_1
	)}

happyReduce_73 = happySpecReduce_1  2# happyReduction_73
happyReduction_73 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymCloseParen happy_var_1) -> 
	happyIn8
		 (TokSymbol SymCloseParen happy_var_1
	)}

happyReduce_74 = happySpecReduce_1  2# happyReduction_74
happyReduction_74 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleOpenBrace happy_var_1) -> 
	happyIn8
		 (TokSymbol SymDoubleOpenBrace happy_var_1
	)}

happyReduce_75 = happySpecReduce_1  2# happyReduction_75
happyReduction_75 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleCloseBrace happy_var_1) -> 
	happyIn8
		 (TokSymbol SymDoubleCloseBrace happy_var_1
	)}

happyReduce_76 = happySpecReduce_1  2# happyReduction_76
happyReduction_76 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenBrace happy_var_1) -> 
	happyIn8
		 (TokSymbol SymOpenBrace happy_var_1
	)}

happyReduce_77 = happySpecReduce_1  2# happyReduction_77
happyReduction_77 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymCloseBrace happy_var_1) -> 
	happyIn8
		 (TokSymbol SymCloseBrace happy_var_1
	)}

happyReduce_78 = happySpecReduce_1  2# happyReduction_78
happyReduction_78 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenVirtualBrace happy_var_1) -> 
	happyIn8
		 (TokSymbol SymOpenVirtualBrace happy_var_1
	)}

happyReduce_79 = happySpecReduce_1  2# happyReduction_79
happyReduction_79 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymCloseVirtualBrace happy_var_1) -> 
	happyIn8
		 (TokSymbol SymCloseVirtualBrace happy_var_1
	)}

happyReduce_80 = happySpecReduce_1  2# happyReduction_80
happyReduction_80 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymVirtualSemi happy_var_1) -> 
	happyIn8
		 (TokSymbol SymVirtualSemi happy_var_1
	)}

happyReduce_81 = happySpecReduce_1  2# happyReduction_81
happyReduction_81 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	happyIn8
		 (TokSymbol SymOpenPragma happy_var_1
	)}

happyReduce_82 = happySpecReduce_1  2# happyReduction_82
happyReduction_82 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymClosePragma happy_var_1) -> 
	happyIn8
		 (TokSymbol SymClosePragma happy_var_1
	)}

happyReduce_83 = happySpecReduce_1  2# happyReduction_83
happyReduction_83 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokId happy_var_1) -> 
	happyIn8
		 (TokId happy_var_1
	)}

happyReduce_84 = happySpecReduce_1  2# happyReduction_84
happyReduction_84 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokQId happy_var_1) -> 
	happyIn8
		 (TokQId happy_var_1
	)}

happyReduce_85 = happySpecReduce_1  2# happyReduction_85
happyReduction_85 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	happyIn8
		 (TokString happy_var_1
	)}

happyReduce_86 = happySpecReduce_1  2# happyReduction_86
happyReduction_86 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokLiteral happy_var_1) -> 
	happyIn8
		 (TokLiteral happy_var_1
	)}

happyReduce_87 = happySpecReduce_3  3# happyReduction_87
happyReduction_87 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut111 happy_x_2 of { happy_var_2 -> 
	happyIn9
		 (takeOptionsPragmas happy_var_2
	)}

happyReduce_88 = happySpecReduce_0  4# happyReduction_88
happyReduction_88  =  happyIn10
		 (()
	)

happyReduce_89 = happySpecReduce_1  4# happyReduction_89
happyReduction_89 happy_x_1
	 =  happyIn10
		 (()
	)

happyReduce_90 = happySpecReduce_1  5# happyReduction_90
happyReduction_90 happy_x_1
	 =  happyIn11
		 (()
	)

happyReduce_91 = happyMonadReduce 1# 5# happyReduction_91
happyReduction_91 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (( popContext)
	) (\r -> happyReturn (happyIn11 r))

happyReduce_92 = happySpecReduce_1  6# happyReduction_92
happyReduction_92 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymSemi happy_var_1) -> 
	happyIn12
		 (happy_var_1
	)}

happyReduce_93 = happySpecReduce_1  6# happyReduction_93
happyReduction_93 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymVirtualSemi happy_var_1) -> 
	happyIn12
		 (happy_var_1
	)}

happyReduce_94 = happyMonadReduce 0# 7# happyReduction_94
happyReduction_94 (happyRest) tk
	 = happyThen (( pushLexState imp_dir)
	) (\r -> happyReturn (happyIn13 r))

happyReduce_95 = happyMonadReduce 1# 8# happyReduction_95
happyReduction_95 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokLiteral happy_var_1) -> 
	( case happy_var_1 of {
		     LitInt _ i	-> return i;
		     _		-> fail $ "Expected integer"
		   })}
	) (\r -> happyReturn (happyIn14 r))

happyReduce_96 = happyMonadReduce 1# 8# happyReduction_96
happyReduction_96 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokId happy_var_1) -> 
	( case happy_var_1 of {
             (_, s) -> case readM s of {
                         Right i  -> return i;
		         Left (err :: String) -> fail $ "Expected integer"
		       }
           })}
	) (\r -> happyReturn (happyIn14 r))

happyReduce_97 = happyMonadReduce 1# 9# happyReduction_97
happyReduction_97 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokId happy_var_1) -> 
	( mkName happy_var_1)}
	) (\r -> happyReturn (happyIn15 r))

happyReduce_98 = happySpecReduce_2  10# happyReduction_98
happyReduction_98 happy_x_2
	happy_x_1
	 =  case happyOut15 happy_x_1 of { happy_var_1 -> 
	case happyOut16 happy_x_2 of { happy_var_2 -> 
	happyIn16
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_99 = happySpecReduce_1  10# happyReduction_99
happyReduction_99 happy_x_1
	 =  case happyOut15 happy_x_1 of { happy_var_1 -> 
	happyIn16
		 ([happy_var_1]
	)}

happyReduce_100 = happySpecReduce_1  11# happyReduction_100
happyReduction_100 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleCloseBrace happy_var_1) -> 
	happyIn17
		 (getRange happy_var_1
	)}

happyReduce_101 = happyMonadReduce 2# 11# happyReduction_101
happyReduction_101 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokSymbol SymCloseBrace happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymCloseBrace happy_var_2) -> 
	(
      if posPos (fromJust (rEnd (getRange happy_var_2))) -
	 posPos (fromJust (rStart (getRange happy_var_1))) > 2
      then parseErrorAt (fromJust (rStart (getRange happy_var_2)))
	 "Expecting '}}', found separated '}'s."
      else return $ getRange (happy_var_1, happy_var_2))}}
	) (\r -> happyReturn (happyIn17 r))

happyReduce_102 = happySpecReduce_2  12# happyReduction_102
happyReduction_102 happy_x_2
	happy_x_1
	 =  case happyOut15 happy_x_2 of { happy_var_2 -> 
	happyIn18
		 (setRelevance Irrelevant $ defaultArg happy_var_2
	)}

happyReduce_103 = happySpecReduce_1  12# happyReduction_103
happyReduction_103 happy_x_1
	 =  case happyOut15 happy_x_1 of { happy_var_1 -> 
	happyIn18
		 (defaultArg happy_var_1
	)}

happyReduce_104 = happySpecReduce_2  13# happyReduction_104
happyReduction_104 happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut19 happy_x_2 of { happy_var_2 -> 
	happyIn19
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_105 = happySpecReduce_1  13# happyReduction_105
happyReduction_105 happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	happyIn19
		 ([happy_var_1]
	)}

happyReduce_106 = happySpecReduce_2  14# happyReduction_106
happyReduction_106 happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut20 happy_x_2 of { happy_var_2 -> 
	happyIn20
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_107 = happySpecReduce_1  14# happyReduction_107
happyReduction_107 happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	happyIn20
		 ([happy_var_1]
	)}

happyReduce_108 = happyReduce 4# 14# happyReduction_108
happyReduction_108 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut19 happy_x_2 of { happy_var_2 -> 
	case happyOut20 happy_x_4 of { happy_var_4 -> 
	happyIn20
		 (map makeInstance happy_var_2 ++ happy_var_4
	) `HappyStk` happyRest}}

happyReduce_109 = happySpecReduce_3  14# happyReduction_109
happyReduction_109 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_2 of { happy_var_2 -> 
	happyIn20
		 (map makeInstance happy_var_2
	)}

happyReduce_110 = happyReduce 4# 14# happyReduction_110
happyReduction_110 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut19 happy_x_2 of { happy_var_2 -> 
	case happyOut20 happy_x_4 of { happy_var_4 -> 
	happyIn20
		 (map hide happy_var_2 ++ happy_var_4
	) `HappyStk` happyRest}}

happyReduce_111 = happySpecReduce_3  14# happyReduction_111
happyReduction_111 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_2 of { happy_var_2 -> 
	happyIn20
		 (map hide happy_var_2
	)}

happyReduce_112 = happyReduce 5# 14# happyReduction_112
happyReduction_112 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut16 happy_x_3 of { happy_var_3 -> 
	case happyOut20 happy_x_5 of { happy_var_5 -> 
	happyIn20
		 (map (hide . setRelevance Irrelevant . defaultArg) happy_var_3 ++ happy_var_5
	) `HappyStk` happyRest}}

happyReduce_113 = happyReduce 4# 14# happyReduction_113
happyReduction_113 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut16 happy_x_3 of { happy_var_3 -> 
	happyIn20
		 (map (hide . setRelevance Irrelevant . defaultArg) happy_var_3
	) `HappyStk` happyRest}

happyReduce_114 = happyReduce 5# 14# happyReduction_114
happyReduction_114 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut16 happy_x_3 of { happy_var_3 -> 
	case happyOut20 happy_x_5 of { happy_var_5 -> 
	happyIn20
		 (map (makeInstance . setRelevance Irrelevant . defaultArg) happy_var_3 ++ happy_var_5
	) `HappyStk` happyRest}}

happyReduce_115 = happyReduce 4# 14# happyReduction_115
happyReduction_115 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut16 happy_x_3 of { happy_var_3 -> 
	happyIn20
		 (map (makeInstance . setRelevance Irrelevant . defaultArg) happy_var_3
	) `HappyStk` happyRest}

happyReduce_116 = happyReduce 5# 14# happyReduction_116
happyReduction_116 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut16 happy_x_3 of { happy_var_3 -> 
	case happyOut20 happy_x_5 of { happy_var_5 -> 
	happyIn20
		 (map (hide . setRelevance NonStrict . defaultArg) happy_var_3 ++ happy_var_5
	) `HappyStk` happyRest}}

happyReduce_117 = happyReduce 4# 14# happyReduction_117
happyReduction_117 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut16 happy_x_3 of { happy_var_3 -> 
	happyIn20
		 (map (hide . setRelevance NonStrict . defaultArg) happy_var_3
	) `HappyStk` happyRest}

happyReduce_118 = happyReduce 5# 14# happyReduction_118
happyReduction_118 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut16 happy_x_3 of { happy_var_3 -> 
	case happyOut20 happy_x_5 of { happy_var_5 -> 
	happyIn20
		 (map (makeInstance . setRelevance NonStrict . defaultArg) happy_var_3 ++ happy_var_5
	) `HappyStk` happyRest}}

happyReduce_119 = happyReduce 4# 14# happyReduction_119
happyReduction_119 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut16 happy_x_3 of { happy_var_3 -> 
	happyIn20
		 (map (makeInstance . setRelevance NonStrict . defaultArg) happy_var_3
	) `HappyStk` happyRest}

happyReduce_120 = happyMonadReduce 1# 15# happyReduction_120
happyReduction_120 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokQId happy_var_1) -> 
	( mkQName happy_var_1)}
	) (\r -> happyReturn (happyIn21 r))

happyReduce_121 = happySpecReduce_1  15# happyReduction_121
happyReduction_121 happy_x_1
	 =  case happyOut15 happy_x_1 of { happy_var_1 -> 
	happyIn21
		 (QName happy_var_1
	)}

happyReduce_122 = happySpecReduce_1  16# happyReduction_122
happyReduction_122 happy_x_1
	 =  case happyOut21 happy_x_1 of { happy_var_1 -> 
	happyIn22
		 (happy_var_1
	)}

happyReduce_123 = happySpecReduce_1  17# happyReduction_123
happyReduction_123 happy_x_1
	 =  case happyOut15 happy_x_1 of { happy_var_1 -> 
	happyIn23
		 (happy_var_1
	)}

happyReduce_124 = happySpecReduce_1  17# happyReduction_124
happyReduction_124 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymUnderscore happy_var_1) -> 
	happyIn23
		 (Name (getRange happy_var_1) [Hole]
	)}

happyReduce_125 = happySpecReduce_2  18# happyReduction_125
happyReduction_125 happy_x_2
	happy_x_1
	 =  case happyOut23 happy_x_1 of { happy_var_1 -> 
	case happyOut24 happy_x_2 of { happy_var_2 -> 
	happyIn24
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_126 = happySpecReduce_1  18# happyReduction_126
happyReduction_126 happy_x_1
	 =  case happyOut23 happy_x_1 of { happy_var_1 -> 
	happyIn24
		 ([happy_var_1]
	)}

happyReduce_127 = happySpecReduce_1  19# happyReduction_127
happyReduction_127 happy_x_1
	 =  case happyOut26 happy_x_1 of { happy_var_1 -> 
	happyIn25
		 (case happy_var_1 of
      Left ns -> ns
      Right _ -> fail $ "expected sequence of bound identifiers, not absurd pattern"
	)}

happyReduce_128 = happyMonadReduce 1# 20# happyReduction_128
happyReduction_128 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut33 happy_x_1 of { happy_var_1 -> 
	(
    let getName (Ident (QName x)) = Just x
	getName (Underscore r _)  = Just (Name r [Hole])
	getName _		  = Nothing

        containsAbsurd (Absurd _) = True
        containsAbsurd (HiddenArg _ (Named _ e)) = containsAbsurd e
        containsAbsurd (InstanceArg _ (Named _ e)) = containsAbsurd e
        containsAbsurd (Paren _ expr)    = containsAbsurd expr
        containsAbsurd (RawApp _ exprs)    = any containsAbsurd exprs
        containsAbsurd _          = False
    in
    if isJust $ find containsAbsurd happy_var_1 then return $ Right happy_var_1 else
    case partition isJust $ map getName happy_var_1 of
	(good, []) -> return $ Left $ map fromJust good
	_	   -> fail $ "expected sequence of bound identifiers")}
	) (\r -> happyReturn (happyIn26 r))

happyReduce_129 = happySpecReduce_0  21# happyReduction_129
happyReduction_129  =  happyIn27
		 ([]
	)

happyReduce_130 = happySpecReduce_2  21# happyReduction_130
happyReduction_130 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	happyIn27
		 (snd happy_var_1 : happy_var_2
	)}}

happyReduce_131 = happySpecReduce_1  22# happyReduction_131
happyReduction_131 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	happyIn28
		 (snd happy_var_1
	)}

happyReduce_132 = happyMonadReduce 1# 23# happyReduction_132
happyReduction_132 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	( fmap QName (mkName happy_var_1))}
	) (\r -> happyReturn (happyIn29 r))

happyReduce_133 = happySpecReduce_2  24# happyReduction_133
happyReduction_133 happy_x_2
	happy_x_1
	 =  case happyOut43 happy_x_1 of { happy_var_1 -> 
	case happyOut30 happy_x_2 of { happy_var_2 -> 
	happyIn30
		 (Pi happy_var_1 happy_var_2
	)}}

happyReduce_134 = happySpecReduce_3  24# happyReduction_134
happyReduction_134 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut56 happy_x_2 of { happy_var_2 -> 
	case happyOut30 happy_x_3 of { happy_var_3 -> 
	happyIn30
		 (forallPi happy_var_2 happy_var_3
	)}}

happyReduce_135 = happySpecReduce_3  24# happyReduction_135
happyReduction_135 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut36 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymArrow happy_var_2) -> 
	case happyOut30 happy_x_3 of { happy_var_3 -> 
	happyIn30
		 (Fun (getRange (happy_var_1,happy_var_2,happy_var_3))
                                              (RawApp (getRange happy_var_1) happy_var_1)
                                              happy_var_3
	)}}}

happyReduce_136 = happySpecReduce_3  24# happyReduction_136
happyReduction_136 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut31 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymEqual happy_var_2) -> 
	case happyOut30 happy_x_3 of { happy_var_3 -> 
	happyIn30
		 (Equal (getRange (happy_var_1, happy_var_2, happy_var_3)) happy_var_1 happy_var_3
	)}}}

happyReduce_137 = happySpecReduce_1  24# happyReduction_137
happyReduction_137 happy_x_1
	 =  case happyOut31 happy_x_1 of { happy_var_1 -> 
	happyIn30
		 (happy_var_1
	)}

happyReduce_138 = happyMonadReduce 1# 25# happyReduction_138
happyReduction_138 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut32 happy_x_1 of { happy_var_1 -> 
	( case happy_var_1 of
		      { [e]    -> return e
		      ; e : es -> return $ WithApp (fuseRange e es) e es
		      ; []     -> fail "impossible: empty with expressions"
		      })}
	) (\r -> happyReturn (happyIn31 r))

happyReduce_139 = happySpecReduce_3  26# happyReduction_139
happyReduction_139 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut36 happy_x_1 of { happy_var_1 -> 
	case happyOut32 happy_x_3 of { happy_var_3 -> 
	happyIn32
		 (RawApp (getRange happy_var_1) happy_var_1 :  happy_var_3
	)}}

happyReduce_140 = happySpecReduce_1  26# happyReduction_140
happyReduction_140 happy_x_1
	 =  case happyOut33 happy_x_1 of { happy_var_1 -> 
	happyIn32
		 ([RawApp (getRange happy_var_1) happy_var_1]
	)}

happyReduce_141 = happySpecReduce_1  27# happyReduction_141
happyReduction_141 happy_x_1
	 =  case happyOut34 happy_x_1 of { happy_var_1 -> 
	happyIn33
		 ([happy_var_1]
	)}

happyReduce_142 = happySpecReduce_2  27# happyReduction_142
happyReduction_142 happy_x_2
	happy_x_1
	 =  case happyOut39 happy_x_1 of { happy_var_1 -> 
	case happyOut33 happy_x_2 of { happy_var_2 -> 
	happyIn33
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_143 = happySpecReduce_3  28# happyReduction_143
happyReduction_143 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymLambda happy_var_1) -> 
	case happyOut48 happy_x_2 of { happy_var_2 -> 
	case happyOut30 happy_x_3 of { happy_var_3 -> 
	happyIn34
		 (Lam (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_2 happy_var_3
	)}}}

happyReduce_144 = happySpecReduce_1  28# happyReduction_144
happyReduction_144 happy_x_1
	 =  case happyOut35 happy_x_1 of { happy_var_1 -> 
	happyIn34
		 (happy_var_1
	)}

happyReduce_145 = happyReduce 4# 28# happyReduction_145
happyReduction_145 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwLet happy_var_1) -> 
	case happyOut136 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokKeyword KwIn happy_var_3) -> 
	case happyOut30 happy_x_4 of { happy_var_4 -> 
	happyIn34
		 (Let (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_146 = happySpecReduce_1  28# happyReduction_146
happyReduction_146 happy_x_1
	 =  case happyOut39 happy_x_1 of { happy_var_1 -> 
	happyIn34
		 (happy_var_1
	)}

happyReduce_147 = happyReduce 4# 28# happyReduction_147
happyReduction_147 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwQuoteGoal happy_var_1) -> 
	case happyOut15 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokKeyword KwIn happy_var_3) -> 
	case happyOut30 happy_x_4 of { happy_var_4 -> 
	happyIn34
		 (QuoteGoal (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_148 = happyReduce 4# 28# happyReduction_148
happyReduction_148 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwQuoteContext happy_var_1) -> 
	case happyOut15 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokKeyword KwIn happy_var_3) -> 
	case happyOut30 happy_x_4 of { happy_var_4 -> 
	happyIn34
		 (QuoteContext (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_149 = happyReduce 4# 29# happyReduction_149
happyReduction_149 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymLambda happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenBrace happy_var_2) -> 
	case happyOut55 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseBrace happy_var_4) -> 
	happyIn35
		 (ExtendedLam (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) (reverse happy_var_3)
	) `HappyStk` happyRest}}}}

happyReduce_150 = happyMonadReduce 2# 29# happyReduction_150
happyReduction_150 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokSymbol SymLambda happy_var_1) -> 
	case happyOut49 happy_x_2 of { happy_var_2 -> 
	( case happy_var_2 of
                                       Left (bs, h) -> if null bs then return $ AbsurdLam r h else
                                                       return $ Lam r bs (AbsurdLam r h)
                                                         where r = fuseRange happy_var_1 bs
    				       Right es -> do -- it is of the form @\ { p1 ... () }@
                                                     p <- exprToLHS (RawApp (getRange es) es);
                                                     return $ ExtendedLam (fuseRange happy_var_1 es)
                                                                     [(p [] [], AbsurdRHS, NoWhere)])}}
	) (\r -> happyReturn (happyIn35 r))

happyReduce_151 = happySpecReduce_1  30# happyReduction_151
happyReduction_151 happy_x_1
	 =  case happyOut39 happy_x_1 of { happy_var_1 -> 
	happyIn36
		 ([happy_var_1]
	)}

happyReduce_152 = happySpecReduce_2  30# happyReduction_152
happyReduction_152 happy_x_2
	happy_x_1
	 =  case happyOut39 happy_x_1 of { happy_var_1 -> 
	case happyOut36 happy_x_2 of { happy_var_2 -> 
	happyIn36
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_153 = happySpecReduce_3  31# happyReduction_153
happyReduction_153 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenBrace happy_var_1) -> 
	case happyOut30 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseBrace happy_var_3) -> 
	happyIn37
		 (HiddenArg (getRange (happy_var_1,happy_var_2,happy_var_3)) (maybeNamed happy_var_2)
	)}}}

happyReduce_154 = happySpecReduce_2  31# happyReduction_154
happyReduction_154 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenBrace happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymCloseBrace happy_var_2) -> 
	happyIn37
		 (let r = fuseRange happy_var_1 happy_var_2 in HiddenArg r $ unnamed $ Absurd r
	)}}

happyReduce_155 = happySpecReduce_1  32# happyReduction_155
happyReduction_155 happy_x_1
	 =  case happyOut21 happy_x_1 of { happy_var_1 -> 
	happyIn38
		 (Ident happy_var_1
	)}

happyReduce_156 = happySpecReduce_1  32# happyReduction_156
happyReduction_156 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokLiteral happy_var_1) -> 
	happyIn38
		 (Lit happy_var_1
	)}

happyReduce_157 = happySpecReduce_1  32# happyReduction_157
happyReduction_157 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymQuestionMark happy_var_1) -> 
	happyIn38
		 (QuestionMark (getRange happy_var_1) Nothing
	)}

happyReduce_158 = happySpecReduce_1  32# happyReduction_158
happyReduction_158 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymUnderscore happy_var_1) -> 
	happyIn38
		 (Underscore (getRange happy_var_1) Nothing
	)}

happyReduce_159 = happySpecReduce_1  32# happyReduction_159
happyReduction_159 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwProp happy_var_1) -> 
	happyIn38
		 (Prop (getRange happy_var_1)
	)}

happyReduce_160 = happySpecReduce_1  32# happyReduction_160
happyReduction_160 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwSet happy_var_1) -> 
	happyIn38
		 (Set (getRange happy_var_1)
	)}

happyReduce_161 = happySpecReduce_1  32# happyReduction_161
happyReduction_161 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuote happy_var_1) -> 
	happyIn38
		 (Quote (getRange happy_var_1)
	)}

happyReduce_162 = happySpecReduce_1  32# happyReduction_162
happyReduction_162 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuoteTerm happy_var_1) -> 
	happyIn38
		 (QuoteTerm (getRange happy_var_1)
	)}

happyReduce_163 = happySpecReduce_1  32# happyReduction_163
happyReduction_163 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUnquote happy_var_1) -> 
	happyIn38
		 (Unquote (getRange happy_var_1)
	)}

happyReduce_164 = happySpecReduce_1  32# happyReduction_164
happyReduction_164 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSetN happy_var_1) -> 
	happyIn38
		 (SetN (getRange (fst happy_var_1)) (snd happy_var_1)
	)}

happyReduce_165 = happySpecReduce_3  32# happyReduction_165
happyReduction_165 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleOpenBrace happy_var_1) -> 
	case happyOut30 happy_x_2 of { happy_var_2 -> 
	case happyOut17 happy_x_3 of { happy_var_3 -> 
	happyIn38
		 (InstanceArg (getRange (happy_var_1,happy_var_2,happy_var_3))
                                                          (maybeNamed happy_var_2)
	)}}}

happyReduce_166 = happySpecReduce_3  32# happyReduction_166
happyReduction_166 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOut30 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseParen happy_var_3) -> 
	happyIn38
		 (Paren (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_2
	)}}}

happyReduce_167 = happySpecReduce_2  32# happyReduction_167
happyReduction_167 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymCloseParen happy_var_2) -> 
	happyIn38
		 (Absurd (fuseRange happy_var_1 happy_var_2)
	)}}

happyReduce_168 = happySpecReduce_2  32# happyReduction_168
happyReduction_168 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleOpenBrace happy_var_1) -> 
	case happyOut17 happy_x_2 of { happy_var_2 -> 
	happyIn38
		 (let r = fuseRange happy_var_1 happy_var_2 in InstanceArg r $ unnamed $ Absurd r
	)}}

happyReduce_169 = happySpecReduce_3  32# happyReduction_169
happyReduction_169 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut15 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymAs happy_var_2) -> 
	case happyOut39 happy_x_3 of { happy_var_3 -> 
	happyIn38
		 (As (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_1 happy_var_3
	)}}}

happyReduce_170 = happySpecReduce_2  32# happyReduction_170
happyReduction_170 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDot happy_var_1) -> 
	case happyOut39 happy_x_2 of { happy_var_2 -> 
	happyIn38
		 (Dot (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_171 = happyReduce 4# 32# happyReduction_171
happyReduction_171 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenBrace happy_var_2) -> 
	case happyOut40 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseBrace happy_var_4) -> 
	happyIn38
		 (Rec (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_172 = happyReduce 5# 32# happyReduction_172
happyReduction_172 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOut38 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymOpenBrace happy_var_3) -> 
	case happyOut40 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymCloseBrace happy_var_5) -> 
	happyIn38
		 (RecUpdate (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_173 = happySpecReduce_1  33# happyReduction_173
happyReduction_173 happy_x_1
	 =  case happyOut37 happy_x_1 of { happy_var_1 -> 
	happyIn39
		 (happy_var_1
	)}

happyReduce_174 = happySpecReduce_1  33# happyReduction_174
happyReduction_174 happy_x_1
	 =  case happyOut38 happy_x_1 of { happy_var_1 -> 
	happyIn39
		 (happy_var_1
	)}

happyReduce_175 = happySpecReduce_0  34# happyReduction_175
happyReduction_175  =  happyIn40
		 ([]
	)

happyReduce_176 = happySpecReduce_1  34# happyReduction_176
happyReduction_176 happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	happyIn40
		 (happy_var_1
	)}

happyReduce_177 = happySpecReduce_1  35# happyReduction_177
happyReduction_177 happy_x_1
	 =  case happyOut42 happy_x_1 of { happy_var_1 -> 
	happyIn41
		 ([happy_var_1]
	)}

happyReduce_178 = happySpecReduce_3  35# happyReduction_178
happyReduction_178 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut42 happy_x_1 of { happy_var_1 -> 
	case happyOut41 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_179 = happySpecReduce_3  36# happyReduction_179
happyReduction_179 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut15 happy_x_1 of { happy_var_1 -> 
	case happyOut30 happy_x_3 of { happy_var_3 -> 
	happyIn42
		 ((happy_var_1, happy_var_3)
	)}}

happyReduce_180 = happySpecReduce_2  37# happyReduction_180
happyReduction_180 happy_x_2
	happy_x_1
	 =  case happyOut44 happy_x_1 of { happy_var_1 -> 
	happyIn43
		 (happy_var_1
	)}

happyReduce_181 = happySpecReduce_1  38# happyReduction_181
happyReduction_181 happy_x_1
	 =  case happyOut45 happy_x_1 of { happy_var_1 -> 
	happyIn44
		 ({-TeleBind-} happy_var_1
	)}

happyReduce_182 = happySpecReduce_2  39# happyReduction_182
happyReduction_182 happy_x_2
	happy_x_1
	 =  case happyOut46 happy_x_1 of { happy_var_1 -> 
	case happyOut45 happy_x_2 of { happy_var_2 -> 
	happyIn45
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_183 = happySpecReduce_1  39# happyReduction_183
happyReduction_183 happy_x_1
	 =  case happyOut46 happy_x_1 of { happy_var_1 -> 
	happyIn45
		 ([happy_var_1]
	)}

happyReduce_184 = happyReduce 4# 40# happyReduction_184
happyReduction_184 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut47 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn46
		 (TypedBindings (getRange (happy_var_2,happy_var_3,happy_var_4))
                                           (setRelevance Irrelevant $ defaultColoredArg happy_var_3)
	) `HappyStk` happyRest}}}

happyReduce_185 = happyReduce 4# 40# happyReduction_185
happyReduction_185 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymOpenBrace happy_var_2) -> 
	case happyOut47 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseBrace happy_var_4) -> 
	happyIn46
		 (TypedBindings (getRange (happy_var_2,happy_var_3,happy_var_4))
                                           (hide $ setRelevance Irrelevant $ defaultColoredArg happy_var_3)
	) `HappyStk` happyRest}}}

happyReduce_186 = happyReduce 4# 40# happyReduction_186
happyReduction_186 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymDoubleOpenBrace happy_var_2) -> 
	case happyOut47 happy_x_3 of { happy_var_3 -> 
	case happyOut17 happy_x_4 of { happy_var_4 -> 
	happyIn46
		 (TypedBindings (getRange (happy_var_2,happy_var_3,happy_var_4))
                                                       (makeInstance $ setRelevance Irrelevant $ defaultColoredArg happy_var_3)
	) `HappyStk` happyRest}}}

happyReduce_187 = happyReduce 4# 40# happyReduction_187
happyReduction_187 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut47 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn46
		 (TypedBindings (getRange (happy_var_2,happy_var_3,happy_var_4))
                                            (setRelevance NonStrict $ defaultColoredArg happy_var_3)
	) `HappyStk` happyRest}}}

happyReduce_188 = happyReduce 4# 40# happyReduction_188
happyReduction_188 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymOpenBrace happy_var_2) -> 
	case happyOut47 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseBrace happy_var_4) -> 
	happyIn46
		 (TypedBindings (getRange (happy_var_2,happy_var_3,happy_var_4))
                                            (hide $ setRelevance NonStrict $ defaultColoredArg happy_var_3)
	) `HappyStk` happyRest}}}

happyReduce_189 = happyReduce 4# 40# happyReduction_189
happyReduction_189 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymDoubleOpenBrace happy_var_2) -> 
	case happyOut47 happy_x_3 of { happy_var_3 -> 
	case happyOut17 happy_x_4 of { happy_var_4 -> 
	happyIn46
		 (TypedBindings (getRange (happy_var_2,happy_var_3,happy_var_4))
                                                        (makeInstance $ setRelevance NonStrict $ defaultColoredArg happy_var_3)
	) `HappyStk` happyRest}}}

happyReduce_190 = happySpecReduce_3  40# happyReduction_190
happyReduction_190 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOut47 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseParen happy_var_3) -> 
	happyIn46
		 (TypedBindings (getRange (happy_var_1,happy_var_2,happy_var_3))
                                           (defaultColoredArg happy_var_2)
	)}}}

happyReduce_191 = happySpecReduce_3  40# happyReduction_191
happyReduction_191 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleOpenBrace happy_var_1) -> 
	case happyOut47 happy_x_2 of { happy_var_2 -> 
	case happyOut17 happy_x_3 of { happy_var_3 -> 
	happyIn46
		 (TypedBindings (getRange (happy_var_1,happy_var_2,happy_var_3))
                                                       (makeInstance $ defaultColoredArg happy_var_2)
	)}}}

happyReduce_192 = happySpecReduce_3  40# happyReduction_192
happyReduction_192 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenBrace happy_var_1) -> 
	case happyOut47 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseBrace happy_var_3) -> 
	happyIn46
		 (TypedBindings (getRange (happy_var_1,happy_var_2,happy_var_3))
                                           (hide $ defaultColoredArg happy_var_2)
	)}}}

happyReduce_193 = happySpecReduce_3  40# happyReduction_193
happyReduction_193 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOut105 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseParen happy_var_3) -> 
	happyIn46
		 (tLet (getRange (happy_var_1,happy_var_3)) happy_var_2
	)}}}

happyReduce_194 = happyReduce 4# 40# happyReduction_194
happyReduction_194 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOut136 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn46
		 (tLet (getRange (happy_var_1,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_195 = happySpecReduce_3  41# happyReduction_195
happyReduction_195 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut25 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymColon happy_var_2) -> 
	case happyOut30 happy_x_3 of { happy_var_3 -> 
	happyIn47
		 (( [], TBind (getRange (happy_var_1,happy_var_2,happy_var_3))    (map mkBoundName_ happy_var_1) happy_var_3 )
	)}}}

happyReduce_196 = happyMonadReduce 2# 42# happyReduction_196
happyReduction_196 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut50 happy_x_1 of { happy_var_1 -> 
	(
      case reverse happy_var_1 of
        Left _ : _ -> parseError "Absurd lambda cannot have a body."
	_ : _      -> return [ b | Right b <- happy_var_1 ]
        []         -> parsePanic "Empty LamBinds")}
	) (\r -> happyReturn (happyIn48 r))

happyReduce_197 = happyMonadReduce 1# 43# happyReduction_197
happyReduction_197 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut51 happy_x_1 of { happy_var_1 -> 
	(
    case happy_var_1 of
      Left lb -> case reverse lb of
                   Right _ : _ -> parseError "Missing body for lambda"
                   Left h  : _ -> return $ Left ([ b | Right b <- init lb], h)
                   _           -> parsePanic "Empty LamBindsAbsurd"
      Right es -> return $ Right es)}
	) (\r -> happyReturn (happyIn49 r))

happyReduce_198 = happySpecReduce_2  44# happyReduction_198
happyReduction_198 happy_x_2
	happy_x_1
	 =  case happyOut59 happy_x_1 of { happy_var_1 -> 
	case happyOut50 happy_x_2 of { happy_var_2 -> 
	happyIn50
		 (map Right happy_var_1 ++ happy_var_2
	)}}

happyReduce_199 = happySpecReduce_2  44# happyReduction_199
happyReduction_199 happy_x_2
	happy_x_1
	 =  case happyOut46 happy_x_1 of { happy_var_1 -> 
	case happyOut50 happy_x_2 of { happy_var_2 -> 
	happyIn50
		 (Right (DomainFull happy_var_1) : happy_var_2
	)}}

happyReduce_200 = happySpecReduce_1  44# happyReduction_200
happyReduction_200 happy_x_1
	 =  case happyOut59 happy_x_1 of { happy_var_1 -> 
	happyIn50
		 (map Right happy_var_1
	)}

happyReduce_201 = happySpecReduce_1  44# happyReduction_201
happyReduction_201 happy_x_1
	 =  case happyOut46 happy_x_1 of { happy_var_1 -> 
	happyIn50
		 ([Right $ DomainFull happy_var_1]
	)}

happyReduce_202 = happySpecReduce_2  44# happyReduction_202
happyReduction_202 happy_x_2
	happy_x_1
	 =  happyIn50
		 ([Left NotHidden]
	)

happyReduce_203 = happySpecReduce_2  44# happyReduction_203
happyReduction_203 happy_x_2
	happy_x_1
	 =  happyIn50
		 ([Left Hidden]
	)

happyReduce_204 = happySpecReduce_2  44# happyReduction_204
happyReduction_204 happy_x_2
	happy_x_1
	 =  happyIn50
		 ([Left Instance]
	)

happyReduce_205 = happySpecReduce_2  45# happyReduction_205
happyReduction_205 happy_x_2
	happy_x_1
	 =  case happyOut59 happy_x_1 of { happy_var_1 -> 
	case happyOut50 happy_x_2 of { happy_var_2 -> 
	happyIn51
		 (Left $ map Right happy_var_1 ++ happy_var_2
	)}}

happyReduce_206 = happySpecReduce_2  45# happyReduction_206
happyReduction_206 happy_x_2
	happy_x_1
	 =  case happyOut46 happy_x_1 of { happy_var_1 -> 
	case happyOut50 happy_x_2 of { happy_var_2 -> 
	happyIn51
		 (Left $ Right (DomainFull happy_var_1) : happy_var_2
	)}}

happyReduce_207 = happySpecReduce_1  45# happyReduction_207
happyReduction_207 happy_x_1
	 =  case happyOut60 happy_x_1 of { happy_var_1 -> 
	happyIn51
		 (case happy_var_1 of
                                    Left lb -> Left $ map Right lb
                                    Right es -> Right es
	)}

happyReduce_208 = happySpecReduce_1  45# happyReduction_208
happyReduction_208 happy_x_1
	 =  case happyOut46 happy_x_1 of { happy_var_1 -> 
	happyIn51
		 (Left [Right $ DomainFull happy_var_1]
	)}

happyReduce_209 = happySpecReduce_2  45# happyReduction_209
happyReduction_209 happy_x_2
	happy_x_1
	 =  happyIn51
		 (Left [Left NotHidden]
	)

happyReduce_210 = happySpecReduce_2  45# happyReduction_210
happyReduction_210 happy_x_2
	happy_x_1
	 =  happyIn51
		 (Left [Left Hidden]
	)

happyReduce_211 = happySpecReduce_2  45# happyReduction_211
happyReduction_211 happy_x_2
	happy_x_1
	 =  happyIn51
		 (Left [Left Instance]
	)

happyReduce_212 = happyMonadReduce 3# 46# happyReduction_212
happyReduction_212 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut36 happy_x_1 of { happy_var_1 -> 
	case happyOut30 happy_x_3 of { happy_var_3 -> 
	( do
      p <- exprToLHS (RawApp (getRange happy_var_1) happy_var_1) ;
      return (p [] [], RHS happy_var_3, NoWhere))}}
	) (\r -> happyReturn (happyIn52 r))

happyReduce_213 = happyMonadReduce 1# 47# happyReduction_213
happyReduction_213 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut33 happy_x_1 of { happy_var_1 -> 
	( do
      p <- exprToLHS (RawApp (getRange happy_var_1) happy_var_1);
      return (p [] [], AbsurdRHS, NoWhere))}
	) (\r -> happyReturn (happyIn53 r))

happyReduce_214 = happySpecReduce_1  48# happyReduction_214
happyReduction_214 happy_x_1
	 =  case happyOut52 happy_x_1 of { happy_var_1 -> 
	happyIn54
		 (happy_var_1
	)}

happyReduce_215 = happySpecReduce_1  48# happyReduction_215
happyReduction_215 happy_x_1
	 =  case happyOut53 happy_x_1 of { happy_var_1 -> 
	happyIn54
		 (happy_var_1
	)}

happyReduce_216 = happySpecReduce_3  49# happyReduction_216
happyReduction_216 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut55 happy_x_1 of { happy_var_1 -> 
	case happyOut54 happy_x_3 of { happy_var_3 -> 
	happyIn55
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_217 = happySpecReduce_3  49# happyReduction_217
happyReduction_217 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut53 happy_x_1 of { happy_var_1 -> 
	case happyOut54 happy_x_3 of { happy_var_3 -> 
	happyIn55
		 ([happy_var_3, happy_var_1]
	)}}

happyReduce_218 = happySpecReduce_1  49# happyReduction_218
happyReduction_218 happy_x_1
	 =  case happyOut52 happy_x_1 of { happy_var_1 -> 
	happyIn55
		 ([happy_var_1]
	)}

happyReduce_219 = happySpecReduce_2  50# happyReduction_219
happyReduction_219 happy_x_2
	happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	happyIn56
		 (happy_var_1
	)}

happyReduce_220 = happySpecReduce_2  51# happyReduction_220
happyReduction_220 happy_x_2
	happy_x_1
	 =  case happyOut59 happy_x_1 of { happy_var_1 -> 
	case happyOut57 happy_x_2 of { happy_var_2 -> 
	happyIn57
		 (happy_var_1 ++ happy_var_2
	)}}

happyReduce_221 = happySpecReduce_2  51# happyReduction_221
happyReduction_221 happy_x_2
	happy_x_1
	 =  case happyOut46 happy_x_1 of { happy_var_1 -> 
	case happyOut57 happy_x_2 of { happy_var_2 -> 
	happyIn57
		 (DomainFull happy_var_1 : happy_var_2
	)}}

happyReduce_222 = happySpecReduce_1  51# happyReduction_222
happyReduction_222 happy_x_1
	 =  case happyOut59 happy_x_1 of { happy_var_1 -> 
	happyIn57
		 (happy_var_1
	)}

happyReduce_223 = happySpecReduce_1  51# happyReduction_223
happyReduction_223 happy_x_1
	 =  case happyOut46 happy_x_1 of { happy_var_1 -> 
	happyIn57
		 ([DomainFull happy_var_1]
	)}

happyReduce_224 = happySpecReduce_2  52# happyReduction_224
happyReduction_224 happy_x_2
	happy_x_1
	 =  case happyOut59 happy_x_1 of { happy_var_1 -> 
	case happyOut58 happy_x_2 of { happy_var_2 -> 
	happyIn58
		 (happy_var_1 ++ happy_var_2
	)}}

happyReduce_225 = happySpecReduce_2  52# happyReduction_225
happyReduction_225 happy_x_2
	happy_x_1
	 =  case happyOut46 happy_x_1 of { happy_var_1 -> 
	case happyOut58 happy_x_2 of { happy_var_2 -> 
	happyIn58
		 (DomainFull happy_var_1 : happy_var_2
	)}}

happyReduce_226 = happySpecReduce_0  52# happyReduction_226
happyReduction_226  =  happyIn58
		 ([]
	)

happyReduce_227 = happySpecReduce_1  53# happyReduction_227
happyReduction_227 happy_x_1
	 =  case happyOut60 happy_x_1 of { happy_var_1 -> 
	happyIn59
		 (case happy_var_1 of
                             Left lbs -> lbs
                             Right _ -> fail "expected sequence of bound identifiers, not absurd pattern"
	)}

happyReduce_228 = happySpecReduce_1  54# happyReduction_228
happyReduction_228 happy_x_1
	 =  case happyOut23 happy_x_1 of { happy_var_1 -> 
	happyIn60
		 (Left [DomainFree defaultArgInfo $ mkBoundName_ happy_var_1]
	)}

happyReduce_229 = happySpecReduce_2  54# happyReduction_229
happyReduction_229 happy_x_2
	happy_x_1
	 =  case happyOut23 happy_x_2 of { happy_var_2 -> 
	happyIn60
		 (Left [DomainFree (setRelevance Irrelevant $ defaultArgInfo) $ mkBoundName_ happy_var_2]
	)}

happyReduce_230 = happySpecReduce_2  54# happyReduction_230
happyReduction_230 happy_x_2
	happy_x_1
	 =  case happyOut23 happy_x_2 of { happy_var_2 -> 
	happyIn60
		 (Left [DomainFree (setRelevance NonStrict $ defaultArgInfo) $ mkBoundName_ happy_var_2]
	)}

happyReduce_231 = happySpecReduce_3  54# happyReduction_231
happyReduction_231 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut26 happy_x_2 of { happy_var_2 -> 
	happyIn60
		 (either (Left . map (DomainFree (setHiding Hidden $ defaultArgInfo) . mkBoundName_)) Right happy_var_2
	)}

happyReduce_232 = happySpecReduce_3  54# happyReduction_232
happyReduction_232 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut25 happy_x_2 of { happy_var_2 -> 
	happyIn60
		 (Left $ map (DomainFree (setHiding Instance $ defaultArgInfo) . mkBoundName_) happy_var_2
	)}

happyReduce_233 = happyReduce 4# 54# happyReduction_233
happyReduction_233 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut25 happy_x_3 of { happy_var_3 -> 
	happyIn60
		 (Left $ map (DomainFree (setHiding Hidden $ setRelevance Irrelevant $ defaultArgInfo) . mkBoundName_) happy_var_3
	) `HappyStk` happyRest}

happyReduce_234 = happyReduce 4# 54# happyReduction_234
happyReduction_234 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut25 happy_x_3 of { happy_var_3 -> 
	happyIn60
		 (Left $ map (DomainFree (setHiding Instance $ setRelevance Irrelevant $ defaultArgInfo) . mkBoundName_) happy_var_3
	) `HappyStk` happyRest}

happyReduce_235 = happyReduce 4# 54# happyReduction_235
happyReduction_235 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut25 happy_x_3 of { happy_var_3 -> 
	happyIn60
		 (Left $ map (DomainFree (setHiding Hidden $ setRelevance NonStrict $ defaultArgInfo) . mkBoundName_) happy_var_3
	) `HappyStk` happyRest}

happyReduce_236 = happyReduce 4# 54# happyReduction_236
happyReduction_236 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut25 happy_x_3 of { happy_var_3 -> 
	happyIn60
		 (Left $ map (DomainFree  (setHiding Instance $ setRelevance NonStrict $ defaultArgInfo) . mkBoundName_) happy_var_3
	) `HappyStk` happyRest}

happyReduce_237 = happyMonadReduce 1# 55# happyReduction_237
happyReduction_237 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut62 happy_x_1 of { happy_var_1 -> 
	( mergeImportDirectives happy_var_1)}
	) (\r -> happyReturn (happyIn61 r))

happyReduce_238 = happySpecReduce_2  56# happyReduction_238
happyReduction_238 happy_x_2
	happy_x_1
	 =  case happyOut63 happy_x_1 of { happy_var_1 -> 
	case happyOut62 happy_x_2 of { happy_var_2 -> 
	happyIn62
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_239 = happySpecReduce_0  56# happyReduction_239
happyReduction_239  =  happyIn62
		 ([]
	)

happyReduce_240 = happySpecReduce_1  57# happyReduction_240
happyReduction_240 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPublic happy_var_1) -> 
	happyIn63
		 (defaultImportDir { importDirRange = getRange happy_var_1, publicOpen = True }
	)}

happyReduce_241 = happySpecReduce_1  57# happyReduction_241
happyReduction_241 happy_x_1
	 =  case happyOut64 happy_x_1 of { happy_var_1 -> 
	happyIn63
		 (defaultImportDir { importDirRange = snd happy_var_1, usingOrHiding = fst happy_var_1 }
	)}

happyReduce_242 = happySpecReduce_1  57# happyReduction_242
happyReduction_242 happy_x_1
	 =  case happyOut65 happy_x_1 of { happy_var_1 -> 
	happyIn63
		 (defaultImportDir { importDirRange = snd happy_var_1, renaming = fst happy_var_1 }
	)}

happyReduce_243 = happyReduce 4# 58# happyReduction_243
happyReduction_243 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwUsing happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn64
		 ((Using happy_var_3 , getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4))
	) `HappyStk` happyRest}}}}

happyReduce_244 = happyReduce 4# 58# happyReduction_244
happyReduction_244 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwHiding happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn64
		 ((Hiding happy_var_3 , getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4))
	) `HappyStk` happyRest}}}}

happyReduce_245 = happyReduce 4# 59# happyReduction_245
happyReduction_245 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwRenaming happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut66 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn65
		 ((happy_var_3 , getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4))
	) `HappyStk` happyRest}}}}

happyReduce_246 = happySpecReduce_3  59# happyReduction_246
happyReduction_246 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwRenaming happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseParen happy_var_3) -> 
	happyIn65
		 (([] , getRange (happy_var_1,happy_var_2,happy_var_3))
	)}}}

happyReduce_247 = happySpecReduce_3  60# happyReduction_247
happyReduction_247 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut67 happy_x_1 of { happy_var_1 -> 
	case happyOut66 happy_x_3 of { happy_var_3 -> 
	happyIn66
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_248 = happySpecReduce_1  60# happyReduction_248
happyReduction_248 happy_x_1
	 =  case happyOut67 happy_x_1 of { happy_var_1 -> 
	happyIn66
		 ([happy_var_1]
	)}

happyReduce_249 = happySpecReduce_3  61# happyReduction_249
happyReduction_249 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut68 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwTo happy_var_2) -> 
	case happyOut15 happy_x_3 of { happy_var_3 -> 
	happyIn67
		 (Renaming happy_var_1 happy_var_3 (getRange happy_var_2)
	)}}}

happyReduce_250 = happySpecReduce_2  62# happyReduction_250
happyReduction_250 happy_x_2
	happy_x_1
	 =  case happyOut15 happy_x_2 of { happy_var_2 -> 
	happyIn68
		 (ImportedName happy_var_2
	)}

happyReduce_251 = happySpecReduce_3  62# happyReduction_251
happyReduction_251 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut15 happy_x_3 of { happy_var_3 -> 
	happyIn68
		 (ImportedModule happy_var_3
	)}

happyReduce_252 = happySpecReduce_1  63# happyReduction_252
happyReduction_252 happy_x_1
	 =  case happyOut15 happy_x_1 of { happy_var_1 -> 
	happyIn69
		 (ImportedName happy_var_1
	)}

happyReduce_253 = happySpecReduce_2  63# happyReduction_253
happyReduction_253 happy_x_2
	happy_x_1
	 =  case happyOut15 happy_x_2 of { happy_var_2 -> 
	happyIn69
		 (ImportedModule happy_var_2
	)}

happyReduce_254 = happySpecReduce_0  64# happyReduction_254
happyReduction_254  =  happyIn70
		 ([]
	)

happyReduce_255 = happySpecReduce_1  64# happyReduction_255
happyReduction_255 happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	happyIn70
		 (happy_var_1
	)}

happyReduce_256 = happySpecReduce_1  65# happyReduction_256
happyReduction_256 happy_x_1
	 =  case happyOut69 happy_x_1 of { happy_var_1 -> 
	happyIn71
		 ([happy_var_1]
	)}

happyReduce_257 = happySpecReduce_3  65# happyReduction_257
happyReduction_257 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut69 happy_x_1 of { happy_var_1 -> 
	case happyOut71 happy_x_3 of { happy_var_3 -> 
	happyIn71
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_258 = happyMonadReduce 3# 66# happyReduction_258
happyReduction_258 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut31 happy_x_1 of { happy_var_1 -> 
	case happyOut75 happy_x_2 of { happy_var_2 -> 
	case happyOut74 happy_x_3 of { happy_var_3 -> 
	( exprToLHS happy_var_1 >>= \p -> return (p happy_var_2 happy_var_3))}}}
	) (\r -> happyReturn (happyIn72 r))

happyReduce_259 = happyReduce 4# 66# happyReduction_259
happyReduction_259 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymEllipsis happy_var_1) -> 
	case happyOut73 happy_x_2 of { happy_var_2 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	case happyOut74 happy_x_4 of { happy_var_4 -> 
	happyIn72
		 (Ellipsis (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_2 happy_var_3 happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_260 = happySpecReduce_0  67# happyReduction_260
happyReduction_260  =  happyIn73
		 ([]
	)

happyReduce_261 = happyMonadReduce 3# 67# happyReduction_261
happyReduction_261 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut36 happy_x_2 of { happy_var_2 -> 
	case happyOut73 happy_x_3 of { happy_var_3 -> 
	( exprToPattern (RawApp (getRange happy_var_2) happy_var_2) >>= \p ->
		   return (p : happy_var_3))}}
	) (\r -> happyReturn (happyIn73 r))

happyReduce_262 = happySpecReduce_0  68# happyReduction_262
happyReduction_262  =  happyIn74
		 ([]
	)

happyReduce_263 = happySpecReduce_2  68# happyReduction_263
happyReduction_263 happy_x_2
	happy_x_1
	 =  case happyOut30 happy_x_2 of { happy_var_2 -> 
	happyIn74
		 (case happy_var_2 of { WithApp _ e es -> e : es; e -> [e] }
	)}

happyReduce_264 = happySpecReduce_0  69# happyReduction_264
happyReduction_264  =  happyIn75
		 ([]
	)

happyReduce_265 = happySpecReduce_2  69# happyReduction_265
happyReduction_265 happy_x_2
	happy_x_1
	 =  case happyOut31 happy_x_2 of { happy_var_2 -> 
	happyIn75
		 (case happy_var_2 of { WithApp _ e es -> e : es; e -> [e] }
	)}

happyReduce_266 = happySpecReduce_0  70# happyReduction_266
happyReduction_266  =  happyIn76
		 (NoWhere
	)

happyReduce_267 = happySpecReduce_2  70# happyReduction_267
happyReduction_267 happy_x_2
	happy_x_1
	 =  case happyOut137 happy_x_2 of { happy_var_2 -> 
	happyIn76
		 (AnyWhere happy_var_2
	)}

happyReduce_268 = happyReduce 4# 70# happyReduction_268
happyReduction_268 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut15 happy_x_2 of { happy_var_2 -> 
	case happyOut137 happy_x_4 of { happy_var_4 -> 
	happyIn76
		 (SomeWhere happy_var_2 happy_var_4
	) `HappyStk` happyRest}}

happyReduce_269 = happyReduce 4# 70# happyReduction_269
happyReduction_269 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut110 happy_x_2 of { happy_var_2 -> 
	case happyOut137 happy_x_4 of { happy_var_4 -> 
	happyIn76
		 (SomeWhere happy_var_2 happy_var_4
	) `HappyStk` happyRest}}

happyReduce_270 = happySpecReduce_1  71# happyReduction_270
happyReduction_270 happy_x_1
	 =  case happyOut89 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 (happy_var_1
	)}

happyReduce_271 = happySpecReduce_1  71# happyReduction_271
happyReduction_271 happy_x_1
	 =  case happyOut81 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 (happy_var_1
	)}

happyReduce_272 = happySpecReduce_1  71# happyReduction_272
happyReduction_272 happy_x_1
	 =  case happyOut83 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 ([happy_var_1]
	)}

happyReduce_273 = happySpecReduce_1  71# happyReduction_273
happyReduction_273 happy_x_1
	 =  case happyOut84 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 ([happy_var_1]
	)}

happyReduce_274 = happySpecReduce_1  71# happyReduction_274
happyReduction_274 happy_x_1
	 =  case happyOut85 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 ([happy_var_1]
	)}

happyReduce_275 = happySpecReduce_1  71# happyReduction_275
happyReduction_275 happy_x_1
	 =  case happyOut86 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 ([happy_var_1]
	)}

happyReduce_276 = happySpecReduce_1  71# happyReduction_276
happyReduction_276 happy_x_1
	 =  case happyOut88 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 ([happy_var_1]
	)}

happyReduce_277 = happySpecReduce_1  71# happyReduction_277
happyReduction_277 happy_x_1
	 =  case happyOut90 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 ([happy_var_1]
	)}

happyReduce_278 = happySpecReduce_1  71# happyReduction_278
happyReduction_278 happy_x_1
	 =  case happyOut91 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 ([happy_var_1]
	)}

happyReduce_279 = happySpecReduce_1  71# happyReduction_279
happyReduction_279 happy_x_1
	 =  case happyOut92 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 ([happy_var_1]
	)}

happyReduce_280 = happySpecReduce_1  71# happyReduction_280
happyReduction_280 happy_x_1
	 =  case happyOut93 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 ([happy_var_1]
	)}

happyReduce_281 = happySpecReduce_1  71# happyReduction_281
happyReduction_281 happy_x_1
	 =  case happyOut94 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 ([happy_var_1]
	)}

happyReduce_282 = happySpecReduce_1  71# happyReduction_282
happyReduction_282 happy_x_1
	 =  case happyOut105 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 (happy_var_1
	)}

happyReduce_283 = happySpecReduce_1  71# happyReduction_283
happyReduction_283 happy_x_1
	 =  case happyOut108 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 ([happy_var_1]
	)}

happyReduce_284 = happySpecReduce_1  71# happyReduction_284
happyReduction_284 happy_x_1
	 =  case happyOut109 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 ([happy_var_1]
	)}

happyReduce_285 = happySpecReduce_1  71# happyReduction_285
happyReduction_285 happy_x_1
	 =  case happyOut112 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 ([happy_var_1]
	)}

happyReduce_286 = happySpecReduce_1  71# happyReduction_286
happyReduction_286 happy_x_1
	 =  case happyOut95 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 ([happy_var_1]
	)}

happyReduce_287 = happySpecReduce_1  71# happyReduction_287
happyReduction_287 happy_x_1
	 =  case happyOut96 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 ([happy_var_1]
	)}

happyReduce_288 = happySpecReduce_3  72# happyReduction_288
happyReduction_288 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut16 happy_x_1 of { happy_var_1 -> 
	case happyOut30 happy_x_3 of { happy_var_3 -> 
	happyIn78
		 (map (flip (TypeSig defaultArgInfo) happy_var_3) happy_var_1
	)}}

happyReduce_289 = happySpecReduce_3  73# happyReduction_289
happyReduction_289 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_1 of { happy_var_1 -> 
	case happyOut30 happy_x_3 of { happy_var_3 -> 
	happyIn79
		 (map (\ (Common.Arg info x) -> TypeSig info x happy_var_3) happy_var_1
	)}}

happyReduce_290 = happySpecReduce_3  74# happyReduction_290
happyReduction_290 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut20 happy_x_1 of { happy_var_1 -> 
	case happyOut30 happy_x_3 of { happy_var_3 -> 
	happyIn80
		 (map (fmap (flip (TypeSig defaultArgInfo) happy_var_3)) happy_var_1
	)}}

happyReduce_291 = happyMonadReduce 3# 75# happyReduction_291
happyReduction_291 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut72 happy_x_1 of { happy_var_1 -> 
	case happyOut82 happy_x_2 of { happy_var_2 -> 
	case happyOut76 happy_x_3 of { happy_var_3 -> 
	( funClauseOrTypeSigs happy_var_1 happy_var_2 happy_var_3)}}}
	) (\r -> happyReturn (happyIn81 r))

happyReduce_292 = happySpecReduce_2  76# happyReduction_292
happyReduction_292 happy_x_2
	happy_x_1
	 =  case happyOut30 happy_x_2 of { happy_var_2 -> 
	happyIn82
		 (JustRHS (RHS happy_var_2)
	)}

happyReduce_293 = happySpecReduce_2  76# happyReduction_293
happyReduction_293 happy_x_2
	happy_x_1
	 =  case happyOut30 happy_x_2 of { happy_var_2 -> 
	happyIn82
		 (TypeSigsRHS happy_var_2
	)}

happyReduce_294 = happySpecReduce_0  76# happyReduction_294
happyReduction_294  =  happyIn82
		 (JustRHS AbsurdRHS
	)

happyReduce_295 = happyReduce 7# 77# happyReduction_295
happyReduction_295 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwData happy_var_1) -> 
	case happyOut15 happy_x_2 of { happy_var_2 -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymColon happy_var_4) -> 
	case happyOut30 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (TokKeyword KwWhere happy_var_6) -> 
	case happyOut133 happy_x_7 of { happy_var_7 -> 
	happyIn83
		 (Data (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5,happy_var_6,happy_var_7)) Inductive happy_var_2 happy_var_3 (Just happy_var_5) happy_var_7
	) `HappyStk` happyRest}}}}}}}

happyReduce_296 = happyReduce 7# 77# happyReduction_296
happyReduction_296 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwCoData happy_var_1) -> 
	case happyOut15 happy_x_2 of { happy_var_2 -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymColon happy_var_4) -> 
	case happyOut30 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (TokKeyword KwWhere happy_var_6) -> 
	case happyOut133 happy_x_7 of { happy_var_7 -> 
	happyIn83
		 (Data (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5,happy_var_6,happy_var_7)) CoInductive happy_var_2 happy_var_3 (Just happy_var_5) happy_var_7
	) `HappyStk` happyRest}}}}}}}

happyReduce_297 = happyReduce 5# 77# happyReduction_297
happyReduction_297 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwData happy_var_1) -> 
	case happyOut15 happy_x_2 of { happy_var_2 -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokKeyword KwWhere happy_var_4) -> 
	case happyOut133 happy_x_5 of { happy_var_5 -> 
	happyIn83
		 (Data (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) Inductive happy_var_2 happy_var_3 Nothing happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_298 = happyReduce 5# 77# happyReduction_298
happyReduction_298 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwCoData happy_var_1) -> 
	case happyOut15 happy_x_2 of { happy_var_2 -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokKeyword KwWhere happy_var_4) -> 
	case happyOut133 happy_x_5 of { happy_var_5 -> 
	happyIn83
		 (Data (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) CoInductive happy_var_2 happy_var_3 Nothing happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_299 = happyReduce 5# 78# happyReduction_299
happyReduction_299 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwData happy_var_1) -> 
	case happyOut15 happy_x_2 of { happy_var_2 -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymColon happy_var_4) -> 
	case happyOut30 happy_x_5 of { happy_var_5 -> 
	happyIn84
		 (DataSig (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) Inductive happy_var_2 happy_var_3 happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_300 = happyMonadReduce 7# 79# happyReduction_300
happyReduction_300 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOut38 happy_x_2 of { happy_var_2 -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymColon happy_var_4) -> 
	case happyOut30 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (TokKeyword KwWhere happy_var_6) -> 
	case happyOut134 happy_x_7 of { happy_var_7 -> 
	( exprToName happy_var_2 >>= \ n -> return $ Record (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5,happy_var_6,happy_var_7)) n (fst3 happy_var_7) (snd3 happy_var_7) happy_var_3 (Just happy_var_5) (thd3 happy_var_7))}}}}}}}
	) (\r -> happyReturn (happyIn85 r))

happyReduce_301 = happyMonadReduce 5# 79# happyReduction_301
happyReduction_301 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOut38 happy_x_2 of { happy_var_2 -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokKeyword KwWhere happy_var_4) -> 
	case happyOut134 happy_x_5 of { happy_var_5 -> 
	( exprToName happy_var_2 >>= \ n -> return $ Record (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) n (fst3 happy_var_5) (snd3 happy_var_5) happy_var_3 Nothing (thd3 happy_var_5))}}}}}
	) (\r -> happyReturn (happyIn85 r))

happyReduce_302 = happyMonadReduce 5# 80# happyReduction_302
happyReduction_302 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOut38 happy_x_2 of { happy_var_2 -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymColon happy_var_4) -> 
	case happyOut30 happy_x_5 of { happy_var_5 -> 
	( exprToName happy_var_2 >>= \ n -> return $ RecordSig (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) n happy_var_3 happy_var_5)}}}}}
	) (\r -> happyReturn (happyIn86 r))

happyReduce_303 = happySpecReduce_2  81# happyReduction_303
happyReduction_303 happy_x_2
	happy_x_1
	 =  case happyOut15 happy_x_2 of { happy_var_2 -> 
	happyIn87
		 (happy_var_2
	)}

happyReduce_304 = happySpecReduce_3  82# happyReduction_304
happyReduction_304 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfix happy_var_1) -> 
	case happyOut14 happy_x_2 of { happy_var_2 -> 
	case happyOut24 happy_x_3 of { happy_var_3 -> 
	happyIn88
		 (Infix (NonAssoc (getRange (happy_var_1,happy_var_3)) happy_var_2) happy_var_3
	)}}}

happyReduce_305 = happySpecReduce_3  82# happyReduction_305
happyReduction_305 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfixL happy_var_1) -> 
	case happyOut14 happy_x_2 of { happy_var_2 -> 
	case happyOut24 happy_x_3 of { happy_var_3 -> 
	happyIn88
		 (Infix (LeftAssoc (getRange (happy_var_1,happy_var_3)) happy_var_2) happy_var_3
	)}}}

happyReduce_306 = happySpecReduce_3  82# happyReduction_306
happyReduction_306 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfixR happy_var_1) -> 
	case happyOut14 happy_x_2 of { happy_var_2 -> 
	case happyOut24 happy_x_3 of { happy_var_3 -> 
	happyIn88
		 (Infix (RightAssoc (getRange (happy_var_1,happy_var_3)) happy_var_2) happy_var_3
	)}}}

happyReduce_307 = happySpecReduce_2  83# happyReduction_307
happyReduction_307 happy_x_2
	happy_x_1
	 =  case happyOut131 happy_x_2 of { happy_var_2 -> 
	happyIn89
		 (let toField (Common.Arg info (TypeSig _ x t)) = Field x (Common.Arg info t) in map toField happy_var_2
	)}

happyReduce_308 = happySpecReduce_2  84# happyReduction_308
happyReduction_308 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwMutual happy_var_1) -> 
	case happyOut136 happy_x_2 of { happy_var_2 -> 
	happyIn90
		 (Mutual (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_309 = happySpecReduce_2  85# happyReduction_309
happyReduction_309 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwAbstract happy_var_1) -> 
	case happyOut136 happy_x_2 of { happy_var_2 -> 
	happyIn91
		 (Abstract (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_310 = happySpecReduce_2  86# happyReduction_310
happyReduction_310 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPrivate happy_var_1) -> 
	case happyOut136 happy_x_2 of { happy_var_2 -> 
	happyIn92
		 (Private (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_311 = happySpecReduce_2  87# happyReduction_311
happyReduction_311 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPostulate happy_var_1) -> 
	case happyOut129 happy_x_2 of { happy_var_2 -> 
	happyIn93
		 (Postulate (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_312 = happySpecReduce_2  88# happyReduction_312
happyReduction_312 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPrimitive happy_var_1) -> 
	case happyOut127 happy_x_2 of { happy_var_2 -> 
	happyIn94
		 (Primitive (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_313 = happyMonadReduce 5# 89# happyReduction_313
happyReduction_313 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut15 happy_x_2 of { happy_var_2 -> 
	case happyOut99 happy_x_3 of { happy_var_3 -> 
	case happyOut98 happy_x_5 of { happy_var_5 -> 
	(
  case happy_var_2 of
    Name _ [_] -> case mkNotation happy_var_3 (map rangedThing happy_var_5) of
      Left err -> parseError $ "malformed syntax declaration: " ++ err
      Right n -> return $ Syntax happy_var_2 n
    _ -> parseError "syntax declarations are allowed only for simple names (without holes)")}}}
	) (\r -> happyReturn (happyIn95 r))

happyReduce_314 = happyMonadReduce 5# 90# happyReduction_314
happyReduction_314 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokKeyword KwPatternSyn happy_var_1) -> 
	case happyOut15 happy_x_2 of { happy_var_2 -> 
	case happyOut97 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymEqual happy_var_4) -> 
	case happyOut30 happy_x_5 of { happy_var_5 -> 
	( do
  p <- exprToPattern happy_var_5
  return (PatternSyn (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) happy_var_2 happy_var_3 p))}}}}}
	) (\r -> happyReturn (happyIn96 r))

happyReduce_315 = happySpecReduce_0  91# happyReduction_315
happyReduction_315  =  happyIn97
		 ([]
	)

happyReduce_316 = happyMonadReduce 1# 91# happyReduction_316
happyReduction_316 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut50 happy_x_1 of { happy_var_1 -> 
	( patternSynArgs happy_var_1)}
	) (\r -> happyReturn (happyIn97 r))

happyReduce_317 = happySpecReduce_1  92# happyReduction_317
happyReduction_317 happy_x_1
	 =  case happyOut103 happy_x_1 of { happy_var_1 -> 
	happyIn98
		 ([happy_var_1]
	)}

happyReduce_318 = happySpecReduce_2  92# happyReduction_318
happyReduction_318 happy_x_2
	happy_x_1
	 =  case happyOut98 happy_x_1 of { happy_var_1 -> 
	case happyOut103 happy_x_2 of { happy_var_2 -> 
	happyIn98
		 (happy_var_1 ++ [happy_var_2]
	)}}

happyReduce_319 = happySpecReduce_1  93# happyReduction_319
happyReduction_319 happy_x_1
	 =  case happyOut100 happy_x_1 of { happy_var_1 -> 
	happyIn99
		 ([happy_var_1]
	)}

happyReduce_320 = happySpecReduce_2  93# happyReduction_320
happyReduction_320 happy_x_2
	happy_x_1
	 =  case happyOut99 happy_x_1 of { happy_var_1 -> 
	case happyOut100 happy_x_2 of { happy_var_2 -> 
	happyIn99
		 (happy_var_1 ++ [happy_var_2]
	)}}

happyReduce_321 = happySpecReduce_1  94# happyReduction_321
happyReduction_321 happy_x_1
	 =  case happyOut101 happy_x_1 of { happy_var_1 -> 
	happyIn100
		 (defaultNamedArg happy_var_1
	)}

happyReduce_322 = happySpecReduce_3  94# happyReduction_322
happyReduction_322 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut102 happy_x_2 of { happy_var_2 -> 
	happyIn100
		 (setHiding Hidden   $ defaultNamedArg happy_var_2
	)}

happyReduce_323 = happySpecReduce_3  94# happyReduction_323
happyReduction_323 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut102 happy_x_2 of { happy_var_2 -> 
	happyIn100
		 (setHiding Instance $ defaultNamedArg happy_var_2
	)}

happyReduce_324 = happyReduce 5# 94# happyReduction_324
happyReduction_324 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut103 happy_x_2 of { happy_var_2 -> 
	case happyOut102 happy_x_4 of { happy_var_4 -> 
	happyIn100
		 (setHiding Hidden   $ defaultArg $ named happy_var_2 happy_var_4
	) `HappyStk` happyRest}}

happyReduce_325 = happyReduce 5# 94# happyReduction_325
happyReduction_325 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut103 happy_x_2 of { happy_var_2 -> 
	case happyOut102 happy_x_4 of { happy_var_4 -> 
	happyIn100
		 (setHiding Instance $ defaultArg $ named happy_var_2 happy_var_4
	) `HappyStk` happyRest}}

happyReduce_326 = happySpecReduce_1  95# happyReduction_326
happyReduction_326 happy_x_1
	 =  case happyOut103 happy_x_1 of { happy_var_1 -> 
	happyIn101
		 (ExprHole (rangedThing happy_var_1)
	)}

happyReduce_327 = happyReduce 6# 95# happyReduction_327
happyReduction_327 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut103 happy_x_3 of { happy_var_3 -> 
	case happyOut103 happy_x_5 of { happy_var_5 -> 
	happyIn101
		 (LambdaHole (rangedThing happy_var_3) (rangedThing happy_var_5)
	) `HappyStk` happyRest}}

happyReduce_328 = happySpecReduce_1  96# happyReduction_328
happyReduction_328 happy_x_1
	 =  case happyOut103 happy_x_1 of { happy_var_1 -> 
	happyIn102
		 (ExprHole (rangedThing happy_var_1)
	)}

happyReduce_329 = happyReduce 4# 96# happyReduction_329
happyReduction_329 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut103 happy_x_2 of { happy_var_2 -> 
	case happyOut103 happy_x_4 of { happy_var_4 -> 
	happyIn102
		 (LambdaHole (rangedThing happy_var_2) (rangedThing happy_var_4)
	) `HappyStk` happyRest}}

happyReduce_330 = happySpecReduce_1  97# happyReduction_330
happyReduction_330 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokId happy_var_1) -> 
	happyIn103
		 (Ranged (getRange $ fst happy_var_1) (stringToRawName $ snd happy_var_1)
	)}

happyReduce_331 = happySpecReduce_1  98# happyReduction_331
happyReduction_331 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwOpen happy_var_1) -> 
	happyIn104
		 (Just (getRange happy_var_1)
	)}

happyReduce_332 = happySpecReduce_0  98# happyReduction_332
happyReduction_332  =  happyIn104
		 (Nothing
	)

happyReduce_333 = happyMonadReduce 5# 99# happyReduction_333
happyReduction_333 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut104 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwImport happy_var_2) -> 
	case happyOut22 happy_x_3 of { happy_var_3 -> 
	case happyOut106 happy_x_4 of { happy_var_4 -> 
	case happyOut61 happy_x_5 of { happy_var_5 -> 
	(
    let
    { doOpen = maybe DontOpen (const DoOpen) happy_var_1
    ; m   = happy_var_3
    ; es  = happy_var_4
    ; dir = happy_var_5
    ; r   = getRange (m, es, dir)
    ; mr  = getRange m
    ; unique = hashString $ show $ (Nothing :: Maybe ()) <$ r
         -- turn range into unique id, but delete file path
         -- which is absolute and messes up suite of failing tests
         -- (different hashs on different installations)
         -- TODO: Don't use (insecure) hashes in this way.
    ; fresh = Name mr [ Id $ stringToRawName $ ".#" ++ show m ++ "-" ++ show unique ]
    ; impStm asR = Import mr m (Just (AsName fresh asR)) DontOpen defaultImportDir
    ; appStm m' es =
        let r = getRange (m, es) in
        Private r
          [ ModuleMacro r m'
             (SectionApp (getRange es) []
               (RawApp (getRange es) (Ident (QName fresh) : es)))
             doOpen dir
          ]
    ; (initArgs, last2Args) = splitAt (length es - 2) es
    ; parseAsClause = case last2Args of
      { [ Ident (QName (Name asR [Id x]))
        , Ident (QName m')
        ] | rawNameToString x == "as" -> Just (asR, m')
      ; _ -> Nothing
      }
    } in
    case es of
      { [] -> return [Import mr m Nothing doOpen dir]
      ; _ | Just (asR, m') <- parseAsClause ->
              if null initArgs then return
                 [ Import (getRange (m, asR, m', dir)) m
                     (Just (AsName m' asR)) doOpen dir
                 ]
              else return [ impStm asR, appStm m' initArgs ]
          | DontOpen <- doOpen -> parseErrorAt (fromJust $ rStart $ getRange happy_var_2) "An import statement with module instantiation does not actually import the module.  This statement achieves nothing.  Either add the `open' keyword or bind the instantiated module with an `as' clause."
          | otherwise -> return
              [ impStm noRange
              , appStm (noName $ beginningOf $ getRange m) es
              ]
      })}}}}}
	) (\r -> happyReturn (happyIn105 r))

happyReduce_334 = happyReduce 4# 99# happyReduction_334
happyReduction_334 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut22 happy_x_2 of { happy_var_2 -> 
	case happyOut106 happy_x_3 of { happy_var_3 -> 
	case happyOut61 happy_x_4 of { happy_var_4 -> 
	happyIn105
		 (let
    { m   = happy_var_2
    ; es  = happy_var_3
    ; dir = happy_var_4
    ; r   = getRange (m, es, dir)
    } in
    [ case es of
      { []  -> Open r m dir
      ; _   -> Private r [ ModuleMacro r (noName $ beginningOf $ getRange m)
			     (SectionApp (getRange (m , es)) [] (RawApp (fuseRange m es) (Ident m : es)))
			     DoOpen dir
                         ]
      }
    ]
	) `HappyStk` happyRest}}}

happyReduce_335 = happyReduce 6# 99# happyReduction_335
happyReduction_335 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut22 happy_x_2 of { happy_var_2 -> 
	case happyOut61 happy_x_6 of { happy_var_6 -> 
	happyIn105
		 (let r = getRange happy_var_2 in
    [ Private r [ ModuleMacro r (noName $ beginningOf $ getRange happy_var_2)
    	      	(RecordModuleIFS r happy_var_2) DoOpen happy_var_6
                ]
    ]
	) `HappyStk` happyRest}}

happyReduce_336 = happySpecReduce_0  100# happyReduction_336
happyReduction_336  =  happyIn106
		 ([]
	)

happyReduce_337 = happySpecReduce_2  100# happyReduction_337
happyReduction_337 happy_x_2
	happy_x_1
	 =  case happyOut39 happy_x_1 of { happy_var_1 -> 
	case happyOut106 happy_x_2 of { happy_var_2 -> 
	happyIn106
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_338 = happyReduce 4# 101# happyReduction_338
happyReduction_338 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut22 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymDoubleOpenBrace happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymEllipsis happy_var_3) -> 
	case happyOut17 happy_x_4 of { happy_var_4 -> 
	happyIn107
		 ((\ts ->
		    if null ts then return $ RecordModuleIFS (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_1
		    else parseError "No bindings allowed for record module with non-canonical implicits" )
	) `HappyStk` happyRest}}}}

happyReduce_339 = happySpecReduce_2  101# happyReduction_339
happyReduction_339 happy_x_2
	happy_x_1
	 =  case happyOut22 happy_x_1 of { happy_var_1 -> 
	case happyOut106 happy_x_2 of { happy_var_2 -> 
	happyIn107
		 ((\ts -> return $ SectionApp (getRange (happy_var_1, happy_var_2)) ts (RawApp (fuseRange happy_var_1 happy_var_2) (Ident happy_var_1 : happy_var_2)) )
	)}}

happyReduce_340 = happyMonadReduce 6# 102# happyReduction_340
happyReduction_340 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokKeyword KwModule happy_var_1) -> 
	case happyOut22 happy_x_2 of { happy_var_2 -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	case happyOut107 happy_x_5 of { happy_var_5 -> 
	case happyOut61 happy_x_6 of { happy_var_6 -> 
	( do { ma <- happy_var_5 (map addType happy_var_3)
                          ; name <- ensureUnqual happy_var_2
                          ; return $ ModuleMacro (getRange (happy_var_1, happy_var_2, ma, happy_var_6)) name ma DontOpen happy_var_6 })}}}}}
	) (\r -> happyReturn (happyIn108 r))

happyReduce_341 = happyMonadReduce 7# 102# happyReduction_341
happyReduction_341 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokKeyword KwOpen happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwModule happy_var_2) -> 
	case happyOut15 happy_x_3 of { happy_var_3 -> 
	case happyOut58 happy_x_4 of { happy_var_4 -> 
	case happyOut107 happy_x_6 of { happy_var_6 -> 
	case happyOut61 happy_x_7 of { happy_var_7 -> 
	( do {ma <- happy_var_6 (map addType happy_var_4); return $ ModuleMacro (getRange (happy_var_1, happy_var_2, happy_var_3, ma, happy_var_7)) happy_var_3 ma DoOpen happy_var_7 })}}}}}}
	) (\r -> happyReturn (happyIn108 r))

happyReduce_342 = happyReduce 5# 103# happyReduction_342
happyReduction_342 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwModule happy_var_1) -> 
	case happyOut22 happy_x_2 of { happy_var_2 -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokKeyword KwWhere happy_var_4) -> 
	case happyOut137 happy_x_5 of { happy_var_5 -> 
	happyIn109
		 (Module (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) happy_var_2 (map addType happy_var_3) happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_343 = happyReduce 5# 103# happyReduction_343
happyReduction_343 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwModule happy_var_1) -> 
	case happyOut110 happy_x_2 of { happy_var_2 -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokKeyword KwWhere happy_var_4) -> 
	case happyOut137 happy_x_5 of { happy_var_5 -> 
	happyIn109
		 (Module (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) (QName happy_var_2) (map addType happy_var_3) happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_344 = happySpecReduce_1  104# happyReduction_344
happyReduction_344 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymUnderscore happy_var_1) -> 
	happyIn110
		 (noName (getRange happy_var_1)
	)}

happyReduce_345 = happySpecReduce_1  105# happyReduction_345
happyReduction_345 happy_x_1
	 =  case happyOut139 happy_x_1 of { happy_var_1 -> 
	happyIn111
		 (figureOutTopLevelModule happy_var_1
	)}

happyReduce_346 = happySpecReduce_1  106# happyReduction_346
happyReduction_346 happy_x_1
	 =  case happyOut113 happy_x_1 of { happy_var_1 -> 
	happyIn112
		 (Pragma happy_var_1
	)}

happyReduce_347 = happySpecReduce_1  107# happyReduction_347
happyReduction_347 happy_x_1
	 =  case happyOut115 happy_x_1 of { happy_var_1 -> 
	happyIn113
		 (happy_var_1
	)}

happyReduce_348 = happySpecReduce_1  107# happyReduction_348
happyReduction_348 happy_x_1
	 =  case happyOut116 happy_x_1 of { happy_var_1 -> 
	happyIn113
		 (happy_var_1
	)}

happyReduce_349 = happySpecReduce_1  107# happyReduction_349
happyReduction_349 happy_x_1
	 =  case happyOut117 happy_x_1 of { happy_var_1 -> 
	happyIn113
		 (happy_var_1
	)}

happyReduce_350 = happySpecReduce_1  107# happyReduction_350
happyReduction_350 happy_x_1
	 =  case happyOut119 happy_x_1 of { happy_var_1 -> 
	happyIn113
		 (happy_var_1
	)}

happyReduce_351 = happySpecReduce_1  107# happyReduction_351
happyReduction_351 happy_x_1
	 =  case happyOut118 happy_x_1 of { happy_var_1 -> 
	happyIn113
		 (happy_var_1
	)}

happyReduce_352 = happySpecReduce_1  107# happyReduction_352
happyReduction_352 happy_x_1
	 =  case happyOut120 happy_x_1 of { happy_var_1 -> 
	happyIn113
		 (happy_var_1
	)}

happyReduce_353 = happySpecReduce_1  107# happyReduction_353
happyReduction_353 happy_x_1
	 =  case happyOut121 happy_x_1 of { happy_var_1 -> 
	happyIn113
		 (happy_var_1
	)}

happyReduce_354 = happySpecReduce_1  107# happyReduction_354
happyReduction_354 happy_x_1
	 =  case happyOut122 happy_x_1 of { happy_var_1 -> 
	happyIn113
		 (happy_var_1
	)}

happyReduce_355 = happySpecReduce_1  107# happyReduction_355
happyReduction_355 happy_x_1
	 =  case happyOut125 happy_x_1 of { happy_var_1 -> 
	happyIn113
		 (happy_var_1
	)}

happyReduce_356 = happySpecReduce_1  107# happyReduction_356
happyReduction_356 happy_x_1
	 =  case happyOut126 happy_x_1 of { happy_var_1 -> 
	happyIn113
		 (happy_var_1
	)}

happyReduce_357 = happySpecReduce_1  107# happyReduction_357
happyReduction_357 happy_x_1
	 =  case happyOut123 happy_x_1 of { happy_var_1 -> 
	happyIn113
		 (happy_var_1
	)}

happyReduce_358 = happySpecReduce_1  107# happyReduction_358
happyReduction_358 happy_x_1
	 =  case happyOut124 happy_x_1 of { happy_var_1 -> 
	happyIn113
		 (happy_var_1
	)}

happyReduce_359 = happySpecReduce_1  107# happyReduction_359
happyReduction_359 happy_x_1
	 =  case happyOut114 happy_x_1 of { happy_var_1 -> 
	happyIn113
		 (happy_var_1
	)}

happyReduce_360 = happyReduce 4# 108# happyReduction_360
happyReduction_360 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwOPTIONS happy_var_2) -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn114
		 (OptionsPragma (getRange (happy_var_1,happy_var_2,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_361 = happyReduce 5# 109# happyReduction_361
happyReduction_361 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwBUILTIN happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokString happy_var_3) -> 
	case happyOut29 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn115
		 (BuiltinPragma (getRange (happy_var_1,happy_var_2,fst happy_var_3,happy_var_4,happy_var_5)) (snd happy_var_3) (Ident happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_362 = happyReduce 5# 110# happyReduction_362
happyReduction_362 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED happy_var_2) -> 
	case happyOut29 happy_x_3 of { happy_var_3 -> 
	case happyOut27 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn116
		 (CompiledPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_5)) happy_var_3 (unwords happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_363 = happyReduce 5# 111# happyReduction_363
happyReduction_363 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED_EXPORT happy_var_2) -> 
	case happyOut29 happy_x_3 of { happy_var_3 -> 
	case happyOut28 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn117
		 (CompiledExportPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_5)) happy_var_3 happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_364 = happyReduce 5# 112# happyReduction_364
happyReduction_364 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED_TYPE happy_var_2) -> 
	case happyOut29 happy_x_3 of { happy_var_3 -> 
	case happyOut27 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn118
		 (CompiledTypePragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_5)) happy_var_3 (unwords happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_365 = happyReduce 6# 113# happyReduction_365
happyReduction_365 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED_DATA happy_var_2) -> 
	case happyOut29 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokString happy_var_4) -> 
	case happyOut27 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (TokSymbol SymClosePragma happy_var_6) -> 
	happyIn119
		 (CompiledDataPragma (getRange (happy_var_1,happy_var_2,happy_var_3,fst happy_var_4,happy_var_6)) happy_var_3 (snd happy_var_4) happy_var_5
	) `HappyStk` happyRest}}}}}}

happyReduce_366 = happyReduce 5# 114# happyReduction_366
happyReduction_366 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED_EPIC happy_var_2) -> 
	case happyOut29 happy_x_3 of { happy_var_3 -> 
	case happyOut27 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn120
		 (CompiledEpicPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_5)) happy_var_3 (unwords happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_367 = happyReduce 5# 115# happyReduction_367
happyReduction_367 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED_JS happy_var_2) -> 
	case happyOut29 happy_x_3 of { happy_var_3 -> 
	case happyOut27 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn121
		 (CompiledJSPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_5)) happy_var_3 (unwords happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_368 = happyReduce 4# 116# happyReduction_368
happyReduction_368 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwSTATIC happy_var_2) -> 
	case happyOut29 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn122
		 (StaticPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_369 = happyReduce 4# 117# happyReduction_369
happyReduction_369 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwETA happy_var_2) -> 
	case happyOut29 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn123
		 (EtaPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_370 = happySpecReduce_3  118# happyReduction_370
happyReduction_370 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwNO_TERMINATION_CHECK happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn124
		 (NoTerminationCheckPragma (getRange (happy_var_1,happy_var_2,happy_var_3))
	)}}}

happyReduce_371 = happyMonadReduce 4# 119# happyReduction_371
happyReduction_371 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwIMPORT happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokString happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	( let s = snd happy_var_3 in
       if validHaskellModuleName s
       then return $ ImportPragma (getRange (happy_var_1,happy_var_2,fst happy_var_3,happy_var_4)) s
       else parseError $ "Malformed module name: " ++ s ++ ".")}}}}
	) (\r -> happyReturn (happyIn125 r))

happyReduce_372 = happySpecReduce_3  120# happyReduction_372
happyReduction_372 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwIMPOSSIBLE happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn126
		 (ImpossiblePragma (getRange (happy_var_1,happy_var_2,happy_var_3))
	)}}}

happyReduce_373 = happySpecReduce_3  121# happyReduction_373
happyReduction_373 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut128 happy_x_2 of { happy_var_2 -> 
	happyIn127
		 (reverse happy_var_2
	)}

happyReduce_374 = happySpecReduce_3  122# happyReduction_374
happyReduction_374 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut128 happy_x_1 of { happy_var_1 -> 
	case happyOut78 happy_x_3 of { happy_var_3 -> 
	happyIn128
		 (reverse happy_var_3 ++ happy_var_1
	)}}

happyReduce_375 = happySpecReduce_1  122# happyReduction_375
happyReduction_375 happy_x_1
	 =  case happyOut78 happy_x_1 of { happy_var_1 -> 
	happyIn128
		 (reverse happy_var_1
	)}

happyReduce_376 = happySpecReduce_3  123# happyReduction_376
happyReduction_376 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut130 happy_x_2 of { happy_var_2 -> 
	happyIn129
		 (reverse happy_var_2
	)}

happyReduce_377 = happySpecReduce_3  124# happyReduction_377
happyReduction_377 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut130 happy_x_1 of { happy_var_1 -> 
	case happyOut79 happy_x_3 of { happy_var_3 -> 
	happyIn130
		 (reverse happy_var_3 ++ happy_var_1
	)}}

happyReduce_378 = happySpecReduce_1  124# happyReduction_378
happyReduction_378 happy_x_1
	 =  case happyOut79 happy_x_1 of { happy_var_1 -> 
	happyIn130
		 (reverse happy_var_1
	)}

happyReduce_379 = happySpecReduce_3  125# happyReduction_379
happyReduction_379 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut132 happy_x_2 of { happy_var_2 -> 
	happyIn131
		 (reverse happy_var_2
	)}

happyReduce_380 = happySpecReduce_3  126# happyReduction_380
happyReduction_380 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut132 happy_x_1 of { happy_var_1 -> 
	case happyOut80 happy_x_3 of { happy_var_3 -> 
	happyIn132
		 (reverse happy_var_3 ++ happy_var_1
	)}}

happyReduce_381 = happySpecReduce_1  126# happyReduction_381
happyReduction_381 happy_x_1
	 =  case happyOut80 happy_x_1 of { happy_var_1 -> 
	happyIn132
		 (reverse happy_var_1
	)}

happyReduce_382 = happySpecReduce_2  127# happyReduction_382
happyReduction_382 happy_x_2
	happy_x_1
	 =  happyIn133
		 ([]
	)

happyReduce_383 = happySpecReduce_1  127# happyReduction_383
happyReduction_383 happy_x_1
	 =  case happyOut127 happy_x_1 of { happy_var_1 -> 
	happyIn133
		 (happy_var_1
	)}

happyReduce_384 = happySpecReduce_2  128# happyReduction_384
happyReduction_384 happy_x_2
	happy_x_1
	 =  happyIn134
		 ((Nothing, Nothing, [])
	)

happyReduce_385 = happySpecReduce_3  128# happyReduction_385
happyReduction_385 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut87 happy_x_2 of { happy_var_2 -> 
	happyIn134
		 ((Nothing, Just happy_var_2, [])
	)}

happyReduce_386 = happyReduce 5# 128# happyReduction_386
happyReduction_386 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut87 happy_x_2 of { happy_var_2 -> 
	case happyOut138 happy_x_4 of { happy_var_4 -> 
	happyIn134
		 ((Nothing, Just happy_var_2, happy_var_4)
	) `HappyStk` happyRest}}

happyReduce_387 = happySpecReduce_3  128# happyReduction_387
happyReduction_387 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut138 happy_x_2 of { happy_var_2 -> 
	happyIn134
		 ((Nothing, Nothing, happy_var_2)
	)}

happyReduce_388 = happySpecReduce_3  128# happyReduction_388
happyReduction_388 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut135 happy_x_2 of { happy_var_2 -> 
	happyIn134
		 ((Just happy_var_2, Nothing, [])
	)}

happyReduce_389 = happyReduce 5# 128# happyReduction_389
happyReduction_389 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut135 happy_x_2 of { happy_var_2 -> 
	case happyOut87 happy_x_4 of { happy_var_4 -> 
	happyIn134
		 ((Just happy_var_2, Just happy_var_4, [])
	) `HappyStk` happyRest}}

happyReduce_390 = happyReduce 7# 128# happyReduction_390
happyReduction_390 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut135 happy_x_2 of { happy_var_2 -> 
	case happyOut87 happy_x_4 of { happy_var_4 -> 
	case happyOut138 happy_x_6 of { happy_var_6 -> 
	happyIn134
		 ((Just happy_var_2, Just happy_var_4, happy_var_6)
	) `HappyStk` happyRest}}}

happyReduce_391 = happyReduce 5# 128# happyReduction_391
happyReduction_391 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut135 happy_x_2 of { happy_var_2 -> 
	case happyOut138 happy_x_4 of { happy_var_4 -> 
	happyIn134
		 ((Just happy_var_2, Nothing, happy_var_4)
	) `HappyStk` happyRest}}

happyReduce_392 = happySpecReduce_1  129# happyReduction_392
happyReduction_392 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInductive happy_var_1) -> 
	happyIn135
		 (Ranged (getRange happy_var_1) Inductive
	)}

happyReduce_393 = happySpecReduce_1  129# happyReduction_393
happyReduction_393 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCoInductive happy_var_1) -> 
	happyIn135
		 (Ranged (getRange happy_var_1) CoInductive
	)}

happyReduce_394 = happySpecReduce_3  130# happyReduction_394
happyReduction_394 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut138 happy_x_2 of { happy_var_2 -> 
	happyIn136
		 (happy_var_2
	)}

happyReduce_395 = happySpecReduce_2  131# happyReduction_395
happyReduction_395 happy_x_2
	happy_x_1
	 =  happyIn137
		 ([]
	)

happyReduce_396 = happySpecReduce_1  131# happyReduction_396
happyReduction_396 happy_x_1
	 =  case happyOut136 happy_x_1 of { happy_var_1 -> 
	happyIn137
		 (happy_var_1
	)}

happyReduce_397 = happySpecReduce_3  132# happyReduction_397
happyReduction_397 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut77 happy_x_1 of { happy_var_1 -> 
	case happyOut138 happy_x_3 of { happy_var_3 -> 
	happyIn138
		 (happy_var_1 ++ happy_var_3
	)}}

happyReduce_398 = happySpecReduce_1  132# happyReduction_398
happyReduction_398 happy_x_1
	 =  case happyOut77 happy_x_1 of { happy_var_1 -> 
	happyIn138
		 (happy_var_1
	)}

happyReduce_399 = happySpecReduce_0  133# happyReduction_399
happyReduction_399  =  happyIn139
		 ([]
	)

happyReduce_400 = happySpecReduce_1  133# happyReduction_400
happyReduction_400 happy_x_1
	 =  case happyOut138 happy_x_1 of { happy_var_1 -> 
	happyIn139
		 (happy_var_1
	)}

happyNewToken action sts stk
	= lexer(\tk -> 
	let cont i = happyDoAction i tk action sts stk in
	case tk of {
	TokEOF -> happyDoAction 82# tk action sts stk;
	TokKeyword KwLet happy_dollar_dollar -> cont 1#;
	TokKeyword KwIn happy_dollar_dollar -> cont 2#;
	TokKeyword KwWhere happy_dollar_dollar -> cont 3#;
	TokKeyword KwWith happy_dollar_dollar -> cont 4#;
	TokKeyword KwRewrite happy_dollar_dollar -> cont 5#;
	TokKeyword KwPostulate happy_dollar_dollar -> cont 6#;
	TokKeyword KwPrimitive happy_dollar_dollar -> cont 7#;
	TokKeyword KwOpen happy_dollar_dollar -> cont 8#;
	TokKeyword KwImport happy_dollar_dollar -> cont 9#;
	TokKeyword KwUsing happy_dollar_dollar -> cont 10#;
	TokKeyword KwHiding happy_dollar_dollar -> cont 11#;
	TokKeyword KwRenaming happy_dollar_dollar -> cont 12#;
	TokKeyword KwTo happy_dollar_dollar -> cont 13#;
	TokKeyword KwPublic happy_dollar_dollar -> cont 14#;
	TokKeyword KwModule happy_dollar_dollar -> cont 15#;
	TokKeyword KwData happy_dollar_dollar -> cont 16#;
	TokKeyword KwCoData happy_dollar_dollar -> cont 17#;
	TokKeyword KwRecord happy_dollar_dollar -> cont 18#;
	TokKeyword KwConstructor happy_dollar_dollar -> cont 19#;
	TokKeyword KwInductive happy_dollar_dollar -> cont 20#;
	TokKeyword KwCoInductive happy_dollar_dollar -> cont 21#;
	TokKeyword KwField happy_dollar_dollar -> cont 22#;
	TokKeyword KwInfix happy_dollar_dollar -> cont 23#;
	TokKeyword KwInfixL happy_dollar_dollar -> cont 24#;
	TokKeyword KwInfixR happy_dollar_dollar -> cont 25#;
	TokKeyword KwMutual happy_dollar_dollar -> cont 26#;
	TokKeyword KwAbstract happy_dollar_dollar -> cont 27#;
	TokKeyword KwPrivate happy_dollar_dollar -> cont 28#;
	TokKeyword KwProp happy_dollar_dollar -> cont 29#;
	TokKeyword KwSet happy_dollar_dollar -> cont 30#;
	TokKeyword KwForall happy_dollar_dollar -> cont 31#;
	TokKeyword KwSyntax happy_dollar_dollar -> cont 32#;
	TokKeyword KwPatternSyn happy_dollar_dollar -> cont 33#;
	TokKeyword KwOPTIONS happy_dollar_dollar -> cont 34#;
	TokKeyword KwBUILTIN happy_dollar_dollar -> cont 35#;
	TokKeyword KwIMPORT happy_dollar_dollar -> cont 36#;
	TokKeyword KwIMPOSSIBLE happy_dollar_dollar -> cont 37#;
	TokKeyword KwETA happy_dollar_dollar -> cont 38#;
	TokKeyword KwNO_TERMINATION_CHECK happy_dollar_dollar -> cont 39#;
	TokKeyword KwCOMPILED happy_dollar_dollar -> cont 40#;
	TokKeyword KwCOMPILED_EXPORT happy_dollar_dollar -> cont 41#;
	TokKeyword KwCOMPILED_DATA happy_dollar_dollar -> cont 42#;
	TokKeyword KwCOMPILED_TYPE happy_dollar_dollar -> cont 43#;
	TokKeyword KwCOMPILED_EPIC happy_dollar_dollar -> cont 44#;
	TokKeyword KwCOMPILED_JS happy_dollar_dollar -> cont 45#;
	TokKeyword KwSTATIC happy_dollar_dollar -> cont 46#;
	TokKeyword KwQuoteGoal happy_dollar_dollar -> cont 47#;
	TokKeyword KwQuoteContext happy_dollar_dollar -> cont 48#;
	TokKeyword KwQuote happy_dollar_dollar -> cont 49#;
	TokKeyword KwQuoteTerm happy_dollar_dollar -> cont 50#;
	TokKeyword KwUnquote happy_dollar_dollar -> cont 51#;
	TokSetN happy_dollar_dollar -> cont 52#;
	TokTeX happy_dollar_dollar -> cont 53#;
	TokComment happy_dollar_dollar -> cont 54#;
	TokSymbol SymEllipsis happy_dollar_dollar -> cont 55#;
	TokSymbol SymDotDot happy_dollar_dollar -> cont 56#;
	TokSymbol SymDot happy_dollar_dollar -> cont 57#;
	TokSymbol SymSemi happy_dollar_dollar -> cont 58#;
	TokSymbol SymColon happy_dollar_dollar -> cont 59#;
	TokSymbol SymEqual happy_dollar_dollar -> cont 60#;
	TokSymbol SymUnderscore happy_dollar_dollar -> cont 61#;
	TokSymbol SymQuestionMark happy_dollar_dollar -> cont 62#;
	TokSymbol SymArrow happy_dollar_dollar -> cont 63#;
	TokSymbol SymLambda happy_dollar_dollar -> cont 64#;
	TokSymbol SymAs happy_dollar_dollar -> cont 65#;
	TokSymbol SymBar happy_dollar_dollar -> cont 66#;
	TokSymbol SymOpenParen happy_dollar_dollar -> cont 67#;
	TokSymbol SymCloseParen happy_dollar_dollar -> cont 68#;
	TokSymbol SymDoubleOpenBrace happy_dollar_dollar -> cont 69#;
	TokSymbol SymDoubleCloseBrace happy_dollar_dollar -> cont 70#;
	TokSymbol SymOpenBrace happy_dollar_dollar -> cont 71#;
	TokSymbol SymCloseBrace happy_dollar_dollar -> cont 72#;
	TokSymbol SymOpenVirtualBrace happy_dollar_dollar -> cont 73#;
	TokSymbol SymCloseVirtualBrace happy_dollar_dollar -> cont 74#;
	TokSymbol SymVirtualSemi happy_dollar_dollar -> cont 75#;
	TokSymbol SymOpenPragma happy_dollar_dollar -> cont 76#;
	TokSymbol SymClosePragma happy_dollar_dollar -> cont 77#;
	TokId happy_dollar_dollar -> cont 78#;
	TokQId happy_dollar_dollar -> cont 79#;
	TokString happy_dollar_dollar -> cont 80#;
	TokLiteral happy_dollar_dollar -> cont 81#;
	_ -> happyError' tk
	})

happyError_ 82# tk = happyError' tk
happyError_ _ tk = happyError' tk

happyThen :: () => Parser a -> (a -> Parser b) -> Parser b
happyThen = (>>=)
happyReturn :: () => a -> Parser a
happyReturn = (return)
happyThen1 = happyThen
happyReturn1 :: () => a -> Parser a
happyReturn1 = happyReturn
happyError' :: () => (Token) -> Parser a
happyError' tk = (\token -> happyError) tk

tokensParser = happySomeParser where
  happySomeParser = happyThen (happyParse 0#) (\x -> happyReturn (happyOut6 x))

exprParser = happySomeParser where
  happySomeParser = happyThen (happyParse 1#) (\x -> happyReturn (happyOut30 x))

moduleParser = happySomeParser where
  happySomeParser = happyThen (happyParse 2#) (\x -> happyReturn (happyOut9 x))

happySeq = happyDontSeq


{--------------------------------------------------------------------------
    Parsers
 --------------------------------------------------------------------------}

-- | Parse the token stream. Used by the TeX compiler.
tokensParser :: Parser [Token]

-- | Parse an expression. Could be used in interactions.
exprParser :: Parser Expr

-- | Parse a module.
moduleParser :: Parser Module


{--------------------------------------------------------------------------
    Happy stuff
 --------------------------------------------------------------------------}

-- | Required by Happy.
happyError :: Parser a
happyError = parseError "Parse error"


{--------------------------------------------------------------------------
    Utility functions
 --------------------------------------------------------------------------}

-- | Grab leading OPTIONS pragmas.
takeOptionsPragmas :: [Declaration] -> ([Pragma], [Declaration])
takeOptionsPragmas = spanJust $ \ d -> case d of
  Pragma p@OptionsPragma{} -> Just p
  _                        -> Nothing

-- | Insert a top-level module if there is none.
figureOutTopLevelModule :: [Declaration] -> [Declaration]
figureOutTopLevelModule ds =
  case span isAllowedBeforeModule ds of
    (ds0, Module r m tel ds1 : ds2) -> ds0 ++ [Module r m tel $ ds1 ++ ds2]
    (ds0, ds1)                      -> ds0 ++ [Module (getRange ds1) (QName noName_) [] ds1]
  where
    isAllowedBeforeModule (Pragma OptionsPragma{}) = True
    isAllowedBeforeModule (Private _ ds) = all isAllowedBeforeModule ds
    isAllowedBeforeModule Import{}       = True
    isAllowedBeforeModule ModuleMacro{}  = True
    isAllowedBeforeModule Open{}         = True
    isAllowedBeforeModule _              = False

-- | Create a name from a string.

mkName :: (Interval, String) -> Parser Name
mkName (i, s) = do
    let xs = C.stringNameParts s
    mapM_ isValidId xs
    unless (alternating xs) $ fail $ "a name cannot contain two consecutive underscores"
    return $ Name (getRange i) xs
    where
	isValidId Hole   = return ()
	isValidId (Id y) = do
          let x = rawNameToString y
          case parse defaultParseFlags [0] (lexer return) x of
	    ParseOk _ (TokId _) -> return ()
	    _			-> fail $ "in the name " ++ s ++ ", the part " ++ x ++ " is not valid"

	-- we know that there are no two Ids in a row
	alternating (Hole : Hole : _) = False
	alternating (_ : xs)	      = alternating xs
	alternating []		      = True

-- | Create a qualified name from a list of strings
mkQName :: [(Interval, String)] -> Parser QName
mkQName ss = do
    xs <- mapM mkName ss
    return $ foldr Qual (QName $ last xs) (init xs)

ensureUnqual :: QName -> Parser Name
ensureUnqual (QName x) = return x
ensureUnqual q@Qual{}  = parseError' (rStart $ getRange q) "Qualified name not allowed here"

-- | Match a particular name.
isName :: String -> (Interval, String) -> Parser ()
isName s (_,s')
    | s == s'	= return ()
    | otherwise	= fail $ "expected " ++ s ++ ", found " ++ s'

-- | Build a forall pi (forall x y z -> ...)
forallPi :: [LamBinding] -> Expr -> Expr
forallPi bs e = Pi (map addType bs) e

-- | Build a telescoping let (let Ds)
tLet :: Range -> [Declaration] -> TypedBindings
tLet r = TypedBindings r . Common.Arg defaultArgInfo . TLet r

-- | Converts lambda bindings to typed bindings.
addType :: LamBinding -> TypedBindings
addType (DomainFull b)	 = b
addType (DomainFree info x) = TypedBindings r $ Common.Arg info $ TBind r [x] $ Underscore r Nothing
  where r = getRange x

mergeImportDirectives :: [ImportDirective] -> Parser ImportDirective
mergeImportDirectives is = do
  i <- foldl merge (return defaultImportDir) is
  verifyImportDirective i
  where
    merge mi i2 = do
      i1 <- mi
      let err = parseError' (rStart $ getRange i2) "Cannot mix using and hiding module directives"
      uh <- case (usingOrHiding i1, usingOrHiding i2) of
            (Hiding [], u)         -> return u
            (u, Hiding [])         -> return u
            (Using{}, Hiding{})    -> err
            (Hiding{}, Using{})    -> err
            (Using xs, Using ys)   -> return $ Using (xs ++ ys)
            (Hiding xs, Hiding ys) -> return $ Hiding (xs ++ ys)
      return $ ImportDirective
        { importDirRange = fuseRange i1 i2
        , usingOrHiding  = uh
        , renaming       = renaming i1 ++ renaming i2
        , publicOpen     = publicOpen i1 || publicOpen i2 }

-- | Check that an import directive doesn't contain repeated names
verifyImportDirective :: ImportDirective -> Parser ImportDirective
verifyImportDirective i =
    case filter ((>1) . length)
	 $ group
	 $ sort xs
    of
	[]  -> return i
	yss -> let Just pos = rStart $ getRange $ head $ concat yss in
               parseErrorAt pos $
		"repeated name" ++ s ++ " in import directive: " ++
		concat (intersperse ", " $ map (show . head) yss)
	    where
		s = case yss of
			[_] -> ""
			_   -> "s"
    where
	xs = names (usingOrHiding i) ++ map renFrom (renaming i)
	names (Using xs)    = xs
	names (Hiding xs)   = xs

-- | Breaks up a string into substrings. Returns every maximal
-- subsequence of zero or more characters distinct from @'.'@.
--
-- > splitOnDots ""         == [""]
-- > splitOnDots "foo.bar"  == ["foo", "bar"]
-- > splitOnDots ".foo.bar" == ["", "foo", "bar"]
-- > splitOnDots "foo.bar." == ["foo", "bar", ""]
-- > splitOnDots "foo..bar" == ["foo", "", "bar"]
splitOnDots :: String -> [String]
splitOnDots ""        = [""]
splitOnDots ('.' : s) = [] : splitOnDots s
splitOnDots (c   : s) = case splitOnDots s of
  p : ps -> (c : p) : ps

prop_splitOnDots = and
  [ splitOnDots ""         == [""]
  , splitOnDots "foo.bar"  == ["foo", "bar"]
  , splitOnDots ".foo.bar" == ["", "foo", "bar"]
  , splitOnDots "foo.bar." == ["foo", "bar", ""]
  , splitOnDots "foo..bar" == ["foo", "", "bar"]
  ]

-- | Returns 'True' iff the name is a valid Haskell (hierarchical)
-- module name.
validHaskellModuleName :: String -> Bool
validHaskellModuleName = all ok . splitOnDots
  where
  -- Checks if a dot-less module name is well-formed.
  ok :: String -> Bool
  ok []      = False
  ok (c : s) =
    isUpper c &&
    all (\c -> isLower c || c == '_' ||
               isUpper c ||
               generalCategory c == DecimalNumber ||
               c == '\'')
        s

{--------------------------------------------------------------------------
    Patterns
 --------------------------------------------------------------------------}

-- | Turn an expression into a left hand side.
exprToLHS :: Expr -> Parser ([Expr] -> [Expr] -> LHS)
exprToLHS e = case e of
  WithApp r e es -> LHS <$> exprToPattern e <*> mapM exprToPattern es
  _		 -> LHS <$> exprToPattern e <*> return []

-- | Turn an expression into a pattern. Fails if the expression is not a
--   valid pattern.
exprToPattern :: Expr -> Parser Pattern
exprToPattern e =
    case e of
	Ident x			-> return $ IdentP x
	App _ e1 e2		-> AppP <$> exprToPattern e1
					<*> T.mapM (T.mapM exprToPattern) e2
	Paren r e		-> ParenP r
					<$> exprToPattern e
	Underscore r _		-> return $ WildP r
	Absurd r		-> return $ AbsurdP r
	As r x e		-> AsP r x <$> exprToPattern e
	Dot r (HiddenArg _ e)	-> return $ HiddenP r $ fmap (DotP r) e
	Dot r e			-> return $ DotP r e
	Lit l			-> return $ LitP l
	HiddenArg r e		-> HiddenP r <$> T.mapM exprToPattern e
	InstanceArg r e		-> InstanceP r <$> T.mapM exprToPattern e
	RawApp r es		-> RawAppP r <$> mapM exprToPattern es
	_			->
          let Just pos = rStart $ getRange e in
          parseErrorAt pos $ "Not a valid pattern: " ++ show e

opAppExprToPattern :: OpApp Expr -> Parser Pattern
opAppExprToPattern (SyntaxBindingLambda _ _ _) = parseError "syntax binding lambda cannot appear in a pattern"
opAppExprToPattern (Ordinary e) = exprToPattern e

-- | Turn an expression into a name. Fails if the expression is not a
--   valid identifier.
exprToName :: Expr -> Parser Name
exprToName (Ident (QName x)) = return x
exprToName e =
  let Just pos = rStart $ getRange e in
  parseErrorAt pos $ "Not a valid identifier: " ++ show e

stripSingletonRawApp :: Expr -> Expr
stripSingletonRawApp (RawApp _ [e]) = stripSingletonRawApp e
stripSingletonRawApp e = e

isEqual :: Expr -> Maybe (Expr, Expr)
isEqual e =
  case stripSingletonRawApp e of
    Equal _ a b -> Just (stripSingletonRawApp a, stripSingletonRawApp b)
    _           -> Nothing

maybeNamed :: Expr -> Named_ Expr
maybeNamed e =
  case isEqual e of
    Just (Ident (QName x), b) -> named (Ranged (getRange x) (nameToRawName x)) b
    _                         -> unnamed e

patternSynArgs :: [Either Hiding LamBinding] -> Parser [Arg Name]
patternSynArgs = mapM pSynArg
  where
    pSynArg Left{}                   = parseError "Absurd patterns are not allowed in pattern synonyms"
    pSynArg (Right DomainFull{})     = parseError "Unexpected type signature in pattern synonym argument"
    pSynArg (Right (DomainFree a x))
      | getHiding a `notElem` [Hidden, NotHidden] = parseError $ show (getHiding a) ++ " arguments not allowed to pattern synonyms"
      | getRelevance a /= Relevant                = parseError "Arguments to pattern synonyms must be relevant"
      | otherwise                                 = return $ Common.Arg a (boundName x)

parsePanic s = parseError $ "Internal parser error: " ++ s ++ ". Please report this as a bug."

{- RHS or type signature -}

data RHSOrTypeSigs = JustRHS RHS
                   | TypeSigsRHS Expr

namesOfPattern :: Pattern -> Maybe [(C.ArgInfo, Name)]
namesOfPattern (IdentP (QName i))         = Just [(defaultArgInfo, i)]
namesOfPattern (DotP _ (Ident (QName i))) = Just [(setRelevance Irrelevant defaultArgInfo, i)]
namesOfPattern (RawAppP _ ps)             = fmap concat $ mapM namesOfPattern ps
namesOfPattern _                          = Nothing

funClauseOrTypeSigs :: LHS -> RHSOrTypeSigs -> WhereClause -> Parser [Declaration]
funClauseOrTypeSigs lhs (JustRHS   rhs) wh = return [FunClause lhs rhs wh]
funClauseOrTypeSigs lhs (TypeSigsRHS e) wh
  | NoWhere <- wh,
    LHS p [] [] [] <- lhs,
    Just names <- namesOfPattern p = return $ map (\(x,y) -> TypeSig x y e) names
  | otherwise                      = parseError "Illegal function clause or type signature"

{--------------------------------------------------------------------------
    Tests
 --------------------------------------------------------------------------}

-- | Test suite.
tests :: IO Bool
tests = runTests "Agda.Syntax.Parser.Parser"
  [ quickCheck' prop_splitOnDots
  ]
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "<built-in>" #-}
{-# LINE 1 "<command-line>" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
-- Id: GenericTemplate.hs,v 1.26 2005/01/14 14:47:22 simonmar Exp 

{-# LINE 13 "templates/GenericTemplate.hs" #-}





-- Do not remove this comment. Required to fix CPP parsing when using GCC and a clang-compiled alex.
#if __GLASGOW_HASKELL__ > 706
#define LT(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.<# m)) :: Bool)
#define GTE(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.>=# m)) :: Bool)
#define EQ(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.==# m)) :: Bool)
#else
#define LT(n,m) (n Happy_GHC_Exts.<# m)
#define GTE(n,m) (n Happy_GHC_Exts.>=# m)
#define EQ(n,m) (n Happy_GHC_Exts.==# m)
#endif
{-# LINE 46 "templates/GenericTemplate.hs" #-}


data Happy_IntList = HappyCons Happy_GHC_Exts.Int# Happy_IntList





{-# LINE 67 "templates/GenericTemplate.hs" #-}

{-# LINE 77 "templates/GenericTemplate.hs" #-}

{-# LINE 86 "templates/GenericTemplate.hs" #-}

infixr 9 `HappyStk`
data HappyStk a = HappyStk a (HappyStk a)

-----------------------------------------------------------------------------
-- starting the parse

happyParse start_state = happyNewToken start_state notHappyAtAll notHappyAtAll

-----------------------------------------------------------------------------
-- Accepting the parse

-- If the current token is 0#, it means we've just accepted a partial
-- parse (a %partial parser).  We must ignore the saved token on the top of
-- the stack in this case.
happyAccept 0# tk st sts (_ `HappyStk` ans `HappyStk` _) =
        happyReturn1 ans
happyAccept j tk st sts (HappyStk ans _) = 
        (happyTcHack j (happyTcHack st)) (happyReturn1 ans)

-----------------------------------------------------------------------------
-- Arrays only: do the next action



happyDoAction i tk st
        = {- nothing -}


          case action of
                0#           -> {- nothing -}
                                     happyFail i tk st
                -1#          -> {- nothing -}
                                     happyAccept i tk st
                n | LT(n,(0# :: Happy_GHC_Exts.Int#)) -> {- nothing -}

                                                   (happyReduceArr Happy_Data_Array.! rule) i tk st
                                                   where rule = (Happy_GHC_Exts.I# ((Happy_GHC_Exts.negateInt# ((n Happy_GHC_Exts.+# (1# :: Happy_GHC_Exts.Int#))))))
                n                 -> {- nothing -}


                                     happyShift new_state i tk st
                                     where new_state = (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#))
   where off    = indexShortOffAddr happyActOffsets st
         off_i  = (off Happy_GHC_Exts.+# i)
         check  = if GTE(off_i,(0# :: Happy_GHC_Exts.Int#))
                  then EQ(indexShortOffAddr happyCheck off_i, i)
                  else False
         action
          | check     = indexShortOffAddr happyTable off_i
          | otherwise = indexShortOffAddr happyDefActions st


indexShortOffAddr (HappyA# arr) off =
        Happy_GHC_Exts.narrow16Int# i
  where
        i = Happy_GHC_Exts.word2Int# (Happy_GHC_Exts.or# (Happy_GHC_Exts.uncheckedShiftL# high 8#) low)
        high = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr (off' Happy_GHC_Exts.+# 1#)))
        low  = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr off'))
        off' = off Happy_GHC_Exts.*# 2#





data HappyAddr = HappyA# Happy_GHC_Exts.Addr#




-----------------------------------------------------------------------------
-- HappyState data type (not arrays)

{-# LINE 170 "templates/GenericTemplate.hs" #-}

-----------------------------------------------------------------------------
-- Shifting a token

happyShift new_state 0# tk st sts stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--     trace "shifting the error token" $
     happyDoAction i tk new_state (HappyCons (st) (sts)) (stk)

happyShift new_state i tk st sts stk =
     happyNewToken new_state (HappyCons (st) (sts)) ((happyInTok (tk))`HappyStk`stk)

-- happyReduce is specialised for the common cases.

happySpecReduce_0 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_0 nt fn j tk st@((action)) sts stk
     = happyGoto nt j tk st (HappyCons (st) (sts)) (fn `HappyStk` stk)

happySpecReduce_1 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_1 nt fn j tk _ sts@((HappyCons (st@(action)) (_))) (v1`HappyStk`stk')
     = let r = fn v1 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_2 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_2 nt fn j tk _ (HappyCons (_) (sts@((HappyCons (st@(action)) (_))))) (v1`HappyStk`v2`HappyStk`stk')
     = let r = fn v1 v2 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_3 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_3 nt fn j tk _ (HappyCons (_) ((HappyCons (_) (sts@((HappyCons (st@(action)) (_))))))) (v1`HappyStk`v2`HappyStk`v3`HappyStk`stk')
     = let r = fn v1 v2 v3 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happyReduce k i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyReduce k nt fn j tk st sts stk
     = case happyDrop (k Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) sts of
         sts1@((HappyCons (st1@(action)) (_))) ->
                let r = fn stk in  -- it doesn't hurt to always seq here...
                happyDoSeq r (happyGoto nt j tk st1 sts1 r)

happyMonadReduce k nt fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyMonadReduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
          let drop_stk = happyDropStk k stk in
          happyThen1 (fn stk tk) (\r -> happyGoto nt j tk st1 sts1 (r `HappyStk` drop_stk))

happyMonad2Reduce k nt fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyMonad2Reduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
         let drop_stk = happyDropStk k stk

             off = indexShortOffAddr happyGotoOffsets st1
             off_i = (off Happy_GHC_Exts.+# nt)
             new_state = indexShortOffAddr happyTable off_i



          in
          happyThen1 (fn stk tk) (\r -> happyNewToken new_state sts1 (r `HappyStk` drop_stk))

happyDrop 0# l = l
happyDrop n (HappyCons (_) (t)) = happyDrop (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) t

happyDropStk 0# l = l
happyDropStk n (x `HappyStk` xs) = happyDropStk (n Happy_GHC_Exts.-# (1#::Happy_GHC_Exts.Int#)) xs

-----------------------------------------------------------------------------
-- Moving to a new state after a reduction


happyGoto nt j tk st = 
   {- nothing -}
   happyDoAction j tk new_state
   where off = indexShortOffAddr happyGotoOffsets st
         off_i = (off Happy_GHC_Exts.+# nt)
         new_state = indexShortOffAddr happyTable off_i




-----------------------------------------------------------------------------
-- Error recovery (0# is the error token)

-- parse error if we are in recovery and we fail again
happyFail 0# tk old_st _ stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--      trace "failing" $ 
        happyError_ i tk

{-  We don't need state discarding for our restricted implementation of
    "error".  In fact, it can cause some bogus parses, so I've disabled it
    for now --SDM

-- discard a state
happyFail  0# tk old_st (HappyCons ((action)) (sts)) 
                                                (saved_tok `HappyStk` _ `HappyStk` stk) =
--      trace ("discarding state, depth " ++ show (length stk))  $
        happyDoAction 0# tk action sts ((saved_tok`HappyStk`stk))
-}

-- Enter error recovery: generate an error token,
--                       save the old token and carry on.
happyFail  i tk (action) sts stk =
--      trace "entering error recovery" $
        happyDoAction 0# tk action sts ( (Happy_GHC_Exts.unsafeCoerce# (Happy_GHC_Exts.I# (i))) `HappyStk` stk)

-- Internal happy errors:

notHappyAtAll :: a
notHappyAtAll = error "Internal Happy error\n"

-----------------------------------------------------------------------------
-- Hack to get the typechecker to accept our action functions


happyTcHack :: Happy_GHC_Exts.Int# -> a -> a
happyTcHack x y = y
{-# INLINE happyTcHack #-}


-----------------------------------------------------------------------------
-- Seq-ing.  If the --strict flag is given, then Happy emits 
--      happySeq = happyDoSeq
-- otherwise it emits
--      happySeq = happyDontSeq

happyDoSeq, happyDontSeq :: a -> b -> b
happyDoSeq   a b = a `seq` b
happyDontSeq a b = b

-----------------------------------------------------------------------------
-- Don't inline any functions from the template.  GHC has a nasty habit
-- of deciding to inline happyGoto everywhere, which increases the size of
-- the generated parser quite a bit.


{-# NOINLINE happyDoAction #-}
{-# NOINLINE happyTable #-}
{-# NOINLINE happyCheck #-}
{-# NOINLINE happyActOffsets #-}
{-# NOINLINE happyGotoOffsets #-}
{-# NOINLINE happyDefActions #-}

{-# NOINLINE happyShift #-}
{-# NOINLINE happySpecReduce_0 #-}
{-# NOINLINE happySpecReduce_1 #-}
{-# NOINLINE happySpecReduce_2 #-}
{-# NOINLINE happySpecReduce_3 #-}
{-# NOINLINE happyReduce #-}
{-# NOINLINE happyMonadReduce #-}
{-# NOINLINE happyGoto #-}
{-# NOINLINE happyFail #-}

-- end of Happy Template.
