
/*
 *  Copyright (c) 1998 - 1999, 2001 Karel Zak "Zakkr" <zakkr@zf.jcu.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  $Id: button.c,v 1.2 2001/01/02 14:16:15 zakkr Exp $
 */

#include "aca.h"
#include "aca_widget.h"
#include "widget_utils.h"

/* 
	------- predefined buttons ------- 
 */ 

   Wbutton def_button[] = {
   { Naca_( "[ |Q|uit ]"	), 0,0 },
   { Naca_( "[ |O|k ]"		), 0,0 },
   { Naca_( "[ |C|ancel ]"	), 0,0 },
   { Naca_( "[ |S|ave ]"	), 0,0 },
   { Naca_( "[ |N|ew ]"		), 0,0 }
   };


   int button_fn(SessW *s, Widget *w, void *data, int key, int Msg)
   {
      Wbutton	*b;

      _D(" button_fn()");
      DEBUG_WIDGET(w,s);	
	
      b = (Wbutton *) data;
   
      switch(Msg) {
      case WIDGET_DRAW:
         if (b->flag & Wb_PRESS_GO) {
            W_mvaddastr(w, w->y, w->x, b->astr, TplC->button.sel_astr, TplC->button.sel); 
            return Wr_OK;
         }	
         if (w->id == s->actual)
            W_mvaddastr(w, w->y, w->x, b->astr, TplC->button.sel_astr, TplC->button.sel); 
         else if (!(w->flag & Wf_NOTVISIBLE)) 	
            W_mvaddastr(w, w->y, w->x, b->astr, TplC->button.nsel_astr, TplC->button.nsel); 				
         return Wr_OK;
      
      case WIDGET_KEY:
         if ((w->id == s->actual) && (key == ' ' || key == '\n' || 
         widget_keys(key, w, s))) 
            return Wr_BUTTON_PRESS;
         else {
            if ((b->flag & Wb_PRESS_GO) && (w->id != s->actual)) {
               if (widget_keys(key, w, s))
                  return Wr_BUTTON_PRESS;
               else 
                  return Wr_OK;	
            }	
            widget_keys(key, w, s);
         }	
         return Wr_OK;	
      }
      return Wr_ERROR;
   }
