/* This file is part of q-tools, a collection of performance tools
   Copyright (c) 2003 Hewlett-Packard Development Company, L.P.
   Contributed by David Mosberger-Tang <davidm@hpl.hp.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330,
   Boston, MA  02111-1307  USA  */

#ifndef sysprof_h
#define sysprof_h

#ifdef __GNUC__
# define likely(x)	(__builtin_expect ((long) (x), 1))
# define unlikely(x)	(__builtin_expect ((long) (x), 0))
#else
# define likely(x)	(x)
# define unlikely(x)	(x)
#endif

extern void prog_stop (int exit_status);

#define panic(args...)				\
do {						\
  fprintf (stderr, ##args);			\
  prog_stop (1);				\
} while (0)

#define INSN_SHIFT	2	/* log2() of the min. size of an instruction */

#define KERNEL_START	0xa000000000000000
#define KERNEL_SIZE	0x6000000000000000

#endif /* sysprof_h */
