// 
// File:          sort_QuickSort_Impl.cc
// Symbol:        sort.QuickSort-v0.1
// Symbol Type:   class
// Babel Version: 0.10.2
// Description:   Server-side implementation for sort.QuickSort
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.10.2
// 
#include "sort_QuickSort_Impl.hh"

// 
// Includes for all method dependencies.
// 
#ifndef included_sidl_BaseInterface_hh
#include "sidl_BaseInterface.hh"
#endif
#ifndef included_sidl_ClassInfo_hh
#include "sidl_ClassInfo.hh"
#endif
#ifndef included_sort_Comparator_hh
#include "sort_Comparator.hh"
#endif
#ifndef included_sort_Container_hh
#include "sort_Container.hh"
#endif
#ifndef included_sort_Counter_hh
#include "sort_Counter.hh"
#endif
#line 32 "../../../../babel/regression/sort/libUCxx/sort_QuickSort_Impl.cc"
// DO-NOT-DELETE splicer.begin(sort.QuickSort._includes)
/**
 * Choose the middle of the first, middle and last element of the
 * list.  For small lists, return the middle without checking.
 */
static int32_t
choosePivot(ucxx::sort::Container  &elems,
            ucxx::sort::Comparator &comp,
            ucxx::sort::Counter    &cmp,
            int32_t           start,
            int32_t           end)
{
  int32_t pivot = (start + end) >> 1;
  if ((end - start) > 4) {
    int32_t mid = pivot;
    cmp.inc();
    if (elems.compare(start, mid, comp) <= 0) {
      cmp.inc();
      if (elems.compare(mid, end - 1, comp) > 0) {
        cmp.inc();
        if (elems.compare( start, end - 1, comp) < 0) {
          pivot = end - 1;
        }
        else {
          pivot = start;
        }
      }
    }
    else {
      cmp.inc();
      if (elems.compare( mid, end - 1, comp) < 0) {
        cmp.inc();
        if (elems.compare( start, end - 1, comp) > 0) {
          pivot = end - 1;
        }
        else {
          pivot = start;
        }
      }
    }
  }
  return pivot;
}

static void 
quickSort(ucxx::sort::Container  &elems,
          ucxx::sort::Comparator &comp,
          ucxx::sort::Counter    &cmp,
          ucxx::sort::Counter    &swp,
          int32_t           start,
          int32_t           end)
{
  if ((end - start) > 1) {
    int32_t pivot = choosePivot(elems, comp, cmp, start, end);
    int32_t i = start;
    int32_t j = end;
    if (pivot != start) {
      swp.inc();
      elems.swap(start, pivot);
    }
    for(;;) {
      do {
        --j;
        cmp.inc();
      } while (elems.compare( start, j, comp) < 0);
      while (++i < j) {
        cmp.inc();
        if (elems.compare( start, i, comp) < 0) break;
      }
      if (i >= j) break;
      swp.inc();
      elems.swap(i, j);
    }
    if (j != start) {
      swp.inc();
      elems.swap(start, j);
    }
    quickSort(elems, comp, cmp, swp, start, j);
    quickSort(elems, comp, cmp, swp, j + 1, end);
  }
}
// DO-NOT-DELETE splicer.end(sort.QuickSort._includes)
#line 115 "sort_QuickSort_Impl.cc"

// user defined constructor
void sort::QuickSort_impl::_ctor() {
#line 117 "../../../../babel/regression/sort/libUCxx/sort_QuickSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.QuickSort._ctor)
  // add construction details here
  // DO-NOT-DELETE splicer.end(sort.QuickSort._ctor)
#line 123 "sort_QuickSort_Impl.cc"
}

// user defined destructor
void sort::QuickSort_impl::_dtor() {
#line 124 "../../../../babel/regression/sort/libUCxx/sort_QuickSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.QuickSort._dtor)
  // add destruction details here
  // DO-NOT-DELETE splicer.end(sort.QuickSort._dtor)
#line 132 "sort_QuickSort_Impl.cc"
}

// static class initializer
void sort::QuickSort_impl::_load() {
#line 131 "../../../../babel/regression/sort/libUCxx/sort_QuickSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.QuickSort._load)
  // guaranteed to be called at most once before any other method in this class
  // DO-NOT-DELETE splicer.end(sort.QuickSort._load)
#line 141 "sort_QuickSort_Impl.cc"
}

// user defined static methods: (none)

// user defined non-static methods:
/**
 * Sort elements using Quick Sort.
 */
void
sort::QuickSort_impl::sort_impl (
  /* in */::ucxx::sort::Container elems,
  /* in */::ucxx::sort::Comparator comp ) 
throw () 
{
#line 148 "../../../../babel/regression/sort/libUCxx/sort_QuickSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.QuickSort.sort)
  const int32_t num = elems.getLength();
  ucxx::sort::Counter cmp = getCompareCounter();
  ucxx::sort::Counter swp = getSwapCounter();
  quickSort(elems, comp, cmp, swp, 0, num);
  // DO-NOT-DELETE splicer.end(sort.QuickSort.sort)
#line 163 "sort_QuickSort_Impl.cc"
}

/**
 * Return quick sort.
 */
::std::string
sort::QuickSort_impl::getName_impl () 
throw () 

{
#line 164 "../../../../babel/regression/sort/libUCxx/sort_QuickSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.QuickSort.getName)
  return "Quick sort";
  // DO-NOT-DELETE splicer.end(sort.QuickSort.getName)
#line 178 "sort_QuickSort_Impl.cc"
}


#line 170 "../../../../babel/regression/sort/libUCxx/sort_QuickSort_Impl.cc"
// DO-NOT-DELETE splicer.begin(sort.QuickSort._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(sort.QuickSort._misc)
#line 186 "sort_QuickSort_Impl.cc"

